/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.RangeFilename;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BookmarksImpl;
import com.sun.star.helper.writer.CharactersImpl;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.FieldsImpl;
import com.sun.star.helper.writer.FindImpl;
import com.sun.star.helper.writer.FontImpl;
import com.sun.star.helper.writer.HyperlinksImpl;
import com.sun.star.helper.writer.ListFormatImpl;
import com.sun.star.helper.writer.OptionsImpl;
import com.sun.star.helper.writer.ParagraphFormatImpl;
import com.sun.star.helper.writer.ParagraphsImpl;
import com.sun.star.helper.writer.RangeHelper;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.RangeMovementHelper;
import com.sun.star.helper.writer.RangeProperties;
import com.sun.star.helper.writer.RangeSortDescriptorHelper;
import com.sun.star.helper.writer.SelectionImpl;
import com.sun.star.helper.writer.StyleImpl;
import com.sun.star.helper.writer.StylesImpl;
import com.sun.star.helper.writer.WordsImpl;
import com.sun.star.helper.writer.WriterImpl;
import com.sun.star.helper.writer.XBookmarks;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XCharacters;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XFields;
import com.sun.star.helper.writer.XFind;
import com.sun.star.helper.writer.XFont;
import com.sun.star.helper.writer.XHyperlinks;
import com.sun.star.helper.writer.XListFormat;
import com.sun.star.helper.writer.XPageSetup;
import com.sun.star.helper.writer.XParagraph;
import com.sun.star.helper.writer.XParagraphFormat;
import com.sun.star.helper.writer.XParagraphs;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XRangeDelegateIfc;
import com.sun.star.helper.writer.XSpellingSuggestions;
import com.sun.star.helper.writer.XTables;
import com.sun.star.helper.writer.XTextFrame;
import com.sun.star.helper.writer.XWords;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.linguistic2.XSpellChecker;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.BreakType;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XSentenceCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextField;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XWordCursor;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XSortable;
import com.sun.star.view.XSelectionSupplier;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class BaseRangeImpl
implements XRangeDelegateIfc,
XUnoAccess {
    protected ParagraphsImpl m_cacheParagraphs = null;
    protected FontImpl m_cacheFont = null;
    protected RangeProperties m_props = new RangeProperties();
    static /* synthetic */ Class class$com$sun$star$text$XTextRangeCompare;
    static /* synthetic */ Class class$com$sun$star$text$XWordCursor;
    static /* synthetic */ Class class$com$sun$star$text$XParagraphCursor;
    static /* synthetic */ Class class$com$sun$star$text$XSentenceCursor;
    static /* synthetic */ Class class$com$sun$star$document$XDocumentInsertable;
    static /* synthetic */ Class class$com$sun$star$linguistic2$XSpellChecker;
    static /* synthetic */ Class class$com$sun$star$util$XSortable;
    static /* synthetic */ Class class$com$sun$star$text$XTextField;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$text$XPageCursor;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;

    public boolean getEmpty() {
        return this.m_props.getXTextCursor().isCollapsed();
    }

    protected DocumentImpl getDocumentImpl() throws BasicErrorException {
        return this.m_props.getDocumentImpl();
    }

    protected void initCursor(XTextRange xTextRange) {
        block7: {
            boolean bl = false;
            XText xText = this.m_props.getXText();
            try {
                this.m_props.setXTextCursor(xText.createTextCursorByRange(xTextRange));
                bl = true;
            }
            catch (Throwable throwable) {
                DebugHelper.writeInfo(throwable.getMessage());
            }
            if (!bl) {
                try {
                    XText xText2 = xTextRange.getText();
                    this.m_props.setXTextCursor(xText2.createTextCursor());
                    bl = true;
                }
                catch (Throwable throwable) {
                    DebugHelper.writeInfo(throwable.getMessage());
                }
            }
            if (bl) break block7;
            try {
                this.m_props.setXTextCursor(xText.createTextCursor());
                bl = true;
            }
            catch (Throwable throwable) {
                DebugHelper.writeInfo(throwable.getMessage());
            }
        }
    }

    public XTextRange getXTextRange() {
        return this.m_props.getXTextCursor();
    }

    public XRange Range(XRange xRange, XRange xRange2) throws BasicErrorException {
        return new RangeImpl(this.m_props.getRangeImpl().getParentAdaptor(), xRange, xRange2);
    }

    public XRange getStartAsRange() throws BasicErrorException {
        return new RangeImpl((HelperInterfaceAdaptor)this.getDocumentImpl(), this.m_props.getXTextCursor().getStart(), false);
    }

    public int getStart() throws BasicErrorException {
        DocumentImpl documentImpl = this.getDocumentImpl();
        XText xText = documentImpl.getXTextRange().getText();
        int n = RangeHelper.getPosition(xText, this.m_props.getXTextCursor().getStart());
        return n;
    }

    public XRange getEndAsRange() throws BasicErrorException {
        return new RangeImpl((HelperInterfaceAdaptor)this.getDocumentImpl(), this.m_props.getXTextCursor().getEnd(), false);
    }

    public int getEnd() throws BasicErrorException {
        DocumentImpl documentImpl = this.getDocumentImpl();
        XText xText = documentImpl.getXTextRange().getText();
        XTables xTables = this.getTables();
        int n = RangeHelper.getPosition(xText, this.m_props.getXTextCursor().getEnd());
        return n;
    }

    public void setStart(int n) throws BasicErrorException {
        DocumentImpl documentImpl = this.getDocumentImpl();
        XText xText = documentImpl.getXTextRange().getText();
        XTextRange xTextRange = RangeHelper.getRangeByPosition(xText, n);
        this.setStartRange(xTextRange);
    }

    public void setEnd(int n) throws BasicErrorException {
        DocumentImpl documentImpl = this.getDocumentImpl();
        XText xText = documentImpl.getXTextRange().getText();
        XTextRange xTextRange = RangeHelper.getRangeByPosition(xText, n);
        this.setEndRange(xTextRange);
    }

    public void SetRange(int n, int n2) throws BasicErrorException {
        DocumentImpl documentImpl = this.getDocumentImpl();
        XText xText = documentImpl.getXTextRange().getText();
        XTextRange xTextRange = RangeHelper.getRangeByPosition(xText, n);
        XTextRange xTextRange2 = RangeHelper.getRangeByPosition(xText, n2);
        this.setStartEndRange(xTextRange, xTextRange2);
    }

    public void Collapse(Object object) {
        int n = 1;
        try {
            n = OptionalParamUtility.getInt("Direction", object, 1, false);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        if (n == 0) {
            this.m_props.getXTextCursor().collapseToEnd();
        } else {
            this.m_props.getXTextCursor().collapseToStart();
        }
    }

    public void Select() throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
        selectionImpl.select(this.m_props.getRangeImpl());
    }

    public void setBold(int n) throws BasicErrorException {
        this.getFont().setBold(n);
    }

    public int getBold() throws BasicErrorException {
        return this.getFont().getBold();
    }

    public XBookmarks getBookmarks() throws BasicErrorException {
        return new BookmarksImpl(this.m_props.getRangeImpl());
    }

    public int getUnderline() throws BasicErrorException {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int n) throws BasicErrorException {
        this.getFont().setUnderline(n);
    }

    public XParagraphs getParagraphs() throws BasicErrorException {
        if (this.m_cacheParagraphs == null) {
            this.m_cacheParagraphs = new ParagraphsImpl(this.m_props.getRangeImpl());
        }
        return this.m_cacheParagraphs;
    }

    public XParagraphFormat getParagraphFormat() throws BasicErrorException {
        return new ParagraphFormatImpl(this.m_props.getRangeImpl());
    }

    public XBorders getBorders() throws BasicErrorException {
        ParagraphFormatImpl paragraphFormatImpl = new ParagraphFormatImpl(this.m_props.getRangeImpl());
        return paragraphFormatImpl.getBorders();
    }

    public Object getStyle() throws BasicErrorException {
        String string = StylesImpl.getHelperStyleName(this.getDocument(), this.m_props.getRangeImpl());
        StyleImpl styleImpl = ((StylesImpl)this.getDocument().getStyles()).getStyleByName(string);
        styleImpl.setRange(this.m_props.getXTextRange());
        return styleImpl;
    }

    public void setStyle(Object object) throws BasicErrorException {
        if (object instanceof StyleImpl) {
            ((StyleImpl)object).setRange(this.m_props.getXTextRange());
        }
        StylesImpl.setHelperStyleAny(this.getDocument(), this.m_props.getRangeImpl(), object);
    }

    public XParagraph getParagraph(int n) throws BasicErrorException {
        return this.getParagraphs().Item(n);
    }

    public XFont getFont() throws BasicErrorException {
        if (this.m_cacheFont == null) {
            this.m_cacheFont = new FontImpl(this.m_props.getRangeImpl());
        }
        return this.m_cacheFont;
    }

    public void setFont(XFont xFont) throws BasicErrorException {
        this.m_cacheFont.setFontProperties(xFont);
    }

    public boolean rangeAtEndOfDocument() throws BasicErrorException {
        DocumentImpl documentImpl = (DocumentImpl)this.getDocument();
        XTextRange xTextRange = documentImpl.getXTextRange().getEnd();
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = BaseRangeImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)documentImpl.getXTextRange());
        try {
            if (xTextRangeCompare.compareRegionEnds(xTextRange, (XTextRange)this.m_props.getXTextCursor()) == 0 || xTextRangeCompare.compareRegionStarts(xTextRange, (XTextRange)this.m_props.getXTextCursor()) == 0) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return false;
    }

    public String getText() throws BasicErrorException {
        String string = this.m_props.getXTextCursor().getString();
        int n = string.length();
        if (this.m_props.getMaySpanEndOfDocument() && n > 0 && string.charAt(n - 1) != '\n' && this.rangeAtEndOfDocument()) {
            return string + System.getProperty("line.separator", "\r\n");
        }
        if (n == 0) {
            if (this.m_props.getXTextCursor().isCollapsed()) {
                this.m_props.getXTextCursor().goRight((short)1, true);
                string = this.m_props.getXTextCursor().getString();
                this.m_props.getXTextCursor().collapseToStart();
            } else {
                XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
                XTextRange xTextRange2 = this.m_props.getXTextCursor().getEnd();
                this.m_props.getXTextCursor().collapseToEnd();
                this.m_props.getXTextCursor().goRight((short)1, true);
                string = this.m_props.getXTextCursor().getString();
                this.m_props.getXTextCursor().gotoRange(xTextRange, false);
                this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
            }
        }
        return string;
    }

    public void setText(String string) throws BasicErrorException {
        if (string != null) {
            if (string.indexOf(10) != -1) {
                this.m_props.getXTextCursor().setString("");
                RangeHelper.insertString((XTextRange)this.m_props.getXTextCursor(), this.m_props.getXText(), string, true);
            } else {
                this.m_props.getXTextCursor().setString(string);
            }
        }
    }

    public XDocument getDocument() throws BasicErrorException {
        return this.getDocumentImpl();
    }

    public boolean IsEqual(XRange xRange) throws BasicErrorException {
        return RangeHelper.areRangesEqual(xRange.getXTextRange(), (XTextRange)this.m_props.getXTextCursor());
    }

    public int getItalic() throws BasicErrorException {
        return this.getFont().getItalic();
    }

    public void setItalic(int n) throws BasicErrorException {
        this.getFont().setItalic(n);
    }

    public void setCase(int n) throws BasicErrorException {
        short s = 0;
        switch (n) {
            case 0: {
                s = 2;
                break;
            }
            case 2: {
                s = 3;
                break;
            }
            case 1: {
                s = 1;
                break;
            }
            case 4: {
                s = 0;
                break;
            }
            case -1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                DebugHelper.exception(73, "WdCharacterCase");
                break;
            }
            default: {
                DebugHelper.exception(14, "WdCharacterCase");
            }
        }
        if (s != 0) {
            PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_props.getXTextCursor());
            propertySetHelper.setPropertyValue("CharCaseMap", new Short(s));
        }
    }

    public int getCase() throws BasicErrorException {
        int n = 2;
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_props.getXTextCursor());
        short s = propertySetHelper.getPropertyValueAsShort("CharCaseMap", (short)0);
        switch (s) {
            case 2: {
                n = 0;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            default: {
                n = 4;
            }
        }
        return n;
    }

    public void setXTextRange(XTextRange xTextRange, XTextRange xTextRange2) {
        this.m_props.getXTextCursor().gotoRange(xTextRange.getStart(), false);
        this.m_props.getXTextCursor().gotoRange(xTextRange2.getEnd(), true);
    }

    public void setXTextRange(XTextRange xTextRange) throws BasicErrorException {
        this.m_props.setXTextRange(xTextRange);
    }

    public void setRange(XRange xRange, XRange xRange2) throws BasicErrorException {
        RangeImpl rangeImpl = null;
        RangeImpl rangeImpl2 = null;
        if (xRange2 instanceof RangeImpl && xRange instanceof RangeImpl) {
            rangeImpl2 = (RangeImpl)xRange2;
            rangeImpl = (RangeImpl)xRange;
        } else {
            DebugHelper.exception(5, "Start, End");
        }
        this.m_props.setMaySpanEndOfDocument(rangeImpl2.getMaySpanEndOfDocument());
        this.setXTextRange((XTextRange)rangeImpl.getXTextCursor(), (XTextRange)rangeImpl2.getXTextCursor());
    }

    public void InsertBefore(String string) throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        RangeHelper.insertString(xTextRange, this.m_props.getXText(), string, true);
        this.m_props.getXTextCursor().gotoRange(xTextRange, true);
    }

    public void InsertAfter(String string) throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getEnd();
        RangeHelper.insertString(xTextRange, this.m_props.getXText(), string, true);
        this.m_props.getXTextCursor().gotoRange(xTextRange, true);
    }

    public void InsertBreak(int n) throws BasicErrorException {
        BreakType breakType = null;
        switch (n) {
            case 7: {
                breakType = BreakType.PAGE_AFTER;
                break;
            }
            case 8: {
                breakType = BreakType.COLUMN_AFTER;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                DebugHelper.exception(73, "BreakType");
                break;
            }
            default: {
                DebugHelper.exception(14, "BreakType");
            }
        }
        if (breakType != null) {
            XTextCursor xTextCursor = this.m_props.getXTextCursor();
            if (!xTextCursor.isCollapsed()) {
                xTextCursor.setString("");
                xTextCursor.collapseToStart();
            }
            PropertySetHelper propertySetHelper = new PropertySetHelper(xTextCursor);
            propertySetHelper.setPropertyValue("BreakType", breakType);
        } else {
            DebugHelper.exception(14, "BreakType");
        }
    }

    public int nextUnit(int n, int n2, boolean bl) throws BasicErrorException {
        return RangeMovementHelper.nextUnit(this.m_props, n, n2, bl);
    }

    public int previousUnit(int n, int n2, boolean bl) throws BasicErrorException {
        return RangeMovementHelper.previousUnit(this.m_props, n, n2, bl);
    }

    protected int startOfSelection(int n, boolean bl) throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocumentImpl().getActiveWindow().getSelection();
        XTextRange xTextRange = selectionImpl.getXTextRange();
        XTextRange xTextRange2 = xTextRange.getStart();
        XTextRange xTextRange3 = xTextRange.getEnd();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        int n2 = selectionImpl.startOf(n, bl);
        this.setXTextRange(selectionImpl.getXTextRange());
        selectionImpl.setXTextRange(xTextRange2, xTextRange3);
        return n2;
    }

    protected int endOfSelection(int n, boolean bl) throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocumentImpl().getActiveWindow().getSelection();
        XTextRange xTextRange = selectionImpl.getXTextRange();
        XTextRange xTextRange2 = xTextRange.getStart();
        XTextRange xTextRange3 = xTextRange.getEnd();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        int n2 = selectionImpl.endOf(n, bl);
        this.setXTextRange(selectionImpl.getXTextRange());
        selectionImpl.setXTextRange(xTextRange2, xTextRange3);
        return n2;
    }

    public XRange Next(Object object, Object object2) throws BasicErrorException {
        int n = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        XRange xRange = this.Duplicate();
        XRangeDelegateIfc xRangeDelegateIfc = null;
        if (xRange instanceof XRangeDelegateIfc) {
            xRangeDelegateIfc = (XRangeDelegateIfc)xRange;
        } else {
            DebugHelper.exception(51, "Illegal ranmge object");
        }
        int n2 = RangeHelper.getTextUnit(object, 1);
        if (n > 0) {
            if (!xRangeDelegateIfc.getXTextCursor().isCollapsed()) {
                --n;
                RangeHelper.collapseLeftOrRight(true, xRangeDelegateIfc.getXTextCursor(), xRangeDelegateIfc.getDocument());
            }
            xRangeDelegateIfc.nextUnit(n2, n, false);
            xRangeDelegateIfc.nextUnit(n2, 1, true);
        } else if (n < 0) {
            ++n;
            if (!xRangeDelegateIfc.getXTextCursor().isCollapsed()) {
                RangeHelper.collapseLeftOrRight(false, xRangeDelegateIfc.getXTextCursor(), xRangeDelegateIfc.getDocument());
            }
            xRangeDelegateIfc.nextUnit(n2, n, false);
            xRangeDelegateIfc.nextUnit(n2, -1, true);
        }
        return xRangeDelegateIfc;
    }

    public XRange Previous(Object object, Object object2) throws BasicErrorException {
        return this.Next(object, object2);
    }

    public int StartOf(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 2);
        boolean bl = false;
        try {
            bl = NumericalHelper.toBoolean(object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        int n2 = 0;
        RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
        if (bl && this.m_props.getXTextCursor().isCollapsed()) {
            return this.previousUnit(n, 1, true);
        }
        XTextRange xTextRange = this.m_props.getXTextCursor().getEnd();
        this.m_props.getXTextCursor().collapseToStart();
        switch (n) {
            case 2: {
                XWordCursor xWordCursor = (XWordCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XWordCursor == null ? (class$com$sun$star$text$XWordCursor = BaseRangeImpl.class$("com.sun.star.text.XWordCursor")) : class$com$sun$star$text$XWordCursor), (Object)this.m_props.getXTextCursor());
                if (xWordCursor.isStartOfWord()) break;
                xWordCursor.gotoStartOfWord(false);
                break;
            }
            case 4: {
                XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = BaseRangeImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor), (Object)this.m_props.getXTextCursor());
                if (xParagraphCursor.isStartOfParagraph()) break;
                xParagraphCursor.gotoStartOfParagraph(false);
                break;
            }
            case 3: {
                XSentenceCursor xSentenceCursor = (XSentenceCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XSentenceCursor == null ? (class$com$sun$star$text$XSentenceCursor = BaseRangeImpl.class$("com.sun.star.text.XSentenceCursor")) : class$com$sun$star$text$XSentenceCursor), (Object)this.m_props.getXTextCursor());
                if (xSentenceCursor.isStartOfSentence()) break;
                xSentenceCursor.gotoStartOfSentence(false);
                break;
            }
            case 5: {
                n2 = this.startOfSelection(n, false);
                break;
            }
            case 6: {
                this.m_props.getXTextCursor().gotoRange(this.getDocumentImpl().getXTextRange().getStart(), false);
                break;
            }
            default: {
                DebugHelper.exception(51, "Unsupported Unit " + n + " for Range/Selection StartOf");
            }
        }
        if (bl) {
            this.m_props.getXTextCursor().gotoRange(xTextRange, true);
        }
        return n2;
    }

    public int EndOf(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 1);
        int n2 = 0;
        try {
            n2 = NumericalHelper.toInt(object2);
            if (n2 == -1) {
                n2 = 1;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n2 = 0;
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        int n3 = 0;
        int n4 = n;
        if (n2 == 0) {
            RangeHelper.collapseLeftOrRight(true, this.m_props.getXTextCursor(), this.getDocument());
        } else {
            RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
        }
        this.m_props.setMaySpanEndOfDocument(true);
        XWordCursor xWordCursor = (XWordCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XWordCursor == null ? (class$com$sun$star$text$XWordCursor = BaseRangeImpl.class$("com.sun.star.text.XWordCursor")) : class$com$sun$star$text$XWordCursor), (Object)this.m_props.getXTextCursor());
        switch (n4) {
            case 2: {
                xWordCursor.gotoEndOfWord(n2 == 1);
                break;
            }
            case 4: {
                XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = BaseRangeImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor), (Object)this.m_props.getXTextCursor());
                xParagraphCursor.gotoEndOfParagraph(n2 == 1);
                break;
            }
            case 3: {
                XSentenceCursor xSentenceCursor = (XSentenceCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XSentenceCursor == null ? (class$com$sun$star$text$XSentenceCursor = BaseRangeImpl.class$("com.sun.star.text.XSentenceCursor")) : class$com$sun$star$text$XSentenceCursor), (Object)this.m_props.getXTextCursor());
                xSentenceCursor.gotoEndOfSentence(n2 == 1);
                break;
            }
            case 5: {
                n3 = this.endOfSelection(n, n2 == 1);
                break;
            }
            default: {
                DebugHelper.exception(51, "Unsupported Unit " + n + " for Range/Selection StartOf");
            }
        }
        if (n4 != 5 || n2 == 1) {
            if (n4 != 3) {
                int n5;
                XTextRange xTextRange = xWordCursor.getStart();
                xWordCursor.collapseToEnd();
                xWordCursor.gotoNextWord(n2 == 1);
                String string = xWordCursor.getString();
                int n6 = string.length();
                if (n6 > 0 && (n5 = string.indexOf(10)) != -1 && n5 != n6 - 1) {
                    n3 += n5;
                    xWordCursor.collapseToStart();
                    xWordCursor.goRight((short)n5, true);
                }
                if (n2 == 1) {
                    XTextRange xTextRange2 = xWordCursor.getEnd();
                    xWordCursor.gotoRange(xTextRange, false);
                    xWordCursor.gotoRange(xTextRange2, true);
                } else {
                    xWordCursor.collapseToEnd();
                }
            } else {
                xWordCursor.gotoNextWord(n2 == 1);
            }
        }
        return n3;
    }

    public int Move(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 1);
        int n2 = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        if (n2 > 0) {
            RangeHelper.collapseLeftOrRight(true, this.m_props.getXTextCursor(), this.getDocument());
            this.nextUnit(n, -1, false);
            return this.nextUnit(n, n2, false);
        }
        RangeHelper.collapseLeftOrRight(false, this.m_props.getXTextCursor(), this.getDocument());
        this.nextUnit(n, 1, false);
        return this.previousUnit(n, -n2, false);
    }

    public int MoveStart(Object object, Object object2) throws BasicErrorException {
        int n;
        block4: {
            int n2 = RangeHelper.getTextUnit(object, 1);
            n = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
            RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
            if (n == 0) {
                return 0;
            }
            XTextRange xTextRange = this.m_props.getXTextCursor().getEnd();
            this.m_props.getXTextCursor().collapseToStart();
            boolean bl = n < 0;
            n = this.nextUnit(n2, n, false);
            n = bl ? -n : n;
            XTextRangeCompare xTextRangeCompare = RangeHelper.getRangeComparator(this.getDocument());
            try {
                if (xTextRangeCompare.compareRegionStarts((XTextRange)this.m_props.getXTextCursor(), xTextRange) < 0) {
                    this.m_props.getXTextCursor().collapseToStart();
                    break block4;
                }
                this.m_props.getXTextCursor().gotoRange(xTextRange, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
                this.m_props.getXTextCursor().gotoRange(xTextRange, true);
            }
        }
        return n;
    }

    public int MoveEnd(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 1);
        int n2 = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
        if (n2 == 0) {
            return 0;
        }
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        this.m_props.getXTextCursor().collapseToEnd();
        n2 = this.nextUnit(n, n2, false);
        XTextRangeCompare xTextRangeCompare = RangeHelper.getRangeComparator(this.getDocument());
        try {
            if (xTextRangeCompare.compareRegionStarts((XTextRange)this.m_props.getXTextCursor(), xTextRange) < 0) {
                this.m_props.getXTextCursor().gotoRange(xTextRange, true);
                RangeHelper.swapDirection(this.m_props.getXTextCursor());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return n2;
    }

    public int MoveWhile(String string, Object object) throws BasicErrorException {
        int n = NumericalHelper.toInt(object, 0x3FFFFFFF);
        boolean bl = false;
        XTextCursor xTextCursor = this.m_props.getXTextCursor();
        if (n >= 0) {
            xTextCursor.collapseToEnd();
        } else {
            xTextCursor.collapseToStart();
        }
        int n2 = 0;
        while (!bl && n2 < Math.abs(n)) {
            XTextRange xTextRange = xTextCursor.getEnd();
            String string2 = RangeMovementHelper.getNeighborChar(xTextRange, n >= 0);
            if (string2 != null && string.indexOf(string2) != -1) {
                if (!RangeMovementHelper.moveCursorOneChar(xTextCursor, true, n >= 0, false)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            ++n2;
        }
        return n >= 0 ? n2 : -(--n2);
    }

    public int MoveStartWhile(String string, Object object) throws BasicErrorException {
        int n = NumericalHelper.toInt(object, 0x3FFFFFFF);
        boolean bl = false;
        XTextCursor xTextCursor = this.m_props.getXTextCursor();
        boolean bl2 = true;
        boolean bl3 = n >= 0;
        int n2 = 0;
        while (!bl && n2 < Math.abs(n)) {
            XTextRange xTextRange = xTextCursor.getStart();
            String string2 = RangeMovementHelper.getNeighborChar(xTextRange, bl3);
            if (string2 != null && string.indexOf(string2) != -1) {
                if (!RangeMovementHelper.moveCursorOneChar(xTextCursor, false, bl3, bl2)) {
                    bl = true;
                } else if (bl3 && RangeHelper.compareStartAndEnd(xTextCursor, this.m_props.getDocumentImpl()) > 0) {
                    xTextCursor.collapseToStart();
                    bl2 = false;
                }
            } else {
                bl = true;
            }
            ++n2;
        }
        return bl3 ? n2 : -(--n2);
    }

    public int MoveEndWhile(String string, Object object) throws BasicErrorException {
        int n = NumericalHelper.toInt(object, 0x3FFFFFFF);
        boolean bl = false;
        XTextCursor xTextCursor = this.m_props.getXTextCursor();
        boolean bl2 = true;
        boolean bl3 = n >= 0;
        int n2 = 0;
        while (!bl && n2 < Math.abs(n)) {
            XTextRange xTextRange = xTextCursor.getEnd();
            String string2 = RangeMovementHelper.getNeighborChar(xTextRange, bl3);
            if (string2 != null && string.indexOf(string2) != -1) {
                if (!RangeMovementHelper.moveCursorOneChar(xTextCursor, true, bl3, bl2)) {
                    bl = true;
                } else if (!bl3 && RangeHelper.compareStartAndEnd(xTextCursor, this.m_props.getDocumentImpl()) > 0) {
                    xTextCursor.collapseToEnd();
                    bl2 = false;
                }
            } else {
                bl = true;
            }
            ++n2;
        }
        return bl3 ? n2 : -(--n2);
    }

    public int MoveUntil(String string, Object object) throws BasicErrorException {
        int n = NumericalHelper.toInt(object, 0x3FFFFFFF);
        boolean bl = false;
        XTextCursor xTextCursor = this.m_props.getXTextCursor();
        if (n >= 0) {
            xTextCursor.collapseToEnd();
        } else {
            xTextCursor.collapseToStart();
        }
        int n2 = 0;
        while (!bl && n2 < Math.abs(n)) {
            XTextRange xTextRange = xTextCursor.getEnd();
            String string2 = RangeMovementHelper.getNeighborChar(xTextRange, n >= 0);
            if (string2 != null && string.indexOf(string2) == -1) {
                if (!RangeMovementHelper.moveCursorOneChar(xTextCursor, true, n >= 0, false)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            ++n2;
        }
        return n >= 0 ? n2 : -n2;
    }

    public int MoveStartUntil(String string, Object object) throws BasicErrorException {
        int n = NumericalHelper.toInt(object, 0x3FFFFFFF);
        boolean bl = false;
        XTextCursor xTextCursor = this.m_props.getXTextCursor();
        boolean bl2 = true;
        boolean bl3 = n >= 0;
        int n2 = 0;
        while (!bl && n2 < Math.abs(n)) {
            XTextRange xTextRange = xTextCursor.getStart();
            String string2 = RangeMovementHelper.getNeighborChar(xTextRange, bl3);
            if (string2 != null && string.indexOf(string2) == -1) {
                if (!RangeMovementHelper.moveCursorOneChar(xTextCursor, false, bl3, bl2)) {
                    bl = true;
                } else if (bl3 && RangeHelper.compareStartAndEnd(xTextCursor, this.m_props.getDocumentImpl()) > 0) {
                    xTextCursor.collapseToStart();
                    bl2 = false;
                }
            } else {
                bl = true;
            }
            ++n2;
        }
        return bl3 ? n2 : -n2;
    }

    public int MoveEndUntil(String string, Object object) throws BasicErrorException {
        int n = NumericalHelper.toInt(object, 0x3FFFFFFF);
        boolean bl = false;
        XTextCursor xTextCursor = this.m_props.getXTextCursor();
        String string2 = xTextCursor.getString();
        boolean bl2 = true;
        boolean bl3 = n >= 0;
        int n2 = 0;
        while (!bl && n2 < Math.abs(n)) {
            XTextRange xTextRange = xTextCursor.getEnd();
            String string3 = RangeMovementHelper.getNeighborChar(xTextRange, bl3);
            if (string3 != null && string.indexOf(string3) == -1) {
                if (!RangeMovementHelper.moveCursorOneChar(xTextCursor, true, bl3, bl2)) {
                    bl = true;
                } else if (!bl3 && RangeHelper.compareStartAndEnd(xTextCursor, this.m_props.getDocumentImpl()) > 0) {
                    xTextCursor.collapseToEnd();
                    bl2 = false;
                }
            } else {
                bl = true;
            }
            ++n2;
        }
        return bl3 ? n2 : -n2;
    }

    public void InsertFile(Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        RangeFilename rangeFilename;
        XTextCursor xTextCursor = this.getXTextCursor();
        String string = null;
        try {
            string = NumericalHelper.toString(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception(5, "FileName");
        }
        boolean bl = NumericalHelper.toBoolean(object3, false);
        if (bl) {
            DebugHelper.writeInfo("ConfirmConversions property is not supported");
        }
        if (!AnyConverter.isVoid((Object)object2)) {
            DebugHelper.exception(73, "Range");
        }
        if (!AnyConverter.isVoid((Object)object4)) {
            DebugHelper.exception(73, "Link");
        }
        if (!AnyConverter.isVoid((Object)object5)) {
            DebugHelper.exception(73, "Attachment");
        }
        if (!(rangeFilename = new RangeFilename(string)).checkExistanceForRead()) {
            DebugHelper.exception(53, string);
        }
        try {
            XDocumentInsertable xDocumentInsertable = (XDocumentInsertable)OptionalParamUtility.getObject(class$com$sun$star$document$XDocumentInsertable == null ? (class$com$sun$star$document$XDocumentInsertable = BaseRangeImpl.class$("com.sun.star.document.XDocumentInsertable")) : class$com$sun$star$document$XDocumentInsertable, xTextCursor);
            PropertyValue[] propertyValueArray = new PropertyValue[]{};
            xDocumentInsertable.insertDocumentFromURL(rangeFilename.getURL(), propertyValueArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (IOException iOException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)iOException));
        }
    }

    public void Cut() throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        selectionImpl.Cut();
    }

    public void Copy() throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        selectionImpl.Copy();
    }

    public void Paste() throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        selectionImpl.Paste();
    }

    public int ComputeStatistics(int n) throws BasicErrorException {
        int n2 = 0;
        switch (n) {
            case 3: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 13;
                break;
            }
            case 0: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 7;
                break;
            }
            default: {
                DebugHelper.exception(73, "StatisticUnit");
            }
        }
        return this.getStatisticCount(n2);
    }

    public boolean InRange(XRange xRange) throws BasicErrorException {
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = BaseRangeImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)this.m_props.getXTextCursor().getText());
        try {
            if (xTextRangeCompare.compareRegionStarts(xRange.getXTextRange(), (XTextRange)this.m_props.getXTextCursor()) >= 0 && xTextRangeCompare.compareRegionEnds(xRange.getXTextRange(), (XTextRange)this.m_props.getXTextCursor()) <= 0) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return false;
    }

    public void Delete(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 1);
        int n2 = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        int n3 = n;
        RangeHelper.collapseLeftOrRight(false, this.m_props.getXTextCursor(), this.getDocument());
        if (n2 == 0) {
            return;
        }
        if (n3 == 1 || n3 == 2) {
            RangeImpl rangeImpl = new RangeImpl((HelperInterfaceAdaptor)this.getDocumentImpl(), this.getXTextCursor().getStart(), false);
            if (n2 > 0) {
                rangeImpl.nextUnit(n, n2, true);
            } else {
                rangeImpl.previousUnit(n, -n2, true);
            }
            boolean bl = false;
            if (n2 < 0) {
                String string = rangeImpl.getXTextCursor().getString();
                if (string.indexOf(10) != -1) {
                    bl = true;
                }
                if (string.length() > 0 && string.charAt(string.length() - 1) != ' ') {
                    String string2;
                    int n4;
                    rangeImpl.getXTextCursor().collapseToStart();
                    do {
                        n4 = rangeImpl.previousUnit(1, 1, true);
                        string2 = rangeImpl.getXTextCursor().getString();
                    } while (n4 == 1 && string2.length() > 0 && string2.charAt(0) == ' ');
                    if (n4 == 1) {
                        rangeImpl.nextUnit(1, 1, true);
                    }
                    rangeImpl.setEndRange(this.getXTextRange());
                }
            }
            if (bl) {
                rangeImpl.getXTextCursor().setString(" ");
            } else {
                rangeImpl.getXTextCursor().setString("");
            }
            this.m_props.getXTextCursor().gotoRange(rangeImpl.getXTextCursor().getStart(), false);
        } else {
            DebugHelper.exception(51, "Unit to delete must be either Character or Word");
        }
    }

    public int extendNext(boolean bl) throws BasicErrorException {
        int n;
        int n2 = n = 1;
        boolean bl2 = RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        XTextRange xTextRange2 = this.m_props.getXTextCursor().getEnd();
        XTextRangeCompare xTextRangeCompare = RangeHelper.getRangeComparator(this.getDocument());
        try {
            do {
                if (n == 4) {
                    this.m_props.getXTextCursor().gotoRange(this.getDocumentImpl().getXTextRange().getStart(), false);
                } else if (n == 8) {
                    this.m_props.getXTextCursor().gotoRange(this.getDocumentImpl().getXTextRange().getStart(), false);
                } else {
                    this.m_props.getXTextCursor().collapseToStart();
                }
                n2 = n;
                n = RangeHelper.getNextExtent(n);
                this.nextUnit(n, 1, true);
                short s = xTextRangeCompare.compareRegionEnds((XTextRange)this.m_props.getXTextCursor(), xTextRange2);
                if (s > 0) continue;
                if (s == 0) {
                    n2 = n;
                }
                break;
            } while (n < 6);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        if (bl) {
            if (n == n2) {
                n2 = RangeHelper.getNextExtent(n);
                this.nextUnit(n2, 1, true);
            }
        } else {
            if (n > 4) {
                this.m_props.getXTextCursor().gotoRange(xTextRange, false);
            } else {
                this.m_props.getXTextCursor().collapseToStart();
            }
            this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
            if (bl2) {
                RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
            }
        }
        return n2;
    }

    public int Expand(Object object) throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getEnd();
        this.m_props.getXTextCursor().collapseToStart();
        int n = RangeHelper.getTextUnit(object, 1);
        if (n == 6) {
            DocumentImpl documentImpl = this.getDocumentImpl();
            XTextRange xTextRange2 = documentImpl.getXTextRange();
            this.m_props.setXTextRange(xTextRange2);
            this.m_props.setMaySpanEndOfDocument(true);
            return 0;
        }
        int n2 = 0;
        if (n != 1) {
            n2 += this.previousUnit(n, 1, false);
        }
        n2 = this.nextUnit(n, 1, true);
        DocumentImpl documentImpl = (DocumentImpl)this.getDocument();
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = BaseRangeImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)documentImpl.getXTextRange());
        try {
            if (xTextRangeCompare.compareRegionEnds(xTextRange, (XTextRange)this.m_props.getXTextCursor()) > 0) {
                return n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        this.m_props.getXTextCursor().gotoRange(xTextRange, true);
        return n2;
    }

    protected void setStartRange(XTextRange xTextRange) {
        XTextRange xTextRange2 = this.getXTextCursor().getEnd();
        this.setStartEndRange(xTextRange, xTextRange2);
    }

    public void setEndRange(XTextRange xTextRange) {
        this.m_props.getXTextCursor().collapseToStart();
        this.m_props.getXTextCursor().gotoRange(xTextRange, true);
    }

    protected void setStartEndRange(XTextRange xTextRange, XTextRange xTextRange2) {
        this.m_props.getXTextCursor().gotoRange(xTextRange, false);
        this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
    }

    public void InsertParagraph() throws BasicErrorException {
        this.m_props.getXTextCursor().setString("");
        RangeHelper.insertControlCharacter((XTextRange)this.m_props.getXTextCursor(), this.m_props.getXText(), (short)0, true);
    }

    public void InsertParagraphBefore() throws BasicErrorException {
        RangeHelper.insertControlCharacter(this.m_props.getXTextCursor().getStart(), this.m_props.getXText(), (short)0, true);
        this.m_props.getXTextCursor().goLeft((short)1, true);
        this.m_props.setXText(this.m_props.getXTextCursor().getText());
    }

    public void InsertParagraphAfter() throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        RangeHelper.insertControlCharacter(this.m_props.getXTextCursor().getEnd(), this.m_props.getXText(), (short)0, true);
        this.m_props.getXTextCursor().goRight((short)1, true);
        XTextRange xTextRange2 = this.m_props.getXTextCursor().getEnd();
        this.m_props.getXTextCursor().gotoRange(xTextRange, false);
        this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
        this.m_props.setXText(this.m_props.getXTextCursor().getText());
    }

    public void WholeStory() throws BasicErrorException {
        this.Expand(new Integer(6));
    }

    public void CheckSpelling(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12) throws BasicErrorException {
        Object object13;
        boolean bl;
        WriterImpl writerImpl = ApplicationImpl.getWriterImpl();
        OptionsImpl optionsImpl = new OptionsImpl(writerImpl);
        boolean bl2 = optionsImpl.getIgnoreUppercase();
        boolean bl3 = NumericalHelper.toBoolean(object2, bl2);
        if (bl3 != bl2) {
            bl2 = bl3;
            optionsImpl.setIgnoreUppercase(bl2);
        }
        if (!(bl = NumericalHelper.toBoolean(object3, optionsImpl.getSuggestSpellingCorrections()))) {
            DebugHelper.exception(976, "AlwaysSuggest is false");
        }
        Vector<Object> vector = new Vector<Object>();
        if (!AnyConverter.isVoid((Object)object)) {
            vector.add(object);
        }
        if (!AnyConverter.isVoid((Object)object4)) {
            vector.add(object4);
        }
        if (!AnyConverter.isVoid((Object)object5)) {
            vector.add(object5);
        }
        if (!AnyConverter.isVoid((Object)object6)) {
            vector.add(object6);
        }
        if (!AnyConverter.isVoid((Object)object7)) {
            vector.add(object7);
        }
        if (!AnyConverter.isVoid((Object)object8)) {
            vector.add(object8);
        }
        if (!AnyConverter.isVoid((Object)object9)) {
            vector.add(object9);
        }
        if (!AnyConverter.isVoid((Object)object10)) {
            vector.add(object10);
        }
        if (!AnyConverter.isVoid((Object)object11)) {
            vector.add(object11);
        }
        if (!AnyConverter.isVoid((Object)object12)) {
            vector.add(object12);
        }
        RangeHelper.enableDictionaries(optionsImpl, vector.toArray(), object == null);
        boolean bl4 = true;
        String string = this.getText();
        try {
            object13 = ApplicationImpl.getXMultiServiceFactory().createInstance("com.sun.star.linguistic2.SpellChecker");
            XSpellChecker xSpellChecker = (XSpellChecker)OptionalParamUtility.getObject(class$com$sun$star$linguistic2$XSpellChecker == null ? (class$com$sun$star$linguistic2$XSpellChecker = BaseRangeImpl.class$("com.sun.star.linguistic2.XSpellChecker")) : class$com$sun$star$linguistic2$XSpellChecker, object13);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                boolean bl5 = bl4 = !xSpellChecker.isValid(string2, RangeHelper.getAdjacentLocale(this.getXTextRange()), new PropertyValue[0]);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        if (bl4) {
            this.Select();
            object13 = this.m_props.getRangeImpl().getXModel();
            DispatchCommand.execute(".uno:SpellDialog", object13.getCurrentController().getFrame());
        }
    }

    public void Sort(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16, Object object17, Object object18, Object object19) throws BasicErrorException {
        try {
            XSortable xSortable = (XSortable)OptionalParamUtility.getObject(class$com$sun$star$util$XSortable == null ? (class$com$sun$star$util$XSortable = BaseRangeImpl.class$("com.sun.star.util.XSortable")) : class$com$sun$star$util$XSortable, this.m_props.getXTextRange());
            PropertyValue[] propertyValueArray = xSortable.createSortDescriptor();
            int n = 0;
            while (n < propertyValueArray.length) {
                DebugHelper.writeInfo("PropValue: " + propertyValueArray[n].Name + "   " + propertyValueArray[n].Value);
                ++n;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            if (!AnyConverter.isVoid((Object)object)) {
                hashtable.put("ExcludeHeader", object);
            }
            if (!AnyConverter.isVoid((Object)object2)) {
                hashtable.put("FieldNumber", object2);
            }
            if (!AnyConverter.isVoid((Object)object3)) {
                hashtable.put("SortFieldType", object3);
            }
            if (!AnyConverter.isVoid((Object)object4)) {
                hashtable.put("SortOrder", object4);
            }
            if (!AnyConverter.isVoid((Object)object5)) {
                hashtable.put("FieldNumber2", object5);
            }
            if (!AnyConverter.isVoid((Object)object6)) {
                hashtable.put("SortFieldType2", object6);
            }
            if (!AnyConverter.isVoid((Object)object7)) {
                hashtable.put("SortOrder2", object7);
            }
            if (!AnyConverter.isVoid((Object)object8)) {
                hashtable.put("FieldNumber3", object8);
            }
            if (!AnyConverter.isVoid((Object)object9)) {
                hashtable.put("SortFieldType3", object9);
            }
            if (!AnyConverter.isVoid((Object)object10)) {
                hashtable.put("SortOrder3", object10);
            }
            if (!AnyConverter.isVoid((Object)object11)) {
                hashtable.put("SortColumn", object11);
            }
            if (!AnyConverter.isVoid((Object)object12)) {
                hashtable.put("Separator", object12);
            }
            if (!AnyConverter.isVoid((Object)object13)) {
                hashtable.put("CaseSensitive", object13);
            }
            if (!AnyConverter.isVoid((Object)object14)) {
                DebugHelper.exception(73, "BidiSort");
            }
            if (!AnyConverter.isVoid((Object)object15)) {
                DebugHelper.exception(73, "IgnoreThe");
            }
            if (!AnyConverter.isVoid((Object)object16)) {
                DebugHelper.exception(73, "IgnoreKashida");
            }
            if (!AnyConverter.isVoid((Object)object17)) {
                DebugHelper.exception(73, "IgnoreDiacritics");
            }
            if (!AnyConverter.isVoid((Object)object18)) {
                DebugHelper.exception(73, "IgnoreHe");
            }
            if (!AnyConverter.isVoid((Object)object19)) {
                hashtable.put("LanguageID", object19);
            }
            xSortable.sort(RangeSortDescriptorHelper.completeSortDescriptorProperties(propertyValueArray, hashtable));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
    }

    public void InsertDateTime(Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        Object object6 = null;
        String string = OptionalParamUtility.getString("DateTimeFormat", object, null, false);
        boolean bl = OptionalParamUtility.getBoolean("InsertAsField", object2, true, false);
        boolean bl2 = OptionalParamUtility.getBoolean("InsertAsFullWidth", object3, false, false);
        try {
            StringBuffer stringBuffer;
            XMultiServiceFactory xMultiServiceFactory = ((DocumentImpl)this.getDocument()).getXMultiServiceFactory();
            object6 = xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DateTime");
            XTextField xTextField = (XTextField)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = BaseRangeImpl.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField), (Object)object6);
            if (bl2) {
                if (string == null) {
                    string = xTextField.getPresentation(true);
                }
                string = RangeHelper.doubleUp(stringBuffer = new StringBuffer(string), 'D') || RangeHelper.doubleUp(stringBuffer, 'M') ? stringBuffer.toString() : null;
            }
            stringBuffer = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = BaseRangeImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
            stringBuffer.setPropertyValue("IsFixed", Boolean.TRUE);
            if (string != null) {
                stringBuffer.setPropertyValue("NumberFormat", string);
            }
            this.m_props.getXText().insertTextContent((XTextRange)this.m_props.getXTextCursor(), (XTextContent)xTextField, bl);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getStatisticCount(int n) throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        XTextRange xTextRange2 = this.m_props.getXTextCursor().getEnd();
        XTextCursor xTextCursor = this.m_props.getXTextCursor();
        xTextCursor.collapseToStart();
        int n2 = 0;
        switch (n) {
            case 13: {
                while (RangeHelper.compareRangesPosition((XTextRange)xTextCursor, xTextRange2) == 2) {
                    xTextCursor.goRight((short)1, true);
                    ++n2;
                    xTextCursor.collapseToEnd();
                }
                break;
            }
            case 1: {
                while (RangeHelper.compareRangesPosition((XTextRange)xTextCursor, xTextRange2) == 2) {
                    xTextCursor.goRight((short)1, true);
                    String string = xTextCursor.getString();
                    if (!string.equals(" ")) {
                        ++n2;
                    }
                    xTextCursor.collapseToEnd();
                }
                break;
            }
            case 2: {
                XWordCursor xWordCursor = (XWordCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XWordCursor == null ? (class$com$sun$star$text$XWordCursor = BaseRangeImpl.class$("com.sun.star.text.XWordCursor")) : class$com$sun$star$text$XWordCursor), (Object)xTextCursor);
                while (RangeHelper.compareRangesPosition((XTextRange)xWordCursor, xTextRange2) == 2) {
                    xWordCursor.gotoNextWord(false);
                    ++n2;
                }
                break;
            }
            case 4: {
                XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = BaseRangeImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor), (Object)xTextCursor);
                while (RangeHelper.compareRangesPosition((XTextRange)xParagraphCursor, xTextRange2) != -2) {
                    xParagraphCursor.gotoNextParagraph(false);
                    ++n2;
                }
                break;
            }
            case 7: {
                XPageCursor xPageCursor = (XPageCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XPageCursor == null ? (class$com$sun$star$text$XPageCursor = BaseRangeImpl.class$("com.sun.star.text.XPageCursor")) : class$com$sun$star$text$XPageCursor), (Object)xTextCursor);
                if (xPageCursor == null) break;
                xPageCursor.jumpToLastPage();
                n2 = xPageCursor.getPage();
                break;
            }
            default: {
                DebugHelper.exception(73, "");
            }
        }
        this.m_props.getXTextCursor().gotoRange(xTextRange, false);
        this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
        return n2;
    }

    public XPageSetup PageSetup() throws BasicErrorException {
        XDocument xDocument = this.getDocument();
        return xDocument.getPageSetup();
    }

    public XWords Words() throws BasicErrorException {
        return new WordsImpl(this.m_props.getRangeImpl(), null);
    }

    public int getOrientation() throws BasicErrorException {
        int n = 0;
        HelperInterfaceAdaptor helperInterfaceAdaptor = this.m_props.getRangeImpl().getParentAdaptor();
        if (helperInterfaceAdaptor instanceof XTextFrame) {
            try {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = BaseRangeImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.m_props.getXTextCursor());
                Object object = xPropertySet.getPropertyValue("CharRotation");
                short s = NumericalHelper.toShort(object);
                n = RangeHelper.getOrientationFromRotation(s);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        } else {
            DebugHelper.exception(438, "");
        }
        return n;
    }

    public void setOrientation(int n) throws BasicErrorException {
        HelperInterfaceAdaptor helperInterfaceAdaptor = this.m_props.getRangeImpl().getParentAdaptor();
        if (helperInterfaceAdaptor instanceof XTextFrame) {
            short s = 0;
            try {
                s = RangeHelper.getRotationFromOrientation(n);
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = BaseRangeImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.m_props.getXTextCursor());
                xPropertySet.setPropertyValue("CharRotation", (Object)new Short(s));
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)unknownPropertyException));
            }
            catch (PropertyVetoException propertyVetoException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)propertyVetoException));
            }
            catch (NoSupportException noSupportException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)noSupportException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        } else {
            DebugHelper.exception(438, "");
        }
    }

    public Object getNoProofing() throws BasicErrorException {
        Comparable<Boolean> comparable;
        block6: {
            comparable = Boolean.FALSE;
            try {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = BaseRangeImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.m_props.getXTextCursor());
                Object object = xPropertySet.getPropertyValue("CharLocale");
                if (object instanceof Locale) {
                    Locale locale = (Locale)object;
                    if (locale == null) {
                        comparable = new Integer(9999999);
                        break block6;
                    }
                    if (locale.Language != null && locale.Language.length() != 0) break block6;
                    comparable = Boolean.TRUE;
                    break block6;
                }
                comparable = new Integer(9999999);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
        }
        return comparable;
    }

    public void setNoProofing(Object object) throws BasicErrorException {
        block8: {
            int n = 9999999;
            try {
                n = NumericalHelper.toInt(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeDebugWarning((Exception)((Object)illegalArgumentException));
            }
            if (n == 9999999) break block8;
            boolean bl = n != 0;
            try {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = BaseRangeImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.m_props.getXTextCursor());
                if (bl) {
                    Locale locale = new Locale();
                    xPropertySet.setPropertyValue("CharLocale", (Object)locale);
                    break block8;
                }
                Locale locale = RangeHelper.getAdjacentLocale(this.m_props.getXTextRange());
                xPropertySet.setPropertyValue("CharLocale", (Object)locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
            catch (PropertyVetoException propertyVetoException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)propertyVetoException));
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
        }
    }

    public XCharacters Characters() throws BasicErrorException {
        return new CharactersImpl(this.m_props.getRangeImpl());
    }

    public XFields Fields() throws BasicErrorException {
        return new FieldsImpl(this.m_props.getRangeImpl());
    }

    public XHyperlinks Hyperlinks() throws BasicErrorException {
        return new HyperlinksImpl(this.m_props.getRangeImpl());
    }

    public int getLanguageID() throws BasicErrorException {
        int n = 9999999;
        try {
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = BaseRangeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.m_props.getRangeImpl().getXModel().getCurrentController());
            Object object = xSelectionSupplier.getSelection();
            SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
            RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
            n = selectionImpl.getLanguageID();
            xSelectionSupplier.select(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public void setLanguageID(int n) throws BasicErrorException {
        try {
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = BaseRangeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.m_props.getRangeImpl().getXModel().getCurrentController());
            Object object = xSelectionSupplier.getSelection();
            SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
            RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
            selectionImpl.setLanguageID(n);
            xSelectionSupplier.select(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
    }

    public XListFormat ListFormat() throws BasicErrorException {
        return new ListFormatImpl(this.m_props.getRangeImpl());
    }

    public XFind Find() throws BasicErrorException {
        FindImpl findImpl = null;
        try {
            findImpl = new FindImpl(this.m_props.getRangeImpl());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return findImpl;
    }

    public int Information(int n) throws BasicErrorException {
        int n2 = 9999999;
        try {
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = BaseRangeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.m_props.getRangeImpl().getXModel().getCurrentController());
            Object object = xSelectionSupplier.getSelection();
            SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
            xSelectionSupplier.select((Object)this.getXTextRange());
            n2 = selectionImpl.Information(n);
            xSelectionSupplier.select(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return n2;
    }

    public XTextCursor getXTextCursor() {
        return this.m_props.getXTextCursor();
    }

    public void setXTextCursor(XTextCursor xTextCursor) {
        this.m_props.setXTextCursor(xTextCursor);
    }

    public XText getXText() {
        return this.m_props.getXText();
    }

    public void setXText(XText xText) {
        this.m_props.setXText(xText);
    }

    public boolean getMaySpanEndOfDocument() {
        return this.m_props.getMaySpanEndOfDocument();
    }

    public void setMaySpanEndOfDocument(boolean bl) {
        this.m_props.setMaySpanEndOfDocument(bl);
    }

    public XRange GoTo(Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        XRange xRange = null;
        try {
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = BaseRangeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.m_props.getRangeImpl().getXModel().getCurrentController());
            Object object5 = xSelectionSupplier.getSelection();
            xSelectionSupplier.select((Object)this.getXTextRange());
            SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
            xRange = selectionImpl.GoTo(object, object2, object3, object4);
            xSelectionSupplier.select(object5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return xRange;
    }

    public RangeImpl getRangeImpl() {
        return this.m_props.getRangeImpl();
    }

    public XSpellingSuggestions GetSpellingSuggestions(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) throws BasicErrorException {
        XSpellingSuggestions xSpellingSuggestions = null;
        try {
            XRange xRange = this.Words().Item(new Integer(1));
            String string = xRange.getText();
            WriterImpl writerImpl = ApplicationImpl.getWriterImpl();
            xSpellingSuggestions = writerImpl.GetSpellingSuggestions(string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return xSpellingSuggestions;
    }

    public Object getUnoObject() {
        return this.m_props.getXTextRange();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

