/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import java.util.ArrayList;

public class WriterFileFormatHelper {
    int m_nFileFormatIdentifier = 0;
    String m_sFileFormat = "";
    String m_sFileExtension = "";
    boolean m_bStoreAsText = false;
    ArrayList m_aPropertyList;

    public WriterFileFormatHelper(int n, ArrayList arrayList) {
        this.m_nFileFormatIdentifier = n;
        this.m_aPropertyList = arrayList;
        this.init();
    }

    private void init() {
        PropertyValue propertyValue;
        if (CommonUtilities.isVersion8()) {
            this.m_sFileFormat = "writer8";
            this.m_sFileExtension = ".odt";
        } else {
            this.m_sFileFormat = "StarOffice XML (Writer)";
            this.m_sFileExtension = ".sxw";
        }
        switch (this.m_nFileFormatIdentifier) {
            case 0: {
                break;
            }
            case 1: {
                if (CommonUtilities.isVersion8()) {
                    this.m_sFileFormat = "writer8_template";
                    this.m_sFileExtension = ".ott";
                    break;
                }
                this.m_sFileFormat = "writer_StarOffice_XML_Writer_Template";
                this.m_sFileExtension = ".stw";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.m_sFileFormat = "Text (encoded)";
                this.m_sFileExtension = ".txt";
                this.m_bStoreAsText = true;
                break;
            }
            case 8: {
                this.m_sFileFormat = "HTML (StarWriter)";
                this.m_sFileExtension = ".html";
                break;
            }
            case 6: {
                this.m_sFileFormat = "Rich Text Format";
                this.m_sFileExtension = ".rtf";
                break;
            }
        }
        if (this.m_nFileFormatIdentifier == 1) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "AsTemplate";
            propertyValue.Value = Boolean.TRUE;
            this.m_aPropertyList.add(propertyValue);
            DebugHelper.writeInfo("FileFormatHelper() Property 'AsTemplate' := 'true'");
        }
        if (this.m_sFileFormat.length() > 0) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "FilterName";
            propertyValue.Value = this.m_sFileFormat;
            this.m_aPropertyList.add(propertyValue);
            DebugHelper.writeInfo("FileFormatHelper(): Property 'FileFormat' := '" + this.m_sFileFormat + "'");
        }
    }

    public String getFileFormat() {
        return this.m_sFileFormat;
    }

    public String getFileExtension() {
        return this.m_sFileExtension;
    }

    public boolean storeAsText() {
        return this.m_bStoreAsText;
    }

    public static void main(String[] stringArray) {
    }
}

