/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.drawing.XShape;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.Millimeter;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;

public class ShapeHelper {
    protected XShape xShape;

    public ShapeHelper(XShape xShape) {
        this.xShape = xShape;
    }

    public double getHeight() {
        return Millimeter.getInPoints(this.xShape.getSize().Height);
    }

    public void setHeight(double d) throws BasicErrorException {
        try {
            Size size = this.xShape.getSize();
            size.Height = Millimeter.getInHundredthsOfOneMillimeter(d);
            this.xShape.setSize(size);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getWidth() {
        return Millimeter.getInPoints(this.xShape.getSize().Width);
    }

    public void setWidth(double d) throws BasicErrorException {
        try {
            Size size = this.xShape.getSize();
            size.Width = Millimeter.getInHundredthsOfOneMillimeter(d);
            this.xShape.setSize(size);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getLeft() {
        return Millimeter.getInPoints(this.xShape.getPosition().X);
    }

    public void setLeft(double d) {
        Point point = this.xShape.getPosition();
        point.X = Millimeter.getInHundredthsOfOneMillimeter(d);
        this.xShape.setPosition(point);
    }

    public double getTop() {
        return Millimeter.getInPoints(this.xShape.getPosition().Y);
    }

    public void setTop(double d) {
        Point point = this.xShape.getPosition();
        point.Y = Millimeter.getInHundredthsOfOneMillimeter(d);
        this.xShape.setPosition(point);
    }
}

