/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;

public class PropertySetHelper {
    XPropertySet m_xPropertySet;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;

    public PropertySetHelper(Object object) {
        this.m_xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = PropertySetHelper.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
    }

    public void setPropertyValueDontThrow(String string, Object object) {
        try {
            this.setPropertyValue(string, object);
        }
        catch (BasicErrorException basicErrorException) {
            DebugHelper.writeInfo("Don't throw the exception with property name(" + string + " ) : " + basicErrorException.getMessage());
        }
    }

    public void setPropertyValue(String string, Object object) throws BasicErrorException {
        if (this.m_xPropertySet != null) {
            try {
                this.m_xPropertySet.setPropertyValue(string, object);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
                DebugHelper.exception((Exception)((Object)unknownPropertyException));
            }
            catch (PropertyVetoException propertyVetoException) {
                DebugHelper.writeInfo(propertyVetoException.getMessage());
                DebugHelper.exception((Exception)((Object)propertyVetoException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo(illegalArgumentException.getMessage());
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
                DebugHelper.exception((Exception)((Object)wrappedTargetException));
            }
        } else {
            DebugHelper.writeInfo("PropertySetHelper.setProperty() can't get XPropertySet");
        }
    }

    public int getPropertyValueAsInteger(String string, int n) {
        int n2;
        block6: {
            Object object = null;
            n2 = n;
            if (this.m_xPropertySet != null) {
                try {
                    object = this.m_xPropertySet.getPropertyValue(string);
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    DebugHelper.writeInfo(unknownPropertyException.getMessage());
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.writeInfo(wrappedTargetException.getMessage());
                }
            }
            if (object == null) break block6;
            try {
                n2 = NumericalHelper.toInt(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to integer.");
            }
        }
        return n2;
    }

    public short getPropertyValueAsShort(String string, short s) {
        short s2;
        block6: {
            Object object = null;
            s2 = s;
            if (this.m_xPropertySet != null) {
                try {
                    object = this.m_xPropertySet.getPropertyValue(string);
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    DebugHelper.writeInfo(unknownPropertyException.getMessage());
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.writeInfo(wrappedTargetException.getMessage());
                }
            }
            if (object == null) break block6;
            try {
                s2 = NumericalHelper.toShort(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to short.");
            }
        }
        return s2;
    }

    public double getPropertyValueAsDouble(String string, double d) {
        double d2;
        block6: {
            Object object = null;
            d2 = d;
            if (this.m_xPropertySet != null) {
                try {
                    object = this.m_xPropertySet.getPropertyValue(string);
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    DebugHelper.writeInfo(unknownPropertyException.getMessage());
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.writeInfo(wrappedTargetException.getMessage());
                }
            }
            if (object == null) break block6;
            try {
                d2 = NumericalHelper.toDouble(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to integer.");
            }
        }
        return d2;
    }

    public boolean getPropertyValueAsBoolean(String string, boolean bl) {
        boolean bl2;
        block6: {
            Object object = null;
            bl2 = bl;
            if (this.m_xPropertySet != null) {
                try {
                    object = this.m_xPropertySet.getPropertyValue(string);
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    DebugHelper.writeInfo(unknownPropertyException.getMessage());
                    DebugHelper.writeInfo("UnknownPropertyException caught: Name:=" + string);
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.writeInfo(wrappedTargetException.getMessage());
                }
            }
            if (object == null) break block6;
            try {
                bl2 = NumericalHelper.toBoolean(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to boolean.");
            }
        }
        return bl2;
    }

    public String getPropertyValueAsString(String string, String string2) {
        String string3;
        block6: {
            Object object = null;
            string3 = string2;
            if (this.m_xPropertySet != null) {
                try {
                    object = this.m_xPropertySet.getPropertyValue(string);
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    DebugHelper.writeInfo(unknownPropertyException.getMessage());
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.writeInfo(wrappedTargetException.getMessage());
                }
            }
            if (object == null) break block6;
            try {
                string3 = AnyConverter.toString(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to string.");
            }
        }
        return string3;
    }

    public Object getPropertyValueAsObject(String string) {
        Object object;
        block3: {
            object = null;
            if (this.m_xPropertySet == null) break block3;
            try {
                object = this.m_xPropertySet.getPropertyValue(string);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
            }
        }
        return object;
    }

    public static void showProperties(Object object) {
        PropertySetHelper propertySetHelper = new PropertySetHelper(object);
        propertySetHelper.showProperties();
    }

    public void showProperties() {
        String string = "";
        if (this.m_xPropertySet != null) {
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = PropertySetHelper.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)this.m_xPropertySet);
            if (xServiceInfo != null) {
                string = xServiceInfo.getImplementationName();
            }
            XPropertySetInfo xPropertySetInfo = this.m_xPropertySet.getPropertySetInfo();
            Property[] propertyArray = xPropertySetInfo.getProperties();
            DebugHelper.writeInfo("Show all properties of Implementation of :'" + string + "'");
            int n = 0;
            while (n < propertyArray.length) {
                DebugHelper.writeInfo(" - " + propertyArray[n].Name);
                ++n;
            }
        } else {
            DebugHelper.writeInfo("The given object don't support XPropertySet interface.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

