/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatter;
import java.util.Calendar;
import java.util.Date;

public class NumberFormatter {
    public int iDateFormatKey = -1;
    public int iDateTimeFormatKey = -1;
    public int iNumberFormatKey = -1;
    public int iTextFormatKey = -1;
    public int iTimeFormatKey = -1;
    public int iLogicalFormatKey = -1;
    public long lDateCorrection;
    public XNumberFormatter xNumberFormatter;
    public XNumberFormats xNumberFormats;
    public XNumberFormatTypes xNumberFormatTypes;
    public XPropertySet xNumberFormatSettings;
    private boolean bNullDateCorrectionIsDefined = false;
    private Locale aLocale;
    private XNumberFormatsSupplier mxNumberFormatsSupplier;
    private XMultiServiceFactory mxMSF;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatsSupplier;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatter;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatTypes;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$util$Date;

    public NumberFormatter(XMultiServiceFactory xMultiServiceFactory, XModel xModel) throws Exception {
        this.mxNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatsSupplier == null ? (class$com$sun$star$util$XNumberFormatsSupplier = NumberFormatter.class$("com.sun.star.util.XNumberFormatsSupplier")) : class$com$sun$star$util$XNumberFormatsSupplier), (Object)xModel);
        this.mxMSF = xMultiServiceFactory;
        this.retrieveObjects();
    }

    public NumberFormatter(XMultiServiceFactory xMultiServiceFactory, XNumberFormatsSupplier xNumberFormatsSupplier) throws Exception {
        this.mxNumberFormatsSupplier = xNumberFormatsSupplier;
        this.mxMSF = xMultiServiceFactory;
        this.retrieveObjects();
    }

    private void retrieveObjects() {
        try {
            Object object = this.mxMSF.createInstance("com.sun.star.util.NumberFormatter");
            this.xNumberFormats = this.mxNumberFormatsSupplier.getNumberFormats();
            this.xNumberFormatSettings = this.mxNumberFormatsSupplier.getNumberFormatSettings();
            this.xNumberFormatter = (XNumberFormatter)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatter == null ? (class$com$sun$star$util$XNumberFormatter = NumberFormatter.class$("com.sun.star.util.XNumberFormatter")) : class$com$sun$star$util$XNumberFormatter), (Object)object);
            this.xNumberFormatter.attachNumberFormatsSupplier(this.mxNumberFormatsSupplier);
            this.xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatTypes == null ? (class$com$sun$star$util$XNumberFormatTypes = NumberFormatter.class$("com.sun.star.util.XNumberFormatTypes")) : class$com$sun$star$util$XNumberFormatTypes), (Object)this.xNumberFormats);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public NumberFormatter(XNumberFormatsSupplier xNumberFormatsSupplier) throws Exception {
        this.xNumberFormats = xNumberFormatsSupplier.getNumberFormats();
        this.xNumberFormatSettings = xNumberFormatsSupplier.getNumberFormatSettings();
        this.xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatTypes == null ? (class$com$sun$star$util$XNumberFormatTypes = NumberFormatter.class$("com.sun.star.util.XNumberFormatTypes")) : class$com$sun$star$util$XNumberFormatTypes), (Object)this.xNumberFormats);
    }

    public static XNumberFormatter createNumberFormatter(XMultiServiceFactory xMultiServiceFactory, XNumberFormatsSupplier xNumberFormatsSupplier) throws Exception {
        Object object = xMultiServiceFactory.createInstance("com.sun.star.util.NumberFormatter");
        XNumberFormatter xNumberFormatter = (XNumberFormatter)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatter == null ? (class$com$sun$star$util$XNumberFormatter = NumberFormatter.class$("com.sun.star.util.XNumberFormatter")) : class$com$sun$star$util$XNumberFormatter), (Object)object);
        xNumberFormatter.attachNumberFormatsSupplier(xNumberFormatsSupplier);
        return xNumberFormatter;
    }

    public static int getNumberFormatterKey(Object object, short s) {
        XNumberFormats xNumberFormats = ((XNumberFormatsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatsSupplier == null ? (class$com$sun$star$util$XNumberFormatsSupplier = NumberFormatter.class$("com.sun.star.util.XNumberFormatsSupplier")) : class$com$sun$star$util$XNumberFormatsSupplier), (Object)object)).getNumberFormats();
        Locale locale = new Locale();
        return ((XNumberFormatTypes)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatTypes == null ? (class$com$sun$star$util$XNumberFormatTypes = NumberFormatter.class$("com.sun.star.util.XNumberFormatTypes")) : class$com$sun$star$util$XNumberFormatTypes), (Object)xNumberFormats)).getFormatIndex(s, locale);
    }

    public String convertNumberToString(int n, double d) {
        return this.xNumberFormatter.convertNumberToString(n, d);
    }

    public static String convertNumberToString(XNumberFormatter xNumberFormatter, int n, double d) {
        return xNumberFormatter.convertNumberToString(n, d);
    }

    public double convertStringToNumber(int n, String string) throws Exception {
        return this.xNumberFormatter.convertStringToNumber(n, string);
    }

    public void setNullDateCorrection(long l) {
        this.lDateCorrection = l;
    }

    public int defineNumberFormat(String string) {
        try {
            int n = this.xNumberFormats.queryKey(string, this.aLocale, true);
            if (n == -1) {
                n = this.xNumberFormats.addNew(string, this.aLocale);
            }
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return -1;
        }
    }

    public int defineNumberFormat(String string, Locale locale) {
        try {
            int n = this.xNumberFormats.queryKey(string, locale, true);
            if (n == -1) {
                n = this.xNumberFormats.addNew(string, locale);
            }
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return -1;
        }
    }

    public void setNumberFormat(Object object, int n) {
        block4: {
            try {
                XPropertySet xPropertySet = this.xNumberFormats.getByKey(n);
                String string = AnyConverter.toString((Object)xPropertySet.getPropertyValue("FormatString"));
                Locale locale = (Locale)xPropertySet.getPropertyValue("Locale");
                int n2 = this.defineNumberFormat(string);
                XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = NumberFormatter.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
                if (xPropertySet2.getPropertySetInfo().hasPropertyByName("NumberFormat")) {
                    xPropertySet2.setPropertyValue("NumberFormat", (Object)new Integer(n2));
                    break block4;
                }
                if (xPropertySet2.getPropertySetInfo().hasPropertyByName("FormatKey")) {
                    xPropertySet2.setPropertyValue("FormatKey", (Object)new Integer(n2));
                    break block4;
                }
                throw new Exception();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    public long getNullDateCorrection() {
        try {
            if (!this.bNullDateCorrectionIsDefined) {
                com.sun.star.util.Date date = (com.sun.star.util.Date)AnyConverter.toObject((Class)(class$com$sun$star$util$Date == null ? (class$com$sun$star$util$Date = NumberFormatter.class$("com.sun.star.util.Date")) : class$com$sun$star$util$Date), (Object)this.xNumberFormatSettings.getPropertyValue("NullDate"));
                long l = NumberFormatter.convertUnoDatetoInteger(date);
                Calendar calendar = Calendar.getInstance();
                calendar.set(1900, 1, 1);
                Date date2 = calendar.getTime();
                long l2 = date2.getTime();
                long l3 = l2 / 86400000L;
                this.lDateCorrection = l3 - l;
                return this.lDateCorrection;
            }
            return this.lDateCorrection;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return 2L;
        }
    }

    public static long convertUnoDatetoInteger(com.sun.star.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(date.Year, date.Month, date.Day);
        Date date2 = calendar.getTime();
        long l = date2.getTime();
        long l2 = l / 86400000L;
        return l2;
    }

    public void setBooleanReportDisplayNumberFormat() {
        String string = "[=1]\"\u2611\";[=0]\"\ue470\";0";
        this.iLogicalFormatKey = this.xNumberFormats.queryKey(string, this.aLocale, true);
        try {
            if (this.iLogicalFormatKey == -1) {
                this.iLogicalFormatKey = this.xNumberFormats.addNew(string, this.aLocale);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.iLogicalFormatKey = this.xNumberFormatTypes.getStandardFormat((short)1024, this.aLocale);
        }
    }

    public int getDateFormatKey() {
        if (this.iDateFormatKey == -1) {
            this.iDateFormatKey = this.xNumberFormatTypes.getStandardFormat((short)2, this.aLocale);
        }
        return this.iDateFormatKey;
    }

    public int getDateTimeFormatKey() {
        if (this.iDateTimeFormatKey == -1) {
            this.iDateTimeFormatKey = this.xNumberFormatTypes.getStandardFormat((short)6, this.aLocale);
        }
        return this.iDateTimeFormatKey;
    }

    public int getLogicalFormatKey() {
        if (this.iLogicalFormatKey == -1) {
            this.iLogicalFormatKey = this.xNumberFormatTypes.getStandardFormat((short)1024, this.aLocale);
        }
        return this.iLogicalFormatKey;
    }

    public void setStandardLogicalFormatKey(Object object) {
        if (this.iLogicalFormatKey == -1) {
            this.iLogicalFormatKey = this.xNumberFormatTypes.getStandardFormat((short)1024, this.aLocale);
        }
        this.setNumberFormat(object, this.iLogicalFormatKey);
    }

    public int getNumberFormatKey() {
        if (this.iNumberFormatKey == -1) {
            this.iNumberFormatKey = this.xNumberFormatTypes.getStandardFormat((short)16, this.aLocale);
        }
        return this.iNumberFormatKey;
    }

    public int getTextFormatKey() {
        if (this.iTextFormatKey == -1) {
            this.iTextFormatKey = this.xNumberFormatTypes.getStandardFormat((short)256, this.aLocale);
        }
        return this.iTextFormatKey;
    }

    public int getTimeFormatKey() {
        if (this.iTimeFormatKey == -1) {
            this.iTimeFormatKey = this.xNumberFormatTypes.getStandardFormat((short)4, this.aLocale);
        }
        return this.iTimeFormatKey;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

