/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

public class MSO2SOStringMapping {
    public static final int INDEX_MSO = 0;
    public static final int INDEX_SO = 1;
    private final String[][] mapping;

    public MSO2SOStringMapping(String[][] stringArray) {
        this.mapping = stringArray;
        this.sanityCheck();
    }

    public int size() {
        return this.mapping.length;
    }

    public int findMSOIndex(String string) {
        int n = 0;
        while (n < this.mapping.length) {
            if (this.mapping[n][0].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findSOIndex(String string) {
        int n = 0;
        while (n < this.mapping.length) {
            if (this.mapping[n][1].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getSOAtIndex(int n) {
        return this.mapping[n][1];
    }

    public String getMSOAtIndex(int n) {
        return this.mapping[n][0];
    }

    public String getSOFromMSO(String string) {
        int n = this.findMSOIndex(string);
        if (n >= 0) {
            return this.getSOAtIndex(n);
        }
        throw new IllegalArgumentException("Invalid value " + string);
    }

    public String getMSOFromSO(String string) {
        int n = this.findSOIndex(string);
        if (n >= 0) {
            return this.mapping[n][0];
        }
        throw new IllegalArgumentException("Invalid value " + string);
    }

    private void sanityCheck() {
        int n = 0;
        while (n < this.mapping.length) {
            if (this.mapping[n].length != 2) {
                throw new IllegalStateException();
            }
            if (this.mapping[n][1] == null) {
                throw new IllegalStateException();
            }
            if (this.mapping[n][0] == null) {
                throw new IllegalStateException();
            }
            ++n;
        }
    }
}

