/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DirectoryHelper;
import com.sun.star.helper.common.DocumentUtilities;
import com.sun.star.helper.common.FoundFilesImpl;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XFileSearch;
import com.sun.star.helper.common.XFoundFiles;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FileSearchImpl
extends HelperInterfaceAdaptor
implements XFileSearch,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.common.FileSearch";
    private String m_fileName = "*";
    private String m_sCurrentPath = null;
    private FoundFilesImpl m_foundFiles = null;
    private MyFileFilter m_fileFilter = new MyFileFilter("*");
    private String m_sSearchTextOrProperty = "";
    private int m_aSearchFileType = 2;
    private int m_aSearchLastModified = 7;
    private boolean m_bSearchSubFolders = true;
    private boolean m_bMatchAllWordForms = false;
    private String m_sSearchExtension = "";
    private static final String sMsoFileTypeAllFiles = "";
    private static final String sMsoFileTypeBinders = ".obd .obt";
    private static final String sMsoFileTypeCalendarItem = ".msg";
    private static final String sMsoFileTypeContactItem = ".msg";
    private static final String sMsoFileTypeDatabases = ".ade .adp .mdb .mde .mdw";
    private static final String sMsoFileTypeDataConnectionFiles = ".odc";
    private static final String sMsoFileTypeDesignerFiles = ".odp";
    private static final String sMsoFileTypeDocumentImagingFiles = ".mdi .tif";
    private static final String sMsoFileTypeExcelWorkbooks = ".xla .xlc .xlm .xls .xlt .sxc .ods";
    private static final String sMsoFileTypeJournalItem = ".msg";
    private static final String sMsoFileTypeMailItem = ".msg";
    private static final String sMsoFileTypeNoteItem = ".msg";
    private static final String sMsoFileTypeOutlookItems = ".msg";
    private static final String sMsoFileTypePhotoDrawFiles = ".mix";
    private static final String sMsoFileTypePowerPointPresentations = ".pot .pps .ppt";
    private static final String sMsoFileTypeProjectFiles = ".mpd .mpp .mpt .mpw";
    private static final String sMsoFileTypePublisherFiles = ".pub";
    private static final String sMsoFileTypeTaskItem = ".msg";
    private static final String sMsoFileTypeTemplates = ".dot .pot .xlt";
    private static final String sMsoFileTypeVisioFiles = ".vdx .vsd .vss .vst .vsx .vtx";
    private static final String sMsoFileTypeWebPages = ".htm .mht .html";
    private static final String sMsoFileTypeWordDocuments = ".dot .doc .odt .sxw";
    private static final String sMsoFileTypeOfficeFiles = ".dot .doc .odt .sxw .xla .xlc .xlm .xls .xlt .sxc .ods .ade .adp .mdb .mde .mdw .pot .pps .ppt";
    static /* synthetic */ Class class$com$sun$star$util$XSearchable;

    public FileSearchImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        this.m_sCurrentPath = this.defaultLookInPath();
        this.NewSearch();
    }

    public void NewSearch() throws BasicErrorException {
        this.m_fileName = this.defaultSearchPattern();
        this.m_foundFiles = new FoundFilesImpl(this);
        this.m_fileFilter.setNewPattern(this.m_fileName);
        this.m_sSearchTextOrProperty = sMsoFileTypeAllFiles;
        this.m_aSearchLastModified = 7;
        this.m_bSearchSubFolders = true;
        this.m_bMatchAllWordForms = false;
        this.setFileType(2);
    }

    public void setLookIn(String string) throws BasicErrorException {
        this.m_sCurrentPath = string;
    }

    public String getLookIn() throws BasicErrorException {
        return this.m_sCurrentPath;
    }

    public void setFileName(String string) throws BasicErrorException {
        this.m_fileName = string;
        this.m_fileFilter.setNewPattern(this.m_fileName);
    }

    public String getFileName() throws BasicErrorException {
        return this.m_fileName;
    }

    public XFoundFiles getFoundFiles() throws BasicErrorException {
        if (this.m_foundFiles == null) {
            this.m_foundFiles = new FoundFilesImpl(this);
        }
        return this.m_foundFiles;
    }

    public Object getUnoObject() throws BasicErrorException {
        return null;
    }

    public int Execute(Object object, Object object2, Object object3) throws BasicErrorException {
        int n = (int)OptionalParamUtility.getAnyNumber("SortBy", object, 1L, false);
        int n2 = (int)OptionalParamUtility.getAnyNumber("SortOrder", object2, 1L, false);
        this.m_foundFiles = new FoundFilesImpl(this);
        Object[] objectArray = DirectoryHelper.traverse(this.m_sCurrentPath, this.m_fileFilter, this.m_bSearchSubFolders);
        File[] fileArray = new File[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            fileArray[n3] = (File)objectArray[n3];
            ++n3;
        }
        this.m_foundFiles.Add(fileArray);
        this.m_foundFiles.Sort(n, n2);
        return this.m_foundFiles.Count();
    }

    private String defaultLookInPath() {
        return System.getProperty("user.home");
    }

    private String defaultSearchPattern() {
        return "*";
    }

    public boolean getMatchAllWordForms() throws BasicErrorException {
        return this.m_bMatchAllWordForms;
    }

    public void setMatchAllWordForms(boolean bl) throws BasicErrorException {
    }

    public void setTextOrProperty(String string) throws BasicErrorException {
        this.m_sSearchTextOrProperty = string;
    }

    public String getTextOrProperty() throws BasicErrorException {
        return this.m_sSearchTextOrProperty;
    }

    public void setFileType(int n) throws BasicErrorException {
        this.m_aSearchFileType = n;
        switch (n) {
            case 1: {
                this.m_sSearchExtension = sMsoFileTypeAllFiles;
                break;
            }
            case 6: {
                this.m_sSearchExtension = sMsoFileTypeBinders;
                break;
            }
            case 11: {
                this.m_sSearchExtension = ".msg";
                break;
            }
            case 12: {
                this.m_sSearchExtension = ".msg";
                break;
            }
            case 7: {
                this.m_sSearchExtension = sMsoFileTypeDatabases;
                break;
            }
            case 17: {
                this.m_sSearchExtension = sMsoFileTypeDataConnectionFiles;
                break;
            }
            case 22: {
                this.m_sSearchExtension = sMsoFileTypeDesignerFiles;
                break;
            }
            case 20: {
                this.m_sSearchExtension = sMsoFileTypeDocumentImagingFiles;
                break;
            }
            case 4: {
                this.m_sSearchExtension = sMsoFileTypeExcelWorkbooks;
                break;
            }
            case 14: {
                this.m_sSearchExtension = ".msg";
                break;
            }
            case 10: {
                this.m_sSearchExtension = ".msg";
                break;
            }
            case 13: {
                this.m_sSearchExtension = ".msg";
                break;
            }
            case 2: {
                this.m_sSearchExtension = sMsoFileTypeOfficeFiles;
                break;
            }
            case 9: {
                this.m_sSearchExtension = ".msg";
                break;
            }
            case 16: {
                this.m_sSearchExtension = sMsoFileTypePhotoDrawFiles;
                break;
            }
            case 5: {
                this.m_sSearchExtension = sMsoFileTypePowerPointPresentations;
                break;
            }
            case 19: {
                this.m_sSearchExtension = sMsoFileTypeProjectFiles;
                break;
            }
            case 18: {
                this.m_sSearchExtension = sMsoFileTypePublisherFiles;
                break;
            }
            case 15: {
                this.m_sSearchExtension = ".msg";
                break;
            }
            case 8: {
                this.m_sSearchExtension = sMsoFileTypeTemplates;
                break;
            }
            case 21: {
                this.m_sSearchExtension = sMsoFileTypeVisioFiles;
                break;
            }
            case 23: {
                this.m_sSearchExtension = sMsoFileTypeWebPages;
                break;
            }
            case 3: {
                this.m_sSearchExtension = sMsoFileTypeWordDocuments;
                break;
            }
            default: {
                DebugHelper.warning((Exception)((Object)new NoSupportException("In Property FileSearch this value is not supported.")));
            }
        }
    }

    public int getFileType() throws BasicErrorException {
        return this.m_aSearchFileType;
    }

    private String getSearchExtension() {
        return this.m_sSearchExtension;
    }

    public void setLastModified(int n) throws BasicErrorException {
        this.m_aSearchLastModified = n;
    }

    public int getLastModified() throws BasicErrorException {
        return this.m_aSearchLastModified;
    }

    public boolean getSearchSubFolders() throws BasicErrorException {
        return this.m_bSearchSubFolders;
    }

    public void setSearchSubFolders(boolean bl) throws BasicErrorException {
        this.m_bSearchSubFolders = bl;
    }

    protected boolean containsADocumentThisString(File file, String string) throws BasicErrorException {
        if (file.exists()) {
            return this.containsADocumentThisString(file.getAbsolutePath(), string);
        }
        DebugHelper.exception(53, "Can't find File");
        return false;
    }

    protected boolean containsADocumentThisString(String string, String string2) throws BasicErrorException {
        SearchInDocument searchInDocument = new SearchInDocument(string);
        searchInDocument.openDocument();
        boolean bl = searchInDocument.searchFor(string2);
        searchInDocument.closeDocument();
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SearchInDocument {
        String m_sFilename;
        XModel m_xDocument = null;
        XSearchable m_xSearchable = null;

        public SearchInDocument(String string) {
            this.m_sFilename = string;
        }

        public boolean openDocument() throws BasicErrorException {
            String string = HelperUtilities.getURLForFileName(this.m_sFilename);
            XModel xModel = HelperUtilities.findModelForURL(string);
            if (xModel != null) {
                this.m_xSearchable = (XSearchable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XSearchable == null ? (class$com$sun$star$util$XSearchable = FileSearchImpl.class$("com.sun.star.util.XSearchable")) : class$com$sun$star$util$XSearchable), (Object)xModel);
                return this.m_xSearchable != null;
            }
            ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "ReadOnly";
            propertyValue.Value = Boolean.TRUE;
            arrayList.add(propertyValue);
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.Name = "Hidden";
            propertyValue2.Value = Boolean.TRUE;
            arrayList.add(propertyValue2);
            this.m_xDocument = DocumentUtilities.openDocument(this.m_sFilename, false, arrayList);
            if (this.m_xDocument != null) {
                this.m_xSearchable = (XSearchable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XSearchable == null ? (class$com$sun$star$util$XSearchable = FileSearchImpl.class$("com.sun.star.util.XSearchable")) : class$com$sun$star$util$XSearchable), (Object)this.m_xDocument);
                if (this.m_xSearchable != null) {
                    return true;
                }
            }
            return false;
        }

        public void closeDocument() throws BasicErrorException {
            if (this.m_xDocument != null) {
                DocumentUtilities.closeDocument(this.m_xDocument, 0, 1);
            }
        }

        public boolean searchFor(String string) {
            boolean bl = false;
            if (this.m_xSearchable != null) {
                XSearchDescriptor xSearchDescriptor = this.m_xSearchable.createSearchDescriptor();
                xSearchDescriptor.setSearchString(string);
                Object object = this.m_xSearchable.findFirst(xSearchDescriptor);
                if (object != null) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private class MyFileFilter
    implements FileFilter {
        private String m_sPattern = null;

        public MyFileFilter(String string) {
            this.setNewPattern(string);
        }

        public void setNewPattern(String string) {
            this.m_sPattern = this.rewriteFileNameToRegex(string);
        }

        private String rewriteFileNameToRegex(String string) {
            String string2 = FileSearchImpl.sMsoFileTypeAllFiles;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                string2 = c == '*' ? string2 + "(.)*" : (c == '?' ? string2 + "." : (c == '.' ? string2 + "\\." : string2 + c));
                ++n;
            }
            return string2;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                try {
                    if (FileSearchImpl.this.getSearchSubFolders()) {
                        return true;
                    }
                }
                catch (BasicErrorException basicErrorException) {
                    DebugHelper.warning((Exception)((Object)basicErrorException));
                }
                return false;
            }
            String string = file.getName();
            try {
                boolean bl;
                if (FileSearchImpl.this.getLastModified() != 7) {
                    long l;
                    long l2;
                    bl = false;
                    long l3 = 86400000L;
                    long l4 = file.lastModified();
                    Calendar calendar = Calendar.getInstance();
                    long l5 = calendar.getTimeInMillis();
                    long l6 = l5 - l5 % l3;
                    if (FileSearchImpl.this.getLastModified() == 2) {
                        if (l4 > l6) {
                            bl = true;
                        }
                    } else if (FileSearchImpl.this.getLastModified() == 1) {
                        if (l4 > l6 - l3 && l4 < l6) {
                            bl = true;
                        }
                    } else if (FileSearchImpl.this.getLastModified() == 4) {
                        l2 = l3 * 7L;
                        l = l5 - l5 % l2;
                        if (l4 > l) {
                            bl = true;
                        }
                    } else if (FileSearchImpl.this.getLastModified() == 3) {
                        l2 = l3 * 7L;
                        l = l5 - l5 % l2;
                        if (l4 > l - l2 && l4 < l) {
                            bl = true;
                        }
                    } else if (FileSearchImpl.this.getLastModified() == 6) {
                        l2 = l3 * 30L;
                        l = l5 - l5 % l2;
                        if (l4 > l) {
                            bl = true;
                        }
                    } else if (FileSearchImpl.this.getLastModified() == 5) {
                        l2 = l3 * 30L;
                        l = l5 - l5 % l2;
                        long l7 = l - l2;
                        if (l4 > l7 && l4 < l) {
                            bl = true;
                        }
                    } else {
                        return false;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                if (FileSearchImpl.this.getFileType() != 1) {
                    bl = false;
                    String string2 = FileSearchImpl.this.getSearchExtension();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (!string.endsWith(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                if (FileSearchImpl.this.getTextOrProperty().length() > 0) {
                    bl = false;
                    if (!FileSearchImpl.this.getMatchAllWordForms()) {
                        bl = FileSearchImpl.this.containsADocumentThisString(file, FileSearchImpl.this.getTextOrProperty());
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
            catch (BasicErrorException basicErrorException) {
                DebugHelper.warning((Exception)((Object)basicErrorException));
            }
            boolean bl = Pattern.matches(this.m_sPattern, string);
            return bl;
        }
    }
}

