/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.script.BasicErrorException;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class CollectionHelper {
    private Hashtable helperLookup = new Hashtable();
    private ArrayList orderedCache = new ArrayList();
    private ArrayList updatedList = new ArrayList();
    private int sortOrder = 1;

    public CollectionHelper(int n) {
        this.sortOrder = n;
    }

    public void updateCache() throws BasicErrorException {
        this.updatedList.clear();
        this.fetchImplementationObjects(this.updatedList);
        int n = 0;
        while (n < this.orderedCache.size()) {
            Object e = this.orderedCache.get(n);
            int n2 = 0;
            while (n2 < this.updatedList.size()) {
                if (this.updatedList.get(n2) == e) {
                    e = null;
                    if (this.sortOrder == 0) break;
                    this.updatedList.remove(n2);
                    break;
                }
                ++n2;
            }
            if (e != null) {
                this.orderedCache.remove(n);
                this.helperLookup.remove(e);
                continue;
            }
            ++n;
        }
        if (this.sortOrder == 0) {
            int n3 = 0;
            while (n3 < this.updatedList.size()) {
                Object e = this.updatedList.get(n3);
                if (!this.isValidImplementationObject(e)) continue;
                Object object = this.getOrCreateHelper(e);
                if (object != null) {
                    this.helperLookup.put(e, object);
                    ++n3;
                    continue;
                }
                this.updatedList.remove(n3);
            }
            ArrayList arrayList = this.orderedCache;
            this.orderedCache = this.updatedList;
            this.updatedList = arrayList;
        } else {
            int n4 = 0;
            while (n4 < this.updatedList.size()) {
                HelperInterfaceAdaptor helperInterfaceAdaptor;
                Object e = this.updatedList.get(n4);
                if (this.isValidImplementationObject(e) && (helperInterfaceAdaptor = this.createHelper(e)) != null) {
                    this.orderedCache.add(e);
                    this.helperLookup.put(e, helperInterfaceAdaptor);
                }
                ++n4;
            }
        }
    }

    public Object item(int n) {
        if (this.sortOrder == 2) {
            n = this.orderedCache.size() - n - 1;
        }
        return this.helperLookup.get(this.orderedCache.get(n));
    }

    public int count() {
        return this.orderedCache.size();
    }

    public Object getHelper(Object object) {
        return this.helperLookup.get(object);
    }

    public Object getOrCreateHelper(Object object, Object object2) throws BasicErrorException {
        if (!this.isValidImplementationObject(object2)) {
            return null;
        }
        Object object3 = this.helperLookup.get(object);
        if (object3 != null) {
            return object3;
        }
        this.orderedCache.add(object2);
        object3 = this.createHelper(object2);
        this.helperLookup.put(object, object3);
        return object3;
    }

    public Object getOrCreateHelper(Object object) throws BasicErrorException {
        if (object == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("received null implementation object");
            HelperUtilities.exception(illegalArgumentException);
            return null;
        }
        if (!this.isValidImplementationObject(object)) {
            return null;
        }
        Object object2 = this.helperLookup.get(object);
        if (object2 == null) {
            object2 = this.addImplementationObject(object);
        }
        return object2;
    }

    public Object addImplementationObject(Object object) throws BasicErrorException {
        if (!this.isValidImplementationObject(object)) {
            return null;
        }
        this.orderedCache.add(object);
        HelperInterfaceAdaptor helperInterfaceAdaptor = this.createHelper(object);
        this.helperLookup.put(object, helperInterfaceAdaptor);
        return helperInterfaceAdaptor;
    }

    public abstract HelperInterfaceAdaptor createHelper(Object var1) throws BasicErrorException;

    public abstract void fetchImplementationObjects(ArrayList var1) throws BasicErrorException;

    public abstract boolean isValidImplementationObject(Object var1);

    public static interface SortOrder {
        public static final int soDefault = 0;
        public static final int soInOrder = 1;
        public static final int soReverse = 2;
    }
}

