/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.linguistic2.XLinguServiceManager;
import com.sun.star.linguistic2.XSpellChecker;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CheckSpelling {
    XSpellChecker m_xSpellChecker = null;
    Locale m_aCurrentLocale = null;
    PropertyValue[] m_aCurrentProperties = new PropertyValue[0];
    ArrayList m_aPropertyList;
    static /* synthetic */ Class class$com$sun$star$linguistic2$XLinguServiceManager;

    public void setPropertyList(ArrayList arrayList) {
        this.m_aPropertyList = arrayList;
        this.m_aCurrentProperties = null;
    }

    public Locale getCurrentLocale() {
        if (this.m_aCurrentLocale == null) {
            java.util.Locale locale = java.util.Locale.getDefault();
            this.setLocale(locale);
        }
        return this.m_aCurrentLocale;
    }

    public void setLocale(java.util.Locale locale) {
        this.m_aCurrentLocale = new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public void setLocale(Locale locale) {
        this.m_aCurrentLocale = locale;
    }

    public PropertyValue[] getCurrentProperties() {
        if (this.m_aCurrentProperties == null) {
            this.m_aCurrentProperties = CommonUtilities.createPropertyValueArrayFormArrayList(this.m_aPropertyList);
        }
        return this.m_aCurrentProperties;
    }

    public XSpellChecker getSpellChecker() throws BasicErrorException {
        if (this.m_xSpellChecker == null) {
            Object object = null;
            try {
                object = ApplicationImpl.getXMultiServiceFactory().createInstance("com.sun.star.linguistic2.LinguServiceManager");
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
            XLinguServiceManager xLinguServiceManager = (XLinguServiceManager)UnoRuntime.queryInterface((Class)(class$com$sun$star$linguistic2$XLinguServiceManager == null ? (class$com$sun$star$linguistic2$XLinguServiceManager = CheckSpelling.class$("com.sun.star.linguistic2.XLinguServiceManager")) : class$com$sun$star$linguistic2$XLinguServiceManager), (Object)object);
            this.m_xSpellChecker = xLinguServiceManager.getSpellChecker();
        }
        return this.m_xSpellChecker;
    }

    public boolean checkWord(String string) throws BasicErrorException {
        boolean bl = true;
        XSpellChecker xSpellChecker = this.getSpellChecker();
        try {
            bl = xSpellChecker.isValid(string, this.getCurrentLocale(), this.getCurrentProperties());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return bl;
    }

    public boolean checkSentence(String string) throws BasicErrorException {
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            bl |= this.checkWord(string2);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

