/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.awt.XTopWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.calc.CalcHelper;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.CalcStylesImpl;
import com.sun.star.helper.calc.ChartsImpl;
import com.sun.star.helper.calc.NamesImpl;
import com.sun.star.helper.calc.SheetsImpl;
import com.sun.star.helper.calc.WindowsImpl;
import com.sun.star.helper.calc.XCalcStyles;
import com.sun.star.helper.calc.XCharts;
import com.sun.star.helper.calc.XNames;
import com.sun.star.helper.calc.XSheet;
import com.sun.star.helper.calc.XSheets;
import com.sun.star.helper.calc.XSpreadsheet;
import com.sun.star.helper.calc.XWindow;
import com.sun.star.helper.calc.XWindows;
import com.sun.star.helper.common.CalcFilename;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.Filename;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.Properties;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XNamedRanges;
import com.sun.star.sheet.XSpreadsheetView;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XProtectable;
import com.sun.star.view.XPrintable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Vector;

public class SpreadsheetImpl
extends HelperInterfaceAdaptor
implements XSpreadsheet,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.Spreadsheet";
    protected static final int HAPICOLOR_BLACK = 0;
    protected static final int HAPICOLOR_WITHE = 0xFFFFFF;
    protected static final int HAPICOLOR_RED = 0xFF0000;
    protected static final int HAPICOLOR_BRIGHTGREEN = 65280;
    protected static final int HAPICOLOR_BLUE = 255;
    protected static final int HAPICOLOR_YELLOW = 0xFFFF00;
    protected static final int HAPICOLOR_PINK = 0xFF00FF;
    protected static final int HAPICOLOR_TURQUOISE = 65535;
    protected static final int HAPICOLOR_DARKRED = 0x800000;
    protected static final int HAPICOLOR_GREEN = 32768;
    protected static final int HAPICOLOR_DARKBLUE = 128;
    protected static final int HAPICOLOR_DARKYELLOW = 0x808000;
    protected static final int HAPICOLOR_VIOLET = 0x800080;
    protected static final int HAPICOLOR_TEAL = 32896;
    protected static final int HAPICOLOR_GRAY_25_PERCENT = 0xC0C0C0;
    protected static final int HAPICOLOR_GRAY_50_PERCENT = 0x808080;
    protected static final int HAPICOLOR_PERIWINCKLE = 0x9999FF;
    protected static final int HAPICOLOR_PLUM = 0x993366;
    protected static final int HAPICOLOR_IVORY = 0xFFFFCC;
    protected static final int HAPICOLOR_LIGHTTURQUOISE = 0xCCFFFF;
    protected static final int HAPICOLOR_DARKPRUPLE = 0x660066;
    protected static final int HAPICOLOR_CORAL = 0xFF8080;
    protected static final int HAPICOLOR_OCEANBLUE = 26316;
    protected static final int HAPICOLOR_ICEBLUE = 0xCCCCFF;
    protected static final int HAPICOLOR_SKYBLUE = 52479;
    protected static final int HAPICOLOR_LIGHTGREEN = 0xCCFFCC;
    protected static final int HAPICOLOR_LIGHTYELLOW = 0xFFFF99;
    protected static final int HAPICOLOR_PALEBLUE = 0x99CCFF;
    protected static final int HAPICOLOR_ROSE = 0xFF99CC;
    protected static final int HAPICOLOR_LAVENDER = 0xCC99FF;
    protected static final int HAPICOLOR_TAN = 0xFFCC99;
    protected static final int HAPICOLOR_LIGHTBLUE = 0x3366FF;
    protected static final int HAPICOLOR_AQUA = 0x33CCCC;
    protected static final int HAPICOLOR_LIME = 0x99CC00;
    protected static final int HAPICOLOR_GOLD = 0xFFCC00;
    protected static final int HAPICOLOR_LIGHTORANGE = 0xFF9900;
    protected static final int HAPICOLOR_ORANGE = 0xFF6600;
    protected static final int HAPICOLOR_BLUEGRAY = 0x666699;
    protected static final int HAPICOLOR_GRAY_40_PERCENT = 0x969696;
    protected static final int HAPICOLOR_DARKTEAL = 13158;
    protected static final int HAPICOLOR_SEAGREEN = 0x339966;
    protected static final int HAPICOLOR_NONAME = 13056;
    protected static final int HAPICOLOR_OLIVEGREEN = 0x333300;
    protected static final int HAPICOLOR_BROWN = 0x993300;
    protected static final int HAPICOLOR_INDIGO = 0x333399;
    protected static final int HAPICOLOR_GRAY_80_PERCENT = 0x333333;
    protected XModel xSpreadsheetModel = null;
    protected SheetsImpl xSheets = null;
    protected ChartsImpl xCharts = null;
    protected WindowsImpl cacheWindows = null;
    boolean saved = false;
    private XColumnRowRange xColumnRowRange = null;
    private int nSpreadsheetColumnCount = -1;
    private int nSpreadsheetRowCount = -1;
    protected int[] COLORINDIZES = new int[]{0, 0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0x800000, 32768, 128, 0x808000, 0x800080, 32896, 0xC0C0C0, 0x808080, 0x9999FF, 0x993366, 0xFFFFCC, 0xCCFFFF, 0x660066, 0xFF8080, 26316, 0xCCCCFF, 32768, 0xFF00FF, 0xFFFF00, 65535, 0x800080, 0x800000, 32896, 255, 52479, 0xCCFFFF, 0xCCFFCC, 0xFFFF99, 0x99CCFF, 0xFF99CC, 0xCC99FF, 0xFFCC99, 0x3366FF, 0x33CCCC, 0x99CC00, 0xFFCC00, 0xFF9900, 0xFF6600, 0x666699, 0x969696, 13158, 0x339966, 13056, 0x333300, 0x993300, 0x993366, 0x333399, 0x333333};
    protected int[] aColorIndizes = new int[this.COLORINDIZES.length];
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class class$com$sun$star$sheet$XNamedRanges;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$sheet$XSpreadsheetView;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$awt$XTopWindow;
    static /* synthetic */ Class class$com$sun$star$util$XProtectable;
    static /* synthetic */ Class class$com$sun$star$view$XPrintable;
    static /* synthetic */ Class class$com$sun$star$table$XColumnRowRange;

    public SpreadsheetImpl(CalcImpl calcImpl, XModel xModel) {
        super(__serviceName, calcImpl);
        this.xSpreadsheetModel = xModel;
        System.arraycopy(this.COLORINDIZES, 0, this.aColorIndizes, 0, this.aColorIndizes.length);
    }

    public int getColorAtIndex(int n) {
        return this.aColorIndizes[n];
    }

    public void setPrecisionAsDisplayed(boolean bl) throws BasicErrorException {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = SpreadsheetImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xSpreadsheetModel);
            xPropertySet.setPropertyValue("CalcAsShown", (Object)bl);
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public boolean getPrecisionAsDisplayed() throws BasicErrorException {
        Boolean bl = null;
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = SpreadsheetImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xSpreadsheetModel);
            bl = (Boolean)xPropertySet.getPropertyValue("CalcAsShown");
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void ResetColors() throws BasicErrorException {
        System.arraycopy(this.COLORINDIZES, 0, this.aColorIndizes, 0, this.aColorIndizes.length);
    }

    public void SetColors(Object object, Object object2) throws BasicErrorException {
        int n = -1;
        try {
            if (!AnyConverter.isVoid((Object)object) && !AnyConverter.isVoid((Object)object2)) {
                n = AnyConverter.toInt((Object)object);
                int n2 = AnyConverter.toInt((Object)object2);
                this.aColorIndizes[n - 1] = CalcHelper.swapFirstAndThirdByte(n2);
            } else {
                Object object3 = AnyConverter.toArray((Object)object);
                int n3 = 0;
                while (n3 < Array.getLength(object3)) {
                    this.aColorIndizes[n3] = (Integer)Array.get(object3, n3);
                    ++n3;
                }
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public Object Colors(Object object) throws BasicErrorException {
        Any any;
        block4: {
            Integer[] integerArray = new Integer[56];
            any = null;
            try {
                if (!AnyConverter.isVoid((Object)object)) {
                    int n = AnyConverter.toInt((Object)object);
                    any = new Any(Type.LONG, (Object)new Integer(CalcHelper.swapFirstAndThirdByte(this.aColorIndizes[n - 1])));
                    break block4;
                }
                int n = 0;
                while (n < 56) {
                    integerArray[n] = new Integer(this.aColorIndizes[n]);
                    ++n;
                }
                any = new Any(new Type(array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = SpreadsheetImpl.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer), (Object)integerArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(1004, "");
            }
        }
        return any;
    }

    public String Name() throws BasicErrorException {
        XFrame xFrame = this.xSpreadsheetModel.getCurrentController().getFrame();
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = SpreadsheetImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xFrame);
        String string = "";
        try {
            string = (String)xPropertySet.getPropertyValue("Title");
            int n = string.lastIndexOf("-");
            string = string.substring(0, n - 1);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        String string2 = CalcFilename.getCalcFileSuffix();
        if (string.endsWith(string2)) {
            DebugHelper.writeInfo("File has the correct extension => returning " + string);
            return string;
        }
        DebugHelper.writeInfo("File doesn't have the correct extension => returning " + string + "+" + string2);
        return string + string2;
    }

    public XNames Names() throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = SpreadsheetImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.getXModel());
        Object object = null;
        try {
            object = xPropertySet.getPropertyValue("NamedRanges");
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        XNamedRanges xNamedRanges = (XNamedRanges)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XNamedRanges == null ? (class$com$sun$star$sheet$XNamedRanges = SpreadsheetImpl.class$("com.sun.star.sheet.XNamedRanges")) : class$com$sun$star$sheet$XNamedRanges), (Object)object);
        return new NamesImpl(this, xNamedRanges);
    }

    public int FileFormat() throws BasicErrorException {
        int n = 0;
        String string = null;
        PropertyValue[] propertyValueArray = this.xSpreadsheetModel.getArgs();
        string = propertyValueArray[0].Name.equals("FilterName") ? (String)propertyValueArray[0].Value : (String)propertyValueArray[1].Value;
        if (string.equals("Text - txt - csv (StarCalc)")) {
            n = 6;
        }
        if (string.equals("DBF")) {
            n = 11;
        }
        if (string.equals("DIF")) {
            n = 9;
        }
        if (string.equals("Lotus")) {
            n = 15;
        }
        if (string.equals("MS Excel 4.0")) {
            n = 35;
        }
        if (string.equals("MS Excel 5.0/95")) {
            n = 39;
        }
        if (string.equals("MS Excel 97")) {
            n = 43;
        }
        if (string.equals("HTML (StarCalc)")) {
            n = 44;
        }
        if (string.equals("calc_StarOffice_XML_Calc_Template")) {
            n = 17;
        }
        if (string.equals("StarOffice XML (Calc)")) {
            n = -4143;
        }
        if (string.equals("calc8")) {
            n = -4143;
        }
        return n;
    }

    public String FullName() throws BasicErrorException {
        boolean bl = false;
        String string = this.xSpreadsheetModel.getURL();
        CalcFilename calcFilename = new CalcFilename(string);
        string = calcFilename.getAbsoluteFilename();
        return string;
    }

    public String Path() throws BasicErrorException {
        String string = this.xSpreadsheetModel.getURL();
        CalcFilename calcFilename = new CalcFilename(string);
        string = calcFilename.getPath();
        return string;
    }

    public void Close(Object object, Object object2, Object object3) throws BasicErrorException {
        boolean bl = OptionalParamUtility.getBoolean("SaveChanges", object, false, false);
        if (!AnyConverter.isVoid((Object)object2)) {
            String string = OptionalParamUtility.getString("FileName", object2, "local:default", false);
            DebugHelper.writeInfo("Spreadsheet.Close(): Filename:=" + string);
        }
        int n = -1;
        n = bl ? -1 : 0;
        HelperUtilities.closeDocument(this.getXModel(), n, 1);
    }

    public void Save() throws BasicErrorException, IOException {
        DebugHelper.writeInfo("Entering Save()");
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = SpreadsheetImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.xSpreadsheetModel);
        if (this.FullName().length() > 3) {
            DebugHelper.writeInfo("Old File, Storing to " + this.FullName());
            xStorable.store();
        } else {
            DebugHelper.writeInfo("New File, using SaveAs()");
            this.SaveAs(this.Name(), null, null, null, null, null, null, null, null, null, null);
        }
        this.saved = true;
    }

    public void SaveAs(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11) throws BasicErrorException, IOException {
        DebugHelper.writeInfo("starting SaveAs");
        String string = OptionalParamUtility.getString("filename", object, "local:default", false);
        if (string.equals("local:default")) {
            DebugHelper.exception(1004, "");
        }
        int n = 0;
        ArrayList<CalcFilename> arrayList = new ArrayList<CalcFilename>();
        try {
            PropertyValue propertyValue;
            String string2;
            CalcFilename calcFilename;
            String string3 = "";
            String string4 = "";
            if (CommonUtilities.isVersion8()) {
                string4 = "calc8";
                string3 = ".ods";
            } else {
                string4 = "StarOffice XML (Calc)";
                string3 = ".sxc";
            }
            if (NumericalHelper.isNumerical(object2)) {
                n = NumericalHelper.toInt(object2);
                switch (n) {
                    case -4158: 
                    case 6: 
                    case 22: 
                    case 23: 
                    case 24: {
                        string4 = "Text - txt - csv (StarCalc)";
                        string3 = ".csv";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 11: {
                        string4 = "DBF";
                        string3 = ".dbf";
                        break;
                    }
                    case 9: {
                        string4 = "DIF";
                        string3 = ".dif";
                        break;
                    }
                    case 4: {
                        string4 = "Lotus";
                        string3 = ".wks";
                        break;
                    }
                    case 29: 
                    case 33: {
                        string4 = "MS Excel 4.0";
                        string3 = ".xls";
                        break;
                    }
                    case 39: 
                    case 43: {
                        string4 = "MS Excel 97";
                        string3 = ".xls";
                        break;
                    }
                    case 44: {
                        string4 = "HTML (StarCalc)";
                        string3 = ".htm";
                        break;
                    }
                    case 17: {
                        if (CommonUtilities.isVersion8()) {
                            string4 = "calc8_template";
                            string3 = ".ots";
                        } else {
                            string4 = "calc_StarOffice_XML_Calc_Template";
                            string3 = ".stc";
                        }
                        calcFilename = Properties.createProperty("AsTemplate", Boolean.TRUE);
                        arrayList.add(calcFilename);
                        break;
                    }
                }
            }
            calcFilename = new CalcFilename(string);
            calcFilename.prepareToWrite(string3);
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.Name = "FilterName";
            propertyValue2.Value = string4;
            arrayList.add((CalcFilename)propertyValue2);
            if (AnyConverter.isString((Object)object3) && (string2 = OptionalParamUtility.getString("Password", object3, "", false)).length() > 0) {
                propertyValue = new PropertyValue();
                propertyValue.Name = "Password";
                propertyValue.Value = (String)object3;
                arrayList.add((CalcFilename)propertyValue);
                DebugHelper.writeInfo("Spreadsheet.SaveAs(): Property 'Password' := 'XXXXXX'");
            }
            string2 = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = SpreadsheetImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.xSpreadsheetModel);
            propertyValue = CommonUtilities.createPropertyValueArrayFormArrayList(arrayList);
            String string5 = calcFilename.getURL();
            DebugHelper.writeInfo("storing to: " + string5);
            string2.storeAsURL(string5, (PropertyValue[])propertyValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        this.saved = true;
    }

    public boolean Saved() throws BasicErrorException {
        if (HelperUtilities.isModified(this.xSpreadsheetModel)) {
            this.saved = false;
        }
        return this.saved;
    }

    public XSheets getSheets() throws BasicErrorException {
        if (this.xSheets == null) {
            this.xSheets = new SheetsImpl(this);
        }
        return this.xSheets;
    }

    public XSheet getActiveSheet() throws BasicErrorException {
        XSheet xSheet = null;
        XSpreadsheetView xSpreadsheetView = (XSpreadsheetView)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheetView == null ? (class$com$sun$star$sheet$XSpreadsheetView = SpreadsheetImpl.class$("com.sun.star.sheet.XSpreadsheetView")) : class$com$sun$star$sheet$XSpreadsheetView), (Object)this.getXModel().getCurrentController());
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = SpreadsheetImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)xSpreadsheetView.getActiveSheet());
        xSheet = this.getSheets().Item(xNamed.getName());
        return xSheet;
    }

    public XCharts Charts() throws BasicErrorException {
        if (this.xCharts == null) {
            this.xCharts = new ChartsImpl(this);
        }
        return this.xCharts;
    }

    public XModel getXModel() {
        return this.xSpreadsheetModel;
    }

    public static CalcImpl getInstance() throws BasicErrorException {
        return ApplicationImpl.getCalcImpl();
    }

    public void Activate() throws BasicErrorException {
        XModel xModel = this.getXModel();
        XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XTopWindow == null ? (class$com$sun$star$awt$XTopWindow = SpreadsheetImpl.class$("com.sun.star.awt.XTopWindow")) : class$com$sun$star$awt$XTopWindow), (Object)xModel.getCurrentController().getFrame().getContainerWindow());
        xTopWindow.toFront();
    }

    public boolean ProtectContents() {
        XProtectable xProtectable = (XProtectable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XProtectable == null ? (class$com$sun$star$util$XProtectable = SpreadsheetImpl.class$("com.sun.star.util.XProtectable")) : class$com$sun$star$util$XProtectable), (Object)this.getXModel());
        return xProtectable.isProtected();
    }

    public void Protect(Object object, Object object2, Object object3) throws BasicErrorException {
        String string = OptionalParamUtility.getString("password", object, "", false);
        XModel xModel = this.getXModel();
        XProtectable xProtectable = (XProtectable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XProtectable == null ? (class$com$sun$star$util$XProtectable = SpreadsheetImpl.class$("com.sun.star.util.XProtectable")) : class$com$sun$star$util$XProtectable), (Object)xModel);
        xProtectable.protect(string);
    }

    public void Unprotect(Object object) throws BasicErrorException {
        try {
            String string = OptionalParamUtility.getString("password", object, "", false);
            XModel xModel = this.getXModel();
            XProtectable xProtectable = (XProtectable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XProtectable == null ? (class$com$sun$star$util$XProtectable = SpreadsheetImpl.class$("com.sun.star.util.XProtectable")) : class$com$sun$star$util$XProtectable), (Object)xModel);
            xProtectable.unprotect(string);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public XWindows getWindows() throws BasicErrorException {
        return this.getWindowsImpl();
    }

    WindowsImpl getWindowsImpl() {
        if (this.cacheWindows == null) {
            this.cacheWindows = new WindowsImpl(this);
        }
        return this.cacheWindows;
    }

    public XWindow getActiveWindow() throws BasicErrorException {
        Object object;
        XFrame xFrame = ApplicationImpl.getXDesktop().getCurrentFrame();
        if (xFrame != null && (object = xFrame.getController().getModel()) == this.getXModel()) {
            return this.getWindowsImpl().getWindow(xFrame);
        }
        object = null;
        try {
            object = ((WindowsImpl)this.getWindows()).Item(1);
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return object;
    }

    public XCalcStyles Styles() throws BasicErrorException {
        return new CalcStylesImpl(this);
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xSpreadsheetModel;
    }

    public boolean WriteReserved() throws BasicErrorException {
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = SpreadsheetImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.xSpreadsheetModel);
        return xStorable.isReadonly();
    }

    public void PrintPreview(Object object) throws BasicErrorException {
        DispatchCommand.execute(".uno:PrintPreview", this.getXModel().getCurrentController().getFrame());
    }

    public void PrintOut(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws BasicErrorException {
        try {
            Object object9;
            int n;
            Vector<PropertyValue> vector = new Vector<PropertyValue>();
            PropertyValue[] propertyValueArray = null;
            short s = (short)NumericalHelper.toInt(object3, 1);
            String string = NumericalHelper.toString(object5, "");
            int n2 = NumericalHelper.toInt(object, 1);
            String string2 = "";
            if (NumericalHelper.isValid(object2)) {
                n = NumericalHelper.toInt(object2);
                string2 = n2 + "-" + n;
            } else {
                string2 = String.valueOf(n2);
            }
            n = NumericalHelper.toBoolean(object4, false) ? 1 : 0;
            boolean bl = NumericalHelper.toBoolean(object6, false);
            XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XPrintable == null ? (class$com$sun$star$view$XPrintable = SpreadsheetImpl.class$("com.sun.star.view.XPrintable")) : class$com$sun$star$view$XPrintable), (Object)this.getXModel());
            if (!string.equals("")) {
                object9 = new PropertyValue[]{Properties.createProperty("Name", string)};
                xPrintable.setPrinter(object9);
            }
            if (bl) {
                object9 = NumericalHelper.toString(object8, "");
                if (object9.equals("")) {
                    // empty if block
                }
                object9 = object9.equals(Filename.getBasename((String)object9)) ? ((CalcImpl)super.Application()).getOfficePathInURLNotation("Work") + "/" + (String)object9 : CommonUtilities.getURLFromSystemPath((String)object9);
                vector.add(Properties.createProperty("FileName", object9));
            }
            vector.add(Properties.createProperty("Pages", string2));
            if (s > 1) {
                boolean bl2 = NumericalHelper.toBoolean(object7, false);
                vector.add(Properties.createProperty("CopyCount", new Short(s)));
                vector.add(Properties.createProperty("Collate", new Boolean(bl2)));
            }
            propertyValueArray = new PropertyValue[vector.size()];
            vector.toArray(propertyValueArray);
            if (n != 0) {
                this.PrintPreview(Boolean.TRUE);
            }
            xPrintable.print(propertyValueArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    protected XColumnRowRange getXColumnRowRange() {
        if (this.xColumnRowRange == null) {
            this.xColumnRowRange = (XColumnRowRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XColumnRowRange == null ? (class$com$sun$star$table$XColumnRowRange = SpreadsheetImpl.class$("com.sun.star.table.XColumnRowRange")) : class$com$sun$star$table$XColumnRowRange), (Object)this.getXModel());
        }
        return this.xColumnRowRange;
    }

    public int getSpreadsheetColumnCount() {
        if (this.nSpreadsheetColumnCount == -1) {
            this.nSpreadsheetColumnCount = this.getXColumnRowRange().getColumns().getCount();
        }
        return this.nSpreadsheetColumnCount;
    }

    public int getSpreadsheetRowCount() {
        if (this.nSpreadsheetRowCount == -1) {
            this.nSpreadsheetRowCount = this.getXColumnRowRange().getRows().getCount();
        }
        return this.nSpreadsheetRowCount;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

