/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.CalcHelper;
import com.sun.star.helper.calc.SpreadsheetFunctionImpl;
import com.sun.star.helper.calc.XCalcRange;
import com.sun.star.helper.calc.range.RangeHelperImpl;
import com.sun.star.helper.calc.range.RangeImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.constant.XlReferenceStyle;
import com.sun.star.helper.constant.XlReferenceType;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.CellAddress;
import com.sun.star.uno.Any;
import java.util.Vector;

public abstract class R1C1Converter
extends SpreadsheetFunctionImpl
implements XlReferenceStyle,
XlReferenceType {
    private static final String sRegularExpressionR1C1 = "((R(\\[\\-?[0-9]{1,6}\\]|[0-9]{1,6})?)?C(\\[\\-?[0-9]{1,6}\\]|[0-9]{1,6})?(?<![a-zA-Z]))|(R(\\[\\-?[0-9]{1,6}\\]|[0-9]{1,6})?(?<![a-zA-Z])(C(\\[\\-?[0-9]{1,6}\\]|[0-9]{1,6})?)?)";
    private static final String sRegularExpressionA1 = "\\$?[A-Z]{1,2}\\$?[0-9]{1,6}";
    private static final String sRegularExpressionA1_ColumnPart = "\\$?[A-Z]{1,2}";
    private static final String sRegularExpressionA1_RowPart = "\\$?[0-9]{1,6}";

    public R1C1Converter(HelperInterfaceAdaptor helperInterfaceAdaptor) throws BasicErrorException {
        super(helperInterfaceAdaptor);
    }

    protected int makeNumbersEven(int n) throws BasicErrorException {
        if (n < 0) {
            n = this.getSpreadsheetColumnCount() + n;
        }
        if (n > this.getSpreadsheetColumnCount()) {
            n -= this.getSpreadsheetColumnCount();
        }
        return n;
    }

    protected int getNumberForString(String string) {
        int n = 0;
        int n2 = 0;
        n2 = string.charAt(0) - 64;
        if (2 == string.length()) {
            n = (string.charAt(1) - 64) * 26;
        }
        return n2 + n;
    }

    protected int calculateVBAIndex(String string, int n) {
        int n2 = 0;
        String string2 = "";
        if (string.startsWith("[")) {
            string2 = string.substring(1, string.length() - 1);
            n2 = new Integer(string2) + n + 1;
        } else {
            n2 = new Integer(string);
        }
        return n2;
    }

    protected String[] getTokens(String string, String string2) {
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        String string3 = string;
        String[] stringArray2 = string3.split(string2, 2);
        if (stringArray2.length > 1) {
            do {
                n = stringArray2[0].length();
                n2 = stringArray2[1].length() == 0 ? string3.length() : string3.indexOf(stringArray2[1]);
                if (!stringArray2[0].equals("")) {
                    vector.add(stringArray2[0]);
                }
                vector.add(string3.substring(n, n2));
            } while ((stringArray2 = (string3 = stringArray2[1]).split(string2, 2)).length == 2);
            if (stringArray2[0].length() != 0) {
                vector.add(stringArray2[0]);
            }
            stringArray = new String[vector.size()];
            return vector.toArray(stringArray);
        }
        return stringArray2;
    }

    public boolean isR1C1Representation(String string) {
        return string.matches(sRegularExpressionR1C1);
    }

    public boolean isA1Representation(String string) {
        String[] stringArray = string.split("!");
        return stringArray[stringArray.length - 1].matches(sRegularExpressionA1);
    }

    private int getColumnFromR1C1Token(String string, int n) throws BasicErrorException {
        String[] stringArray = null;
        int n2 = 0;
        stringArray = string.split("C");
        n2 = stringArray.length == 2 ? this.calculateVBAIndex(stringArray[1], n) : n + 1;
        return this.makeNumbersEven(n2);
    }

    public int getRowFromR1C1Token(String string, int n) throws BasicErrorException {
        String[] stringArray = null;
        int n2 = 0;
        stringArray = string.split("C");
        n2 = stringArray[0].equals("") || stringArray[0].equals("R") ? n + 1 : this.calculateVBAIndex(stringArray[0].substring(1), n);
        return this.makeNumbersEven(n2);
    }

    public String getA1RepresentationForSingleForR1C1Token(String string, int n, int n2, boolean bl, boolean bl2) throws BasicErrorException {
        String string2 = string;
        int n3 = 0;
        int n4 = 0;
        String string3 = "";
        String string4 = "";
        if (!bl) {
            string3 = "$";
        }
        if (!bl2) {
            string4 = "$";
        }
        if (this.isR1C1Representation(string)) {
            n3 = this.getColumnFromR1C1Token(string, n2);
            n4 = this.getRowFromR1C1Token(string, n);
            string2 = string3 + CalcHelper.getStringForNumber(n3) + string4 + String.valueOf(n4);
        }
        return string2;
    }

    private String getR1C1RepresentationForSingleA1Token(String string, int n, int n2, boolean bl, boolean bl2) {
        String string2 = string;
        String string3 = "";
        int n3 = 0;
        if (this.isA1Representation(string)) {
            String[] stringArray = string.split(sRegularExpressionA1_RowPart);
            string3 = stringArray[0].startsWith("$") ? stringArray[0].substring(1) : stringArray[0];
            if ('$' == string.charAt(stringArray[0].length())) {
                n3 = 1;
            }
            String string4 = string.substring(stringArray[0].length() + n3);
            int n4 = this.getNumberForString(string3);
            int n5 = new Integer(string4);
            string2 = "R" + this.getR1C1DeltaString(n5, n, bl2) + "C" + this.getR1C1DeltaString(n4, n2, bl);
        }
        return string2;
    }

    private String getR1C1DeltaString(int n, int n2, boolean bl) {
        String string = "";
        boolean bl2 = false;
        if (bl) {
            if (n2 + 1 != n) {
                String string2 = String.valueOf(n - (n2 + 1));
                string = "[" + string2 + "]";
            }
        } else {
            string = String.valueOf(n);
        }
        return string;
    }

    public String getA1RepresentationForR1C1(String string, int n, int n2, boolean bl, boolean bl2) throws BasicErrorException {
        String string2 = "";
        String[] stringArray = this.getR1C1Tokens(string);
        int n3 = 0;
        while (n3 < stringArray.length) {
            string2 = string2 + this.getA1RepresentationForSingleForR1C1Token(stringArray[n3], n, n2, bl, bl2);
            ++n3;
        }
        return string2;
    }

    public String getR1C1RepresentationForA1(String string, int n, int n2, boolean bl, boolean bl2) throws BasicErrorException {
        String string2 = "";
        String[] stringArray = this.getA1Tokens(string);
        int n3 = 0;
        while (n3 < stringArray.length) {
            string2 = string2 + this.getR1C1RepresentationForSingleA1Token(stringArray[n3], n, n2, bl, bl2);
            ++n3;
        }
        return string2;
    }

    public boolean isRelativeReference(String string) {
        return string.indexOf("[") > -1;
    }

    private String[] getR1C1Tokens(String string) {
        return this.getTokens(string, sRegularExpressionR1C1);
    }

    private String[] getA1Tokens(String string) {
        return this.getTokens(string, sRegularExpressionA1);
    }

    private String[] getA1ColumnTokens(String string) {
        String[] stringArray = string.split("!");
        return this.getTokens(stringArray[stringArray.length - 1], sRegularExpressionA1_ColumnPart);
    }

    private String[] getA1RowTokens(String string) {
        String[] stringArray = string.split("!");
        return this.getTokens(stringArray[stringArray.length - 1], sRegularExpressionA1_RowPart);
    }

    public String ConvertFormula(String string, int n, Object object, Object object2, Object object3) throws BasicErrorException {
        RangeImpl rangeImpl = null;
        int n2 = NumericalHelper.toInt(object, n);
        int n3 = -1;
        CellAddress cellAddress = null;
        n3 = NumericalHelper.isValid(object2) ? NumericalHelper.toIntWithErrorMessage(object2) : this.getReferenceType(string);
        rangeImpl = NumericalHelper.isValid(object3) ? (RangeImpl)((Any)object3).getObject() : (RangeImpl)this.ActiveCell();
        cellAddress = RangeHelperImpl.getCellAddress(rangeImpl);
        return this.ConvertFastFormula(string, n, n2, n3, cellAddress);
    }

    public String ConvertFastFormula(String string, int n, int n2, CellAddress cellAddress) throws BasicErrorException {
        return this.ConvertFastFormula(string, n, n2, this.getReferenceType(string), cellAddress);
    }

    public String ConvertFastFormula(String string, int n, int n2, int n3, CellAddress cellAddress) throws BasicErrorException {
        String string2 = string;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (NumericalHelper.isValid(cellAddress)) {
            n4 = cellAddress.Column;
            n5 = cellAddress.Row;
        }
        switch (n3) {
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl2 = true;
                break;
            }
            case 4: {
                bl = true;
                bl2 = true;
                break;
            }
            case 1: {
                break;
            }
            default: {
                DebugHelper.exception(1004, "");
            }
        }
        if (n != n2) {
            switch (n2) {
                case 1: {
                    string = string.replaceAll(";", ",");
                    string = string.replaceAll("\\.", "!");
                    string2 = this.getA1RepresentationForR1C1(string, n5, n4, bl, bl2);
                    break;
                }
                case -4150: {
                    string2 = this.getR1C1RepresentationForA1(string, n5, n4, bl, bl2);
                    string = string.replaceAll(",", ";");
                    string = string.replaceAll("!", ".");
                    break;
                }
                default: {
                    DebugHelper.exception(1004, "");
                }
            }
        }
        return string2;
    }

    public int getReferenceType(String string) {
        int n = 1;
        if (this.isA1Representation(string)) {
            boolean bl = false;
            boolean bl2 = false;
            String[] stringArray = this.getA1ColumnTokens(string);
            String[] stringArray2 = this.getA1RowTokens(string);
            if (stringArray.length > -1) {
                boolean bl3 = bl = stringArray[0].indexOf("$") > -1;
            }
            if (stringArray2.length > -1) {
                boolean bl4 = bl2 = stringArray2[0].indexOf("$") > -1;
            }
            n = bl2 && bl ? 1 : (bl2 && !bl ? 2 : (!bl2 && bl ? 3 : 4));
        }
        return n;
    }

    public abstract int getSpreadsheetColumnCount() throws BasicErrorException;

    public abstract int getSpreadsheetRowCount() throws BasicErrorException;

    public abstract XCalcRange ActiveCell() throws BasicErrorException;
}

