/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.calc.QueryTableDescriptor;
import com.sun.star.helper.calc.XQueryTable;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.StringHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.DataImportMode;
import com.sun.star.sheet.SheetLinkMode;
import com.sun.star.sheet.XAreaLinks;
import com.sun.star.sheet.XSheetLinkable;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.ui.dialogs.XFilePicker;
import com.sun.star.ui.dialogs.XFilterManager;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XImportable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class QueryTableImpl
extends HelperInterfaceAdaptor
implements XQueryTable,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.QueryTable";
    QueryTableDescriptor desc;
    XComponent xComponent;
    private boolean m_TextFileCommaDelimiter = false;
    private boolean m_TextFileTabDelimiter = false;
    private boolean m_TextFileConsecutiveDelimiter = false;
    private boolean m_TextFileSemicolonDelimiter = false;
    private boolean m_TextFileSpaceDelimiter = false;
    private int m_TextFileParseType = 1;
    private int m_TextFileTextQualifier = 1;
    private int m_TextFilePlatform = 3;
    private int m_TextFileStartRow = 1;
    private int[] m_TextFileColumnDataTypes = new int[]{1, 1};
    private boolean m_TextFilePromptOnRefresh = false;
    private int m_RefreshPeriod = 5;
    private boolean m_PreserveFormatting = false;
    private boolean m_SaveData = true;
    private int m_RefreshStyle = 0;
    private PropertySetHelper m_PropertySetHelper = null;
    static /* synthetic */ Class class$com$sun$star$sheet$XAreaLinks;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetLinkable;
    static /* synthetic */ Class class$com$sun$star$util$XImportable;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$ui$dialogs$XExecutableDialog;
    static /* synthetic */ Class class$com$sun$star$ui$dialogs$XFilePicker;
    static /* synthetic */ Class class$com$sun$star$ui$dialogs$XFilterManager;

    public QueryTableImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, QueryTableDescriptor queryTableDescriptor, XComponent xComponent) {
        super(__serviceName, helperInterfaceAdaptor);
        this.desc = queryTableDescriptor;
        this.xComponent = xComponent;
    }

    public void refresh(Object object) throws BasicErrorException {
        if (this.desc.Type == 1) {
            this.refresh_web();
        } else if (this.desc.Type == 2) {
            this.refresh_file();
        }
        if (this.desc.Type == 0) {
            this.refresh_db();
        }
    }

    private void refresh_web() throws BasicErrorException {
        XAreaLinks xAreaLinks = (XAreaLinks)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XAreaLinks == null ? (class$com$sun$star$sheet$XAreaLinks = QueryTableImpl.class$("com.sun.star.sheet.XAreaLinks")) : class$com$sun$star$sheet$XAreaLinks), (Object)this.desc.UnoInterface);
        xAreaLinks.insertAtPosition(this.desc.Destination, this.desc.link, "html_all", "calc_HTML_WebQuery", "");
        try {
            this.desc.UnoInterface = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = QueryTableImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xAreaLinks.getByIndex(xAreaLinks.getCount() - 1));
            this.m_PropertySetHelper = new PropertySetHelper(this.desc.UnoInterface);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (this.m_PropertySetHelper != null) {
            this.m_PropertySetHelper.setPropertyValueDontThrow("RefreshPeriod", new Integer(this.m_RefreshPeriod));
        }
    }

    private void refresh_file() throws BasicErrorException {
        if (this.m_TextFilePromptOnRefresh) {
            this.desc.link = this.getFileForTextQuery(this.desc.link);
        }
        XSheetLinkable xSheetLinkable = (XSheetLinkable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetLinkable == null ? (class$com$sun$star$sheet$XSheetLinkable = QueryTableImpl.class$("com.sun.star.sheet.XSheetLinkable")) : class$com$sun$star$sheet$XSheetLinkable), (Object)this.desc.UnoInterface);
        DebugHelper.writeInfo("refreshing file query");
        String string = QueryTableImpl.encodeFilename(HelperUtilities.getURLForFileName(this.desc.link));
        DebugHelper.writeInfo("\tLink " + string);
        DebugHelper.writeInfo("\tOptions " + this.getFilterOptions());
        xSheetLinkable.link(string, "", "Text - txt - csv (StarCalc)", this.getFilterOptions(), SheetLinkMode.NORMAL);
    }

    private void refresh_db() throws BasicErrorException {
        PropertyValue[] propertyValueArray = new PropertyValue[4];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "DatabaseName";
        propertyValueArray[0].Value = this.desc.link;
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "SourceType";
        propertyValueArray[1].Value = DataImportMode.SQL;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "SourceObject";
        propertyValueArray[2].Value = this.desc.sql;
        propertyValueArray[3] = new PropertyValue();
        propertyValueArray[3].Name = "IsNative";
        propertyValueArray[3].Value = Boolean.TRUE;
        XImportable xImportable = (XImportable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XImportable == null ? (class$com$sun$star$util$XImportable = QueryTableImpl.class$("com.sun.star.util.XImportable")) : class$com$sun$star$util$XImportable), (Object)this.desc.UnoInterface);
        xImportable.doImport(propertyValueArray);
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = QueryTableImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xComponent);
            Object object = xPropertySet.getPropertyValue("DatabaseRanges");
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = QueryTableImpl.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)object);
            String[] stringArray = xNameAccess.getElementNames();
            int n = 0;
            while (n < stringArray.length) {
                Object object2;
                XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? QueryTableImpl.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet), (Object)(object2 = xNameAccess.getByName(stringArray[n])));
                boolean bl = AnyConverter.toBoolean((Object)xPropertySet2.getPropertyValue("IsUserDefined"));
                if (!bl) {
                    this.desc.UnoInterface = xPropertySet2;
                    XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? QueryTableImpl.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed), (Object)object2);
                    xNamed.setName("external_" + this.desc.link);
                    this.m_PropertySetHelper = new PropertySetHelper(this.desc.UnoInterface);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        this.setProperties();
    }

    private String getFilterOptions() {
        return this.getFieldSeparator() + "," + this.getTextDelimiter() + "," + this.getCharSet() + "," + this.m_TextFileStartRow + "," + this.getFormatCodes();
    }

    private String getFormatCodes() {
        String string = "";
        int n = 0;
        while (n < this.m_TextFileColumnDataTypes.length) {
            string = string + (n + 1) + "/" + this.transform(this.m_TextFileColumnDataTypes[n]) + "/";
            ++n;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private int transform(int n) {
        int n2 = 1;
        if (n == 1) {
            n2 = 1;
        } else if (n == 2) {
            n2 = 2;
        } else if (n == 9) {
            n2 = 9;
        } else if (n == 4) {
            n2 = 4;
        } else if (n == 7) {
            n2 = 1;
        } else if (n == 10) {
            n2 = 1;
        } else if (n == 3) {
            n2 = 3;
        } else if (n == 6) {
            n2 = 1;
        } else if (n == 8) {
            n2 = 1;
        } else if (n == 5) {
            n2 = 5;
        }
        return n2;
    }

    private String getCharSet() {
        String string = "0";
        if (this.m_TextFilePlatform == 3) {
            string = "25";
        } else if (this.m_TextFilePlatform == 1) {
            string = "42";
        } else if (this.m_TextFilePlatform == 2) {
            string = "1";
        }
        return string;
    }

    private String getTextDelimiter() {
        String string = "";
        if (this.m_TextFileTextQualifier == 1) {
            string = "34";
        } else if (this.m_TextFileTextQualifier == 2) {
            string = "39";
        }
        return string;
    }

    private String getFieldSeparator() {
        if (this.m_TextFileParseType == 2) {
            return "FIX";
        }
        String string = "";
        if (this.m_TextFileCommaDelimiter) {
            string = "44/";
        }
        if (this.m_TextFileSemicolonDelimiter) {
            string = string + "59/";
        }
        if (this.m_TextFileTabDelimiter) {
            string = string + "9/";
        }
        if (this.m_TextFileSpaceDelimiter) {
            string = string + "32/";
        }
        if (this.m_TextFileConsecutiveDelimiter) {
            string = string + "MSG";
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getFileForTextQuery(String string) throws BasicErrorException {
        String string2 = string;
        Object object = null;
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        try {
            object = ApplicationImpl.getXMultiServiceFactory().createInstance("com.sun.star.ui.dialogs.FilePicker");
            XExecutableDialog xExecutableDialog = (XExecutableDialog)UnoRuntime.queryInterface((Class)(class$com$sun$star$ui$dialogs$XExecutableDialog == null ? (class$com$sun$star$ui$dialogs$XExecutableDialog = QueryTableImpl.class$("com.sun.star.ui.dialogs.XExecutableDialog")) : class$com$sun$star$ui$dialogs$XExecutableDialog), (Object)object);
            xExecutableDialog.setTitle("Choose a file for the QueryTable");
            XFilePicker xFilePicker = (XFilePicker)UnoRuntime.queryInterface((Class)(class$com$sun$star$ui$dialogs$XFilePicker == null ? (class$com$sun$star$ui$dialogs$XFilePicker = QueryTableImpl.class$("com.sun.star.ui.dialogs.XFilePicker")) : class$com$sun$star$ui$dialogs$XFilePicker), (Object)object);
            xFilePicker.setDisplayDirectory(string3);
            xFilePicker.setDefaultName(string4);
            XFilterManager xFilterManager = (XFilterManager)UnoRuntime.queryInterface((Class)(class$com$sun$star$ui$dialogs$XFilterManager == null ? (class$com$sun$star$ui$dialogs$XFilterManager = QueryTableImpl.class$("com.sun.star.ui.dialogs.XFilterManager")) : class$com$sun$star$ui$dialogs$XFilterManager), (Object)object);
            xFilterManager.appendFilter("Text CSV (*.txt;*.csv)", "*.csv;*.txt");
            xFilterManager.appendFilter("All files", "*.*");
            xExecutableDialog.execute();
            if (xFilePicker.getFiles().length > 0) {
                string2 = CommonUtilities.getSystemPathFromURL(xFilePicker.getFiles()[0]);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return string2;
    }

    public int[] getTextFileColumnDataTypes() throws BasicErrorException {
        return this.m_TextFileColumnDataTypes;
    }

    public boolean getTextFileCommaDelimiter() throws BasicErrorException {
        return this.m_TextFileCommaDelimiter;
    }

    public boolean getTextFileConsecutiveDelimiter() throws BasicErrorException {
        return this.m_TextFileConsecutiveDelimiter;
    }

    public int getTextFileParseType() throws BasicErrorException {
        return this.m_TextFileParseType;
    }

    public int getTextFilePlatform() throws BasicErrorException {
        return this.m_TextFilePlatform;
    }

    public boolean getTextFilePromptOnRefresh() throws BasicErrorException {
        return this.m_TextFilePromptOnRefresh;
    }

    public boolean getTextFileSemicolonDelimiter() throws BasicErrorException {
        return this.m_TextFileSemicolonDelimiter;
    }

    public boolean getTextFileSpaceDelimiter() throws BasicErrorException {
        return this.m_TextFileSpaceDelimiter;
    }

    public int getTextFileStartRow() throws BasicErrorException {
        return this.m_TextFileStartRow;
    }

    public boolean getTextFileTabDelimiter() throws BasicErrorException {
        return this.m_TextFileTabDelimiter;
    }

    public int getTextFileTextQualifier() throws BasicErrorException {
        return this.m_TextFileTextQualifier;
    }

    public int getRefreshPeriod() throws BasicErrorException {
        if (this.desc.Type != 1 && this.desc.Type != 0) {
            return this.m_RefreshPeriod;
        }
        if (this.m_PropertySetHelper != null) {
            this.m_RefreshPeriod = this.m_PropertySetHelper.getPropertyValueAsInteger("RefreshPeriod", this.m_RefreshPeriod);
        }
        return this.m_RefreshPeriod;
    }

    public boolean getPreserveFormatting() throws BasicErrorException {
        if (this.desc.Type != 0) {
            return this.m_PreserveFormatting;
        }
        if (this.m_PropertySetHelper != null) {
            this.m_PreserveFormatting = this.m_PropertySetHelper.getPropertyValueAsBoolean("KeepFormats", this.m_PreserveFormatting);
        }
        return this.m_PreserveFormatting;
    }

    public boolean getSavePassword() throws BasicErrorException {
        return true;
    }

    public boolean getRowNumbers() throws BasicErrorException {
        return false;
    }

    public boolean getSaveData() throws BasicErrorException {
        if (this.desc.Type != 0) {
            return this.m_SaveData;
        }
        if (this.m_PropertySetHelper != null) {
            this.m_SaveData = !this.m_PropertySetHelper.getPropertyValueAsBoolean("StripData", !this.m_SaveData);
        }
        return this.m_SaveData;
    }

    public int getRefreshStyle() throws BasicErrorException {
        if (this.desc.Type != 0) {
            return this.m_RefreshStyle;
        }
        if (this.m_PropertySetHelper != null) {
            boolean bl = this.m_PropertySetHelper.getPropertyValueAsBoolean("MoveCells", false);
            this.m_RefreshStyle = bl ? 1 : 0;
        }
        return this.m_RefreshStyle;
    }

    public boolean getRefreshOnFileOpen() throws BasicErrorException {
        return false;
    }

    public boolean getFillAdjacentFormulas() throws BasicErrorException {
        return true;
    }

    public boolean getFieldNames() throws BasicErrorException {
        return true;
    }

    public boolean getAdjustColumnWidth() throws BasicErrorException {
        return true;
    }

    public void setAdjustColumnWidth(boolean bl) throws BasicErrorException {
        DebugHelper.writeInfo("Property AdjustColumnWidth doesn't exist in UNO-API, so the setting is ignored");
    }

    public void setFieldNames(boolean bl) throws BasicErrorException {
        DebugHelper.writeInfo("Property FieldNames doesn't exist in UNO-API, so the setting is ignored");
    }

    public void setFillAdjacentFormulas(boolean bl) throws BasicErrorException {
        DebugHelper.writeInfo("Property FillAdjacentFormulas doesn't exist in UNO-API, so the setting is ignored");
    }

    public void setRefreshOnFileOpen(boolean bl) throws BasicErrorException {
        DebugHelper.writeInfo("Property RefreshOnFileOpen doesn't exist in UNO-API, so the setting is ignored");
    }

    public void setRefreshStyle(int n) throws BasicErrorException {
        Boolean bl = Boolean.FALSE;
        if (n == 1) {
            bl = Boolean.TRUE;
        } else if (n == 0) {
            bl = Boolean.FALSE;
        } else if (n == 2) {
            bl = Boolean.FALSE;
        } else {
            DebugHelper.exception(14, "");
        }
        if (this.m_PropertySetHelper != null) {
            this.m_PropertySetHelper.setPropertyValueDontThrow("MoveCells", bl);
        }
        this.m_RefreshStyle = n;
    }

    public void setSaveData(boolean bl) throws BasicErrorException {
        this.m_SaveData = bl;
        if (this.m_PropertySetHelper != null) {
            this.m_PropertySetHelper.setPropertyValueDontThrow("StripData", !this.m_SaveData);
        }
    }

    public void setRowNumbers(boolean bl) throws BasicErrorException {
        DebugHelper.writeInfo("Property RowNumbers doesn't exist in UNO-API, so the setting is ignored");
    }

    public void setSavePassword(boolean bl) throws BasicErrorException {
        DebugHelper.writeInfo("Property SavePassword doesn't exist in UNO-API, so the setting is ignored");
    }

    public void setPreserveFormatting(boolean bl) throws BasicErrorException {
        this.m_PreserveFormatting = bl;
        if (this.m_PropertySetHelper != null) {
            this.m_PropertySetHelper.setPropertyValueDontThrow("KeepFormats", this.m_PreserveFormatting);
        }
    }

    public void setRefreshPeriod(int n) throws BasicErrorException {
        this.m_RefreshPeriod = n;
        if (this.m_PropertySetHelper != null) {
            this.m_PropertySetHelper.setPropertyValueDontThrow("RefreshPeriod", new Integer(this.m_RefreshPeriod));
        }
    }

    public void setTextFileColumnDataTypes(int[] nArray) throws BasicErrorException {
        this.m_TextFileColumnDataTypes = nArray;
    }

    public void setTextFileCommaDelimiter(boolean bl) throws BasicErrorException {
        this.m_TextFileCommaDelimiter = bl;
    }

    public void setTextFileConsecutiveDelimiter(boolean bl) throws BasicErrorException {
        this.m_TextFileConsecutiveDelimiter = bl;
    }

    public void setTextFileParseType(int n) throws BasicErrorException {
        this.m_TextFileParseType = n;
    }

    public void setTextFilePlatform(int n) throws BasicErrorException {
        this.m_TextFilePlatform = n;
    }

    public void setTextFilePromptOnRefresh(boolean bl) throws BasicErrorException {
        this.m_TextFilePromptOnRefresh = bl;
    }

    public void setTextFileSemicolonDelimiter(boolean bl) throws BasicErrorException {
        this.m_TextFileSemicolonDelimiter = bl;
    }

    public void setTextFileSpaceDelimiter(boolean bl) throws BasicErrorException {
        this.m_TextFileSpaceDelimiter = bl;
    }

    public void setTextFileStartRow(int n) throws BasicErrorException {
        this.m_TextFileStartRow = n;
    }

    public void setTextFileTabDelimiter(boolean bl) throws BasicErrorException {
        this.m_TextFileTabDelimiter = bl;
    }

    public void setTextFileTextQualifier(int n) throws BasicErrorException {
        this.m_TextFileTextQualifier = n;
    }

    private static String encodeFilename(String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        string2 = StringHelper.replaceAll13(string2, "+", "%20");
        string2 = StringHelper.replaceAll13(string2, "%2F", "/");
        string2 = StringHelper.replaceAll13(string2, "%3A", ":");
        string2 = StringHelper.replaceAll13(string2, "%5C", "\\");
        return string2;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.desc.UnoInterface;
    }

    private void setProperties() {
        if (this.m_PropertySetHelper != null) {
            this.m_PropertySetHelper.setPropertyValueDontThrow("RefreshPeriod", new Integer(this.m_RefreshPeriod));
            this.m_PropertySetHelper.setPropertyValueDontThrow("KeepFormats", this.m_PreserveFormatting);
            this.m_PropertySetHelper.setPropertyValueDontThrow("StripData", !this.m_SaveData);
            Boolean bl = Boolean.FALSE;
            if (this.m_RefreshStyle == 1) {
                bl = Boolean.TRUE;
            } else if (this.m_RefreshStyle == 0) {
                bl = Boolean.FALSE;
            } else if (this.m_RefreshStyle == 2) {
                bl = Boolean.FALSE;
            }
            this.m_PropertySetHelper.setPropertyValueDontThrow("MoveCells", bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

