/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.range.RangeHelperImpl;
import com.sun.star.helper.calc.range.RangeImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.constant.XlFormatConditionOperator;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.ConditionOperator;
import com.sun.star.sheet.XSheetCondition;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.uno.UnoRuntime;

public abstract class ConditionImpl
extends HelperInterfaceAdaptor
implements XlFormatConditionOperator {
    protected XSheetCondition mxSheetCondition;
    protected final int ISFORMULA = 98765432;
    protected RangeImpl moRangeImpl;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetCondition;

    public ConditionImpl(String string, HelperInterfaceAdaptor helperInterfaceAdaptor, Object object) throws BasicErrorException {
        super(string, helperInterfaceAdaptor);
        this.mxSheetCondition = (XSheetCondition)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetCondition == null ? (class$com$sun$star$sheet$XSheetCondition = ConditionImpl.class$("com.sun.star.sheet.XSheetCondition")) : class$com$sun$star$sheet$XSheetCondition), (Object)object);
        if (this.mxSheetCondition == null) {
            DebugHelper.exception(1004, "");
        }
        if (helperInterfaceAdaptor instanceof RangeImpl) {
            this.moRangeImpl = (RangeImpl)helperInterfaceAdaptor;
        } else {
            DebugHelper.exception(1004, "");
        }
    }

    public String Formula1() throws BasicErrorException {
        return this.mxSheetCondition.getFormula1();
    }

    public String Formula2() throws BasicErrorException {
        return this.mxSheetCondition.getFormula2();
    }

    protected void setFormula1(Object object) throws BasicErrorException {
        if (NumericalHelper.isValid(object) && object instanceof String) {
            this.mxSheetCondition.setFormula1((String)object);
            CellRangeAddress cellRangeAddress = RangeHelperImpl.getRangeAddress(this.moRangeImpl);
            CellAddress cellAddress = new CellAddress();
            cellAddress.Row = cellRangeAddress.StartRow;
            cellAddress.Column = cellRangeAddress.StartColumn;
            this.mxSheetCondition.setSourcePosition(cellAddress);
        }
    }

    protected void setFormula2(Object object) throws BasicErrorException {
        if (NumericalHelper.isValid(object) && object instanceof String) {
            this.mxSheetCondition.setFormula1((String)object);
        }
    }

    public int Operator(boolean bl) throws BasicErrorException {
        int n = -1;
        ConditionOperator conditionOperator = this.mxSheetCondition.getOperator();
        switch (conditionOperator.getValue()) {
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 7;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 8;
                break;
            }
            case 7: {
                n = 1;
                break;
            }
            case 8: {
                n = 2;
                break;
            }
            case 9: {
                if (bl) {
                    n = 98765432;
                    break;
                }
            }
            default: {
                DebugHelper.exception(1004, "Operator not supported");
            }
        }
        return n;
    }

    protected static ConditionOperator retrieveAPIOperator(Object object) throws BasicErrorException {
        ConditionOperator conditionOperator = ConditionOperator.NONE;
        if (NumericalHelper.isValid(object)) {
            int n = NumericalHelper.toIntWithErrorMessage(object);
            switch (n) {
                case 1: {
                    conditionOperator = ConditionOperator.BETWEEN;
                    break;
                }
                case 2: {
                    conditionOperator = ConditionOperator.NOT_BETWEEN;
                    break;
                }
                case 3: {
                    conditionOperator = ConditionOperator.EQUAL;
                    break;
                }
                case 4: {
                    conditionOperator = ConditionOperator.NOT_EQUAL;
                    break;
                }
                case 5: {
                    conditionOperator = ConditionOperator.GREATER;
                    break;
                }
                case 6: {
                    conditionOperator = ConditionOperator.LESS;
                    break;
                }
                case 7: {
                    conditionOperator = ConditionOperator.GREATER_EQUAL;
                    break;
                }
                case 8: {
                    conditionOperator = ConditionOperator.LESS_EQUAL;
                    break;
                }
                default: {
                    conditionOperator = ConditionOperator.NONE;
                }
            }
        }
        return conditionOperator;
    }

    protected void setOperator(Object object) throws BasicErrorException {
        ConditionOperator conditionOperator = ConditionImpl.retrieveAPIOperator(object);
        this.mxSheetCondition.setOperator(conditionOperator);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

