/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.awt.Rectangle;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.frame.XDesktop;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.ChartObjectImpl;
import com.sun.star.helper.calc.XChart;
import com.sun.star.helper.calc.XChartObject;
import com.sun.star.helper.calc.XChartObjects;
import com.sun.star.helper.common.ContainerUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.Millimeter;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.constant.XlChartType;
import com.sun.star.lang.XComponent;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import java.util.Hashtable;
import java.util.Vector;

public class ChartObjectsImpl
extends HelperInterfaceAdaptor
implements XChartObjects,
XlChartType,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.ChartObjects";
    protected XDesktop xDesktop = null;
    protected XChart xChart = null;
    protected XComponent xComponent;
    protected XTableCharts xTableCharts;
    protected XIndexAccess xIndexAccess;
    protected XNameAccess xNameAccess;
    protected XDrawPageSupplier xDrawPageSupplier;
    protected XNameContainer xNameContainer;
    protected Hashtable aHashTable = new Hashtable();
    protected XSpreadsheetDocument xSpreadsheetDocument;
    static /* synthetic */ Class class$com$sun$star$container$XIndexAccess;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$container$XNameContainer;
    static /* synthetic */ Class class$com$sun$star$sheet$XSpreadsheetDocument;
    static /* synthetic */ Class class$com$sun$star$helper$calc$XChartObject;
    static /* synthetic */ Class class$com$sun$star$table$XTableChart;
    static /* synthetic */ Class class$com$sun$star$table$XTableChartsSupplier;

    public ChartObjectsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XTableCharts xTableCharts, XDrawPageSupplier xDrawPageSupplier) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        this.xTableCharts = xTableCharts;
        this.xDrawPageSupplier = xDrawPageSupplier;
        this.xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = ChartObjectsImpl.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess), (Object)this.xTableCharts);
        this.xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = ChartObjectsImpl.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)this.xTableCharts);
        this.xNameContainer = (XNameContainer)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameContainer == null ? (class$com$sun$star$container$XNameContainer = ChartObjectsImpl.class$("com.sun.star.container.XNameContainer")) : class$com$sun$star$container$XNameContainer), (Object)this.xTableCharts);
        String[] stringArray = this.xNameAccess.getElementNames();
        this.xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheetDocument == null ? (class$com$sun$star$sheet$XSpreadsheetDocument = ChartObjectsImpl.class$("com.sun.star.sheet.XSpreadsheetDocument")) : class$com$sun$star$sheet$XSpreadsheetDocument), (Object)this.getXModel());
        int n = 0;
        while (n < stringArray.length) {
            this.putByPersistName(stringArray[n]);
            ++n;
        }
    }

    public XChartObject Add(double d, double d2, double d3, double d4) throws BasicErrorException {
        try {
            CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[]{new CellRangeAddress()};
            Rectangle rectangle = new Rectangle();
            rectangle.X = Millimeter.getInHundredthsOfOneMillimeter(d);
            rectangle.Y = Millimeter.getInHundredthsOfOneMillimeter(d2);
            rectangle.Width = Millimeter.getInHundredthsOfOneMillimeter(d3);
            rectangle.Height = Millimeter.getInHundredthsOfOneMillimeter(d4);
            String string = ContainerUtilities.getUniqueName(this.getChartObjectNames(), "Chart ", "", 1);
            this.xTableCharts.addNewByName(string, rectangle, cellRangeAddressArray, true, false);
            XChartObject xChartObject = this.putByPersistName(string);
            xChartObject.getChart().setChartType(51);
            return xChartObject;
        }
        catch (Exception exception) {
            DebugHelper.writeInfo("Exception when creating blank Chart: " + exception);
            return null;
        }
    }

    public XChartObject Item(Object object) throws BasicErrorException {
        XChartObject xChartObject = null;
        if (object != null && !AnyConverter.isVoid((Object)object)) {
            String string = "";
            try {
                if (NumericalHelper.isNumerical(object)) {
                    int n = (int)OptionalParamUtility.getAnyNumber("Index", object, 1L, true);
                    String[] stringArray = this.xTableCharts.getElementNames();
                    string = stringArray[n - 1];
                    return (XChartObject)AnyConverter.toObject((Class)(class$com$sun$star$helper$calc$XChartObject == null ? (class$com$sun$star$helper$calc$XChartObject = ChartObjectsImpl.class$("com.sun.star.helper.calc.XChartObject")) : class$com$sun$star$helper$calc$XChartObject), this.aHashTable.get(string));
                }
                if (AnyConverter.isString((Object)object)) {
                    string = AnyConverter.toString((Object)object);
                }
                return (XChartObject)this.aHashTable.get(string);
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return xChartObject;
    }

    private XChartObject putByPersistName(String string) throws BasicErrorException {
        ChartObjectImpl chartObjectImpl = null;
        try {
            if (this.xNameAccess.hasByName(string)) {
                Object object = this.xTableCharts.getByName(string);
                XTableChart xTableChart = (XTableChart)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XTableChart == null ? (class$com$sun$star$table$XTableChart = ChartObjectsImpl.class$("com.sun.star.table.XTableChart")) : class$com$sun$star$table$XTableChart), (Object)object);
                chartObjectImpl = new ChartObjectImpl(this, xTableChart, this.xDrawPageSupplier);
                this.aHashTable.put(string, chartObjectImpl);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return chartObjectImpl;
    }

    public int getCount() throws BasicErrorException {
        return this.xIndexAccess.getCount();
    }

    public void removeByName(String string) {
        if (this.aHashTable.containsKey(string)) {
            this.aHashTable.remove(string);
        }
        this.xTableCharts.removeByName(string);
    }

    public void Delete() throws BasicErrorException {
        String[] stringArray = this.xTableCharts.getElementNames();
        int n = this.xTableCharts.getElementNames().length;
        int n2 = 0;
        while (n2 < n) {
            this.removeByName(stringArray[n2]);
            ++n2;
        }
    }

    public String[] getChartObjectNames() throws BasicErrorException {
        String[] stringArray = null;
        try {
            XSpreadsheets xSpreadsheets = this.xSpreadsheetDocument.getSheets();
            Vector<String> vector = new Vector<String>();
            String[] stringArray2 = xSpreadsheets.getElementNames();
            int n = 0;
            while (n < stringArray2.length) {
                XTableChartsSupplier xTableChartsSupplier = (XTableChartsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XTableChartsSupplier == null ? ChartObjectsImpl.class$("com.sun.star.table.XTableChartsSupplier") : class$com$sun$star$table$XTableChartsSupplier), (Object)xSpreadsheets.getByName(stringArray2[n]));
                String[] stringArray3 = xTableChartsSupplier.getCharts().getElementNames();
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    vector.add(stringArray3[n2]);
                    ++n2;
                }
                ++n;
            }
            stringArray = new String[vector.size()];
            vector.toArray(stringArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return stringArray;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xTableCharts;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

