/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper;

import com.sun.star.awt.XPointer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.frame.XFrame;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.XSystemEnvironment;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.IniFile;
import com.sun.star.helper.common.IniFilename;
import com.sun.star.helper.common.LocaleUtilities;
import com.sun.star.helper.writer.OptionsImpl;
import com.sun.star.helper.writer.WriterImpl;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Locale;

public class SystemEnvironmentImpl
extends HelperInterfaceAdaptor
implements XSystemEnvironment {
    protected static final String __serviceName = "com.sun.star.helper.SystemEnvironment";
    Dimension m_aScreenSize = null;
    WriterImpl m_aWriterImpl = null;
    static /* synthetic */ Class class$com$sun$star$awt$XPointer;
    static /* synthetic */ Class class$com$sun$star$awt$XWindowPeer;

    public SystemEnvironmentImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, WriterImpl writerImpl) {
        super(__serviceName, helperInterfaceAdaptor);
        this.m_aWriterImpl = writerImpl;
    }

    public int getCountry() throws BasicErrorException {
        return LocaleUtilities.getCountry();
    }

    public String getLanguageDesignation() throws BasicErrorException {
        Locale locale = LocaleUtilities.getCurrentLocale();
        return locale.getDisplayName();
    }

    Dimension getDimension() {
        if (this.m_aScreenSize == null) {
            this.m_aScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return this.m_aScreenSize;
    }

    public int getHorizontalResolution() throws BasicErrorException {
        return this.getDimension().width;
    }

    public int getVerticalResolution() throws BasicErrorException {
        return this.getDimension().height;
    }

    public String getVersion() throws BasicErrorException {
        String string = System.getProperty("os.version");
        return string;
    }

    public boolean getMathCoprocessorInstalled() throws BasicErrorException {
        return true;
    }

    public String getOperatingSystem() throws BasicErrorException {
        String string = System.getProperty("os.name");
        if (string.equals("Windows 2000") || string.equals("Windows XP")) {
            return "Windows NT";
        }
        return string;
    }

    public String getProcessorType() throws BasicErrorException {
        String string = System.getProperty("os.arch");
        if (string.equals("i386") || string.equals("x86")) {
            return "Pentium";
        }
        return string;
    }

    private XPointer getXPointer() throws BasicErrorException {
        XPointer xPointer;
        block3: {
            XMultiServiceFactory xMultiServiceFactory;
            xPointer = null;
            if (this.m_aWriterImpl == null || (xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory()) == null) break block3;
            try {
                Object object = xMultiServiceFactory.createInstance("com.sun.star.awt.Pointer");
                if (object == null) {
                    throw new BasicErrorException("Can't get XPointer");
                }
                xPointer = (XPointer)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XPointer == null ? (class$com$sun$star$awt$XPointer = SystemEnvironmentImpl.class$("com.sun.star.awt.XPointer")) : class$com$sun$star$awt$XPointer), (Object)object);
            }
            catch (Exception exception) {
                DebugHelper.exception(51, exception.getMessage());
            }
        }
        return xPointer;
    }

    public int getCursor() throws BasicErrorException {
        XPointer xPointer = this.getXPointer();
        int n = xPointer.getType();
        int n2 = 2;
        switch (n) {
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 0: {
                break;
            }
        }
        return n2;
    }

    public void setCursor(int n) throws BasicErrorException {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        XPointer xPointer = this.getXPointer();
        xPointer.setType(n2);
        XFrame xFrame = ApplicationImpl.getXDesktop().getCurrentFrame();
        XWindow xWindow = xFrame.getContainerWindow();
        XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XWindowPeer == null ? (class$com$sun$star$awt$XWindowPeer = SystemEnvironmentImpl.class$("com.sun.star.awt.XWindowPeer")) : class$com$sun$star$awt$XWindowPeer), (Object)xWindow);
        if (xWindowPeer != null) {
            xWindowPeer.setPointer(xPointer);
        }
    }

    public String PrivateProfileString(String string, String string2, String string3) throws BasicErrorException {
        OptionsImpl optionsImpl;
        String string4;
        IniFilename iniFilename;
        if (string.length() == 0) {
            DebugHelper.writeInfo("Error: getPrivateProfileString() it is not allowed to leave the filename out.");
            DebugHelper.exception(5, "");
        }
        if (!(iniFilename = new IniFilename(string, string4 = (optionsImpl = new OptionsImpl(this.m_aWriterImpl)).DefaultFilePath(4))).checkExistanceForRead()) {
            iniFilename.prepareToWrite("");
        }
        IniFile iniFile = new IniFile(iniFilename.getAbsoluteFilename());
        String string5 = iniFile.getValue(string2, string3);
        return string5;
    }

    public void SetPrivateProfileString(String string, String string2, String string3, String string4) throws BasicErrorException {
        if (string.length() == 0) {
            DebugHelper.writeInfo("Error: getPrivateProfileString() it is not allowed to leave the filename out.");
            DebugHelper.exception(5, "");
        }
        OptionsImpl optionsImpl = new OptionsImpl(this.m_aWriterImpl);
        String string5 = optionsImpl.DefaultFilePath(4);
        IniFilename iniFilename = new IniFilename(string, string5);
        iniFilename.prepareToWrite("");
        IniFile iniFile = new IniFile(iniFilename.getAbsoluteFilename());
        iniFile.insertValue(string2, string3, string4);
        iniFile.store();
    }

    public String ProfileString(String string, String string2) throws BasicErrorException {
        return this.PrivateProfileString("privateprofile.ini", string, string2);
    }

    public void SetProfileString(String string, String string2, String string3) throws BasicErrorException {
        this.SetPrivateProfileString("privateprofile.ini", string, string2, string3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

