/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.IntLookup;

public class DoubleIntIndex
implements IntLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = true;
    private boolean hasChanged;
    private final boolean fixedSize;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public DoubleIntIndex(int n, boolean bl) {
        this.capacity = n;
        this.keys = new int[n];
        this.values = new int[n];
        this.fixedSize = bl;
        this.hasChanged = true;
    }

    public synchronized int getKey(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n];
    }

    public synchronized int getValue(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[n];
    }

    public synchronized void setKey(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[n] = n2;
    }

    public synchronized void setValue(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[n] = n2;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    public synchronized boolean addUnsorted(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0) {
            if (this.sortOnValues) {
                if (n2 < this.values[this.count - 1]) {
                    this.sorted = false;
                }
            } else if (n2 < this.keys[this.count - 1]) {
                this.sorted = false;
            }
        }
        this.hasChanged = true;
        this.keys[this.count] = n;
        this.values[this.count] = n2;
        ++this.count;
        return true;
    }

    public synchronized boolean addSorted(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0 && n2 < this.values[this.count - 1]) {
            return false;
        }
        this.hasChanged = true;
        this.keys[this.count] = n;
        this.values[this.count] = n2;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnique(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n2 : n;
        int n3 = this.binaryEmptySlotSearch();
        if (n3 == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != n3) {
            this.moveRows(n3, n3 + 1, this.count - n3);
        }
        this.keys[n3] = n;
        this.values[n3] = n2;
        ++this.count;
        return true;
    }

    public synchronized boolean add(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n2 : n;
        int n3 = this.binarySlotSearch();
        if (n3 == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != n3) {
            this.moveRows(n3, n3 + 1, this.count - n3);
        }
        this.keys[n3] = n;
        this.values[n3] = n2;
        ++this.count;
        return true;
    }

    public int lookupFirstEqual(int n) throws NoSuchElementException {
        int n2;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n2 = this.findFirstEqualKeyIndex(n)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n2);
    }

    public int lookupFirstGreaterEqual(int n) throws NoSuchElementException {
        int n2;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n2 = this.findFirstGreaterEqualKeyIndex(n)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n2);
    }

    public synchronized void setValuesSearchTarget() {
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = true;
    }

    public synchronized void setKeysSearchTarget() {
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = false;
    }

    public synchronized int findFirstGreaterEqualKeyIndex(int n) {
        int n2 = this.findFirstGreaterEqualSlotIndex(n);
        return n2 == this.count ? -1 : n2;
    }

    public synchronized int findFirstEqualKeyIndex(int n) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        return this.binaryFirstSearch();
    }

    public synchronized int findFirstGreaterEqualSlotIndex(int n) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        return this.binarySlotSearch();
    }

    private int binaryFirstSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.count;
        while (n < n2) {
            n3 = (n + n2) / 2;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
            n5 = n3;
        }
        return n5 == this.count ? -1 : n5;
    }

    private int binaryGreaterSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = (n + n2) / 2;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return n == this.count ? -1 : n;
    }

    private int binarySlotSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = (n + n2) / 2;
            n4 = this.compare(n3);
            if (n4 <= 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return n;
    }

    private int binaryEmptySlotSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = (n + n2) / 2;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return -1;
        }
        return n;
    }

    private synchronized void fastQuickSort() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n, int n2) {
        int n3 = 4;
        if (n2 - n > n3) {
            int n4 = (n2 + n) / 2;
            if (this.lessThan(n4, n)) {
                this.swap(n, n4);
            }
            if (this.lessThan(n2, n)) {
                this.swap(n, n2);
            }
            if (this.lessThan(n2, n4)) {
                this.swap(n4, n2);
            }
            int n5 = n2 - 1;
            this.swap(n4, n5);
            n4 = n;
            int n6 = n5;
            while (true) {
                if (this.lessThan(++n4, n6)) {
                    continue;
                }
                while (this.lessThan(n6, --n5)) {
                }
                if (n5 < n4) break;
                this.swap(n4, n5);
            }
            this.swap(n4, n2 - 1);
            this.quickSort(n, n5);
            this.quickSort(n4 + 1, n2);
        }
    }

    private void insertionSort(int n, int n2) {
        int n3 = n + 1;
        while (n3 <= n2) {
            int n4 = n3;
            while (n4 > n && this.lessThan(n3, n4 - 1)) {
                --n4;
            }
            if (n3 != n4) {
                this.moveAndInsertRow(n3, n4);
            }
            ++n3;
        }
    }

    private void moveAndInsertRow(int n, int n2) {
        int n3 = this.keys[n];
        int n4 = this.values[n];
        this.moveRows(n2, n2 + 1, n - n2);
        this.keys[n2] = n3;
        this.values[n2] = n4;
    }

    private void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (int[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    private void swap(int n, int n2) {
        int n3 = this.keys[n];
        int n4 = this.values[n];
        this.keys[n] = this.keys[n2];
        this.values[n] = this.values[n2];
        this.keys[n2] = n3;
        this.values[n2] = n4;
    }

    private void moveRows(int n, int n2, int n3) {
        System.arraycopy(this.keys, n, this.keys, n2, n3);
        System.arraycopy(this.values, n, this.values, n2, n3);
    }

    public void removeRange(int n, int n2) {
        this.moveRows(n2, n, this.count - n2);
        this.count -= n2 - n;
    }

    public void removeAll() {
        this.hasChanged = true;
        ArrayUtil.clearArray(73, this.keys, 0, this.count);
        ArrayUtil.clearArray(73, this.values, 0, this.count);
        this.count = 0;
    }

    private int compare(int n) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[n]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[n]) {
                return -1;
            }
        } else {
            if (this.targetSearchValue > this.keys[n]) {
                return 1;
            }
            if (this.targetSearchValue < this.keys[n]) {
                return -1;
            }
        }
        return 0;
    }

    public final synchronized void remove(int n) {
        this.hasChanged = true;
        this.moveRows(n + 1, n, this.count - n - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    private boolean lessThan(int n, int n2) {
        return this.sortOnValues ? this.values[n] < this.values[n2] : this.keys[n] < this.keys[n2];
    }
}

