/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcColumnMetaData;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.persist.HsqlProperties;

public class jdbcResultSetMetaData
implements ResultSetMetaData {
    private jdbcColumnMetaData[] columnMetaData;
    private int columnCount;
    private boolean useColumnName;
    private static final boolean TRACE = false;

    jdbcResultSetMetaData(jdbcResultSet jdbcResultSet2, HsqlProperties hsqlProperties) throws SQLException {
        this.init(jdbcResultSet2, hsqlProperties);
    }

    jdbcResultSetMetaData(Result result, HsqlProperties hsqlProperties) throws SQLException {
        this.init(result, hsqlProperties);
    }

    void init(jdbcResultSet jdbcResultSet2, HsqlProperties hsqlProperties) throws SQLException {
        if (jdbcResultSet2 == null) {
            throw Util.sqlException(40, 119, null);
        }
        this.init(jdbcResultSet2.rResult, hsqlProperties);
    }

    void init(Result result, HsqlProperties hsqlProperties) throws SQLException {
        if (result == null) {
            throw Util.sqlException(40, 120, null);
        }
        if (result.mode != 3) {
            return;
        }
        this.columnCount = result.getColumnCount();
        this.useColumnName = hsqlProperties == null ? true : hsqlProperties.isPropertyTrue("get_column_name");
        this.columnMetaData = new jdbcColumnMetaData[this.columnCount];
        Result.ResultMetaData resultMetaData = result.metaData;
        int n = 0;
        while (n < this.columnCount) {
            Boolean bl;
            jdbcColumnMetaData jdbcColumnMetaData2;
            this.columnMetaData[n] = jdbcColumnMetaData2 = new jdbcColumnMetaData();
            jdbcColumnMetaData2.catalogName = resultMetaData.catalogNames[n] == null ? "" : resultMetaData.catalogNames[n];
            jdbcColumnMetaData2.schemaName = resultMetaData.schemaNames[n] == null ? "" : resultMetaData.schemaNames[n];
            jdbcColumnMetaData2.tableName = resultMetaData.tableNames[n] == null ? "" : resultMetaData.tableNames[n];
            jdbcColumnMetaData2.columnName = resultMetaData.colNames[n] == null ? "" : resultMetaData.colNames[n];
            jdbcColumnMetaData2.columnLabel = resultMetaData.colLabels[n] == null ? "" : resultMetaData.colLabels[n];
            jdbcColumnMetaData2.columnType = resultMetaData.colTypes[n];
            jdbcColumnMetaData2.columnTypeName = Types.getTypeString(jdbcColumnMetaData2.columnType);
            jdbcColumnMetaData2.isWritable = resultMetaData.isWritable[n];
            jdbcColumnMetaData2.isReadOnly = !jdbcColumnMetaData2.isWritable;
            jdbcColumnMetaData2.isAutoIncrement = resultMetaData.isIdentity[n];
            jdbcColumnMetaData2.isNullable = resultMetaData.colNullable[n];
            int n2 = jdbcColumnMetaData2.columnType;
            jdbcColumnMetaData2.columnClassName = resultMetaData.classNames[n];
            if (jdbcColumnMetaData2.columnClassName == null || jdbcColumnMetaData2.columnClassName.length() == 0) {
                jdbcColumnMetaData2.columnClassName = Types.getColStClsName(n2);
            }
            if (Types.acceptsPrecisionCreateParam(n2)) {
                if (resultMetaData.colSizes[n] == 0) {
                    jdbcColumnMetaData2.columnDisplaySize = Types.getMaxDisplaySize(n2);
                } else {
                    jdbcColumnMetaData2.columnDisplaySize = resultMetaData.colSizes[n];
                    if (Types.acceptsScaleCreateParam(n2) && resultMetaData.colScales[n] != 0) {
                        jdbcColumnMetaData2.columnDisplaySize += 1 + resultMetaData.colScales[n];
                    }
                }
            } else {
                jdbcColumnMetaData2.columnDisplaySize = Types.getMaxDisplaySize(n2);
            }
            if (Types.isNumberType(n2) && Types.acceptsPrecisionCreateParam(n2)) {
                jdbcColumnMetaData2.precision = resultMetaData.colSizes[n];
                if (jdbcColumnMetaData2.precision == 0) {
                    jdbcColumnMetaData2.precision = Types.getPrecision(n2);
                }
            } else {
                jdbcColumnMetaData2.precision = Types.getPrecision(n2);
            }
            if (Types.acceptsScaleCreateParam(n2)) {
                jdbcColumnMetaData2.scale = resultMetaData.colScales[n];
            }
            jdbcColumnMetaData2.isSigned = (bl = Types.isUnsignedAttribute(n2)) != null && bl == false;
            Boolean bl2 = Types.isCaseSensitive(n2);
            jdbcColumnMetaData2.isCaseSensitive = bl2 != null && bl2 != false;
            jdbcColumnMetaData2.isSearchable = Types.isSearchable(n2);
            ++n;
        }
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isAutoIncrement;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isCaseSensitive;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isSearchable;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isCurrency;
    }

    public int isNullable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isNullable;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isSigned;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnDisplaySize;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnLabel;
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumn(n);
        return this.useColumnName ? this.columnMetaData[n].columnName : this.columnMetaData[--n].columnLabel;
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].schemaName;
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].precision;
    }

    public int getScale(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].scale;
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].tableName;
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].catalogName;
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColumn(n);
        int n2 = this.columnMetaData[--n].columnType;
        return n2 == 100 ? 12 : n2;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnTypeName;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isReadOnly;
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isWritable;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isDefinitelyWritable;
    }

    public String getColumnClassName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnClassName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.columnCount == 0) {
            stringBuffer.append("[columnCount=0]");
            return stringBuffer.toString();
        }
        stringBuffer.append('[');
        int n = 0;
        while (n < this.columnCount) {
            stringBuffer.append('\n');
            stringBuffer.append("   column_");
            stringBuffer.append(n + 1);
            stringBuffer.append('=');
            stringBuffer.append(this.columnMetaData[n]);
            if (n + 1 < this.columnCount) {
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            ++n;
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void checkColumn(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw Util.sqlException(28, String.valueOf(n));
        }
    }
}

