/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcBlob;
import org.hsqldb.jdbc.jdbcClob;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcParameterMetaData;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.jdbc.jdbcResultSetMetaData;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement {
    protected Object[] parameterValues;
    protected int[] parameterTypes;
    protected int[] parameterModes;
    protected int[] streamLengths;
    protected boolean hasStreams;
    protected Result rsmdDescriptor;
    protected Result pmdDescriptor;
    protected jdbcResultSetMetaData rsmd;
    protected Object pmd;
    protected String sql;
    protected int statementID;
    protected boolean isRowCount;

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
    }

    public boolean execute() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.resultIn = null;
        try {
            this.resultOut.setMaxRows(this.maxRows);
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
        if (this.resultIn.mode == 2) {
            Util.throwError(this.resultIn);
        }
        return this.resultIn.mode == 3;
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(false);
        this.resultIn = null;
        try {
            this.resultOut.setMaxRows(this.maxRows);
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
        if (this.resultIn.mode == 2) {
            Util.throwError(this.resultIn);
        } else if (this.resultIn.mode != 3) {
            String string = "Expected but did not recieve a result set";
            throw Util.sqlException(85, string);
        }
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
    }

    public int executeUpdate() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(true);
        this.resultIn = null;
        try {
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
        if (this.resultIn.mode == 2) {
            Util.throwError(this.resultIn);
        } else if (this.resultIn.mode != 1) {
            String string = "Expected but did not recieve a row update count";
            throw Util.sqlException(85, string);
        }
        return this.resultIn.getUpdateCount();
    }

    public int[] executeBatch() throws SQLException {
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
        }
        return super.executeBatch();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setParameter(n, null);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(n, bl2);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setIntParameter(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.setIntParameter(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setIntParameter(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.setLongParameter(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.setParameter(n, d2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setParameter(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.setParameter(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setParameter(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setParameter(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setParameter(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setParameter(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        if (inputStream == null) {
            String string = "input stream is null";
            throw Util.sqlException(62, string);
        }
        try {
            String string = StringConverter.inputStreamToString(inputStream, n2);
            this.setParameter(n, string);
        }
        catch (IOException iOException) {
            throw Util.sqlException(81);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        String string = null;
        if (inputStream == null) {
            string = "input stream is null";
        } else if (n2 % 2 != 0) {
            string = "odd length argument";
        }
        if (string != null) {
            throw Util.sqlException(62, string);
        }
        int n3 = n2 / 2;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (n4 < n3) {
                int n5;
                int n6 = inputStream.read();
                if (n6 != -1 && (n5 = inputStream.read()) != -1) {
                    stringBuffer.append((char)(n6 << 8 | n5));
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw Util.sqlException(19);
        }
        this.setParameter(n, stringBuffer.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        if (inputStream == null) {
            throw Util.sqlException(Trace.error(62, 176));
        }
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = null;
        try {
            try {
                int n5;
                hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
                int n3 = 2048;
                byte[] byArray = new byte[n3];
                int n4 = n2;
                while (n4 > 0 && (n5 = inputStream.read(byArray, 0, n4 > n3 ? n3 : n4)) != -1) {
                    hsqlByteArrayOutputStream.write(byArray, 0, n5);
                    n4 -= n5;
                }
                this.setParameter(n, hsqlByteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                throw Util.sqlException(34, iOException.getMessage());
            }
            Object var10_10 = null;
            if (hsqlByteArrayOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (hsqlByteArrayOutputStream == null) throw throwable;
            try {
                hsqlByteArrayOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        hsqlByteArrayOutputStream.close();
        return;
    }

    public void clearParameters() throws SQLException {
        this.checkClosed();
        ArrayUtil.fillArray(this.parameterValues, null);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setParameter(n, object);
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        int n = this.parameterValues.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.parameterValues, 0, objectArray, 0, n);
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
        }
        this.batchResultOut.add(objectArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        if (reader == null) {
            String string = "reader is null";
            throw Util.sqlException(62, string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            int n3 = n2;
            while (n3 > 0) {
                int n4 = reader.read(cArray, 0, n3 > 2048 ? 2048 : n3);
                if (n4 != -1) {
                    stringBuffer.append(cArray, 0, n4);
                    n3 -= n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw Util.sqlException(19, iOException.toString());
        }
        this.setParameter(n, stringBuffer.toString());
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw Util.notSupported;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBlob(int n, Blob blob) throws SQLException {
        if (blob instanceof jdbcBlob) {
            this.setParameter(n, ((jdbcBlob)blob).data);
            return;
        }
        if (blob == null) {
            this.setParameter(n, null);
            return;
        }
        this.checkSetParameterIndex(n);
        long l = blob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Blob input octet length exceeded: " + l;
            throw Util.sqlException(34, string);
        }
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = null;
        try {
            try {
                int n4;
                hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
                InputStream inputStream = blob.getBinaryStream();
                int n2 = 2048;
                byte[] byArray = new byte[n2];
                int n3 = (int)l;
                while (n3 > 0 && (n4 = inputStream.read(byArray, 0, n3 > n2 ? n2 : n3)) != -1) {
                    hsqlByteArrayOutputStream.write(byArray, 0, n4);
                    n3 -= n4;
                }
                this.setParameter(n, hsqlByteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                throw Util.sqlException(34, iOException.getMessage());
            }
            Object var12_12 = null;
            if (hsqlByteArrayOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (hsqlByteArrayOutputStream == null) throw throwable;
            try {
                hsqlByteArrayOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        hsqlByteArrayOutputStream.close();
        return;
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (clob instanceof jdbcClob) {
            this.setParameter(n, ((jdbcClob)clob).data);
            return;
        }
        if (clob == null) {
            this.setParameter(n, null);
            return;
        }
        this.checkSetParameterIndex(n);
        long l = clob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Max Clob input character length exceeded: " + l;
            throw Util.sqlException(34, string);
        }
        Reader reader = clob.getCharacterStream();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            int n2 = (int)l;
            while (n2 > 0) {
                int n3 = reader.read(cArray, 0, n2 > 2048 ? 2048 : n2);
                if (n3 != -1) {
                    stringBuffer.append(cArray, 0, n3);
                    n2 -= n3;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw Util.sqlException(19, iOException.toString());
        }
        this.setParameter(n, stringBuffer.toString());
    }

    public void setArray(int n, Array array) throws SQLException {
        throw Util.notSupported;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.isRowCount) {
            return null;
        }
        if (this.rsmd == null) {
            this.rsmd = new jdbcResultSetMetaData(this.rsmdDescriptor, this.connection.connProperties);
        }
        return this.rsmd;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        String string;
        try {
            string = HsqlDateTime.getDateString(date, calendar);
        }
        catch (Exception exception) {
            throw Util.sqlException(7, exception.getMessage());
        }
        this.setParameter(n, string);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        String string;
        try {
            string = HsqlDateTime.getTimeString(time, calendar);
        }
        catch (Exception exception) {
            throw Util.sqlException(7, exception.getMessage());
        }
        this.setParameter(n, string);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkSetParameterIndex(n);
        if (calendar != null && timestamp != null) {
            int n2 = timestamp.getNanos();
            timestamp = new Timestamp(HsqlDateTime.getTimeInMillis(timestamp, calendar, null));
            timestamp.setNanos(n2);
        }
        this.setParameter(n, timestamp);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setParameter(n, null);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw Util.notSupported;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new jdbcParameterMetaData(this.pmdDescriptor);
        }
        return (ParameterMetaData)this.pmd;
    }

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string, int n) throws HsqlException, SQLException {
        super(jdbcConnection2, n);
        string = jdbcConnection2.nativeSQL(string);
        this.resultOut.setResultType(65555);
        this.resultOut.setMainString(string);
        Result result = this.connection.sessionProxy.execute(this.resultOut);
        if (result.mode == 2) {
            Util.throwError(result);
        }
        Iterator iterator = result.iterator();
        try {
            Object[] objectArray = (Object[])iterator.next();
            this.statementID = ((Result)objectArray[0]).getStatementID();
            objectArray = (Object[])iterator.next();
            this.rsmdDescriptor = (Result)objectArray[0];
            this.isRowCount = this.rsmdDescriptor.mode == 1;
            objectArray = (Object[])iterator.next();
            this.pmdDescriptor = (Result)objectArray[0];
            this.parameterTypes = this.pmdDescriptor.metaData.getParameterTypes();
            this.parameterValues = new Object[this.parameterTypes.length];
            this.parameterModes = this.pmdDescriptor.metaData.paramMode;
        }
        catch (Exception exception) {
            throw Trace.error(40, exception.toString());
        }
        this.resultOut = new Result(65548, this.parameterTypes, this.statementID);
        this.sql = string;
    }

    protected void checkIsRowCount(boolean bl) throws SQLException {
        if (bl != this.isRowCount) {
            int n = bl ? 154 : 155;
            throw Util.sqlException(n);
        }
    }

    protected void checkSetParameterIndex(int n) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.parameterValues.length) {
            String string = "parameter index out of range: " + n;
            throw Util.sqlException(62, string);
        }
    }

    private void setParameter(int n, Object object) throws SQLException {
        this.checkSetParameterIndex(n);
        --n;
        if (object == null) {
            this.parameterValues[n] = null;
            return;
        }
        int n2 = this.parameterTypes[n];
        try {
            switch (n2) {
                case 1111: {
                    object = new JavaObject((Serializable)object);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (!(object instanceof byte[])) {
                        throw Util.sqlException(Trace.error(95));
                    }
                    object = new Binary((byte[])object, !this.connection.isNetConn);
                    break;
                }
                case 91: {
                    if (object instanceof java.util.Date) {
                        long l = HsqlDateTime.getNormalisedDate(((java.util.Date)object).getTime());
                        object = new Date(l);
                        break;
                    }
                    object = Column.convertObject(object, n2);
                    break;
                }
                case 92: {
                    if (object instanceof java.util.Date) {
                        long l = HsqlDateTime.getNormalisedTime(((java.util.Date)object).getTime());
                        object = new Time(l);
                        break;
                    }
                    object = Column.convertObject(object, n2);
                    break;
                }
                case 93: {
                    if (object instanceof Timestamp) {
                        long l = ((Timestamp)object).getTime();
                        int n3 = ((Timestamp)object).getNanos();
                        object = new Timestamp(l);
                        ((Timestamp)object).setNanos(n3);
                        break;
                    }
                    object = Column.convertObject(object, n2);
                    break;
                }
                default: {
                    object = Column.convertObject(object, n2);
                    break;
                }
            }
        }
        catch (HsqlException hsqlException) {
            Util.throwError(hsqlException);
        }
        this.parameterValues[n] = object;
    }

    private void setIntParameter(int n, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        int n3 = this.parameterTypes[n - 1];
        switch (n3) {
            case -6: 
            case 4: 
            case 5: {
                Integer n4 = new Integer(n2);
                this.parameterValues[n - 1] = n4;
                break;
            }
            default: {
                this.setLongParameter(n, n2);
            }
        }
    }

    private void setLongParameter(int n, long l) throws SQLException {
        this.checkSetParameterIndex(n);
        int n2 = this.parameterTypes[n - 1];
        switch (n2) {
            case -5: {
                Long l2 = new Long(l);
                this.parameterValues[n - 1] = l2;
                break;
            }
            case -2: 
            case 1111: {
                throw Util.sqlException(Trace.error(95));
            }
            default: {
                this.setParameter(n, new Long(l));
            }
        }
    }

    public void addBatch(String string) throws SQLException {
        throw Util.notSupported;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw Util.notSupported;
    }

    public boolean execute(String string) throws SQLException {
        throw Util.notSupported;
    }

    public int executeUpdate(String string) throws SQLException {
        throw Util.notSupported;
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        HsqlException hsqlException = null;
        try {
            if (!this.connection.isClosed) {
                this.connection.sessionProxy.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        this.parameterValues = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.rsmdDescriptor = null;
        this.pmdDescriptor = null;
        this.rsmd = null;
        this.pmd = null;
        super.close();
        if (hsqlException != null) {
            throw Util.sqlException(hsqlException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        String string = this.sql;
        Object[] objectArray = this.parameterValues;
        if (string == null || objectArray == null) {
            stringBuffer.append("[closed]");
            return stringBuffer.toString();
        }
        stringBuffer.append("[sql=[").append(string).append("]");
        if (objectArray.length > 0) {
            stringBuffer.append(", parameters=[");
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append('[');
                stringBuffer.append(objectArray[n]);
                stringBuffer.append("], ");
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

