/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.GrantConstants;
import org.hsqldb.Grantee;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringUtil;

class GranteeManager
implements GrantConstants {
    static final String SYSTEM_AUTHORIZATION_NAME = "_SYSTEM";
    static final String DBA_ADMIN_ROLE_NAME = "DBA";
    static final String PUBLIC_ROLE_NAME = "PUBLIC";
    static final String[] emptyRightsList = new String[0];
    static final IntKeyHashMap hRightsLists = new IntKeyHashMap();
    private HashMappedList map = new HashMappedList();
    private HashMappedList roleMap = new HashMappedList();
    static final IntValueHashMap rightsStringLookup = new IntValueHashMap(7);

    public GranteeManager(Database database) throws HsqlException {
        this.addRole(DBA_ADMIN_ROLE_NAME);
        this.getRole(DBA_ADMIN_ROLE_NAME).setAdminDirect();
    }

    void grant(String string, Object object, int n) throws HsqlException {
        Grantee grantee = this.get(string);
        if (grantee == null) {
            throw Trace.error(232, string);
        }
        if (GranteeManager.isImmutable(string)) {
            throw Trace.error(243, string);
        }
        grantee.grant(object, n);
        grantee.updateAllRights();
        if (grantee.isRole) {
            this.updateAllRights(grantee);
        }
    }

    void grant(String string, String string2) throws HsqlException {
        Grantee grantee = this.get(string);
        if (grantee == null) {
            throw Trace.error(232, string);
        }
        if (GranteeManager.isImmutable(string)) {
            throw Trace.error(243, string);
        }
        Grantee grantee2 = this.get(string2);
        if (grantee2 == null) {
            throw Trace.error(239, string2);
        }
        if (string2.equals(string)) {
            throw Trace.error(244, string);
        }
        if (grantee2.hasRole(string)) {
            throw Trace.error(244, Trace.getMessage(245) + " GRANT " + string + " TO " + string2);
        }
        if (grantee.getDirectRoles().contains(string2)) {
            throw Trace.error(245, string2);
        }
        grantee.grant(string2);
        grantee.updateAllRights();
        if (grantee.isRole) {
            this.updateAllRights(grantee);
        }
    }

    void revoke(String string, String string2) throws HsqlException {
        Grantee grantee = this.get(string);
        if (grantee == null) {
            throw Trace.error(232, string);
        }
        grantee.revoke(string2);
        grantee.updateAllRights();
        if (grantee.isRole) {
            this.updateAllRights(grantee);
        }
    }

    void revoke(String string, Object object, int n) throws HsqlException {
        Grantee grantee = this.get(string);
        grantee.revoke(object, n);
        grantee.updateAllRights();
        if (grantee.isRole) {
            this.updateAllRights(grantee);
        }
    }

    void removeEmptyRole(Grantee grantee) {
        String string = grantee.getName();
        int n = 0;
        while (n < this.map.size()) {
            Grantee grantee2 = (Grantee)this.map.get(n);
            grantee2.roles.remove(string);
            ++n;
        }
    }

    void removeDbObject(Object object) {
        int n = 0;
        while (n < this.map.size()) {
            Grantee grantee = (Grantee)this.map.get(n);
            grantee.revokeDbObject(object);
            ++n;
        }
    }

    void updateAllRights(Grantee grantee) {
        String string = grantee.getName();
        int n = 0;
        while (n < this.map.size()) {
            Grantee grantee2 = (Grantee)this.map.get(n);
            if (grantee2.isRole) {
                grantee2.updateNestedRoles(string);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.map.size()) {
            Grantee grantee3 = (Grantee)this.map.get(n2);
            if (!grantee3.isRole) {
                grantee3.updateAllRights();
            }
            ++n2;
        }
    }

    public boolean removeGrantee(String string) {
        if (GranteeManager.isReserved(string)) {
            return false;
        }
        Grantee grantee = (Grantee)this.map.remove(string);
        if (grantee == null) {
            return false;
        }
        grantee.clearPrivileges();
        this.updateAllRights(grantee);
        if (grantee.isRole) {
            this.roleMap.remove(string);
            this.removeEmptyRole(grantee);
        }
        return true;
    }

    public Grantee addGrantee(String string) throws HsqlException {
        if (this.map.containsKey(string)) {
            throw Trace.error(241, string);
        }
        Grantee grantee = null;
        if (!GranteeManager.isReserved(string) && (grantee = this.get(PUBLIC_ROLE_NAME)) == null) {
            Trace.doAssert(false, Trace.getMessage(242));
        }
        Grantee grantee2 = new Grantee(string, grantee, this);
        this.map.put(string, grantee2);
        return grantee2;
    }

    boolean isGrantee(String string) {
        return this.map.containsKey(string);
    }

    static int getCheckRight(String string) throws HsqlException {
        int n = GranteeManager.getRight(string);
        if (n != 0) {
            return n;
        }
        throw Trace.error(249, string);
    }

    static int getRight(String string) {
        return rightsStringLookup.get((Object)string, 0);
    }

    static String getRightsList(int n) {
        if (n == 0) {
            return null;
        }
        if (n == 15) {
            return "ALL";
        }
        return StringUtil.getList(GranteeManager.getRightsArray(n), ",", "");
    }

    static String[] getRightsArray(int n) {
        if (n == 0) {
            return emptyRightsList;
        }
        String[] stringArray = (String[])hRightsLists.get(n);
        if (stringArray != null) {
            return stringArray;
        }
        stringArray = GranteeManager.getRightsArraySub(n);
        hRightsLists.put(n, stringArray);
        return stringArray;
    }

    private static String[] getRightsArraySub(int n) {
        if (n == 0) {
            return emptyRightsList;
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = rightsStringLookup.keySet().iterator();
        while (iterator.hasNext()) {
            int n2;
            String string = (String)iterator.next();
            if (string.equals("ALL") || (n & (n2 = rightsStringLookup.get((Object)string, 0))) == 0) continue;
            hsqlArrayList.add(string);
        }
        return (String[])hsqlArrayList.toArray(new String[hsqlArrayList.size()]);
    }

    HashSet getGrantedClassNames() throws HsqlException {
        int n = this.map.size();
        HashSet hashSet = new HashSet();
        int n2 = 0;
        while (n2 < n) {
            Grantee grantee = (Grantee)this.map.get(n2);
            if (grantee != null) {
                Iterator iterator = grantee.getGrantedClassNames(false).iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next());
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public Grantee get(String string) {
        return (Grantee)this.map.get(string);
    }

    public Collection getGrantees() {
        return this.map.values();
    }

    public static boolean validRightString(String string) {
        return GranteeManager.getRight(string) != 0;
    }

    public static boolean isImmutable(String string) {
        return string.equals(SYSTEM_AUTHORIZATION_NAME) || string.equals(DBA_ADMIN_ROLE_NAME);
    }

    public static boolean isReserved(String string) {
        return string.equals(SYSTEM_AUTHORIZATION_NAME) || string.equals(DBA_ADMIN_ROLE_NAME) || string.equals(PUBLIC_ROLE_NAME);
    }

    String addRole(String string) throws HsqlException {
        if (string == null) {
            Trace.doAssert(false, Trace.getMessage(236));
        }
        Grantee grantee = null;
        if (GranteeManager.validRightString(string)) {
            throw Trace.error(237, string);
        }
        grantee = this.addGrantee(string);
        grantee.isRole = true;
        boolean bl = this.roleMap.add(string, grantee);
        if (!bl) {
            throw Trace.error(238, string);
        }
        return string;
    }

    void dropRole(String string) throws HsqlException {
        if (string.equals(DBA_ADMIN_ROLE_NAME)) {
            throw Trace.error(33);
        }
        if (!this.isRole(string)) {
            throw Trace.error(239, string);
        }
        this.removeGrantee(string);
        this.roleMap.remove(string);
    }

    public Set getRoleNames() {
        return this.roleMap.keySet();
    }

    Grantee getRole(String string) throws HsqlException {
        Grantee grantee;
        if (!this.isRole(string)) {
            Trace.doAssert(false, "No role '" + string + "'");
        }
        if ((grantee = (Grantee)this.roleMap.get(string)) == null) {
            throw Trace.error(234, string);
        }
        return grantee;
    }

    boolean isRole(String string) throws HsqlException {
        return this.roleMap.containsKey(string);
    }

    static {
        rightsStringLookup.put("ALL", 15);
        rightsStringLookup.put("SELECT", 1);
        rightsStringLookup.put("UPDATE", 8);
        rightsStringLookup.put("DELETE", 2);
        rightsStringLookup.put("INSERT", 4);
    }
}

