/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.IllegalArgumentException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;

public class UnoUrl {
    private static final String FORMAT_ERROR = "syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname";
    private static final String VALUE_CHAR_SET = "!$&'()*+-./:?@_~";
    private static final String OID_CHAR_SET = "!$&'()*+-./:?@_~,=";
    private UnoUrlPart connection;
    private UnoUrlPart protocol;
    private String rootOid;

    private UnoUrl(UnoUrlPart unoUrlPart, UnoUrlPart unoUrlPart2, String string) {
        this.connection = unoUrlPart;
        this.protocol = unoUrlPart2;
        this.rootOid = string;
    }

    public String getConnection() {
        return this.connection.getPartTypeName();
    }

    public String getProtocol() {
        return this.protocol.getPartTypeName();
    }

    public String getRootOid() {
        return this.rootOid;
    }

    public HashMap getProtocolParameters() {
        return this.protocol.getPartParameters();
    }

    public HashMap getConnectionParameters() {
        return this.connection.getPartParameters();
    }

    public String getProtocolParametersAsString() {
        return this.protocol.getUninterpretedParameterString();
    }

    public String getConnectionParametersAsString() {
        return this.connection.getUninterpretedParameterString();
    }

    public String getProtocolAndParametersAsString() {
        return this.protocol.getUninterpretedString();
    }

    public String getConnectionAndParametersAsString() {
        return this.connection.getUninterpretedString();
    }

    private static int hexToInt(int n) throws IllegalArgumentException {
        boolean bl;
        char c = Character.toLowerCase((char)n);
        boolean bl2 = '0' <= c && c <= '9';
        boolean bl3 = bl = 'a' <= c && c <= 'f' || bl2;
        if (!bl) {
            throw new IllegalArgumentException("Invalid UTF-8 hex byte '" + c + "'.");
        }
        return bl2 ? n - 48 : 10 + ((char)c - 97) & 0xF;
    }

    private static String decodeUTF8(String string) throws IllegalArgumentException {
        int n;
        int n2;
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        while (n3 < string.length()) {
            n2 = string.charAt(n3);
            if (n2 == 37) {
                int n4 = UnoUrl.hexToInt(string.charAt(++n3));
                n = UnoUrl.hexToInt(string.charAt(++n3));
                n2 = n4 << 4 | n;
            }
            vector.addElement(new Integer(n2));
            ++n3;
        }
        n2 = vector.size();
        byte[] byArray = new byte[n2];
        n = 0;
        while (n < n2) {
            Integer n5 = (Integer)vector.elementAt(n);
            byArray[n] = (byte)(n5 & 0xFF);
            ++n;
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Couldn't convert parameter string to UTF-8 string:" + unsupportedEncodingException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static HashMap buildParamHashMap(String var0) throws IllegalArgumentException {
        var1_1 = new HashMap<String, String>();
        var2_2 = 0;
        do {
            var3_3 = ',';
            var4_4 = "";
            var5_5 = "";
            if (true) ** GOTO lbl10
            do {
                var4_4 = var4_4 + var3_3;
lbl10:
                // 2 sources

                if (var2_2 >= var0.length()) ** GOTO lbl17
                v0 = var0.charAt(var2_2++);
                var3_3 = v0;
            } while (v0 != '=');
            if (true) ** GOTO lbl17
            do {
                var5_5 = var5_5 + var3_3;
lbl17:
                // 3 sources

                if (var2_2 >= var0.length()) break;
                v1 = var0.charAt(var2_2++);
                var3_3 = v1;
            } while (v1 != ',' && var3_3 != 59);
            if (var4_4.length() <= 0 || var5_5.length() <= 0) continue;
            if (!UnoUrl.isAlphaNumeric(var4_4)) {
                throw new IllegalArgumentException("The parameter key '" + var4_4 + "' may only consist of alpha numeric ASCII characters.");
            }
            if (!UnoUrl.isValidString(var5_5, "!$&'()*+-./:?@_~%")) {
                throw new IllegalArgumentException("The parameter value for key '" + var4_4 + "' contains illegal characters.");
            }
            var1_1.put(var4_4, UnoUrl.decodeUTF8(var5_5));
        } while (var2_2 < var0.length() && var3_3 == 44);
        return var1_1;
    }

    private static UnoUrlPart parseUnoUrlPart(String string) throws IllegalArgumentException {
        String string2 = string;
        String string3 = "";
        int n = string.indexOf(",");
        if (n != -1) {
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1).trim();
        }
        if (!UnoUrl.isAlphaNumeric(string2)) {
            throw new IllegalArgumentException("The part name '" + string2 + "' may only consist of alpha numeric ASCII characters.");
        }
        HashMap hashMap = UnoUrl.buildParamHashMap(string3);
        return new UnoUrlPart(string3, string2, hashMap);
    }

    private static boolean isAlphaNumeric(String string) {
        return UnoUrl.isValidString(string, null);
    }

    private static boolean isValidString(String string, String string2) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            char c = string.charAt(n2);
            boolean bl2 = bl = 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9';
            if (!bl && string2 != null) {
                boolean bl3 = bl = string2.indexOf(c) != -1;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static UnoUrl parseUnoUrl(String string) throws IllegalArgumentException {
        String string2;
        String string3 = string;
        int n = string3.indexOf(58);
        if (n != -1 && !"uno".equals(string2 = string3.substring(0, n).trim())) {
            throw new IllegalArgumentException("Uno Urls must start with 'uno:'. syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname");
        }
        if ((n = (string3 = string3.substring(n + 1).trim()).indexOf(59)) == -1) {
            throw new IllegalArgumentException("'" + string + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        string2 = string3.substring(0, n).trim();
        string3 = string3.substring(n + 1).trim();
        UnoUrlPart unoUrlPart = UnoUrl.parseUnoUrlPart(string2);
        n = string3.indexOf(59);
        if (n == -1) {
            throw new IllegalArgumentException("'" + string + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        String string4 = string3.substring(0, n).trim();
        string3 = string3.substring(n + 1).trim();
        UnoUrlPart unoUrlPart2 = UnoUrl.parseUnoUrlPart(string4);
        String string5 = string3.trim();
        if (!UnoUrl.isValidString(string5, OID_CHAR_SET)) {
            throw new IllegalArgumentException("Root OID '" + string5 + "' contains illegal characters.");
        }
        return new UnoUrl(unoUrlPart, unoUrlPart2, string5);
    }

    private static class UnoUrlPart {
        private String partTypeName;
        private HashMap partParameters;
        private String uninterpretedParameterString;

        public UnoUrlPart(String string, String string2, HashMap hashMap) {
            this.uninterpretedParameterString = string;
            this.partTypeName = string2;
            this.partParameters = hashMap;
        }

        public String getPartTypeName() {
            return this.partTypeName;
        }

        public HashMap getPartParameters() {
            return this.partParameters;
        }

        public String getUninterpretedParameterString() {
            return this.uninterpretedParameterString;
        }

        public String getUninterpretedString() {
            StringBuffer stringBuffer = new StringBuffer(this.partTypeName);
            if (this.uninterpretedParameterString.length() > 0) {
                stringBuffer.append(',');
                stringBuffer.append(this.uninterpretedParameterString);
            }
            return stringBuffer.toString();
        }
    }
}

