/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.util.UrlToFileMapper;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public final class NativeLibraryLoader {
    public static void loadLibrary(ClassLoader classLoader, String string) {
        File file = NativeLibraryLoader.getResource(classLoader, System.mapLibraryName(string));
        if (file == null) {
            System.loadLibrary(string);
        } else {
            System.load(file.getAbsolutePath());
        }
    }

    public static File getResource(ClassLoader classLoader, String string) {
        URL[] uRLArray;
        if (classLoader != null && (uRLArray = UrlToFileMapper.mapUrlToFile(classLoader.getResource(string))) != null) {
            return uRLArray;
        }
        if (classLoader instanceof URLClassLoader) {
            uRLArray = ((URLClassLoader)classLoader).getURLs();
            int n = 0;
            while (n < uRLArray.length) {
                File file = UrlToFileMapper.mapUrlToFile(uRLArray[n]);
                if (file != null) {
                    File file2;
                    File file3 = file2 = file.isDirectory() ? file : file.getParentFile();
                    if (file2 != null) {
                        file = new File(file2, string);
                        if (file.exists()) {
                            return file;
                        }
                        if ((file2 = file2.getParentFile()) != null && (file = new File(file2, string)).exists()) {
                            return file;
                        }
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private NativeLibraryLoader() {
    }
}

