/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.IMessage;
import com.sun.star.lib.uno.environments.remote.Protocol;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Marshal;
import com.sun.star.lib.uno.protocols.urp.Unmarshal;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IMethodDescription;
import com.sun.star.uno.ITypeDescription;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;

public class urp
extends Protocol {
    public static final boolean DEBUG = false;
    private static final ITypeDescription[] __emptyITypeDescArray = new ITypeDescription[0];
    private static final short __cache_size = 256;
    protected IBridge _iBridge;
    private String _in_oid;
    private ITypeDescription _in_interface;
    private ThreadId _in_threadId;
    private String _out_oid;
    private ITypeDescription _out_interface;
    private ThreadId _out_threadId;
    private int _message_count;
    private boolean _ignore_cache;
    private Marshal _marshal;
    private Unmarshal _unmarshal;
    private String[] _operationContainer = new String[1];
    private Object[][] _paramsContainer = new Object[1][];
    private boolean[] _synchronContainer = new boolean[1];
    private boolean[] _mustReplyContainer = new boolean[1];
    private boolean[] _exceptionContainer = new boolean[1];
    private static final byte BIG_HEADER = -128;
    private static final byte REQUEST = 64;
    private static final byte NEWTYPE = 32;
    private static final byte NEWOID = 16;
    private static final byte NEWTID = 8;
    private static final byte LONGMETHODID = 4;
    private static final byte IGNORECACHE = 2;
    private static final byte MOREFLAGS = 1;
    private static final byte MUSTREPLY = -128;
    private static final byte SYNCHRONOUSE = 64;
    private static final byte DIR_MID = 64;
    private static final byte EXCEPTION = 32;

    public urp(IBridge iBridge) {
        this._iBridge = iBridge;
        this._marshal = new Marshal(iBridge, 256);
        this._unmarshal = new Unmarshal(iBridge, 256);
    }

    public String getName() {
        return "urp";
    }

    private Object readReply(int n, boolean[] blArray) {
        if ((n & 8) != 0) {
            this._in_threadId = this._unmarshal.readThreadId();
        }
        Object[] objectArray = (Object[])this.removePendingRequest(this._in_threadId);
        Object[] objectArray2 = (Object[])objectArray[0];
        ITypeDescription[] iTypeDescriptionArray = (ITypeDescription[])objectArray[1];
        TypeDescription typeDescription = (TypeDescription)objectArray[2];
        boolean bl = blArray[0] = (n & 0x20) != 0;
        if (blArray[0]) {
            iTypeDescriptionArray = __emptyITypeDescArray;
            try {
                typeDescription = TypeDescription.getTypeDescription("any");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("this cannot happen: " + classNotFoundException);
            }
        }
        Object object = null;
        if (typeDescription != null) {
            object = this._unmarshal.readValue(typeDescription);
        }
        int n2 = 0;
        while (n2 < iTypeDescriptionArray.length) {
            if (iTypeDescriptionArray[n2] != null) {
                Array.set(objectArray2[n2], 0, this._unmarshal.readValue((TypeDescription)iTypeDescriptionArray[n2].getComponentType()));
            }
            ++n2;
        }
        return object;
    }

    private Object[] readParams(IMethodDescription iMethodDescription) {
        ITypeDescription[] iTypeDescriptionArray = iMethodDescription.getInSignature();
        ITypeDescription[] iTypeDescriptionArray2 = iMethodDescription.getOutSignature();
        Object[] objectArray = new Object[iTypeDescriptionArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (iTypeDescriptionArray[n] != null) {
                if (iTypeDescriptionArray2[n] != null) {
                    Object object = Array.newInstance(iTypeDescriptionArray2[n].getComponentType().getZClass(), 1);
                    Array.set(object, 0, this._unmarshal.readValue((TypeDescription)iTypeDescriptionArray2[n].getComponentType()));
                    objectArray[n] = object;
                } else {
                    objectArray[n] = this._unmarshal.readValue((TypeDescription)iTypeDescriptionArray[n]);
                }
            } else {
                objectArray[n] = Array.newInstance(iTypeDescriptionArray2[n].getComponentType().getZClass(), 1);
            }
            ++n;
        }
        return objectArray;
    }

    private void readShortRequest(int n, String[] stringArray, Object[][] objectArray, boolean[] blArray) {
        ++this._requestsRecieved;
        int n2 = (n & 0x40) != 0 ? (n & 0x3F) << 8 | this._unmarshal.read8Bit() : n & 0x3F;
        IMethodDescription iMethodDescription = this._in_interface.getMethodDescription(n2);
        stringArray[0] = iMethodDescription.getName();
        blArray[0] = !iMethodDescription.isOneway();
        objectArray[0] = this.readParams(iMethodDescription);
        if (blArray[0]) {
            this.putPendingReply(this._in_threadId, new Object[]{objectArray[0], iMethodDescription.getOutSignature(), iMethodDescription.getReturnSignature()});
        }
    }

    private void readLongRequest(int n, String[] stringArray, Object[][] objectArray, boolean[] blArray, boolean[] blArray2) {
        int n2;
        ++this._requestsRecieved;
        if ((n & 1) != 0) {
            n2 = this._unmarshal.read8Bit();
            blArray2[0] = (n2 & 0xFFFFFF80) != 0;
            blArray[0] = (n2 & 0x40) != 0;
        }
        n2 = (n & 4) != 0 ? this._unmarshal.read16Bit() : this._unmarshal.read8Bit();
        if ((n & 0x20) != 0) {
            this._in_interface = this._unmarshal.readType();
        }
        IMethodDescription iMethodDescription = this._in_interface.getMethodDescription(n2);
        if ((n & 1) == 0) {
            boolean bl = blArray[0] = !iMethodDescription.isOneway();
        }
        if ((n & 0x10) != 0) {
            this._in_oid = this._unmarshal.readObjectId();
        }
        if ((n & 8) != 0) {
            this._in_threadId = this._unmarshal.readThreadId();
        }
        this._ignore_cache = (n & 2) != 0;
        stringArray[0] = iMethodDescription.getName();
        objectArray[0] = this.readParams(iMethodDescription);
        if (blArray[0]) {
            this.putPendingReply(this._in_threadId, new Object[]{objectArray[0], iMethodDescription.getOutSignature(), iMethodDescription.getReturnSignature()});
        }
    }

    private Object readMessage(String[] stringArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
        int n = this._unmarshal.read8Bit();
        Object object = null;
        if ((n & 0xFFFFFF80) != 0) {
            if ((n & 0x40) != 0) {
                this.readLongRequest(n, stringArray, (Object[][])objectArray, blArray, blArray2);
            } else {
                object = this.readReply(n, blArray3);
            }
        } else {
            this.readShortRequest(n, stringArray, (Object[][])objectArray, blArray);
        }
        if (blArray[0]) {
            blArray2[0] = true;
        }
        return object;
    }

    public void writeRequest(String string, TypeDescription typeDescription, String string2, ThreadId threadId, Object[] objectArray, Boolean[] booleanArray, Boolean[] booleanArray2) {
        ++this._requestsSend;
        ++this._message_count;
        IMethodDescription iMethodDescription = typeDescription.getMethodDescription(string2);
        int n = 0;
        boolean bl = false;
        if (this._out_oid == null || !string.equals(this._out_oid)) {
            n = (byte)(n | 0x10);
            this._out_oid = string;
            bl = true;
        } else {
            string = null;
        }
        if (this._out_interface == null || !this._out_interface.equals(typeDescription)) {
            n = (byte)(n | 0x20);
            this._out_interface = typeDescription;
            bl = true;
        } else {
            typeDescription = null;
        }
        if (this._out_threadId == null || !this._out_threadId.equals(threadId)) {
            n = (byte)(n | 8);
            this._out_threadId = threadId;
            bl = true;
        } else {
            threadId = null;
        }
        boolean bl2 = false;
        if (booleanArray[0] != null) {
            if (iMethodDescription.isOneway() == booleanArray[0].booleanValue()) {
                bl = true;
                bl2 = true;
            }
        } else {
            booleanArray[0] = new Boolean(!iMethodDescription.isOneway());
        }
        if (booleanArray2[0] != null && booleanArray2[0] != booleanArray[0]) {
            bl = true;
            bl2 = true;
        } else {
            booleanArray2[0] = booleanArray[0];
        }
        int n2 = iMethodDescription.getIndex();
        if (n2 < 0 || n2 >= 65536) {
            throw new IllegalArgumentException("Method ID " + n2 + " out of range");
        }
        if (n2 >= 49152) {
            bl = true;
        }
        if (bl) {
            n = (byte)(n | 0xFFFFFF80);
            n = (byte)(n | 0x40);
            n = (byte)(n | (bl2 ? 1 : 0));
            if (n2 > 255) {
                n = (byte)(n | 4);
            }
            this._marshal.write8Bit(n);
            if (bl2) {
                int n3 = 0;
                n3 = (byte)(n3 | (booleanArray[0] != false ? 64 : 0));
                n3 = (byte)(n3 | (booleanArray2[0] != false ? -128 : 0));
                this._marshal.write8Bit(n3);
            }
            if (n2 > 255) {
                this._marshal.write16Bit(n2);
            } else {
                this._marshal.write8Bit(n2);
            }
            if (typeDescription != null) {
                this._marshal.writeType(typeDescription);
            }
            if (string != null) {
                this._marshal.writeObjectId(this._out_oid);
            }
            if (threadId != null) {
                this._marshal.writeThreadId(threadId);
            }
        } else if (n2 <= 47) {
            this._marshal.write8Bit(n2);
        } else {
            n = (byte)(n | 0x40);
            n = (byte)(n | n2 >> 8);
            this._marshal.write8Bit(n);
            this._marshal.write8Bit(n2);
        }
        ITypeDescription[] iTypeDescriptionArray = iMethodDescription.getInSignature();
        ITypeDescription[] iTypeDescriptionArray2 = iMethodDescription.getOutSignature();
        int n4 = 0;
        while (n4 < iTypeDescriptionArray.length) {
            if (iTypeDescriptionArray[n4] != null) {
                if (iTypeDescriptionArray2[n4] != null) {
                    this._marshal.writeValue((TypeDescription)iTypeDescriptionArray2[n4].getComponentType(), ((Object[])objectArray[n4])[0]);
                } else {
                    this._marshal.writeValue((TypeDescription)iTypeDescriptionArray[n4], objectArray[n4]);
                }
            }
            ++n4;
        }
        if (booleanArray[0].booleanValue()) {
            this.putPendingRequest(this._out_threadId, new Object[]{objectArray, iTypeDescriptionArray2, iMethodDescription.getReturnSignature()});
        }
    }

    public void writeReply(boolean bl, ThreadId threadId, Object object) {
        ++this._message_count;
        Object[] objectArray = (Object[])this.removePendingReply(threadId);
        Object[] objectArray2 = (Object[])objectArray[0];
        ITypeDescription[] iTypeDescriptionArray = (ITypeDescription[])objectArray[1];
        TypeDescription typeDescription = (TypeDescription)objectArray[2];
        int n = -128;
        if (bl) {
            n = (byte)(n | 0x20);
            iTypeDescriptionArray = __emptyITypeDescArray;
            try {
                typeDescription = TypeDescription.getTypeDescription("any");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("this cannot happen: " + classNotFoundException);
            }
        }
        if (this._out_threadId == null || !this._out_threadId.equals(threadId)) {
            n = (byte)(n | 8);
            this._out_threadId = threadId;
        } else {
            threadId = null;
        }
        this._marshal.write8Bit(n);
        if (threadId != null) {
            this._marshal.writeThreadId(threadId);
        }
        this._marshal.writeValue(typeDescription, object);
        int n2 = 0;
        while (n2 < iTypeDescriptionArray.length) {
            if (iTypeDescriptionArray[n2] != null) {
                this._marshal.writeValue((TypeDescription)iTypeDescriptionArray[n2].getComponentType(), Array.get(objectArray2[n2], 0));
            }
            ++n2;
        }
    }

    private byte[] readBlock(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return byArray;
    }

    private void writeBlock(DataOutput dataOutput, byte[] byArray, int n) throws IOException {
        dataOutput.writeInt(byArray.length);
        dataOutput.writeInt(n);
        dataOutput.write(byArray);
    }

    public IMessage readMessage(InputStream inputStream) throws IOException {
        Message message = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        while (message == null) {
            Object object;
            if (!this._unmarshal.hasMore()) {
                object = this.readBlock(dataInputStream);
                this._unmarshal.reset((byte[])object);
            }
            if (!this._unmarshal.hasMore()) {
                throw new IOException("connection close message received");
            }
            object = this.readMessage(this._operationContainer, (Object[])this._paramsContainer, this._synchronContainer, this._mustReplyContainer, this._exceptionContainer);
            message = this._operationContainer[0] == null ? new Message(null, object, null, null, this._in_threadId, false, false, this._exceptionContainer[0], this._paramsContainer[0]) : new Message(this._in_oid, null, this._in_interface, this._operationContainer[0], this._in_threadId, this._synchronContainer[0], this._mustReplyContainer[0], false, this._paramsContainer[0]);
            this._operationContainer[0] = null;
            this._paramsContainer[0] = null;
            this._synchronContainer[0] = false;
            this._exceptionContainer[0] = false;
            this._mustReplyContainer[0] = false;
        }
        return message;
    }

    public void flush(DataOutput dataOutput) throws IOException {
        if (this._message_count > 0) {
            this.writeBlock(dataOutput, this._marshal.reset(), this._message_count);
            this._message_count = 0;
        }
    }

    static class Message
    implements IMessage {
        String _oid;
        Object _result;
        ITypeDescription _iTypeDescription;
        String _operation;
        ThreadId _threadId;
        boolean _synchron;
        boolean _mustReply;
        boolean _exception;
        Object[] _params;

        Message(String string, Object object, ITypeDescription iTypeDescription, String string2, ThreadId threadId, boolean bl, boolean bl2, boolean bl3, Object[] objectArray) {
            this._oid = string;
            this._result = object;
            this._iTypeDescription = iTypeDescription;
            this._operation = string2;
            this._threadId = threadId;
            this._synchron = bl;
            this._mustReply = bl2;
            this._exception = bl3;
            this._params = objectArray;
        }

        public String getOperation() {
            return this._operation;
        }

        public ThreadId getThreadId() {
            return this._threadId;
        }

        public ITypeDescription getInterface() {
            return this._iTypeDescription;
        }

        public boolean isSynchron() {
            return this._synchron;
        }

        public boolean mustReply() {
            return this._mustReply;
        }

        public boolean isException() {
            return this._exception;
        }

        public String getOid() {
            return this._oid;
        }

        public Object getData(Object[][] objectArray) {
            objectArray[0] = this._params;
            return this._result;
        }
    }
}

