/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.connections.socket.ConnectionDescriptor;
import com.sun.star.lib.connections.socket.SocketConnection;
import com.sun.star.registry.XRegistryKey;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public final class socketConnector
implements XConnector {
    public static final String __serviceName = "com.sun.star.connection.socketConnector";
    private boolean connected = false;
    static /* synthetic */ Class class$com$sun$star$lib$connections$socket$socketConnector;

    public static XSingleServiceFactory __getServiceFactory(String string, XMultiServiceFactory xMultiServiceFactory, XRegistryKey xRegistryKey) {
        return string.equals((class$com$sun$star$lib$connections$socket$socketConnector == null ? (class$com$sun$star$lib$connections$socket$socketConnector = socketConnector.class$("com.sun.star.lib.connections.socket.socketConnector")) : class$com$sun$star$lib$connections$socket$socketConnector).getName()) ? FactoryHelper.getServiceFactory(class$com$sun$star$lib$connections$socket$socketConnector == null ? (class$com$sun$star$lib$connections$socket$socketConnector = socketConnector.class$("com.sun.star.lib.connections.socket.socketConnector")) : class$com$sun$star$lib$connections$socket$socketConnector, __serviceName, xMultiServiceFactory, xRegistryKey) : null;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        return FactoryHelper.writeRegistryServiceInfo((class$com$sun$star$lib$connections$socket$socketConnector == null ? (class$com$sun$star$lib$connections$socket$socketConnector = socketConnector.class$("com.sun.star.lib.connections.socket.socketConnector")) : class$com$sun$star$lib$connections$socket$socketConnector).getName(), __serviceName, xRegistryKey);
    }

    public synchronized XConnection connect(String string) throws NoConnectException, ConnectionSetupException {
        SocketConnection socketConnection;
        InetAddress[] inetAddressArray;
        ConnectionDescriptor connectionDescriptor;
        if (this.connected) {
            throw new ConnectionSetupException("alread connected");
        }
        try {
            connectionDescriptor = new ConnectionDescriptor(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConnectionSetupException(illegalArgumentException.toString());
        }
        if (connectionDescriptor.getHost() == null) {
            throw new ConnectionSetupException("host parameter missing");
        }
        try {
            inetAddressArray = InetAddress.getAllByName(connectionDescriptor.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            throw new ConnectionSetupException(unknownHostException.toString());
        }
        Socket socket = null;
        int n = 0;
        while (n < inetAddressArray.length) {
            try {
                socket = new Socket(inetAddressArray[n], connectionDescriptor.getPort());
                break;
            }
            catch (IOException iOException) {
                if (n == inetAddressArray.length - 1) {
                    throw new NoConnectException(iOException.toString());
                }
                ++n;
            }
        }
        try {
            if (connectionDescriptor.getTcpNoDelay() != null) {
                socket.setTcpNoDelay(connectionDescriptor.getTcpNoDelay());
            }
            socketConnection = new SocketConnection(string, socket);
        }
        catch (IOException iOException) {
            throw new NoConnectException(iOException.toString());
        }
        this.connected = true;
        return socketConnection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

