/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.beans;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.beans.ContainerFactory;
import com.sun.star.comp.beans.LocalOfficeWindow;
import com.sun.star.comp.beans.NativeService;
import com.sun.star.comp.beans.OfficeConnection;
import com.sun.star.comp.beans.OfficeWindow;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.UnoUrl;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LocalOfficeConnection
implements OfficeConnection {
    public static final String OFFICE_APP_NAME = "soffice";
    public static final String OFFICE_LIB_NAME = "officebean";
    public static final String OFFICE_ID_SUFFIX = "_Office";
    private static String mProgramPath;
    private Process mProcess;
    private ContainerFactory mContainerFactory;
    private XComponentContext mContext;
    private XBridge mBridge;
    private String mURL;
    private String mConnType;
    private String mPipe;
    private String mPort;
    private String mProtocol;
    private String mInitialObject;
    private List mComponents = new Vector();
    private static long m_nBridgeCounter;
    static /* synthetic */ Class class$com$sun$star$comp$beans$LocalOfficeConnection;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$uno$XComponentContext;
    static /* synthetic */ Class class$com$sun$star$bridge$XBridgeFactory;
    static /* synthetic */ Class class$com$sun$star$connection$XConnector;

    private void dbgPrint(String string) {
        System.err.println(string);
    }

    public LocalOfficeConnection() {
        try {
            this.setUnoUrl("uno:pipe,name=" + LocalOfficeConnection.getPipeName() + ";urp;StarOffice.ServiceManager");
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void setUnoUrl(String string) throws MalformedURLException {
        this.mURL = null;
        String string2 = "uno:localoffice";
        if (string.startsWith(string2)) {
            this.parseUnoUrlWithOfficePath(string, string2);
        } else {
            try {
                UnoUrl unoUrl = UnoUrl.parseUnoUrl((String)string);
                mProgramPath = null;
                this.mConnType = unoUrl.getConnection();
                this.mPipe = (String)unoUrl.getConnectionParameters().get("pipe");
                this.mPort = (String)unoUrl.getConnectionParameters().get("port");
                this.mProtocol = unoUrl.getProtocol();
                this.mInitialObject = unoUrl.getRootOid();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedURLException("Invalid UNO connection URL.");
            }
        }
        this.mURL = string;
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.mContainerFactory = containerFactory;
    }

    public synchronized XComponentContext getComponentContext() {
        if (this.mContext == null) {
            this.mContext = this.connect();
        }
        return this.mContext;
    }

    public OfficeWindow createOfficeWindow(Container container) {
        return new LocalOfficeWindow(this);
    }

    public void dispose() {
        Iterator iterator = this.mComponents.iterator();
        while (iterator.hasNext()) {
            try {
                ((XEventListener)iterator.next()).disposing(null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.mComponents.clear();
        if (this.mBridge != null) {
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = LocalOfficeConnection.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)this.mBridge);
            if (xComponent != null) {
                xComponent.dispose();
            } else {
                System.err.println("LocalOfficeConnection: could not dispose bridge!");
            }
            this.mBridge = null;
        }
        this.mContainerFactory = null;
        this.mContext = null;
    }

    public void addEventListener(XEventListener xEventListener) {
        this.mComponents.add(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this.mComponents.remove(xEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private XComponentContext connect() {
        try {
            block14: {
                var1_1 = Bootstrap.createInitialComponentContext(null);
                var2_3 = var1_1.getServiceManager();
                var3_5 = null;
                try {
                    try {
                        var3_5 = this.resolve(var1_1, this.mURL);
                    }
                    catch (NoConnectException var4_10) {
                        var5_13 = new OfficeService();
                        var5_13.startupService();
                        var6_15 = System.currentTimeMillis() + (long)(1000 * var5_13.getStartupTime());
                        ** while (var3_5 == null)
                    }
                    var10_7 = null;
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Thread.currentThread();
                            Thread.sleep(500L);
                            var3_5 = this.resolve(var1_1, this.mURL);
                            continue;
                        }
                        catch (NoConnectException var8_17) {
                            if (System.currentTimeMillis() <= var6_15) continue;
                            throw var8_17;
                        }
                    }
                }
                catch (Throwable var9_18) {
                    var10_9 = null;
                    throw var9_18;
                }
lbl29:
                // 1 sources

                var10_8 = null;
                {
                }
            }
            if (null != var3_5) {
                var4_11 = (XPropertySet)UnoRuntime.queryInterface((Class)(LocalOfficeConnection.class$com$sun$star$beans$XPropertySet == null ? (LocalOfficeConnection.class$com$sun$star$beans$XPropertySet = LocalOfficeConnection.class$("com.sun.star.beans.XPropertySet")) : LocalOfficeConnection.class$com$sun$star$beans$XPropertySet), (Object)var3_5);
                var5_13 = var4_11.getPropertyValue("DefaultContext");
                var6_16 = (XComponentContext)UnoRuntime.queryInterface((Class)(LocalOfficeConnection.class$com$sun$star$uno$XComponentContext == null ? (LocalOfficeConnection.class$com$sun$star$uno$XComponentContext = LocalOfficeConnection.class$("com.sun.star.uno.XComponentContext")) : LocalOfficeConnection.class$com$sun$star$uno$XComponentContext), (Object)var5_13);
                return var6_16;
            }
        }
        catch (NoConnectException var1_2) {
            System.out.println("Couldn't connect to remote server");
            System.out.println(var1_2.getMessage());
        }
        catch (ConnectionSetupException var2_4) {
            System.out.println("Couldn't access necessary local resource to establish the interprocess connection");
            System.out.println(var2_4.getMessage());
        }
        catch (IllegalArgumentException var3_6) {
            System.out.println("uno-url is syntactical illegal ( " + this.mURL + " )");
            System.out.println(var3_6.getMessage());
        }
        catch (com.sun.star.uno.RuntimeException var4_12) {
            System.out.println("--- RuntimeException:");
            System.out.println(var4_12.getMessage());
            var4_12.printStackTrace();
            System.out.println("--- end.");
            throw var4_12;
        }
        catch (Exception var5_14) {
            System.out.println("java.lang.Exception: ");
            System.out.println(var5_14);
            var5_14.printStackTrace();
            System.out.println("--- end.");
            throw new com.sun.star.uno.RuntimeException(var5_14.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resolve(XComponentContext xComponentContext, String string) throws NoConnectException, ConnectionSetupException, IllegalArgumentException {
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string.indexOf(59) == -1) {
            string3 = string;
            string4 = "iiop";
            string5 = "classic_uno";
        } else {
            int n = string.indexOf(58);
            string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            n = string.indexOf(59);
            string3 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            n = string.indexOf(59);
            string4 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            string5 = string.trim().trim();
        }
        Object object = null;
        string2 = null;
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        try {
            string2 = (XBridgeFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$bridge$XBridgeFactory == null ? (class$com$sun$star$bridge$XBridgeFactory = LocalOfficeConnection.class$("com.sun.star.bridge.XBridgeFactory")) : class$com$sun$star$bridge$XBridgeFactory), (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", xComponentContext));
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new com.sun.star.uno.RuntimeException(exception.getMessage());
        }
        LocalOfficeConnection localOfficeConnection = this;
        synchronized (localOfficeConnection) {
            if (this.mBridge == null) {
                Object object2 = null;
                try {
                    object2 = xMultiComponentFactory.createInstanceWithContext("com.sun.star.connection.Connector", xComponentContext);
                }
                catch (com.sun.star.uno.Exception exception) {
                    throw new com.sun.star.uno.RuntimeException(exception.getMessage());
                }
                XConnector xConnector = (XConnector)UnoRuntime.queryInterface((Class)(class$com$sun$star$connection$XConnector == null ? (class$com$sun$star$connection$XConnector = LocalOfficeConnection.class$("com.sun.star.connection.XConnector")) : class$com$sun$star$connection$XConnector), (Object)object2);
                XConnection xConnection = xConnector.connect(string3);
                String string6 = "OOoBean_private_bridge_" + String.valueOf(m_nBridgeCounter++);
                try {
                    this.mBridge = string2.createBridge(string6, string4, xConnection, null);
                }
                catch (BridgeExistsException bridgeExistsException) {
                    throw new com.sun.star.uno.RuntimeException(bridgeExistsException.getMessage());
                }
            }
            object = this.mBridge.getInstance(string5);
            return object;
        }
    }

    private static String getProgramPath() {
        if (mProgramPath == null) {
            File file;
            String string = OFFICE_APP_NAME;
            String string2 = System.getProperty("os.name");
            if (string2.startsWith("Windows")) {
                string = "soffice.exe";
            }
            if ((file = NativeLibraryLoader.getResource((ClassLoader)(class$com$sun$star$comp$beans$LocalOfficeConnection == null ? (class$com$sun$star$comp$beans$LocalOfficeConnection = LocalOfficeConnection.class$("com.sun.star.comp.beans.LocalOfficeConnection")) : class$com$sun$star$comp$beans$LocalOfficeConnection).getClassLoader(), (String)string)) != null) {
                mProgramPath = file.getParent();
            }
            if (mProgramPath == null) {
                mProgramPath = "";
            }
        }
        return mProgramPath;
    }

    private void parseUnoUrlWithOfficePath(String string, String string2) throws MalformedURLException {
        int n = string.indexOf(";urp;StarOffice.NamingService");
        if (n < 0) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        String string3 = string.substring(string2.length(), n + 1);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        while (n < string3.length()) {
            char c = string3.charAt(n);
            block0 : switch (n2) {
                case 0: {
                    switch (c) {
                        case ',': {
                            stringBuffer.delete(0, stringBuffer.length());
                            n2 = 1;
                            break block0;
                        }
                        case ';': {
                            n2 = 7;
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case ' ': 
                        case '=': {
                            string4 = stringBuffer.toString();
                            n2 = c == ' ' ? 2 : 3;
                            break block0;
                        }
                        case ',': 
                        case ';': {
                            n2 = -6;
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case '=': {
                            n2 = 3;
                            break block0;
                        }
                        case ' ': {
                            break block0;
                        }
                    }
                    n2 = -1;
                    break;
                }
                case 3: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 4;
                    break;
                }
                case 4: {
                    switch (c) {
                        case ' ': 
                        case ',': 
                        case ';': {
                            --n;
                            n2 = 5;
                            if (string4.equals("path")) {
                                if (string5 == null) {
                                    string5 = stringBuffer.toString();
                                } else {
                                    n2 = -3;
                                }
                            } else if (string4.equals("pipe")) {
                                if (string6 == null) {
                                    string6 = stringBuffer.toString();
                                } else {
                                    n2 = -4;
                                }
                            } else {
                                n2 = -2;
                            }
                            stringBuffer.delete(0, stringBuffer.length());
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 5: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                        case ',': {
                            n2 = 6;
                            break block0;
                        }
                        case ';': {
                            n2 = 7;
                            break block0;
                        }
                    }
                    n2 = -5;
                    break;
                }
                case 6: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    break;
                }
                default: {
                    throw new MalformedURLException("Invalid UNO connection URL.");
                }
            }
            ++n;
        }
        if (n2 != 7) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        if (string5 != null) {
            mProgramPath = string5;
        }
        if (string6 != null) {
            this.mPipe = string6;
        }
    }

    private static String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = string2.length();
        while ((n = string.lastIndexOf(string2, n - 1)) > -1) {
            stringBuffer.replace(n, n + n2, string3);
        }
        return stringBuffer.toString();
    }

    static String getPipeName() {
        String string = System.getProperty("user.name") + OFFICE_ID_SUFFIX;
        string = LocalOfficeConnection.replaceAll(string, "_", "%B7");
        return LocalOfficeConnection.replaceAll(LocalOfficeConnection.replaceAll(URLEncoder.encode(string), "\\+", "%20"), "%", "_");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_nBridgeCounter = 0L;
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)(class$com$sun$star$comp$beans$LocalOfficeConnection == null ? (class$com$sun$star$comp$beans$LocalOfficeConnection = LocalOfficeConnection.class$("com.sun.star.comp.beans.LocalOfficeConnection")) : class$com$sun$star$comp$beans$LocalOfficeConnection).getClassLoader(), (String)"msvcr70");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find msvcr70");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)(class$com$sun$star$comp$beans$LocalOfficeConnection == null ? (class$com$sun$star$comp$beans$LocalOfficeConnection = LocalOfficeConnection.class$("com.sun.star.comp.beans.LocalOfficeConnection")) : class$com$sun$star$comp$beans$LocalOfficeConnection).getClassLoader(), (String)"msvcr71");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find msvcr71");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)(class$com$sun$star$comp$beans$LocalOfficeConnection == null ? (class$com$sun$star$comp$beans$LocalOfficeConnection = LocalOfficeConnection.class$("com.sun.star.comp.beans.LocalOfficeConnection")) : class$com$sun$star$comp$beans$LocalOfficeConnection).getClassLoader(), (String)"uwinapi");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find uwinapi");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)(class$com$sun$star$comp$beans$LocalOfficeConnection == null ? (class$com$sun$star$comp$beans$LocalOfficeConnection = LocalOfficeConnection.class$("com.sun.star.comp.beans.LocalOfficeConnection")) : class$com$sun$star$comp$beans$LocalOfficeConnection).getClassLoader(), (String)"jawt");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find jawt");
            }
        }
        NativeLibraryLoader.loadLibrary((ClassLoader)(class$com$sun$star$comp$beans$LocalOfficeConnection == null ? (class$com$sun$star$comp$beans$LocalOfficeConnection = LocalOfficeConnection.class$("com.sun.star.comp.beans.LocalOfficeConnection")) : class$com$sun$star$comp$beans$LocalOfficeConnection).getClassLoader(), (String)OFFICE_LIB_NAME);
    }

    class StreamProcessor
    extends Thread {
        InputStream m_in;
        PrintStream m_print;

        public StreamProcessor(InputStream inputStream, PrintStream printStream) {
            this.m_in = inputStream;
            this.m_print = printStream;
            this.start();
        }

        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_in));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    this.m_print.println(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    private class OfficeService
    implements NativeService {
        private OfficeService() {
        }

        public String getIdentifier() {
            if (LocalOfficeConnection.this.mPipe == null) {
                return LocalOfficeConnection.getPipeName();
            }
            return LocalOfficeConnection.this.mPipe;
        }

        public void startupService() throws IOException {
            int n = 4;
            String string = null;
            try {
                string = System.getProperty("com.sun.star.officebean.Options");
                if (string != null) {
                    ++n;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            String[] stringArray = new String[n];
            stringArray[0] = new File(LocalOfficeConnection.getProgramPath(), LocalOfficeConnection.OFFICE_APP_NAME).getPath();
            stringArray[1] = "-nologo";
            stringArray[2] = "-nodefault";
            if (LocalOfficeConnection.this.mConnType.equals("pipe")) {
                stringArray[3] = "-accept=pipe,name=" + this.getIdentifier() + ";" + LocalOfficeConnection.this.mProtocol + ";" + LocalOfficeConnection.this.mInitialObject;
            } else if (LocalOfficeConnection.this.mConnType.equals("socket")) {
                stringArray[3] = "-accept=socket,port=" + LocalOfficeConnection.this.mPort + ";urp";
            } else {
                throw new IOException("not connection specified");
            }
            if (string != null) {
                stringArray[4] = string;
            }
            LocalOfficeConnection.this.mProcess = Runtime.getRuntime().exec(stringArray);
            if (LocalOfficeConnection.this.mProcess == null) {
                throw new RuntimeException("cannot start soffice: " + stringArray);
            }
            new StreamProcessor(LocalOfficeConnection.this.mProcess.getInputStream(), System.out);
            new StreamProcessor(LocalOfficeConnection.this.mProcess.getErrorStream(), System.err);
        }

        public int getStartupTime() {
            return 60;
        }
    }
}

