/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleExtendedComponent;
import com.sun.star.accessibility.XAccessibleKeyBinding;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleKeyBinding;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;

public abstract class Component
extends java.awt.Component {
    public static final Type RectangleType = new Type(class$com$sun$star$awt$Rectangle == null ? (class$com$sun$star$awt$Rectangle = Component.class$("com.sun.star.awt.Rectangle")) : class$com$sun$star$awt$Rectangle);
    public static final Type SelectionType = new Type(class$com$sun$star$awt$Selection == null ? (class$com$sun$star$awt$Selection = Component.class$("com.sun.star.awt.Selection")) : class$com$sun$star$awt$Selection);
    protected XAccessible unoAccessible;
    protected XAccessibleContext unoAccessibleContext;
    protected XAccessibleComponent unoAccessibleComponent;
    protected boolean disposed = false;
    protected AccessibleContext accessibleContext = null;
    static /* synthetic */ Class class$com$sun$star$awt$Rectangle;
    static /* synthetic */ Class class$com$sun$star$awt$Selection;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleEventBroadcaster;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleExtendedComponent;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleAction;

    protected Component(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        this.unoAccessible = xAccessible;
        this.unoAccessibleContext = xAccessibleContext;
        this.unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = Component.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent), (Object)xAccessibleContext);
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleEventBroadcaster == null ? (class$com$sun$star$accessibility$XAccessibleEventBroadcaster = Component.class$("com.sun.star.accessibility.XAccessibleEventBroadcaster")) : class$com$sun$star$accessibility$XAccessibleEventBroadcaster), (Object)this.unoAccessibleComponent);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener(this.createEventListener());
        }
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public void requestFocus() {
    }

    public boolean requestFocus(boolean bl) {
        return true;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    protected boolean requestFocusInWindow(boolean bl) {
        if (this.isFocusable() && this.isVisible()) {
            this.getEventQueue().postEvent(new FocusEvent(this, 1004, bl));
            return true;
        }
        return false;
    }

    public Object[] getAccessibleComponents(Object[] objectArray) {
        try {
            ArrayList<java.awt.Component> arrayList = new ArrayList<java.awt.Component>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                java.awt.Component component = AccessibleObjectFactory.getAccessibleComponent((XAccessible)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessible == null ? Component.class$("com.sun.star.accessibility.XAccessible") : class$com$sun$star$accessibility$XAccessible), (Object)objectArray[n]));
                if (component != null) {
                    arrayList.add(component);
                }
                ++n;
            }
            arrayList.trimToSize();
            return arrayList.toArray();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    protected EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getEventQueue();
        EventQueue.invokeLater(new PropertyChangeBroadcaster(string, object, object2));
    }

    protected void fireStatePropertyChange(AccessibleState accessibleState, boolean bl) {
        PropertyChangeBroadcaster propertyChangeBroadcaster = bl ? new PropertyChangeBroadcaster("AccessibleState", null, accessibleState) : new PropertyChangeBroadcaster("AccessibleState", accessibleState, null);
        this.getEventQueue();
        EventQueue.invokeLater(propertyChangeBroadcaster);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleUNOComponentListener();
    }

    protected AccessibleContext createAccessibleContext() {
        return null;
    }

    public final AccessibleContext getAccessibleContext() {
        block3: {
            if (this.accessibleContext != null) break block3;
            try {
                AccessibleContext accessibleContext = this.createAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(this.unoAccessibleContext.getAccessibleName());
                    accessibleContext.setAccessibleDescription(this.unoAccessibleContext.getAccessibleDescription());
                    this.accessibleContext = accessibleContext;
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        return this.accessibleContext;
    }

    public static Number toNumber(Object object) {
        try {
            if (AnyConverter.isByte((Object)object)) {
                return new Byte(AnyConverter.toByte((Object)object));
            }
            if (AnyConverter.isShort((Object)object)) {
                return new Short(AnyConverter.toShort((Object)object));
            }
            if (AnyConverter.isInt((Object)object)) {
                return new Integer(AnyConverter.toInt((Object)object));
            }
            if (AnyConverter.isLong((Object)object)) {
                return new Long(AnyConverter.toLong((Object)object));
            }
            if (AnyConverter.isFloat((Object)object)) {
                return new Float(AnyConverter.toFloat((Object)object));
            }
            if (AnyConverter.isDouble((Object)object)) {
                return new Double(AnyConverter.toDouble((Object)object));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new java.lang.IllegalArgumentException(illegalArgumentException.getMessage());
        }
        return null;
    }

    public String toString() {
        return UnoRuntime.generateOid((Object)this.unoAccessible);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected abstract class AccessibleUNOComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleExtendedComponent {
        protected ComponentListener accessibleComponentHandler = null;
        protected FocusListener accessibleFocusHandler = null;
        protected int propertyChangeListenerCount = 0;

        protected AccessibleUNOComponent() {
            super(Component.this);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Component.this.addComponentListener(this.accessibleComponentHandler);
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                Component.this.addFocusListener(this.accessibleFocusHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                Component.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Component.this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            if (Component.this.disposed) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
            try {
                return AccessibleStateAdapter.getAccessibleStateSet(Component.this, Component.this.unoAccessibleContext.getAccessibleStateSet());
            }
            catch (RuntimeException runtimeException) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
        }

        public java.util.Locale getLocale() throws IllegalComponentStateException {
            try {
                Locale locale = Component.this.unoAccessible.getAccessibleContext().getLocale();
                return new java.util.Locale(locale.Language, locale.Country);
            }
            catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                return java.util.Locale.getDefault();
            }
        }

        public Color getBackground() {
            try {
                return new Color(Component.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            try {
                return new Color(Component.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return Component.this.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return Component.this.isShowing();
        }

        public boolean contains(java.awt.Point point) {
            try {
                return Component.this.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = Component.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point point = Component.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setLocation(java.awt.Point point) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = Component.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle rectangle) {
        }

        public Dimension getSize() {
            try {
                Size size = Component.this.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return Component.this.isFocusable();
        }

        public void requestFocus() {
            Component.this.unoAccessibleComponent.grabFocus();
        }

        public String getToolTipText() {
            try {
                XAccessibleExtendedComponent xAccessibleExtendedComponent = (XAccessibleExtendedComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleExtendedComponent == null ? (class$com$sun$star$accessibility$XAccessibleExtendedComponent = Component.class$("com.sun.star.accessibility.XAccessibleExtendedComponent")) : class$com$sun$star$accessibility$XAccessibleExtendedComponent), (Object)Component.this.unoAccessibleComponent);
                if (xAccessibleExtendedComponent != null) {
                    return xAccessibleExtendedComponent.getToolTipText();
                }
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        public String getTitledBorderText() {
            try {
                XAccessibleExtendedComponent xAccessibleExtendedComponent = (XAccessibleExtendedComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleExtendedComponent == null ? (class$com$sun$star$accessibility$XAccessibleExtendedComponent = Component.class$("com.sun.star.accessibility.XAccessibleExtendedComponent")) : class$com$sun$star$accessibility$XAccessibleExtendedComponent), (Object)Component.this.unoAccessibleComponent);
                if (xAccessibleExtendedComponent != null) {
                    return xAccessibleExtendedComponent.getTitledBorderText();
                }
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        public javax.accessibility.AccessibleKeyBinding getAccessibleKeyBinding() {
            try {
                XAccessibleKeyBinding xAccessibleKeyBinding;
                XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleAction == null ? (class$com$sun$star$accessibility$XAccessibleAction = Component.class$("com.sun.star.accessibility.XAccessibleAction")) : class$com$sun$star$accessibility$XAccessibleAction), (Object)Component.this.unoAccessibleComponent);
                if (xAccessibleAction != null && (xAccessibleKeyBinding = xAccessibleAction.getAccessibleActionKeyBinding(0)) != null) {
                    return new AccessibleKeyBinding(xAccessibleKeyBinding);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent focusEvent) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }

    protected class AccessibleUNOComponentListener
    implements XAccessibleEventListener {
        protected AccessibleUNOComponentListener() {
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 1: {
                    break;
                }
                case 2: {
                    Component.this.fireStatePropertyChange(AccessibleState.ARMED, bl);
                    break;
                }
                case 4: {
                    Component.this.fireStatePropertyChange(AccessibleState.CHECKED, bl);
                    break;
                }
                case 7: {
                    Component.this.setEnabled(bl);
                    Component.this.fireStatePropertyChange(AccessibleState.ENABLED, bl);
                    break;
                }
                case 11: {
                    Component.this.getEventQueue().postEvent(new FocusEvent(Component.this, bl ? 1004 : 1005));
                    break;
                }
                case 20: {
                    Component.this.fireStatePropertyChange(AccessibleState.PRESSED, bl);
                    break;
                }
                case 23: {
                    Component.this.fireStatePropertyChange(AccessibleState.SELECTED, bl);
                    break;
                }
                case 25: {
                    break;
                }
                case 30: {
                    Component.this.setVisible(bl);
                    break;
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.setAccessibleName(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            if (!Component.this.disposed) {
                switch (accessibleEventObject.EventId) {
                    case 3: {
                        AccessibleContext cfr_ignored_0 = Component.this.accessibleContext;
                        Component.this.firePropertyChange("accessibleActionProperty", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                        break;
                    }
                    case 1: {
                        this.handleNameChangedEvent(accessibleEventObject.NewValue);
                        break;
                    }
                    case 2: {
                        this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 4: {
                        this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                        break;
                    }
                    case 6: 
                    case 10: {
                        Component.this.firePropertyChange("AccessibleVisibleData", null, null);
                        break;
                    }
                    case 22: {
                        Component.this.firePropertyChange("AccessibleText", AccessibleTextImpl.convertTextSegment(accessibleEventObject.OldValue), AccessibleTextImpl.convertTextSegment(accessibleEventObject.NewValue));
                        break;
                    }
                    case 20: {
                        AccessibleContext cfr_ignored_1 = Component.this.accessibleContext;
                        Component.this.firePropertyChange("AccessibleCaret", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                        break;
                    }
                    case 11: {
                        AccessibleContext cfr_ignored_2 = Component.this.accessibleContext;
                        Component.this.firePropertyChange("AccessibleValue", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                    }
                }
            }
        }

        public void disposing(EventObject eventObject) {
            Component.this.disposed = true;
            AccessibleObjectFactory.disposing(Component.this);
        }
    }

    protected class PropertyChangeBroadcaster
    implements Runnable {
        String propertyName;
        Object oldValue;
        Object newValue;

        public PropertyChangeBroadcaster(String string, Object object, Object object2) {
            this.propertyName = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        public void run() {
            try {
                AccessibleContext accessibleContext = Component.this.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.firePropertyChange(this.propertyName, this.oldValue, this.newValue);
                }
            }
            catch (Exception exception) {}
        }
    }
}

