/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String filename;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.cache = dataFileCache;
        this.scale = dataFileCache.cacheFileScale;
        this.filename = string;
    }

    void process() throws HsqlException, IOException {
        boolean bl = false;
        Trace.printSystemOut("Defrag Transfer begins");
        this.transactionRowLookup = this.database.txManager.getTransactionIDList();
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
        this.rootsList = new int[hsqlArrayList.size()][];
        Storage storage = null;
        try {
            OutputStream outputStream = this.database.getFileAccess().openOutputStreamElement(this.filename + ".new");
            this.fileStreamOut = new BufferedOutputStream(outputStream, 4096);
            int n = 0;
            while (n < 32) {
                this.fileStreamOut.write(0);
                ++n;
            }
            this.fileOffset = 32L;
            int n2 = 0;
            int n3 = hsqlArrayList.size();
            while (n2 < n3) {
                Table table = (Table)hsqlArrayList.get(n2);
                if (table.getTableType() == 4) {
                    int[] nArray = this.writeTableToDataFile(table);
                    this.rootsList[n2] = nArray;
                } else {
                    this.rootsList[n2] = null;
                }
                Trace.printSystemOut(table.getName().name + " complete");
                ++n2;
            }
            this.writeTransactionRows();
            this.fileStreamOut.close();
            this.fileStreamOut = null;
            storage = ScaledRAFile.newScaledRAFile(this.filename + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
            storage.seek(12L);
            storage.writeLong(this.fileOffset);
            storage.close();
            storage = null;
            int n4 = 0;
            int n5 = this.rootsList.length;
            while (n4 < n5) {
                int[] nArray = this.rootsList[n4];
                if (nArray != null) {
                    Trace.printSystemOut(StringUtil.getList(nArray, ",", ""));
                }
                ++n4;
            }
            bl = true;
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.filename + ".new");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw Trace.error(72);
        }
        finally {
            if (this.fileStreamOut != null) {
                this.fileStreamOut.close();
            }
            if (storage != null) {
                storage.close();
            }
            if (!bl) {
                this.database.getFileAccess().removeElement(this.filename + ".new");
            }
        }
    }

    void updateTableIndexRoots() throws HsqlException {
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
        int n = 0;
        int n2 = hsqlArrayList.size();
        while (n < n2) {
            Table table = (Table)hsqlArrayList.get(n);
            if (table.getTableType() == 4) {
                int[] nArray = this.rootsList[n];
                table.setIndexRoots(nArray);
            }
            ++n;
        }
    }

    void updateTransactionRowIDs() throws HsqlException {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        Row row;
        RowOutputBinary rowOutputBinary = new RowOutputBinary();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(), false);
        int[] nArray = table.getIndexRootsArray();
        long l = this.fileOffset;
        int n = 0;
        doubleIntIndex.setKeysSearchTarget();
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator rowIterator = table.rowIterator(null);
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            doubleIntIndex.addUnsorted(row.getPos(), (int)(l / (long)this.scale));
            if (n % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n + " " + row.getPos() + " " + l);
            }
            l += (long)row.getStorageSize();
            ++n;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n = 0;
        rowIterator = table.rowIterator(null);
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            rowOutputBinary.reset();
            row.write(rowOutputBinary, doubleIntIndex);
            this.fileStreamOut.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.size());
            this.fileOffset += (long)row.getStorageSize();
            if (n % 50000 == 0) {
                Trace.printSystemOut(n + " rows " + this.stopw.elapsedTime());
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != -1) {
                int n3 = doubleIntIndex.findFirstEqualKeyIndex(nArray[n2]);
                if (n3 == -1) {
                    throw Trace.error(129);
                }
                nArray[n2] = doubleIntIndex.getValue(n3);
            }
            ++n2;
        }
        this.setTransactionRowLookups(doubleIntIndex);
        Trace.printSystemOut(table.getName().name + " : table converted");
        return nArray;
    }

    void setTransactionRowLookups(DoubleIntIndex doubleIntIndex) {
        int n = 0;
        int n2 = this.transactionRowLookup.size();
        while (n < n2) {
            int n3 = this.transactionRowLookup.getKey(n);
            int n4 = doubleIntIndex.findFirstEqualKeyIndex(n3);
            if (n4 != -1) {
                this.transactionRowLookup.setValue(n, doubleIntIndex.getValue(n4));
            }
            ++n;
        }
    }

    void writeTransactionRows() {
        int n = 0;
        int n2 = this.transactionRowLookup.size();
        while (n < n2) {
            if (this.transactionRowLookup.getValue(n) == 0) {
                int n3 = this.transactionRowLookup.getKey(n);
                try {
                    this.transactionRowLookup.setValue(n, (int)(this.fileOffset / (long)this.scale));
                    RowInputInterface rowInputInterface = this.cache.readObject(n3);
                    this.fileStreamOut.write(rowInputInterface.getBuffer(), 0, rowInputInterface.getSize());
                    this.fileOffset += (long)rowInputInterface.getSize();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }
}

