/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.ZipUnzipFile;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

public class DataFileCache {
    private FileAccess fa;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int FLAGS_POS = 28;
    static final int INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    private static final int FREE_BLOCKS_COUNT = 512;
    protected String fileName;
    protected String backupFileName;
    protected Database database;
    protected boolean fileModified;
    protected int cacheFileScale;
    protected boolean cacheReadonly;
    protected boolean storeOnInsert;
    protected int cachedRowPadding = 8;
    protected boolean hasRowInfo = false;
    protected RowInputInterface rowIn;
    protected RowOutputInterface rowOut;
    public long maxDataFileSize;
    protected Storage dataFile;
    protected long fileFreePosition;
    protected int maxCacheSize;
    protected long maxCacheBytes;
    protected Cache cache;

    public DataFileCache(Database database, String string, String string2) throws HsqlException {
        this.fileName = string;
        this.backupFileName = string2;
        this.database = database;
        this.fa = this.database.getFileAccess();
        this.initParams();
        this.cache = new Cache(this);
    }

    protected void initParams() throws HsqlException {
        int n = this.database.getProperties().getIntegerProperty("hsqldb.cache_scale", 14, 8, 18);
        int n2 = this.database.getProperties().getIntegerProperty("hsqldb.cache_size_scale", 10, 6, 20);
        this.cacheFileScale = this.database.getProperties().getIntegerProperty("hsqldb.cache_file_scale", 1);
        Trace.printSystemOut("cache_scale: " + n);
        Trace.printSystemOut("cache_size_scale: " + n2);
        this.cacheReadonly = this.database.isFilesReadOnly();
        int n3 = 1 << n;
        int n4 = 1 << n2;
        this.maxCacheSize = n3 * 3;
        this.maxCacheBytes = this.maxCacheSize * n4;
        this.maxDataFileSize = this.cacheFileScale == 1 ? Integer.MAX_VALUE : 0x3FFFFFFF8L;
        this.dataFile = null;
    }

    public void open(boolean bl) throws HsqlException {
        this.fileFreePosition = 0L;
        try {
            boolean bl2;
            int n;
            Object object;
            boolean bl3 = this.database.isFilesInJar();
            long l = 0L;
            if (!bl3 && this.fa.isStreamElement(this.fileName)) {
                if (this.database.isStoredFileAccess()) {
                    bl3 = true;
                } else {
                    object = new File(this.fileName);
                    boolean bl4 = bl3 = ((File)object).length() > 32L;
                }
            }
            if (bl3) {
                object = this.database.getProperties().getProperty("hsqldb.cache_version");
                n = "1.7.0".equals(object);
                boolean bl5 = "1.8.0".equals(object);
                if (n == 0) {
                    throw Trace.error(30);
                }
            }
            int n2 = n = (bl2 = this.database.getProperties().isPropertyTrue("hsqldb.nio_data_file")) ? 1 : 0;
            if (this.database.isFilesInJar()) {
                n = 2;
            }
            String string = this.database.getURLProperties().getProperty("storage_class_name");
            String string2 = this.database.getURLProperties().getProperty("storage_key");
            this.dataFile = ScaledRAFile.newScaledRAFile(this.fileName, bl, n, string, string2);
            if (bl3) {
                this.dataFile.seek(28L);
                int n3 = this.dataFile.readInt();
                this.hasRowInfo = BitMap.isSet(n3, 3);
                this.dataFile.seek(4L);
                l = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                if (this.fileFreePosition < 32L) {
                    this.fileFreePosition = 32L;
                }
            } else {
                this.fileFreePosition = 32L;
            }
            this.initBuffers();
            this.fileModified = false;
            this.freeBlocks = new DataFileBlockManager(512, this.cacheFileScale, l);
        }
        catch (Throwable throwable) {
            this.database.logger.appLog.logContext(throwable);
            this.close(false);
            throw Trace.error(29, 210, new Object[]{throwable, this.fileName});
        }
    }

    public void close(boolean bl) throws HsqlException {
        try {
            int n;
            if (this.cacheReadonly) {
                if (this.dataFile != null) {
                    this.dataFile.close();
                }
                return;
            }
            StopWatch stopWatch = new StopWatch();
            if (bl) {
                this.cache.saveAll();
                Trace.printSystemOut("saveAll: " + stopWatch.elapsedTime());
                this.dataFile.seek(4L);
                this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                this.dataFile.seek(12L);
                this.dataFile.writeLong(this.fileFreePosition);
                this.dataFile.seek(28L);
                n = BitMap.set(0, 2);
                if (this.hasRowInfo) {
                    n = BitMap.set(n, 3);
                }
                this.dataFile.writeInt(n);
                this.dataFile.seek(this.fileFreePosition);
                Trace.printSystemOut("pos and flags: " + stopWatch.elapsedTime());
            }
            if (this.dataFile != null) {
                this.dataFile.close();
                this.dataFile = null;
                Trace.printSystemOut("close: " + stopWatch.elapsedTime());
            }
            int n2 = n = this.fileFreePosition == 32L ? 1 : 0;
            if (n != 0) {
                this.fa.removeElement(this.fileName);
                this.fa.removeElement(this.backupFileName);
            }
        }
        catch (Throwable throwable) {
            this.database.logger.appLog.logContext(throwable);
            throw Trace.error(29, 211, new Object[]{throwable, this.fileName});
        }
    }

    void postClose(boolean bl) throws HsqlException {
        if (this.cacheReadonly) {
            return;
        }
        try {
            if (bl) {
                this.database.getProperties().setProperty("hsqldb.cache_version", "1.7.0");
                this.database.getProperties().save();
                if (this.fileModified) {
                    this.backup();
                }
            } else {
                this.fa.removeElement(this.backupFileName);
                DataFileCache.deleteOrResetFreePos(this.database, this.fileName);
            }
        }
        catch (IOException iOException) {
            throw new HsqlException(iOException, Trace.getMessage(98), 98);
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null || ((RowOutputBinary)this.rowOut).getBuffer().length > 256) {
            this.rowOut = new RowOutputBinary(256);
        }
        if (this.rowIn == null || ((RowInputBinary)this.rowIn).getBuffer().length > 256) {
            this.rowIn = new RowInputBinary(new byte[256]);
        }
    }

    public void defrag() throws HsqlException {
        if (this.cacheReadonly) {
            return;
        }
        if (this.fileFreePosition == 32L) {
            return;
        }
        try {
            this.cache.saveAll();
            boolean bl = this.dataFile.wasNio();
            DataFileDefrag dataFileDefrag = new DataFileDefrag(this.database, this, this.fileName);
            dataFileDefrag.process();
            this.close(false);
            Trace.printSystemOut("closed old cache");
            this.fa.removeElement(this.fileName);
            if (bl) {
                System.gc();
                if (this.fa.isStreamElement(this.fileName)) {
                    this.fa.removeElement(this.fileName);
                    if (this.fa.isStreamElement(this.fileName)) {
                        this.fa.renameElement(this.fileName, this.fileName + ".old");
                        File file = new File(this.fileName + ".old");
                        FileUtil.deleteOnExit(file);
                    }
                }
            }
            this.fa.renameElement(this.fileName + ".new", this.fileName);
            this.backup();
            this.database.getProperties().setProperty("hsqldb.cache_version", "1.7.0");
            this.database.getProperties().save();
            this.initParams();
            this.cache.clear();
            this.cache = new Cache(this);
            this.open(this.cacheReadonly);
            dataFileDefrag.updateTableIndexRoots();
            dataFileDefrag.updateTransactionRowIDs();
            Trace.printSystemOut("opened cache");
        }
        catch (Throwable throwable) {
            this.database.logger.appLog.logContext(throwable);
            throw new HsqlException(throwable, Trace.getMessage(98), 98);
        }
    }

    public synchronized void remove(int n, PersistentStore persistentStore) throws IOException {
        CachedObject cachedObject = this.release(n);
        int n2 = cachedObject == null ? this.getStorageSize(n) : cachedObject.getStorageSize();
        this.freeBlocks.add(n, n2);
    }

    public synchronized void removePersistence(int n, PersistentStore persistentStore) throws IOException {
    }

    private int setFilePos(CachedObject cachedObject) throws IOException {
        int n;
        int n2 = cachedObject.getStorageSize();
        int n3 = n = this.freeBlocks == null ? -1 : this.freeBlocks.get(n2);
        if (n == -1) {
            n = (int)(this.fileFreePosition / (long)this.cacheFileScale);
            long l = this.fileFreePosition + (long)n2;
            if (l > this.maxDataFileSize) {
                throw new IOException(Trace.getMessage(225));
            }
            this.fileFreePosition = l;
        }
        cachedObject.setPos(n);
        return n;
    }

    public synchronized void add(CachedObject cachedObject) throws IOException {
        int n = cachedObject.getRealSize(this.rowOut);
        n = (n + this.cachedRowPadding - 1) / this.cachedRowPadding * this.cachedRowPadding;
        cachedObject.setStorageSize(n);
        int n2 = this.setFilePos(cachedObject);
        this.cache.put(n2, cachedObject);
        if (this.storeOnInsert) {
            this.saveRow(cachedObject);
        }
    }

    public synchronized void restore(CachedObject cachedObject) throws IOException {
        int n = cachedObject.getPos();
        this.cache.put(n, cachedObject);
        if (this.storeOnInsert) {
            this.saveRow(cachedObject);
        }
    }

    public synchronized int getStorageSize(int n) throws IOException {
        CachedObject cachedObject = this.cache.get(n);
        if (cachedObject != null) {
            return cachedObject.getStorageSize();
        }
        return this.readSize(n);
    }

    public synchronized CachedObject get(int n, PersistentStore persistentStore, boolean bl) throws HsqlException {
        if (n < 0) {
            return null;
        }
        try {
            CachedObject cachedObject = this.cache.get(n);
            if (cachedObject == null) {
                RowInputInterface rowInputInterface = this.readObject(n);
                if (rowInputInterface == null) {
                    return null;
                }
                cachedObject = persistentStore.get(rowInputInterface);
                n = cachedObject.getPos();
                this.cache.put(n, cachedObject);
            }
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            return cachedObject;
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext("" + this.cache + " pos: " + n);
            this.database.logger.appLog.logContext(iOException);
            throw Trace.error(129, 209, new Object[]{iOException, this.fileName});
        }
    }

    synchronized RowInputInterface getRaw(int n) throws IOException {
        return this.readObject(n);
    }

    protected synchronized int readSize(int n) throws IOException {
        this.dataFile.seek((long)n * (long)this.cacheFileScale);
        return this.dataFile.readInt();
    }

    protected synchronized RowInputInterface readObject(int n) throws IOException {
        this.dataFile.seek((long)n * (long)this.cacheFileScale);
        int n2 = this.dataFile.readInt();
        this.rowIn.resetRow(n, n2);
        this.dataFile.read(this.rowIn.getBuffer(), 4, n2 - 4);
        return this.rowIn;
    }

    public synchronized CachedObject release(int n) {
        return this.cache.release(n);
    }

    protected synchronized void saveRows(CachedObject[] cachedObjectArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            CachedObject cachedObject = cachedObjectArray[n3];
            this.saveRow(cachedObject);
            cachedObjectArray[n3] = null;
            ++n3;
        }
        this.initBuffers();
    }

    public synchronized void saveRow(CachedObject cachedObject) throws IOException {
        this.setFileModified();
        this.rowOut.reset();
        cachedObject.write(this.rowOut);
        this.dataFile.seek((long)cachedObject.getPos() * (long)this.cacheFileScale);
        this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
    }

    public void backup() throws IOException {
        try {
            ZipUnzipFile.compressFile(this.fileName, this.backupFileName + ".new", this.database.getFileAccess());
            this.fa.renameElement(this.backupFileName + ".new", this.backupFileName);
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOrResetFreePos(Database database, String string) {
        ScaledRAFile scaledRAFile = null;
        try {
            database.getFileAccess().removeElement(string);
        }
        catch (IOException iOException) {
            database.logger.appLog.logContext(iOException);
        }
        if (database.isStoredFileAccess()) {
            return;
        }
        if (!database.getFileAccess().isStreamElement(string)) {
            return;
        }
        try {
            scaledRAFile = new ScaledRAFile(string, false);
            scaledRAFile.seek(12L);
            scaledRAFile.writeLong(32L);
        }
        catch (IOException iOException) {
            database.logger.appLog.logContext(iOException);
        }
        finally {
            if (scaledRAFile != null) {
                try {
                    scaledRAFile.close();
                }
                catch (IOException iOException) {
                    database.logger.appLog.logContext(iOException);
                }
            }
        }
    }

    public static int getFlags(String string) throws HsqlException {
        try {
            ScaledRAFile scaledRAFile = (ScaledRAFile)ScaledRAFile.newScaledRAFile(string, true, 0, null, null);
            scaledRAFile.seek(28L);
            int n = scaledRAFile.readInt();
            scaledRAFile.close();
            return n;
        }
        catch (IOException iOException) {
            throw Trace.error(129);
        }
    }

    public int capacity() {
        return this.maxCacheSize;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    protected synchronized void setFileModified() throws IOException {
        if (!this.fileModified) {
            this.dataFile.seek(28L);
            int n = BitMap.set(0, 2);
            if (this.hasRowInfo) {
                n = BitMap.set(n, 3);
            }
            this.dataFile.writeInt(n);
            this.fileModified = true;
        }
    }
}

