/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcPreparedStatement;
import org.hsqldb.lib.IntValueHashMap;

public class jdbcCallableStatement
extends jdbcPreparedStatement
implements CallableStatement {
    private IntValueHashMap parameterNameMap = new IntValueHashMap();

    public jdbcCallableStatement(jdbcConnection jdbcConnection2, String string, int n) throws HsqlException, SQLException {
        super(jdbcConnection2, string, n);
        if (this.pmdDescriptor != null && this.pmdDescriptor.metaData != null) {
            String[] stringArray = this.pmdDescriptor.metaData.colNames;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                if (string2 != null && string2.length() != 0) {
                    this.parameterNameMap.put(string2, n2);
                }
                ++n2;
            }
        }
    }

    int findParameterIndex(String string) throws SQLException {
        this.checkClosed();
        int n = this.parameterNameMap.get((Object)string, -1);
        if (n >= 0) {
            return n;
        }
        throw Util.sqlException(28, string);
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    private void checkGetParameterIndex(int n) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.parameterModes.length) {
            String string = "Parameter index out of bounds: " + n;
            throw Util.sqlException(62, string);
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        throw Util.notSupported;
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public boolean wasNull() throws SQLException {
        throw Util.notSupported;
    }

    public String getString(int n) throws SQLException {
        throw Util.notSupported;
    }

    public boolean getBoolean(int n) throws SQLException {
        throw Util.notSupported;
    }

    public byte getByte(int n) throws SQLException {
        throw Util.notSupported;
    }

    public short getShort(int n) throws SQLException {
        throw Util.notSupported;
    }

    public int getInt(int n) throws SQLException {
        throw Util.notSupported;
    }

    public long getLong(int n) throws SQLException {
        throw Util.notSupported;
    }

    public float getFloat(int n) throws SQLException {
        throw Util.notSupported;
    }

    public double getDouble(int n) throws SQLException {
        throw Util.notSupported;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw Util.notSupported;
    }

    public byte[] getBytes(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Date getDate(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Time getTime(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Object getObject(int n) throws SQLException {
        throw Util.notSupported;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw Util.notSupported;
    }

    public Ref getRef(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Blob getBlob(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Clob getClob(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Array getArray(int n) throws SQLException {
        throw Util.notSupported;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw Util.notSupported;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw Util.notSupported;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw Util.notSupported;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    public URL getURL(int n) throws SQLException {
        throw Util.notSupported;
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.setURL(this.findParameterIndex(string), uRL);
    }

    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParameterIndex(string), n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParameterIndex(string), bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParameterIndex(string), by);
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParameterIndex(string), s);
    }

    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParameterIndex(string), n);
    }

    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParameterIndex(string), l);
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParameterIndex(string), f);
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParameterIndex(string), d);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParameterIndex(string), bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.findParameterIndex(string), string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParameterIndex(string), byArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParameterIndex(string), date);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParameterIndex(string), time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string), timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParameterIndex(string), inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParameterIndex(string), inputStream, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParameterIndex(string), object, n, n2);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParameterIndex(string), object, n);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParameterIndex(string), object);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParameterIndex(string), reader, n);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParameterIndex(string), date, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParameterIndex(string), time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string), timestamp, calendar);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParameterIndex(string), n, string2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findParameterIndex(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findParameterIndex(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findParameterIndex(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findParameterIndex(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findParameterIndex(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findParameterIndex(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findParameterIndex(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findParameterIndex(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findParameterIndex(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findParameterIndex(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findParameterIndex(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findParameterIndex(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findParameterIndex(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findParameterIndex(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findParameterIndex(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findParameterIndex(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findParameterIndex(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findParameterIndex(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findParameterIndex(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string), calendar);
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findParameterIndex(string));
    }
}

