/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.BaseTable;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.ValuePool;

public class Table
extends BaseTable {
    public static final int SYSTEM_TABLE = 0;
    public static final int SYSTEM_SUBQUERY = 1;
    public static final int TEMP_TABLE = 2;
    public static final int MEMORY_TABLE = 3;
    public static final int CACHED_TABLE = 4;
    public static final int TEMP_TEXT_TABLE = 5;
    public static final int TEXT_TABLE = 6;
    public static final int VIEW = 7;
    static final int SYSTEM_VIEW = 8;
    public HashMappedList columnList;
    private int[] primaryKeyCols;
    private int[] primaryKeyTypes;
    private int[] primaryKeyColsSequence;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    int identityColumn;
    NumberSequence identitySequence;
    NumberSequence rowIdSequence;
    Constraint[] constraintList;
    HsqlArrayList[] triggerLists;
    private int[] colTypes;
    private int[] colSizes;
    private int[] colScales;
    private boolean[] colNullable;
    private Expression[] colDefaults;
    private int[] defaultColumnMap;
    private boolean hasDefaultValues;
    boolean sqlEnforceSize;
    protected int columnCount;
    public Database database;
    protected DataFileCache cache;
    protected HsqlNameManager.HsqlName tableName;
    private int tableType;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected boolean isText;
    protected boolean isMemory;
    private boolean isView;
    protected boolean isLogged;
    protected int indexType;
    protected boolean onCommitPreserve;
    PersistentStore rowStore;
    Index[] indexList;
    HashSet constraintPath;
    HashMappedList tableUpdateList;

    Table(Database database, HsqlNameManager.HsqlName hsqlName, int n) throws HsqlException {
        this.database = database;
        this.sqlEnforceSize = database.sqlEnforceStrictSize;
        this.identitySequence = new NumberSequence(null, 0L, 1L, -5);
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        switch (n) {
            case 1: {
                this.isTemp = true;
                this.isMemory = true;
            }
            case 0: {
                this.isMemory = true;
                break;
            }
            case 4: {
                if (DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    this.cache = database.logger.getCache();
                    this.isCached = true;
                    this.isLogged = !this.database.isFilesReadOnly();
                    this.indexType = 1;
                    this.rowStore = new RowStore();
                    break;
                }
                n = 3;
            }
            case 3: {
                this.isMemory = true;
                this.isLogged = !this.database.isFilesReadOnly();
                break;
            }
            case 2: {
                this.isMemory = true;
                this.isTemp = true;
                break;
            }
            case 5: {
                if (!DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    throw Trace.error(63);
                }
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                this.indexType = 2;
                this.rowStore = new RowStore();
                break;
            }
            case 6: {
                if (!DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    throw Trace.error(63);
                }
                this.isText = true;
                this.indexType = 2;
                this.rowStore = new RowStore();
                break;
            }
            case 7: 
            case 8: {
                this.isView = true;
            }
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.primaryKeyCols = null;
        this.primaryKeyTypes = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = new Index[0];
        this.constraintList = new Constraint[0];
        this.triggerLists = new HsqlArrayList[12];
        if (database.isFilesReadOnly() && this.isFileBased()) {
            this.isReadOnly = true;
        }
    }

    boolean equals(Session session, String string) {
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    boolean equals(HsqlNameManager.HsqlName hsqlName) {
        return this.tableName.equals(hsqlName);
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.isFilesReadOnly() && this.isFileBased()) {
            throw Trace.error(32);
        }
        this.isReadOnly = bl;
    }

    boolean isFileBased() {
        return this.isCached || this.isText;
    }

    protected void setDataSource(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        throw Trace.error(22);
    }

    protected String getDataSource() {
        return null;
    }

    protected boolean isDescDataSource() {
        return false;
    }

    public void setHeader(String string) throws HsqlException {
        throw Trace.error(150);
    }

    public String getHeader() {
        return null;
    }

    void addConstraint(Constraint constraint) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, constraint, this.constraintList.length, 1);
    }

    Constraint[] getConstraints() {
        return this.constraintList;
    }

    Index getUniqueConstraintIndexForColumns(int[] nArray) {
        if (ArrayUtil.areEqual(this.getPrimaryIndex().getColumns(), nArray, nArray.length, true)) {
            return this.getPrimaryIndex();
        }
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getType() == 2 && ArrayUtil.areEqual(constraint.getMainColumns(), nArray, nArray.length, true)) {
                return constraint.getMainIndex();
            }
            ++n;
        }
        return null;
    }

    Constraint getConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.isEquivalent(table, nArray, this, nArray2)) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    Constraint getUniqueConstraintForColumns(int[] nArray) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.isEquivalent(nArray, 2)) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    Constraint getUniqueConstraintForIndex(Index index) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getMainIndex() == index && constraint.getType() == 2) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = n;
        int n4 = this.constraintList.length;
        while (n3 < n4) {
            Constraint constraint = this.constraintList[n3];
            if (constraint.getType() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void addColumn(Column column) throws HsqlException {
        if (this.findColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4 || column.getType() == -5, 16, column.columnName.name);
            Trace.check(this.identityColumn == -1, 24, column.columnName.name);
            this.identityColumn = this.columnCount;
        }
        if (this.primaryKeyCols != null) {
            Trace.doAssert(false, "Table.addColumn");
        }
        this.columnList.add(column.columnName.name, column);
        ++this.columnCount;
    }

    void addColumns(Result.ResultMetaData resultMetaData, int n) throws HsqlException {
        int n2 = 0;
        while (n2 < n) {
            Column column = new Column(this.database.nameManager.newHsqlName(resultMetaData.colLabels[n2], resultMetaData.isLabelQuoted[n2]), true, resultMetaData.colTypes[n2], resultMetaData.colSizes[n2], resultMetaData.colScales[n2], false, null);
            this.addColumn(column);
            ++n2;
        }
    }

    void addColumns(Select select) throws HsqlException {
        int n = select.iResultLen;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = select.exprColumns[n2];
            Column column = new Column(this.database.nameManager.newHsqlName(expression.getAlias(), expression.isAliasQuoted()), true, expression.getDataType(), expression.getColumnSize(), expression.getColumnScale(), false, null);
            this.addColumn(column);
            ++n2;
        }
    }

    public HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    public int getId() {
        return this.tableName.hashCode();
    }

    void rename(Session session, String string, boolean bl) throws HsqlException {
        String string2 = this.tableName.name;
        this.tableName.rename(string, bl);
        if (HsqlNameManager.HsqlName.isReservedIndexName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
        this.renameTableInCheckConstraints(session, string2, string);
    }

    int getInternalColumnCount() {
        return this.columnCount;
    }

    protected Table duplicate() throws HsqlException {
        Table table = new Table(this.database, this.tableName, this.tableType);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws HsqlException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= this.columnCount || nArray2[n] >= table.columnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[n]).getType() != table.getColumn(nArray2[n]).getType()) {
                throw Trace.error(57);
            }
            ++n;
        }
    }

    Table moveDefinition(int[] nArray, Column column, int n, int n2) throws HsqlException {
        Object object;
        int[] nArray2;
        Table table = this.duplicate();
        int n3 = 0;
        while (n3 < this.columnCount + 1) {
            block12: {
                block10: {
                    block13: {
                        block11: {
                            if (n3 != n) break block10;
                            if (n2 != 0) break block11;
                            if (column == null) break block10;
                            table.addColumn(column);
                            break block12;
                        }
                        if (n2 <= 0) break block13;
                        table.addColumn(column);
                        break block10;
                    }
                    if (n2 < 0) break block12;
                }
                if (n3 == this.columnCount) break;
                table.addColumn(this.getColumn(n3));
            }
            ++n3;
        }
        int[] nArray3 = nArray2 = this.primaryKeyCols.length == 0 ? null : this.primaryKeyCols;
        if (nArray2 != null) {
            object = ArrayUtil.toAdjustedColumnArray(nArray2, n, n2);
            if (nArray2.length != ((int[])object).length) {
                throw Trace.error(25);
            }
            nArray2 = object;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray2, false);
        table.constraintList = this.constraintList;
        object = this.getIndex(nArray, n);
        if (object != null) {
            if (object.isConstraint()) {
                throw Trace.error(252);
            }
            throw Trace.error(123);
        }
        int n4 = 1;
        while (n4 < this.indexList.length) {
            if (nArray == null || ArrayUtil.find(nArray, n4) == -1) {
                table.createAdjustedIndex(this.indexList[n4], n, n2);
            }
            ++n4;
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    Index getIndex(int[] nArray, int n) {
        int n2 = 1;
        while (n2 < this.indexList.length) {
            Index index;
            int[] nArray2;
            if ((nArray == null || ArrayUtil.find(nArray, n2) == -1) && ArrayUtil.find(nArray2 = (index = this.indexList[n2]).getColumns(), n) != -1) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    private Table newDuplicate() throws HsqlException {
        Table table = this.duplicate();
        int n = 0;
        while (n < this.columnCount) {
            Column column = (Column)this.columnList.get(n);
            column = column.duplicate(false);
            table.columnList.add(column.columnName.name, column);
            ++n;
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    private void copyIndexes(Table table, int n, int n2, int n3) throws HsqlException {
        int n4 = 1;
        while (n4 < this.getIndexCount()) {
            Index index;
            Index index2 = this.indexList[n4];
            if (n != n4 && (index = table.createAdjustedIndex(index2, n2, n3)) == null) {
                throw Trace.error(123);
            }
            ++n4;
        }
    }

    Table moveDefinitionNew(int[] nArray, int n, Column column, int n2, int n3) throws HsqlException {
        int[] nArray2;
        Table table = this.newDuplicate();
        if (n3 == 0) {
            if (column != null) {
                table.columnList.set(n2, column.columnName.name, column);
            }
        } else if (n3 > 0) {
            table.columnList.insert(n2, column.columnName.name, column);
        } else if (n3 < 0) {
            table.columnList.remove(n2);
        }
        int[] nArray3 = nArray2 = this.hasPrimaryKey() ? this.primaryKeyCols : null;
        if (nArray2 == null) {
            if (column.isPrimaryKey()) {
                nArray2 = new int[n2];
            }
        } else {
            nArray2 = ArrayUtil.toAdjustedColumnArray(nArray2, n2, n3);
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray2, false);
        this.copyIndexes(table, n, n2, n3);
        table.constraintList = this.constraintList;
        table.triggerLists = this.triggerLists;
        return table;
    }

    Table moveDefinitionPK(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) throws HsqlException {
        if (this.hasPrimaryKey() && nArray != null || !this.hasPrimaryKey() && nArray == null) {
            throw Trace.error(25);
        }
        Table table = this.duplicate();
        int n = 0;
        while (n < this.columnCount) {
            table.addColumn(this.getColumn(n).duplicate(bl));
            ++n;
        }
        table.createPrimaryKey(hsqlName, nArray, true);
        table.constraintList = this.constraintList;
        int n2 = 1;
        while (n2 < this.getIndexCount()) {
            Index index = this.getIndex(n2);
            table.createAdjustedIndex(index, -1, 0);
            ++n2;
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    void updateConstraintsTables(Session session, Table table, int n, int n2) throws HsqlException {
        int n3 = 0;
        int n4 = this.constraintList.length;
        while (n3 < n4) {
            Constraint constraint = this.constraintList[n3];
            constraint.replaceTable(table, this, n, n2);
            if (constraint.constType == 3) {
                this.recompileCheckConstraint(session, constraint);
            }
            ++n3;
        }
    }

    private void recompileCheckConstraints(Session session) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                this.recompileCheckConstraint(session, constraint);
            }
            ++n;
        }
    }

    private void recompileCheckConstraint(Session session, Constraint constraint) throws HsqlException {
        Expression expression;
        String string = constraint.core.check.getDDL();
        Tokenizer tokenizer = new Tokenizer(string);
        Parser parser = new Parser(session, this.database, tokenizer);
        constraint.core.check = expression = parser.parseExpression();
        expression.setLikeOptimised();
        Select select = Expression.getCheckSelect(session, this, expression);
        constraint.core.checkFilter = select.tFilter[0];
        constraint.core.checkFilter.setAsCheckFilter();
        constraint.core.mainTable = this;
    }

    void checkColumnInCheckConstraint(String string) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3 && constraint.hasColumn(this, string)) {
                throw Trace.error(197, constraint.getName());
            }
            ++n;
        }
    }

    void checkColumnInFKConstraint(String string) throws HsqlException {
        int n = this.getColumnNr(string);
        int n2 = 0;
        int n3 = this.constraintList.length;
        while (n2 < n3) {
            Constraint constraint = this.constraintList[n2];
            if (constraint.hasColumn(n) && (constraint.getType() == 1 || constraint.getType() == 0)) {
                throw Trace.error(197, constraint.getName());
            }
            ++n2;
        }
    }

    private void renameColumnInCheckConstraints(String string, String string2, boolean bl) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                Expression.Collector collector = new Expression.Collector();
                collector.addAll(constraint.core.check, 2);
                Iterator iterator = collector.iterator();
                while (iterator.hasNext()) {
                    Expression expression = (Expression)iterator.next();
                    if (expression.getColumnName() != string) continue;
                    expression.setColumnName(string2, bl);
                }
            }
            ++n;
        }
    }

    private void renameTableInCheckConstraints(Session session, String string, String string2) throws HsqlException {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (constraint.constType == 3) {
                Expression.Collector collector = new Expression.Collector();
                collector.addAll(constraint.core.check, 2);
                Iterator iterator = collector.iterator();
                while (iterator.hasNext()) {
                    Expression expression = (Expression)iterator.next();
                    if (expression.getTableName() != string) continue;
                    expression.setTableName(string2);
                }
            }
            ++n;
        }
        this.recompileCheckConstraints(session);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getIndexCount() {
        return this.indexList.length;
    }

    int getIdentityColumn() {
        return this.identityColumn;
    }

    int getColumnNr(String string) throws HsqlException {
        int n = this.findColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int findColumn(String string) {
        int n = this.columnList.getIndex(string);
        return n;
    }

    public Index getPrimaryIndex() {
        return this.getIndex(0);
    }

    public int[] getPrimaryKey() {
        return this.primaryKeyCols;
    }

    public int[] getPrimaryKeyTypes() {
        return this.primaryKeyTypes;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKeyCols.length != 0;
    }

    int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    private void setBestRowIdentifiers() {
        int[] nArray = null;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        if (this.colNullable == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.columnList.size()];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        int n3 = 0;
        while (n3 < this.indexList.length) {
            block18: {
                int n4;
                int[] nArray2;
                Index index;
                block17: {
                    index = this.indexList[n3];
                    nArray2 = index.getColumns();
                    n4 = index.getVisibleColumns();
                    if (n3 != 0) break block17;
                    if (!this.hasPrimaryKey()) break block18;
                    bl = true;
                }
                if (this.bestIndexForColumn[nArray2[0]] == -1) {
                    this.bestIndexForColumn[nArray2[0]] = n3;
                }
                if (!index.isUnique()) {
                    if (this.bestIndex == null) {
                        this.bestIndex = index;
                    }
                } else {
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n4) {
                        if (!this.colNullable[nArray2[n6]]) {
                            ++n5;
                        }
                        ++n6;
                    }
                    if (this.bestIndex != null) {
                        this.bestIndex = index;
                    }
                    if (n5 == n4) {
                        if (nArray == null || n != n2 || n4 < n) {
                            nArray = nArray2;
                            n = n4;
                            n2 = n4;
                            bl = true;
                        }
                    } else if (!(bl || nArray != null && n4 >= n && n5 <= n2)) {
                        nArray = nArray2;
                        n = n4;
                        n2 = n5;
                    }
                }
            }
            ++n3;
        }
        this.bestRowIdentifierCols = nArray == null || n == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n);
        this.bestRowIdentifierStrict = bl;
        if (this.hasPrimaryKey()) {
            this.bestIndex = this.getPrimaryIndex();
        }
    }

    void setDefaultExpression(int n, Expression expression) {
        Column column = this.getColumn(n);
        column.setDefaultExpression(expression);
        this.colDefaults[n] = column.getDefaultExpression();
        this.resetDefaultsFlag();
    }

    void resetDefaultsFlag() {
        this.hasDefaultValues = false;
        int n = 0;
        while (n < this.columnCount) {
            this.hasDefaultValues = this.hasDefaultValues || this.colDefaults[n] != null;
            ++n;
        }
    }

    DataFileCache getCache() {
        return this.cache;
    }

    Index getIndexForColumn(Session session, int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 == -1 && (this.tableType == 1 || this.tableType == 0)) {
            try {
                HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX");
                this.createIndex(session, new int[]{n}, hsqlName, false, false, false);
                n2 = this.bestIndexForColumn[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2 == -1 ? null : this.getIndex(n2);
    }

    Index getIndexForColumns(boolean[] blArray) {
        Index index = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.indexList.length) {
            Index index2 = this.indexList[n2];
            boolean bl = ArrayUtil.containsAllTrueElements(blArray, index2.colCheck);
            if (bl && index2.getVisibleColumns() > n) {
                n = index2.getVisibleColumns();
                index = index2;
            }
            ++n2;
        }
        return index;
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws HsqlException {
        int n = 0;
        int n2 = this.getIndexCount();
        while (n < n2) {
            Index index = this.getIndex(n);
            int[] nArray2 = index.getColumns();
            if (ArrayUtil.haveEqualArrays(nArray2, nArray, nArray.length) && (!bl || index.isUnique())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    public int[] getIndexRootsArray() {
        int[] nArray = new int[this.getIndexCount()];
        int n = 0;
        while (n < this.getIndexCount()) {
            Node node = this.indexList[n].getRoot(null);
            nArray[n] = node != null ? node.getKey() : -1;
            ++n;
        }
        return nArray;
    }

    String getIndexRoots() {
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", "");
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.identitySequence.peek());
        return stringBuffer.toString();
    }

    public void setIndexRoots(int[] nArray) throws HsqlException {
        Trace.check(this.isCached, 22);
        int n = 0;
        while (n < this.getIndexCount()) {
            int n2 = nArray[n];
            CachedRow cachedRow = null;
            if (n2 != -1) {
                cachedRow = (CachedRow)this.rowStore.get(n2);
            }
            Node node = null;
            if (cachedRow != null) {
                node = cachedRow.getNode(n);
            }
            this.indexList[n].setRoot(null, node);
            ++n;
        }
    }

    void setIndexRoots(String string) throws HsqlException {
        Trace.check(this.isCached, 22);
        Tokenizer tokenizer = new Tokenizer(string);
        int[] nArray = new int[this.getIndexCount()];
        int n = 0;
        while (n < this.getIndexCount()) {
            int n2;
            nArray[n] = n2 = tokenizer.getInt();
            ++n;
        }
        this.setIndexRoots(nArray);
        long l = tokenizer.getBigint();
        this.identitySequence.reset(l);
    }

    void createPrimaryKey(int[] nArray) throws HsqlException {
        this.createPrimaryKey(null, nArray, false);
    }

    void createPrimaryKey() throws HsqlException {
        this.createPrimaryKey(null, null, false);
    }

    void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) throws HsqlException {
        int n;
        if (this.primaryKeyCols != null) {
            Trace.doAssert(false, "Table.createPrimaryKey(column)");
        }
        if (nArray == null) {
            nArray = new int[]{};
        } else {
            n = 0;
            while (n < nArray.length) {
                if (bl) {
                    this.getColumn(nArray[n]).setNullable(false);
                }
                this.getColumn(nArray[n]).setPrimaryKey(true);
                ++n;
            }
        }
        this.primaryKeyCols = nArray;
        this.colTypes = new int[this.columnCount];
        this.colDefaults = new Expression[this.columnCount];
        this.colSizes = new int[this.columnCount];
        this.colScales = new int[this.columnCount];
        this.colNullable = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        n = 0;
        while (n < this.columnCount) {
            this.setColumnTypeVars(n);
            ++n;
        }
        this.primaryKeyTypes = new int[this.primaryKeyCols.length];
        ArrayUtil.copyColumnValues(this.colTypes, this.primaryKeyCols, this.primaryKeyTypes);
        this.primaryKeyColsSequence = new int[this.primaryKeyCols.length];
        ArrayUtil.fillSequence(this.primaryKeyColsSequence);
        this.resetDefaultsFlag();
        HsqlNameManager.HsqlName hsqlName2 = hsqlName != null ? hsqlName : this.makeSysPKName();
        this.createPrimaryIndex(nArray, hsqlName2);
        this.setBestRowIdentifiers();
    }

    void setColumnTypeVars(int n) {
        Column column = this.getColumn(n);
        this.colTypes[n] = column.getType();
        this.colSizes[n] = column.getSize();
        this.colScales[n] = column.getScale();
        this.colNullable[n] = column.isNullable();
        this.defaultColumnMap[n] = n;
        if (column.isIdentity()) {
            this.identitySequence.reset(column.identityStart, column.identityIncrement);
        }
        this.colDefaults[n] = column.getDefaultExpression();
    }

    HsqlNameManager.HsqlName makeSysPKName() throws HsqlException {
        return this.database.nameManager.newAutoName("PK");
    }

    void createPrimaryIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.colTypes[nArray[n]];
            ++n;
        }
        Index index = new Index(this.database, hsqlName, this, nArray, nArray2, true, true, true, false, nArray, nArray2, this.isTemp);
        this.addIndex(index);
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws HsqlException {
        int[] nArray = (int[])ArrayUtil.resizeArray(index.getColumns(), index.getVisibleColumns());
        int[] nArray2 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
        if (nArray2.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexStructure(nArray2, index.getName(), index.isUnique(), index.isConstraint, index.isForward);
    }

    Index createIndex(Session session, int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3);
        Index index = this.indexList[n];
        Index index2 = this.getPrimaryIndex();
        RowIterator rowIterator = index2.firstRow(session);
        int n2 = 0;
        int n3 = 0;
        try {
            while (rowIterator.hasNext()) {
                Row row = rowIterator.next();
                Node node = row.getNode(n - 1);
                Node node2 = Node.newNode(row, n, this);
                node2.nNext = node.nNext;
                node.nNext = node2;
                ++n2;
                index.insert(session, row, n);
            }
            return index;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n3 = 72;
        }
        catch (HsqlException hsqlException) {
            n3 = 9;
        }
        rowIterator = index2.firstRow(session);
        int n4 = 0;
        while (n4 < n2) {
            Row row = rowIterator.next();
            Node node = row.getNode(0);
            int n5 = n;
            while (--n5 > 0) {
                node = node.nNext;
            }
            node.nNext = node.nNext.nNext;
            ++n4;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
        this.setBestRowIdentifiers();
        throw Trace.error(n3);
    }

    Index createIndexStructure(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3);
        return this.indexList[n];
    }

    int createIndexStructureGetNo(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        if (this.primaryKeyCols == null) {
            Trace.doAssert(false, "createIndex");
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = nArray[n2];
            nArray3[n2] = this.colTypes[nArray2[n2]];
            ++n2;
        }
        int[] nArray4 = this.getPrimaryKey();
        int[] nArray5 = this.getPrimaryKeyTypes();
        Index index = new Index(this.database, hsqlName, this, nArray2, nArray3, false, bl, bl2, bl3, nArray4, nArray5, this.isTemp);
        int n3 = this.addIndex(index);
        this.setBestRowIdentifiers();
        return n3;
    }

    private int addIndex(Index index) {
        int n = 0;
        while (n < this.indexList.length) {
            Index index2 = this.indexList[n];
            int n2 = index.getIndexOrderValue() - index2.getIndexOrderValue();
            if (n2 < 0) break;
            ++n;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, index, n, 1);
        return n;
    }

    boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    void checkDropIndex(String string, HashSet hashSet, boolean bl) throws HsqlException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (!bl && index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            Constraint constraint = this.constraintList[n];
            if (hashSet == null || !hashSet.contains(constraint)) {
                if (constraint.isIndexFK(index)) {
                    throw Trace.error(50, string);
                }
                if (constraint.isIndexUnique(index)) {
                    throw Trace.error(56, string);
                }
            }
            ++n;
        }
    }

    public boolean isEmpty(Session session) {
        if (this.getIndexCount() == 0) {
            return true;
        }
        return this.getIndex(0).isEmpty(session);
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.columnCount];
    }

    boolean[] getNewColumnCheckList() {
        return new boolean[this.columnCount];
    }

    Object[] getEmptyRowData() {
        return new Object[this.columnCount];
    }

    Object[] getNewRowData(Session session, boolean[] blArray) throws HsqlException {
        Object[] objectArray = new Object[this.columnCount];
        if (blArray != null && this.hasDefaultValues) {
            int n = 0;
            while (n < this.columnCount) {
                Expression expression = this.colDefaults[n];
                if (!blArray[n] && expression != null) {
                    objectArray[n] = expression.getValue(session, this.colTypes[n]);
                }
                ++n;
            }
        }
        return objectArray;
    }

    void dropIndex(Session session, String string) throws HsqlException {
        int n = this.getIndexIndex(string);
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
        this.setBestRowIdentifiers();
        this.dropIndexFromRows(session, n);
    }

    void dropIndexFromRows(Session session, int n) throws HsqlException {
        RowIterator rowIterator = this.getPrimaryIndex().firstRow(session);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            int n2 = n - 1;
            Node node = row.getNode(0);
            while (n2-- > 0) {
                node = node.nNext;
            }
            node.nNext = node.nNext.nNext;
        }
    }

    void moveData(Session session, Table table, int n, int n2) throws HsqlException {
        Object object = null;
        Column column = null;
        if (n2 >= 0 && n != -1) {
            column = this.getColumn(n);
            object = column.getDefaultValue(session);
        }
        RowIterator rowIterator = table.getPrimaryIndex().firstRow(session);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            Object[] objectArray = row.getData();
            Object[] objectArray2 = this.getEmptyRowData();
            if (n2 == 0 && n != -1) {
                object = Column.convertObject(session, objectArray[n], column.getType(), column.getSize(), column.getScale());
            }
            ArrayUtil.copyAdjustArray(objectArray, objectArray2, object, n, n2);
            this.setIdentityColumn(session, objectArray2);
            this.enforceNullConstraints(objectArray2);
            Row row2 = this.newRow(objectArray2);
            this.indexRow(session, row2);
        }
        table.drop();
    }

    int insert(Session session, Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        this.fireAll(session, 3);
        while (record != null) {
            this.insertRow(session, record.data);
            record = record.next;
            ++n;
        }
        this.fireAll(session, 0);
        return n;
    }

    void insert(Session session, Object[] objectArray) throws HsqlException {
        this.fireAll(session, 3);
        this.insertRow(session, objectArray);
        this.fireAll(session, 0);
    }

    private void insertRow(Session session, Object[] objectArray) throws HsqlException {
        if (this.triggerLists[9] != null) {
            this.fireAll(session, 9, null, objectArray);
        }
        this.setIdentityColumn(session, objectArray);
        this.checkRowDataInsert(session, objectArray);
        this.insertNoCheck(session, objectArray);
        if (this.triggerLists[6] != null) {
            this.fireAll(session, 6, null, objectArray);
            this.checkRowDataInsert(session, objectArray);
        }
    }

    void insertIntoTable(Session session, Result result) throws HsqlException {
        this.insertResult(session, result);
        if (!this.isLogged) {
            return;
        }
        Record record = result.rRoot;
        while (record != null) {
            this.database.logger.writeInsertStatement(session, this, record.data);
            record = record.next;
        }
    }

    private void insertNoCheck(Session session, Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(session, row);
        if (session != null) {
            session.addTransactionInsert(this, row);
        }
        if (this.isLogged) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
    }

    public void insertNoCheckFromLog(Session session, Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.updateIdentityValue(objectArray);
        this.indexRow(session, row);
        if (session != null) {
            session.addTransactionInsert(this, row);
        }
    }

    void insertNoCheckRollback(Session session, Row row, boolean bl) throws HsqlException {
        Row row2 = this.restoreRow(row);
        this.indexRow(session, row2);
        if (bl && this.isLogged) {
            this.database.logger.writeInsertStatement(session, this, row.getData());
        }
    }

    int insertSys(Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            this.insertData(null, record.data);
            record = record.next;
            ++n;
        }
        return n;
    }

    int insertResult(Session session, Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            Object[] objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(record.data, this.columnCount);
            this.insertData(session, objectArray);
            record = record.next;
            ++n;
        }
        return n;
    }

    public void insertFromScript(Object[] objectArray) throws HsqlException {
        this.updateIdentityValue(objectArray);
        this.insertData(null, objectArray);
    }

    public void insertData(Session session, Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(session, row);
        this.commitRowToStore(row);
    }

    public void insertSys(Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(null, row);
    }

    protected void insertFromTextSource(CachedRow cachedRow) throws HsqlException {
        Object[] objectArray = cachedRow.getData();
        this.updateIdentityValue(objectArray);
        this.enforceFieldValueLimits(objectArray, this.defaultColumnMap);
        this.enforceNullConstraints(objectArray);
        int n = 0;
        try {
            while (n < this.indexList.length) {
                this.indexList[n].insert(null, cachedRow, n);
                ++n;
            }
        }
        catch (HsqlException hsqlException) {
            Index index = this.indexList[n];
            boolean bl = index.isConstraint;
            if (bl) {
                throw Trace.error(104, index.getName().name);
            }
            throw hsqlException;
        }
    }

    protected void enforceNullConstraints(Object[] objectArray) throws HsqlException {
        int n = 0;
        while (n < this.columnCount) {
            if (objectArray[n] == null && !this.colNullable[n]) {
                Trace.throwerror(10, "column: " + this.getColumn((int)n).columnName.name + " table: " + this.tableName.name);
            }
            ++n;
        }
    }

    protected void setIdentityColumn(Session session, Object[] objectArray) throws HsqlException {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = this.colTypes[this.identityColumn] == 4 ? (Number)ValuePool.getInt((int)this.identitySequence.getValue()) : (Number)ValuePool.getLong(this.identitySequence.getValue());
                objectArray[this.identityColumn] = number;
            } else {
                this.identitySequence.getValue(number.longValue());
            }
            if (session != null) {
                session.setLastIdentity(number);
            }
        }
    }

    protected void updateIdentityValue(Object[] objectArray) throws HsqlException {
        Number number;
        if (this.identityColumn != -1 && (number = (Number)objectArray[this.identityColumn]) != null) {
            this.identitySequence.getValue(number.longValue());
        }
    }

    void enforceFieldValueLimits(Object[] objectArray, int[] nArray) throws HsqlException {
        if (this.sqlEnforceSize) {
            if (nArray == null) {
                nArray = this.defaultColumnMap;
            }
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if ((this.colTypes[n2] == 93 || this.colSizes[n2] != 0) && objectArray[n2] != null) {
                    objectArray[n2] = Column.enforceSize(objectArray[n2], this.colTypes[n2], this.colSizes[n2], this.colScales[n2], true);
                }
                ++n;
            }
        }
    }

    void fireAll(Session session, int n, Object[] objectArray, Object[] objectArray2) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        HsqlArrayList hsqlArrayList = this.triggerLists[n];
        if (hsqlArrayList == null) {
            return;
        }
        int n2 = 0;
        int n3 = hsqlArrayList.size();
        while (n2 < n3) {
            TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n2);
            triggerDef.pushPair(session, objectArray, objectArray2);
            ++n2;
        }
    }

    void fireAll(Session session, int n) {
        if (this.triggerLists[n] != null) {
            this.fireAll(session, n, null, null);
        }
    }

    void addTrigger(TriggerDef triggerDef) {
        if (this.triggerLists[triggerDef.vectorIndex] == null) {
            this.triggerLists[triggerDef.vectorIndex] = new HsqlArrayList();
        }
        this.triggerLists[triggerDef.vectorIndex].add(triggerDef);
    }

    void dropTrigger(String string) {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            HsqlArrayList hsqlArrayList = this.triggerLists[n2];
            if (hsqlArrayList != null) {
                int n3 = hsqlArrayList.size() - 1;
                while (n3 >= 0) {
                    TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n3);
                    if (triggerDef.name.name.equals(string)) {
                        hsqlArrayList.remove(n3);
                        triggerDef.terminate();
                    }
                    --n3;
                }
                if (hsqlArrayList.isEmpty()) {
                    this.triggerLists[n2] = null;
                }
            }
            ++n2;
        }
    }

    void dropTriggers() {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            HsqlArrayList hsqlArrayList = this.triggerLists[n2];
            if (hsqlArrayList != null) {
                int n3 = hsqlArrayList.size() - 1;
                while (n3 >= 0) {
                    TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n3);
                    triggerDef.terminate();
                    --n3;
                }
                this.triggerLists[n2] = null;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void checkCascadeDelete(Session session, Table table, HashMappedList hashMappedList, Row row, boolean bl, HashSet hashSet) throws HsqlException {
        int n = 0;
        int n2 = table.constraintList.length;
        while (true) {
            block24: {
                RowIterator rowIterator;
                if (n >= n2) {
                    return;
                }
                Constraint constraint = table.constraintList[n];
                if (constraint.getType() == 1 && constraint.getRef() != null && (rowIterator = constraint.findFkRef(session, row.getData(), bl)).hasNext()) {
                    Object var23_22;
                    block26: {
                        block25: {
                            try {
                                Row row2;
                                boolean bl2;
                                Object object;
                                if (constraint.core.deleteAction == 3) {
                                    if (constraint.core.mainTable == constraint.core.refTable && row.equals(object = rowIterator.next())) {
                                        var23_22 = null;
                                        rowIterator.release();
                                        break block24;
                                    } else {
                                        throw Trace.error(8, 100, new Object[]{constraint.core.fkName.name, constraint.core.refTable.getName().name});
                                    }
                                }
                                object = constraint.getRef();
                                boolean bl3 = bl2 = ((Table)object).getNextConstraintIndex(0, 1) != -1;
                                if (!bl && !bl2) {
                                    break block25;
                                }
                                Index index = constraint.getRefIndex();
                                int[] nArray = constraint.getMainColumns();
                                int[] nArray2 = constraint.getRefColumns();
                                Object[] objectArray = row.getData();
                                boolean bl4 = constraint.getDeleteAction() == 2 || constraint.getDeleteAction() == 4;
                                HashMappedList hashMappedList2 = null;
                                if (bl4 && (hashMappedList2 = (HashMappedList)hashMappedList.get(object)) == null) {
                                    hashMappedList2 = new HashMappedList();
                                    hashMappedList.add(object, hashMappedList2);
                                }
                                while ((row2 = rowIterator.next()) != null && !row2.isCascadeDeleted() && index.compareRowNonUnique(session, objectArray, nArray, row2.getData()) == 0) {
                                    if (bl4) {
                                        int n3;
                                        Object[] objectArray2 = ((Table)object).getEmptyRowData();
                                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                                        if (constraint.getDeleteAction() == 2) {
                                            n3 = 0;
                                            while (n3 < nArray2.length) {
                                                objectArray2[nArray2[n3]] = null;
                                                ++n3;
                                            }
                                        } else {
                                            n3 = 0;
                                            while (n3 < nArray2.length) {
                                                Column column = ((Table)object).getColumn(nArray2[n3]);
                                                objectArray2[nArray2[n3]] = column.getDefaultValue(session);
                                                ++n3;
                                            }
                                        }
                                        if (bl2 && hashSet.add(constraint)) {
                                            Table.checkCascadeUpdate(session, (Table)object, null, row2, objectArray2, nArray2, null, hashSet);
                                            hashSet.remove(constraint);
                                        }
                                        if (bl && (object != table || !row2.equals(row))) {
                                            Table.mergeUpdate(hashMappedList2, row2, objectArray2, nArray2);
                                        }
                                    } else if (bl2) {
                                        if (object != table) {
                                            if (hashSet.add(constraint)) {
                                                Table.checkCascadeDelete(session, (Table)object, hashMappedList, row2, bl, hashSet);
                                                hashSet.remove(constraint);
                                            }
                                        } else if (row2 != row) {
                                            Table.checkCascadeDelete(session, (Table)object, hashMappedList, row2, bl, hashSet);
                                        }
                                    }
                                    if (!bl || bl4 || row2.isCascadeDeleted()) continue;
                                    super.deleteNoRefCheck(session, row2);
                                }
                                break block26;
                            }
                            catch (Throwable throwable) {
                                var23_22 = null;
                                rowIterator.release();
                                throw throwable;
                            }
                        }
                        var23_22 = null;
                        rowIterator.release();
                        break block24;
                    }
                    var23_22 = null;
                    rowIterator.release();
                }
            }
            ++n;
        }
    }

    static void checkCascadeUpdate(Session session, Table table, HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray, Table table2, HashSet hashSet) throws HsqlException {
        int n = 0;
        int n2 = table.constraintList.length;
        while (n < n2) {
            int[] nArray2;
            Constraint constraint = table.constraintList[n];
            if (constraint.getType() == 0 && constraint.getRef() != null) {
                if ((table2 == null || constraint.getMain() != table2) && ArrayUtil.countCommonElements(nArray, constraint.getRefColumns()) != 0) {
                    constraint.hasMainRef(session, objectArray);
                }
            } else if (constraint.getType() == 1 && constraint.getRef() != null && (nArray2 = ArrayUtil.commonElements(nArray, constraint.getMainColumns())) != null) {
                RowIterator rowIterator;
                int[] nArray3 = constraint.getMainColumns();
                int[] nArray4 = constraint.getRefColumns();
                boolean bl = true;
                int n3 = 0;
                while (n3 < nArray3.length) {
                    if (!row.getData()[nArray3[n3]].equals(objectArray[nArray3[n3]])) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (!bl && (rowIterator = constraint.findFkRef(session, row.getData(), false)).hasNext()) {
                    if (constraint.core.updateAction == 3) {
                        throw Trace.error(8, 100, new Object[]{constraint.core.fkName.name, constraint.core.refTable.getName().name});
                    }
                    Table table3 = constraint.getRef();
                    boolean bl2 = table3.getNextConstraintIndex(0, 1) != -1;
                    Index index = constraint.getRefIndex();
                    HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(table3);
                    if (hashMappedList2 == null) {
                        hashMappedList2 = new HashMappedList();
                        hashMappedList.add(table3, hashMappedList2);
                    }
                    Row row2 = rowIterator.next();
                    while (row2 != null && index.compareRowNonUnique(session, row.getData(), nArray3, row2.getData()) == 0) {
                        int n4;
                        Object[] objectArray2 = table3.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        if (constraint.getUpdateAction() == 2) {
                            n4 = 0;
                            while (n4 < nArray4.length) {
                                objectArray2[nArray4[n4]] = null;
                                ++n4;
                            }
                        } else if (constraint.getUpdateAction() == 4) {
                            n4 = 0;
                            while (n4 < nArray4.length) {
                                Column column = table3.getColumn(nArray4[n4]);
                                objectArray2[nArray4[n4]] = column.getDefaultValue(session);
                                ++n4;
                            }
                            if (hashSet.add(constraint)) {
                                Table.checkCascadeUpdate(session, table3, hashMappedList, row2, objectArray2, nArray4, null, hashSet);
                                hashSet.remove(constraint);
                            }
                        } else {
                            n4 = 0;
                            while (n4 < nArray3.length) {
                                objectArray2[nArray4[n4]] = objectArray[nArray3[n4]];
                                ++n4;
                            }
                            if (hashSet.add(constraint)) {
                                Table.checkCascadeUpdate(session, table3, hashMappedList, row2, objectArray2, nArray2, table, hashSet);
                                hashSet.remove(constraint);
                            }
                        }
                        Table.mergeUpdate(hashMappedList2, row2, objectArray2, nArray4);
                        row2 = rowIterator.next();
                    }
                }
            }
            ++n;
        }
    }

    static void mergeUpdate(HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            int n = 0;
            while (n < nArray.length) {
                objectArray2[nArray[n]] = objectArray[nArray[n]];
                ++n;
            }
        } else {
            hashMappedList.add(row, objectArray);
        }
    }

    static boolean mergeKeepUpdate(Session session, HashMappedList hashMappedList, int[] nArray, int[] nArray2, Row row, Object[] objectArray) throws HsqlException {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            if (Index.compareRows(session, row.getData(), objectArray, nArray, nArray2) != 0 && Index.compareRows(session, objectArray, objectArray2, nArray, nArray2) != 0) {
                return false;
            }
            int n = 0;
            while (n < nArray.length) {
                objectArray[nArray[n]] = objectArray2[nArray[n]];
                ++n;
            }
            hashMappedList.put(row, objectArray);
        } else {
            hashMappedList.add(row, objectArray);
        }
        return true;
    }

    static void clearUpdateLists(HashMappedList hashMappedList) {
        int n = 0;
        while (n < hashMappedList.size()) {
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(n);
            hashMappedList2.clear();
            ++n;
        }
    }

    int delete(Session session, HsqlArrayList hsqlArrayList) throws HsqlException {
        Object object;
        Object object2;
        int n;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        if (this.database.isReferentialIntegrity()) {
            n = 0;
            while (n < hsqlArrayList.size()) {
                object2 = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList, (Row)object2, false, hashSet);
                ++n;
            }
        }
        this.database.txManager.checkDelete(session, hsqlArrayList);
        n = 0;
        while (n < hashMappedList.size()) {
            object2 = (Table)hashMappedList.getKey(n);
            object = (HashMappedList)hashMappedList.get(n);
            this.database.txManager.checkDelete(session, (HashMappedList)object);
            ++n;
        }
        this.fireAll(session, 4);
        if (this.database.isReferentialIntegrity()) {
            int n2 = 0;
            while (n2 < hsqlArrayList.size()) {
                object = (Row)hsqlArrayList.get(n2);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList, (Row)object, true, hashSet);
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < hsqlArrayList.size()) {
            object = (Row)hsqlArrayList.get(n3);
            if (!((Row)object).isCascadeDeleted()) {
                this.deleteNoRefCheck(session, (Row)object);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < hashMappedList.size()) {
            Table table = (Table)hashMappedList.getKey(n4);
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(n4);
            table.updateRowSet(session, hashMappedList2, null, false);
            hashMappedList2.clear();
            ++n4;
        }
        this.fireAll(session, 1);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList;
        return hsqlArrayList.size();
    }

    private void deleteNoRefCheck(Session session, Row row) throws HsqlException {
        Object[] objectArray = row.getData();
        this.fireAll(session, 10, objectArray, null);
        this.deleteNoCheck(session, row, true);
        this.fireAll(session, 7, objectArray, null);
    }

    private void deleteNoCheck(Session session, Row row, boolean bl) throws HsqlException {
        if (row.isCascadeDeleted()) {
            return;
        }
        Object[] objectArray = row.getData();
        row = row.getUpdatedRow();
        int n = this.indexList.length - 1;
        while (n >= 0) {
            Node node = row.getNode(n);
            this.indexList[n].delete(session, node);
            --n;
        }
        row.delete();
        if (session != null) {
            boolean bl2 = session.addTransactionDelete(this, row);
        }
        if (bl && this.isLogged) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    public void deleteNoCheckFromLog(Session session, Object[] objectArray) throws HsqlException {
        Object object;
        RowIterator rowIterator;
        Row row = null;
        if (this.hasPrimaryKey()) {
            rowIterator = this.getPrimaryIndex().findFirstRow(session, objectArray, this.primaryKeyColsSequence);
            row = rowIterator.next();
        } else if (this.bestIndex == null) {
            rowIterator = this.getPrimaryIndex().firstRow(session);
            while ((row = rowIterator.next()) != null && Index.compareRows(session, row.getData(), objectArray, this.defaultColumnMap, this.colTypes) != 0) {
            }
        } else {
            rowIterator = this.bestIndex.findFirstRow(session, objectArray);
            while ((row = rowIterator.next()) != null) {
                object = row.getData();
                if (this.bestIndex.compareRowNonUnique(session, objectArray, this.bestIndex.getColumns(), (Object[])object) != 0) {
                    row = null;
                    break;
                }
                if (Index.compareRows(session, object, objectArray, this.defaultColumnMap, this.colTypes) != 0) continue;
            }
        }
        if (row == null) {
            return;
        }
        this.database.txManager.checkDelete(session, row);
        int n = this.indexList.length - 1;
        while (n >= 0) {
            object = row.getNode(n);
            this.indexList[n].delete(session, (Node)object);
            --n;
        }
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, row);
        }
    }

    void deleteNoCheckRollback(Session session, Row row, boolean bl) throws HsqlException {
        row = this.indexList[0].findRow(session, row);
        int n = this.indexList.length - 1;
        while (n >= 0) {
            Node node = row.getNode(n);
            this.indexList[n].delete(session, node);
            --n;
        }
        row.delete();
        this.removeRowFromStore(row);
        if (bl && this.isLogged) {
            this.database.logger.writeDeleteStatement(session, this, row.getData());
        }
    }

    int update(Session session, HashMappedList hashMappedList, int[] nArray) throws HsqlException {
        Object object;
        Object object2;
        Object[] objectArray;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList2 = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        int n = 0;
        while (n < hashMappedList.size()) {
            objectArray = (Object[])hashMappedList.get(n);
            this.setIdentityColumn(session, objectArray);
            this.enforceFieldValueLimits(objectArray, nArray);
            this.enforceNullConstraints(objectArray);
            ++n;
        }
        if (this.database.isReferentialIntegrity()) {
            int n2 = 0;
            while (n2 < hashMappedList.size()) {
                Object[] objectArray2 = (Object[])hashMappedList.get(n2);
                object2 = (Row)hashMappedList.getKey(n2);
                Table.checkCascadeUpdate(session, this, hashMappedList2, (Row)object2, objectArray2, nArray, null, hashSet);
                ++n2;
            }
        }
        this.fireAll(session, 5);
        objectArray = (HashMappedList)hashMappedList2.get(this);
        if (objectArray != null) {
            int n3 = 0;
            while (n3 < objectArray.size()) {
                object2 = (Row)objectArray.getKey(n3);
                object = (Object[])objectArray.get(n3);
                Table.mergeKeepUpdate(session, hashMappedList, nArray, this.colTypes, (Row)object2, (Object[])object);
                ++n3;
            }
            objectArray.clear();
        }
        int n4 = 0;
        while (n4 < hashMappedList2.size()) {
            object2 = (Table)hashMappedList2.getKey(n4);
            object = (HashMappedList)hashMappedList2.get(n4);
            this.database.txManager.checkDelete(session, (HashMappedList)object);
            ++n4;
        }
        this.database.txManager.checkDelete(session, hashMappedList);
        int n5 = 0;
        while (n5 < hashMappedList2.size()) {
            object = (Table)hashMappedList2.getKey(n5);
            HashMappedList hashMappedList3 = (HashMappedList)hashMappedList2.get(n5);
            ((Table)object).updateRowSet(session, hashMappedList3, null, false);
            hashMappedList3.clear();
            ++n5;
        }
        this.updateRowSet(session, hashMappedList, nArray, true);
        this.fireAll(session, 2);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList2;
        Table.clearUpdateLists(this.tableUpdateList);
        return hashMappedList.size();
    }

    void updateRowSet(Session session, HashMappedList hashMappedList, int[] nArray, boolean bl) throws HsqlException {
        Object object;
        int n = hashMappedList.size() - 1;
        while (n >= 0) {
            Row row = (Row)hashMappedList.getKey(n);
            object = (Object[])hashMappedList.get(n);
            if (row.isCascadeDeleted()) {
                if (bl) {
                    throw Trace.error(199);
                }
                hashMappedList.remove(n);
            } else {
                int n2 = 0;
                while (n2 < this.constraintList.length) {
                    Constraint constraint = this.constraintList[n2];
                    if (constraint.getType() == 3) {
                        constraint.checkCheckConstraint(session, (Object[])object);
                    }
                    ++n2;
                }
                this.deleteNoCheck(session, row, true);
            }
            --n;
        }
        int n3 = 0;
        while (n3 < hashMappedList.size()) {
            object = (Row)hashMappedList.getKey(n3);
            Object[] objectArray = (Object[])hashMappedList.get(n3);
            if (this.triggerLists[11] != null) {
                this.fireAll(session, 11, ((Row)object).getData(), objectArray);
                this.checkRowDataUpdate(session, objectArray, nArray);
            }
            this.insertNoCheck(session, objectArray);
            if (this.triggerLists[8] != null) {
                this.fireAll(session, 8, ((Row)object).getData(), objectArray);
                this.checkRowDataUpdate(session, objectArray, nArray);
            }
            ++n3;
        }
    }

    void checkRowDataInsert(Session session, Object[] objectArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray, null);
        this.enforceNullConstraints(objectArray);
        if (this.database.isReferentialIntegrity()) {
            int n = 0;
            int n2 = this.constraintList.length;
            while (n < n2) {
                this.constraintList[n].checkInsert(session, objectArray);
                ++n;
            }
        }
    }

    void checkRowDataUpdate(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray, nArray);
        this.enforceNullConstraints(objectArray);
        int n = 0;
        while (n < this.constraintList.length) {
            Constraint constraint = this.constraintList[n];
            if (constraint.getType() == 3) {
                constraint.checkCheckConstraint(session, objectArray);
            }
            ++n;
        }
    }

    public boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    int getIndexIndex(String string) {
        Index[] indexArray = this.indexList;
        int n = 0;
        while (n < indexArray.length) {
            if (string.equals(indexArray[n].getName().name)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Index getIndex(String string) {
        Index[] indexArray = this.indexList;
        int n = this.getIndexIndex(string);
        return n == -1 ? null : indexArray[n];
    }

    int getConstraintIndex(String string) {
        int n = 0;
        int n2 = this.constraintList.length;
        while (n < n2) {
            if (this.constraintList[n].getName().name.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        return n < 0 ? null : this.constraintList[n];
    }

    void removeConstraint(String string) {
        int n = this.getConstraintIndex(string);
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, null, n, -1);
    }

    Column getColumn(int n) {
        return (Column)this.columnList.get(n);
    }

    void renameColumn(Column column, String string, boolean bl) throws HsqlException {
        String string2 = column.columnName.name;
        int n = this.getColumnNr(string2);
        this.columnList.setKey(n, string);
        column.columnName.rename(string, bl);
        this.renameColumnInCheckConstraints(string2, string, bl);
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    public Index getIndex(int n) {
        return this.indexList[n];
    }

    public Index[] getIndexes() {
        return this.indexList;
    }

    CachedRow getRow(int n, Node node) throws HsqlException {
        if (this.isText) {
            CachedDataRow cachedDataRow = (CachedDataRow)this.rowStore.get(n);
            cachedDataRow.nPrimaryNode = node;
            return cachedDataRow;
        }
        if (this.isCached) {
            return (CachedRow)this.rowStore.get(n);
        }
        return null;
    }

    CachedRow getRow(int n) {
        return (CachedRow)this.rowStore.get(n);
    }

    CachedRow getRow(long l) {
        return (CachedRow)this.rowStore.get((int)l);
    }

    void registerRow(CachedRow cachedRow) {
    }

    void removeRowFromPersistence(Row row) {
        if (this.isText && this.cache != null) {
            this.rowStore.removePersistence(row.getPos());
        }
    }

    void removeRowFromStore(Row row) throws HsqlException {
        if (this.isCached || this.isText && this.cache != null) {
            this.rowStore.remove(row.getPos());
        }
        row.oData = null;
    }

    void releaseRowFromStore(Row row) throws HsqlException {
        if (this.isCached || this.isText && this.cache != null) {
            this.rowStore.release(row.getPos());
        }
    }

    void commitRowToStore(Row row) {
        if (this.isText && this.cache != null) {
            this.rowStore.commit(row);
        }
    }

    /*
     * Unable to fully structure code
     */
    void indexRow(Session var1_1, Row var2_2) throws HsqlException {
        block5: {
            var3_3 = 0;
            try {
                while (var3_3 < this.indexList.length) {
                    this.indexList[var3_3].insert(var1_1, var2_2, var3_3);
                    ++var3_3;
                }
                break block5;
            }
            catch (HsqlException var4_4) {
                var5_5 = this.indexList[var3_3];
                var6_6 = var5_5.isConstraint;
                --var3_3;
                ** while (var3_3 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                var7_7 = var2_2.getNode(var3_3);
                this.indexList[var3_3].delete(var1_1, (Node)var7_7);
                --var3_3;
                continue;
            }
lbl17:
            // 1 sources

            var2_2.delete();
            this.removeRowFromStore(var2_2);
            if (var6_6) {
                var7_7 = this.getUniqueConstraintForIndex(var5_5);
                var8_8 = var7_7 == null ? "" : var7_7.getName().name;
                throw Trace.error(104, var8_8);
            }
            throw var4_4;
        }
    }

    void clearAllRows(Session session) {
        int n = 0;
        while (n < this.indexList.length) {
            this.indexList[n].clearAll(session);
            ++n;
        }
        if (!this.isTemp) {
            this.identitySequence.reset();
            this.rowIdSequence.reset();
        }
    }

    void drop() throws HsqlException {
    }

    boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    String getCatalogName() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs") ? this.database.getURI() : null;
    }

    public String getSchemaName() {
        return this.tableName.schema.name;
    }

    public int getRowCount(Session session) throws HsqlException {
        return this.getPrimaryIndex().size(session);
    }

    public void resetRowId(Session session) throws HsqlException {
        if (this.isCached) {
            return;
        }
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        RowIterator rowIterator = this.getPrimaryIndex().firstRow(session);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            int n = (int)this.rowIdSequence.getValue();
            row.setPos(n);
        }
    }

    Row newRow(Object[] objectArray) throws HsqlException {
        Row row;
        try {
            if (this.isText) {
                row = new CachedDataRow(this, objectArray);
                this.rowStore.add(row);
            } else if (this.isCached) {
                row = new CachedRow(this, objectArray);
                this.rowStore.add(row);
            } else {
                row = new Row(this, objectArray);
                int n = (int)this.rowIdSequence.getValue();
                row.setPos(n);
            }
        }
        catch (IOException iOException) {
            throw new HsqlException(iOException, Trace.getMessage(98), 98);
        }
        return row;
    }

    Row restoreRow(Row row) throws HsqlException {
        Row row2;
        try {
            if (this.isText) {
                row2 = new CachedDataRow(this, row.oData);
                row2.setStorageSize(row.getStorageSize());
                row2.setPos(row.getPos());
                this.rowStore.restore(row2);
            } else if (this.isCached) {
                row2 = new CachedRow(this, row.oData);
                row2.setStorageSize(row.getStorageSize());
                row2.setPos(row.getPos());
                this.rowStore.restore(row2);
            } else {
                row2 = new Row(this, row.oData);
                row2.setPos(row.getPos());
            }
        }
        catch (IOException iOException) {
            throw new HsqlException(iOException, Trace.getMessage(98), 98);
        }
        return row2;
    }

    public class RowStore
    implements PersistentStore {
        public CachedObject get(int n) {
            try {
                return Table.this.cache.get(n, this, false);
            }
            catch (HsqlException hsqlException) {
                return null;
            }
        }

        public CachedObject getKeep(int n) {
            try {
                return Table.this.cache.get(n, this, true);
            }
            catch (HsqlException hsqlException) {
                return null;
            }
        }

        public int getStorageSize(int n) {
            try {
                return Table.this.cache.get(n, this, false).getStorageSize();
            }
            catch (HsqlException hsqlException) {
                return 0;
            }
        }

        public void add(CachedObject cachedObject) throws IOException {
            Table.this.cache.add(cachedObject);
        }

        public void restore(CachedObject cachedObject) throws IOException {
            Table.this.cache.restore(cachedObject);
        }

        public CachedObject get(RowInputInterface rowInputInterface) {
            try {
                if (Table.this.isText) {
                    return new CachedDataRow(Table.this, rowInputInterface);
                }
                CachedRow cachedRow = new CachedRow(Table.this, rowInputInterface);
                return cachedRow;
            }
            catch (HsqlException hsqlException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public CachedObject getNewInstance(int n) {
            return null;
        }

        public void remove(int n) {
            try {
                Table.this.cache.remove(n, this);
            }
            catch (IOException iOException) {}
        }

        public void removePersistence(int n) {
            try {
                Table.this.cache.removePersistence(n, this);
            }
            catch (IOException iOException) {}
        }

        public void release(int n) {
            Table.this.cache.release(n);
        }

        public void commit(CachedObject cachedObject) {
            try {
                if (Table.this.isText) {
                    Table.this.cache.saveRow(cachedObject);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

