/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.DatabaseObjectNames;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.NumberSequence;
import org.hsqldb.SequenceManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.Trace;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.persist.Logger;

public class SchemaManager {
    static final String SYSTEM_SCHEMA = "SYSTEM_SCHEMA";
    static final String DEFINITION_SCHEMA = "DEFINITION_SCHEMA";
    static final String INFORMATION_SCHEMA = "INFORMATION_SCHEMA";
    static final String PUBLIC_SCHEMA = "PUBLIC";
    static HsqlNameManager.HsqlName INFORMATION_SCHEMA_HSQLNAME = HsqlNameManager.newHsqlSystemObjectName("INFORMATION_SCHEMA");
    static HsqlNameManager.HsqlName SYSTEM_SCHEMA_HSQLNAME = HsqlNameManager.newHsqlSystemObjectName("SYSTEM_SCHEMA");
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    HashMappedList schemaMap = new HashMappedList();

    SchemaManager(Database database) {
        this.database = database;
        Schema schema = new Schema(PUBLIC_SCHEMA, false);
        this.defaultSchemaHsqlName = schema.name;
        this.schemaMap.put(PUBLIC_SCHEMA, schema);
    }

    void createSchema(String string, boolean bl) throws HsqlException {
        if (DEFINITION_SCHEMA.equals(string) || INFORMATION_SCHEMA.equals(string) || SYSTEM_SCHEMA.equals(string)) {
            throw Trace.error(227);
        }
        Schema schema = new Schema(string, bl);
        this.schemaMap.add(string, schema);
    }

    void dropSchema(String string, boolean bl) throws HsqlException {
        Object object;
        Schema schema = (Schema)this.schemaMap.get(string);
        if (schema == null) {
            throw Trace.error(227);
        }
        if (!bl && !schema.isEmpty()) {
            throw Trace.error(228);
        }
        Iterator iterator = schema.tablesIterator();
        while (iterator.hasNext()) {
            object = (Table)iterator.next();
            this.database.getUserManager().removeDbObject(((Table)object).getName());
            ((Table)object).drop();
        }
        object = schema.sequencesIterator();
        while (iterator.hasNext()) {
            NumberSequence numberSequence = (NumberSequence)object.next();
            this.database.getUserManager().removeDbObject(numberSequence.getName());
        }
        schema.clearStructures();
        this.schemaMap.remove(string);
        if (this.defaultSchemaHsqlName.name.equals(string)) {
            schema = this.schemaMap.isEmpty() ? new Schema(PUBLIC_SCHEMA, false) : (Schema)this.schemaMap.get(0);
            this.defaultSchemaHsqlName = schema.name;
            this.schemaMap.put(this.defaultSchemaHsqlName.name, schema);
        }
    }

    void renameSchema(String string, String string2, boolean bl) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(string);
        Schema schema2 = (Schema)this.schemaMap.get(string2);
        if (schema == null || schema2 != null || INFORMATION_SCHEMA.equals(string2)) {
            throw Trace.error(227, schema == null ? string : string2);
        }
        schema.name.rename(string2, bl);
        int n = this.schemaMap.getIndex(string);
        this.schemaMap.set(n, string2, schema);
    }

    void clearStructures() {
        Iterator iterator = this.schemaMap.values().iterator();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            schema.clearStructures();
        }
    }

    public Iterator userSchemaNameIterator() {
        return this.schemaMap.keySet().iterator();
    }

    HsqlNameManager.HsqlName toSchemaHsqlName(String string) {
        Schema schema = (Schema)this.schemaMap.get(string);
        return schema == null ? null : schema.name;
    }

    HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaHsqlName.name;
    }

    boolean schemaExists(String string) {
        if (INFORMATION_SCHEMA.equals(string)) {
            return true;
        }
        return this.schemaMap.containsKey(string);
    }

    HsqlNameManager.HsqlName getSchemaHsqlName(String string) throws HsqlException {
        if (string == null) {
            return this.defaultSchemaHsqlName;
        }
        if (string.equals(INFORMATION_SCHEMA)) {
            return INFORMATION_SCHEMA_HSQLNAME;
        }
        Schema schema = (Schema)this.schemaMap.get(string);
        if (schema == null) {
            throw Trace.error(227, string);
        }
        return schema.name;
    }

    String getSchemaName(String string) throws HsqlException {
        return this.getSchemaHsqlName((String)string).name;
    }

    Iterator fullSchemaNamesIterator() {
        return new WrapperIterator(new WrapperIterator(INFORMATION_SCHEMA), this.schemaMap.keySet().iterator());
    }

    public boolean isSystemSchema(HsqlNameManager.HsqlName hsqlName) {
        return INFORMATION_SCHEMA_HSQLNAME.equals(hsqlName) || SYSTEM_SCHEMA_HSQLNAME.equals(hsqlName);
    }

    public Iterator tablesIterator(String string) {
        Schema schema = (Schema)this.schemaMap.get(string);
        return schema.tablesIterator();
    }

    public Iterator allTablesIterator() {
        Iterator iterator = this.userSchemaNameIterator();
        WrapperIterator wrapperIterator = new WrapperIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.tablesIterator(string);
            wrapperIterator = new WrapperIterator(wrapperIterator, iterator2);
        }
        return wrapperIterator;
    }

    Iterator sequenceIterator(String string) {
        Schema schema = (Schema)this.schemaMap.get(string);
        return schema.sequencesIterator();
    }

    public Iterator allSequencesIterator() {
        Iterator iterator = this.schemaMap.values().iterator();
        WrapperIterator wrapperIterator = new WrapperIterator();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            wrapperIterator = new WrapperIterator(wrapperIterator, schema.sequencesIterator());
        }
        return wrapperIterator;
    }

    public HsqlArrayList getAllTables() {
        Iterator iterator = this.userSchemaNameIterator();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashMappedList hashMappedList = this.getTables(string);
            hsqlArrayList.addAll(hashMappedList.values());
        }
        return hsqlArrayList;
    }

    public HashMappedList getTables(String string) {
        Schema schema = (Schema)this.schemaMap.get(string);
        return schema.tableList;
    }

    void checkUserViewNotExists(Session session, String string, String string2) throws HsqlException {
        boolean bl;
        boolean bl2 = bl = this.database.schemaManager.findUserTable(session, string, string2) != null;
        if (bl) {
            throw Trace.error(52, string);
        }
    }

    void checkUserTableNotExists(Session session, String string, String string2) throws HsqlException {
        boolean bl;
        boolean bl2 = bl = this.findUserTable(session, string, string2) != null;
        if (bl) {
            throw Trace.error(21, string);
        }
    }

    public Table getTable(Session session, String string, String string2) throws HsqlException {
        Table table = this.findUserTable(session, string, string2);
        if (table == null) {
            if (!INFORMATION_SCHEMA.equals(string2)) {
                throw Trace.error(22);
            }
            if (this.database.dbInfo != null) {
                table = this.database.dbInfo.getSystemTable(session, string);
            }
        }
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    public Table getUserTable(Session session, String string, String string2) throws HsqlException {
        Table table = this.findUserTable(session, string, string2);
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    Table findUserTable(Session session, String string, String string2) {
        Schema schema = (Schema)this.schemaMap.get(string2);
        if (schema == null) {
            return null;
        }
        int n = 0;
        int n2 = schema.tableList.size();
        while (n < n2) {
            Table table = (Table)schema.tableList.get(n);
            if (table.equals(session, string)) {
                return table;
            }
            ++n;
        }
        return null;
    }

    void linkTable(Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName());
        schema.tableList.add(table.getName().name, table);
    }

    NumberSequence getSequence(String string, String string2) throws HsqlException {
        NumberSequence numberSequence = this.findSequence(string, string2);
        if (numberSequence == null) {
            throw Trace.error(191, string);
        }
        return numberSequence;
    }

    public NumberSequence findSequence(String string, String string2) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(string2);
        NumberSequence numberSequence = schema.sequenceManager.getSequence(string);
        return numberSequence;
    }

    Table findUserTableForIndex(Session session, String string, String string2) {
        Schema schema = (Schema)this.schemaMap.get(string2);
        HsqlNameManager.HsqlName hsqlName = schema.indexNameList.getOwner(string);
        if (hsqlName == null) {
            return null;
        }
        return this.findUserTable(session, hsqlName.name, string2);
    }

    int getTableIndex(Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName());
        int n = 0;
        int n2 = schema.tableList.size();
        while (n < n2) {
            Table table2 = (Table)schema.tableList.get(n);
            if (table2 == table) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void dropIndex(Session session, String string, String string2, boolean bl) throws HsqlException {
        Table table = this.findUserTableForIndex(session, string, string2);
        if (table == null) {
            if (bl) {
                return;
            }
            throw Trace.error(26, string);
        }
        table.checkDropIndex(string, null, false);
        session.commit();
        session.setScripting(true);
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.dropIndex(string);
    }

    void checkTriggerExists(String string, String string2, boolean bl) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(string2);
        boolean bl2 = schema.triggerNameList.containsName(string);
        if (bl2 != bl) {
            int n = bl ? 43 : 164;
            throw Trace.error(n, string);
        }
    }

    void registerTriggerName(String string, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.triggerNameList.addName(string, hsqlName, 164);
    }

    void checkIndexExists(String string, String string2, boolean bl) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(string2);
        boolean bl2 = schema.indexNameList.containsName(string);
        if (bl2 != bl) {
            int n = bl ? 26 : 23;
            throw Trace.error(n, string);
        }
    }

    void registerIndexName(String string, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.indexNameList.addName(string, hsqlName, 23);
    }

    void removeIndexName(String string, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.indexNameList.removeName(string);
    }

    void removeIndexNames(HsqlNameManager.HsqlName hsqlName) {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.indexNameList.removeOwner(hsqlName);
    }

    void renameIndex(String string, String string2, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.indexNameList.rename(string, string2, 23);
    }

    void checkConstraintExists(String string, String string2, boolean bl) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(string2);
        boolean bl2 = schema.constraintNameList.containsName(string);
        if (bl2 != bl) {
            int n = bl ? 61 : 60;
            throw Trace.error(n, string);
        }
    }

    void registerConstraintName(String string, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.constraintNameList.addName(string, hsqlName, 60);
    }

    void removeConstraintName(String string, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.constraintNameList.removeName(string);
    }

    void removeConstraintNames(HsqlNameManager.HsqlName hsqlName) {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.constraintNameList.removeOwner(hsqlName);
    }

    NumberSequence createSequence(HsqlNameManager.HsqlName hsqlName, long l, long l2, int n) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        return schema.sequenceManager.createSequence(hsqlName, l, l2, n);
    }

    void dropSequence(NumberSequence numberSequence) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(numberSequence.getSchemaName());
        schema.sequenceManager.dropSequence(numberSequence.getName().name);
    }

    void logSequences(Session session, Logger logger) throws HsqlException {
        int n = 0;
        int n2 = this.schemaMap.size();
        while (n < n2) {
            Schema schema = (Schema)this.schemaMap.get(n);
            schema.sequenceManager.logSequences(session, logger);
            ++n;
        }
    }

    void clearTempTables(Session session, Table table) {
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        Index[] indexArray = table.getIndexes();
        int n = 0;
        while (n < sessionArray.length) {
            if (sessionArray[n] != session) {
                int n2 = 0;
                while (n2 < indexArray.length) {
                    sessionArray[n].dropIndex(indexArray[n2].getName(), false);
                    ++n2;
                }
            }
            ++n;
        }
    }

    void dropTable(Session session, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        Table table = null;
        int n = -1;
        Schema schema = (Schema)this.schemaMap.get(string2);
        int n2 = 0;
        while (n2 < schema.tableList.size()) {
            table = (Table)schema.tableList.get(n2);
            if (table.equals(session, string) && bl2 == table.isView()) {
                n = n2;
                break;
            }
            table = null;
            ++n2;
        }
        if (n == -1) {
            if (bl) {
                return;
            }
            throw Trace.error(bl2 ? 53 : 22, string);
        }
        session.checkAdmin();
        session.checkDDLWrite();
        session.commit();
        this.dropTable(table, bl3);
        session.setScripting(!table.isTemp());
    }

    void dropTable(Table table, boolean bl) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName());
        int n = schema.tableList.getIndex(table.getName().name);
        if (table.isView()) {
            this.checkCascadeDropViews((View)table, bl);
        } else {
            this.checkCascadeDropReferenced(table, bl);
            this.checkCascadeDropViews(table, bl);
        }
        table = (Table)schema.tableList.remove(n);
        this.removeExportedKeys(table);
        this.database.getUserManager().removeDbObject(table.getName());
        schema.triggerNameList.removeOwner(table.tableName);
        schema.indexNameList.removeOwner(table.tableName);
        schema.constraintNameList.removeOwner(table.tableName);
        table.dropTriggers();
        table.drop();
    }

    void setTable(int n, Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName());
        schema.tableList.set(n, table.getName().name, table);
    }

    void renameTable(Session session, Table table, String string, boolean bl) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(table.tableName.schema.name);
        int n = schema.tableList.getIndex(table.tableName.name);
        table.rename(session, string, bl);
        schema.tableList.setKey(n, string);
    }

    private void checkCascadeDropReferenced(Table table, boolean bl) throws HsqlException {
        Constraint[] constraintArray = table.getConstraints();
        Constraint constraint = null;
        Table table2 = null;
        boolean bl2 = false;
        int n = constraintArray.length - 1;
        while (n >= 0) {
            constraint = constraintArray[n];
            if (constraint.getType() == 1) {
                table2 = constraint.getRef();
                boolean bl3 = bl2 = table2 != null && table.equals(table2);
                if (!bl2) {
                    if (bl) {
                        Constraint constraint2 = table2.getConstraint(constraint.getFkName());
                        TableWorks tableWorks = new TableWorks(null, table2);
                        tableWorks.dropFKConstraint(constraint2);
                        constraintArray = table.constraintList;
                        n = constraintArray.length;
                    } else {
                        throw Trace.error(193, 101, new Object[]{constraint.getName().name, table2.getName().name});
                    }
                }
            }
            --n;
        }
    }

    void checkCascadeDropViews(View view, boolean bl) throws HsqlException {
        View[] viewArray = this.getViewsWithView(view);
        if (viewArray != null) {
            if (bl) {
                int n = viewArray.length - 1;
                while (n >= 0) {
                    this.dropTable(viewArray[n], bl);
                    --n;
                }
            } else {
                throw Trace.error(194, viewArray[0].getName().name);
            }
        }
    }

    void checkCascadeDropViews(Table table, boolean bl) throws HsqlException {
        View[] viewArray = this.getViewsWithTable(table, null);
        if (viewArray != null) {
            if (bl) {
                int n = viewArray.length - 1;
                while (n >= 0) {
                    this.dropTable(viewArray[n], bl);
                    --n;
                }
            } else {
                throw Trace.error(194, viewArray[0].getName().name);
            }
        }
    }

    void checkCascadeDropViews(NumberSequence numberSequence, boolean bl) throws HsqlException {
        View[] viewArray = this.getViewsWithSequence(numberSequence);
        if (viewArray != null) {
            if (bl) {
                int n = viewArray.length - 1;
                while (n >= 0) {
                    this.dropTable(viewArray[n], bl);
                    --n;
                }
            } else {
                throw Trace.error(186, viewArray[0].getName().name);
            }
        }
    }

    void checkColumnIsInView(Table table, String string) throws HsqlException {
        View[] viewArray = this.getViewsWithTable(table, string);
        if (viewArray != null) {
            throw Trace.error(197, viewArray[0].getName().name);
        }
    }

    private View[] getViewsWithView(View view) {
        HsqlArrayList hsqlArrayList = null;
        Schema schema = (Schema)this.schemaMap.get(view.getSchemaName());
        int n = 0;
        while (n < schema.tableList.size()) {
            boolean bl;
            Table table = (Table)schema.tableList.get(n);
            if (table.isView() && (bl = ((View)table).hasView(view))) {
                if (hsqlArrayList == null) {
                    hsqlArrayList = new HsqlArrayList();
                }
                hsqlArrayList.add(table);
            }
            ++n;
        }
        return hsqlArrayList == null ? null : (View[])hsqlArrayList.toArray(new View[hsqlArrayList.size()]);
    }

    private View[] getViewsWithTable(Table table, String string) {
        HsqlArrayList hsqlArrayList = null;
        Iterator iterator = this.allTablesIterator();
        while (iterator.hasNext()) {
            boolean bl;
            Table table2 = (Table)iterator.next();
            if (!table2.isView()) continue;
            boolean bl2 = bl = string == null ? ((View)table2).hasTable(table) : ((View)table2).hasColumn(table, string);
            if (!bl) continue;
            if (hsqlArrayList == null) {
                hsqlArrayList = new HsqlArrayList();
            }
            hsqlArrayList.add(table2);
        }
        return hsqlArrayList == null ? null : (View[])hsqlArrayList.toArray(new View[hsqlArrayList.size()]);
    }

    View[] getViewsWithSequence(NumberSequence numberSequence) {
        HsqlArrayList hsqlArrayList = null;
        Iterator iterator = this.allTablesIterator();
        while (iterator.hasNext()) {
            boolean bl;
            Table table = (Table)iterator.next();
            if (!table.isView() || !(bl = ((View)table).hasSequence(numberSequence))) continue;
            if (hsqlArrayList == null) {
                hsqlArrayList = new HsqlArrayList();
            }
            hsqlArrayList.add(table);
        }
        return hsqlArrayList == null ? null : (View[])hsqlArrayList.toArray(new View[hsqlArrayList.size()]);
    }

    void recompileViews(Table table) throws HsqlException {
        View[] viewArray = this.getViewsWithTable(table, null);
        if (viewArray != null) {
            int n = 0;
            while (n < viewArray.length) {
                String string = viewArray[n].compileTimeSchema.name;
                if (!this.schemaExists(string)) {
                    string = null;
                }
                Session session = this.database.sessionManager.getSysSession(string, false);
                viewArray[n].compile(session);
                ++n;
            }
        }
    }

    void removeExportedKeys(Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName());
        int n = 0;
        while (n < schema.tableList.size()) {
            Table table2 = (Table)schema.tableList.get(n);
            int n2 = table2.constraintList.length - 1;
            while (n2 >= 0) {
                Table table3 = table2.constraintList[n2].getRef();
                if (table == table3) {
                    table2.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(table2.constraintList, null, n2, -1);
                }
                --n2;
            }
            ++n;
        }
    }

    void dropTrigger(Session session, String string, String string2) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(string2);
        boolean bl = schema.triggerNameList.containsName(string);
        Trace.check(bl, 43, string);
        HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)schema.triggerNameList.removeName(string);
        Table table = this.findUserTable(session, hsqlName.name, string2);
        table.dropTrigger(string);
        session.setScripting(true);
    }

    public class Schema {
        HsqlNameManager.HsqlName name;
        DatabaseObjectNames triggerNameList;
        DatabaseObjectNames constraintNameList;
        DatabaseObjectNames indexNameList;
        SequenceManager sequenceManager;
        HashMappedList tableList;

        Schema(String string, boolean bl) {
            this.name = SchemaManager.this.database.nameManager.newHsqlName(string, bl);
            this.triggerNameList = new DatabaseObjectNames();
            this.indexNameList = new DatabaseObjectNames();
            this.constraintNameList = new DatabaseObjectNames();
            this.sequenceManager = new SequenceManager();
            this.tableList = new HashMappedList();
        }

        boolean isEmpty() {
            return this.sequenceManager.sequenceMap.isEmpty() && this.tableList.isEmpty();
        }

        Iterator tablesIterator() {
            return this.tableList.values().iterator();
        }

        Iterator sequencesIterator() {
            return this.sequenceManager.sequenceMap.values().iterator();
        }

        void clearStructures() {
            if (this.tableList != null) {
                int n = 0;
                while (n < this.tableList.size()) {
                    Table table = (Table)this.tableList.get(n);
                    table.dropTriggers();
                    ++n;
                }
            }
            this.triggerNameList = null;
            this.indexNameList = null;
            this.constraintNameList = null;
            this.sequenceManager = null;
            this.tableList = null;
        }
    }
}

