/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.SchemaManager;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.ValuePool;

class Parser {
    private Database database;
    private Tokenizer tokenizer;
    private Session session;
    private String sSchema;
    private String sTable;
    private String sToken;
    private boolean wasQuoted;
    private Object oData;
    private int iType;
    private int iToken;
    private int subQueryLevel;
    private HsqlArrayList subQueryList = new HsqlArrayList();
    static HashMap simpleFunctions = new HashMap();
    private static IntValueHashMap tokenSet;
    HsqlArrayList parameters = new HsqlArrayList();
    private static final Expression[] noParameters;
    private static final SubQuery[] noSubqueries;

    Parser(Session session, Database database, Tokenizer tokenizer) {
        this.database = database;
        this.tokenizer = tokenizer;
        this.session = session;
    }

    void reset(String string) {
        this.sTable = null;
        this.sToken = null;
        this.oData = null;
        this.tokenizer.reset(string);
        this.subQueryList.clear();
        this.subQueryLevel = 0;
        this.parameters.clear();
    }

    void checkTableWriteAccess(Table table, int n) throws HsqlException {
        this.session.checkReadWrite();
        this.session.check(table.getName(), n);
        if (table.isView()) {
            throw Trace.error(55, table.getName().name);
        }
        table.checkDataReadOnly();
    }

    static HsqlArrayList getColumnNames(Database database, Table table, Tokenizer tokenizer, boolean bl) throws HsqlException {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (true) {
            String string;
            if (bl) {
                string = tokenizer.getSimpleName();
                boolean bl2 = tokenizer.wasQuotedIdentifier();
                HsqlNameManager.HsqlName hsqlName = database.nameManager.newHsqlName(string, bl2);
                hsqlArrayList.add(hsqlName);
            } else {
                hsqlArrayList.add(tokenizer.getName());
                if (tokenizer.wasLongName() && !tokenizer.getLongNameFirst().equals(table.getName().name)) {
                    throw Trace.error(22, tokenizer.getLongNameFirst());
                }
            }
            if ((string = tokenizer.getSimpleToken()).equals(",")) continue;
            if (string.equals(")")) break;
            tokenizer.throwUnexpected();
        }
        return hsqlArrayList;
    }

    SubQuery parseSubquery(int n, HsqlNameManager.HsqlName[] hsqlNameArray, boolean bl, int n2) throws HsqlException {
        Object object;
        int n3;
        SubQuery subQuery = new SubQuery();
        ++this.subQueryLevel;
        boolean bl2 = n2 == 115;
        boolean bl3 = n2 == 115 || n2 == 3 || n2 == 30 || n2 == 32 || n2 == 33 || n2 == 103;
        Select select = this.parseSelect(n, bl2, false, bl3, true);
        subQuery.level = this.subQueryLevel--;
        boolean bl4 = select.resolveAll(this.session, bl);
        subQuery.select = select;
        subQuery.isResolved = bl4;
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false);
        SchemaManager cfr_ignored_0 = this.database.schemaManager;
        hsqlName.schema = SchemaManager.SYSTEM_SCHEMA_HSQLNAME;
        Table table = new Table(this.database, hsqlName, 1);
        if (hsqlNameArray != null) {
            if (hsqlNameArray.length != select.iResultLen) {
                throw Trace.error(5);
            }
            n3 = 0;
            while (n3 < select.iResultLen) {
                object = hsqlNameArray[n3];
                select.exprColumns[n3].setAlias(((HsqlNameManager.HsqlName)object).name, ((HsqlNameManager.HsqlName)object).isNameQuoted);
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < select.iResultLen) {
                object = select.exprColumns[n3].getAlias();
                if (object == null || ((String)object).length() == 0) {
                    object = "COL_" + String.valueOf(n3 + 1);
                    select.exprColumns[n3].setAlias((String)object, false);
                }
                ++n3;
            }
        }
        table.addColumns(select);
        n3 = n2 == 31 || n2 == 30 || n2 == 32 || n2 == 33 ? 1 : 0;
        object = null;
        if (n3 != 0) {
            object = new int[select.iResultLen];
            ArrayUtil.fillSequence((int[])object);
        }
        table.createPrimaryKey((int[])object);
        subQuery.table = table;
        subQuery.uniqueRows = n3;
        this.subQueryList.add(subQuery);
        return subQuery;
    }

    SubQuery getViewSubquery(View view) {
        SubQuery subQuery = view.viewSubQuery;
        int n = 0;
        while (n < view.viewSubqueries.length) {
            this.subQueryList.add(view.viewSubqueries[n]);
            ++n;
        }
        return subQuery;
    }

    Select parseSelect(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws HsqlException {
        int n2;
        boolean bl6;
        Object object;
        Expression expression;
        Select select = new Select();
        String string = this.tokenizer.getString();
        if ((bl2 || bl3) && (this.tokenizer.wasThis("LIMIT") || this.tokenizer.wasThis("TOP"))) {
            this.parseLimit(string, select, false);
            string = this.tokenizer.getString();
        }
        if (this.tokenizer.wasThis("DISTINCT")) {
            select.isDistinctSelect = true;
        } else if (!this.tokenizer.wasThis("ALL")) {
            this.tokenizer.back();
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        do {
            expression = this.parseExpression();
            string = this.tokenizer.getString();
            if (this.tokenizer.wasThis("AS")) {
                expression.setAlias(this.tokenizer.getSimpleName(), this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            } else if (this.tokenizer.wasSimpleName()) {
                expression.setAlias(string, this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            }
            hsqlArrayList.add(expression);
        } while (this.tokenizer.wasThis(","));
        if (string.equals("INTO")) {
            boolean bl7 = true;
            string = this.tokenizer.getString();
            if (this.tokenizer.wasSimpleToken()) {
                switch (Token.get(string)) {
                    case 302: {
                        select.intoType = 4;
                        break;
                    }
                    case 327: {
                        select.intoType = 2;
                        break;
                    }
                    case 328: {
                        select.intoType = 6;
                        break;
                    }
                    case 310: {
                        select.intoType = 3;
                        break;
                    }
                    default: {
                        select.intoType = this.database.getDefaultTableType();
                        bl7 = false;
                    }
                }
                if (bl7) {
                    string = this.tokenizer.getName();
                } else if (!this.tokenizer.wasName()) {
                    this.tokenizer.throwUnexpected();
                }
            }
            select.sIntoTable = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
            select.sIntoTable.schema = this.session.getSchemaHsqlName(this.tokenizer.getLongNameFirst());
            string = this.tokenizer.getString();
        }
        this.tokenizer.matchThis("FROM");
        expression = null;
        Object object2 = new HsqlArrayList();
        ((HsqlArrayList)object2).add(this.parseTableFilter(false));
        while (true) {
            Object object3;
            string = this.tokenizer.getString();
            boolean bl8 = false;
            if (this.tokenizer.wasThis("INNER")) {
                this.tokenizer.getThis("JOIN");
                string = "JOIN";
            } else if (this.tokenizer.wasThis("CROSS")) {
                this.tokenizer.getThis("JOIN");
                string = "JOIN";
                bl8 = true;
            }
            if (string.equals("LEFT") && !this.tokenizer.wasQuotedIdentifier()) {
                this.tokenizer.isGetThis("OUTER");
                this.tokenizer.getThis("JOIN");
                object = this.parseTableFilter(true);
                ((HsqlArrayList)object2).add(object);
                this.tokenizer.getThis("ON");
                object3 = this.parseExpression();
                ((Expression)object3).checkTables((HsqlArrayList)object2);
                expression = Parser.addJoinCondition(expression, (Expression)object3, (TableFilter)object, true);
                continue;
            }
            if (string.equals("RIGHT") && !this.tokenizer.wasQuotedIdentifier()) {
                this.tokenizer.isGetThis("OUTER");
                this.tokenizer.getThis("JOIN");
                object = this.parseTableFilter(false);
                object3 = new HsqlArrayList();
                ((HsqlArrayList)object3).add(object);
                ((BaseList)object3).addAll((Collection)object2);
                object2 = object3;
                ((TableFilter)((HsqlArrayList)object2).get((int)1)).isOuterJoin = true;
                this.tokenizer.getThis("ON");
                Expression expression2 = this.parseExpression();
                expression2.checkTables((HsqlArrayList)object2);
                expression = Parser.addJoinCondition(expression, expression2, (TableFilter)((HsqlArrayList)object2).get(1), true);
                continue;
            }
            if (this.tokenizer.wasThis("JOIN")) {
                ((HsqlArrayList)object2).add(this.parseTableFilter(false));
                if (bl8) continue;
                this.tokenizer.getThis("ON");
                object = this.parseExpression();
                ((Expression)object).checkTables((HsqlArrayList)object2);
                expression = Parser.addJoinCondition(expression, (Expression)object, null, false);
                continue;
            }
            if (!this.tokenizer.wasThis(",")) break;
            ((HsqlArrayList)object2).add(this.parseTableFilter(false));
        }
        this.tokenizer.back();
        this.resolveSelectTableFilter(select, hsqlArrayList, (HsqlArrayList)object2);
        string = this.tokenizer.getString();
        if (this.tokenizer.wasThis("WHERE")) {
            Expression expression3 = this.parseExpression();
            expression = Parser.addCondition(expression, expression3);
            string = this.tokenizer.getString();
        }
        select.queryCondition = expression;
        if (this.tokenizer.wasThis("GROUP")) {
            this.tokenizer.getThis("BY");
            int n3 = 0;
            do {
                object = this.parseExpression();
                hsqlArrayList.add(object);
                string = this.tokenizer.getString();
                ++n3;
            } while (this.tokenizer.wasThis(","));
            select.iGroupLen = n3;
        }
        if (this.tokenizer.wasThis("HAVING")) {
            select.iHavingLen = 1;
            select.havingCondition = this.parseExpression();
            string = this.tokenizer.getString();
            hsqlArrayList.add(select.havingCondition);
        }
        if (bl4 || bl3) {
            if (this.tokenizer.wasThis("ORDER")) {
                this.tokenizer.getThis("BY");
                this.parseOrderBy(select, hsqlArrayList);
                string = this.tokenizer.getString();
            }
            if (this.tokenizer.wasThis("LIMIT")) {
                this.parseLimit(string, select, true);
                string = this.tokenizer.getString();
            }
        }
        boolean bl9 = false;
        if (n > 0 && string.equals(")")) {
            bl9 = true;
            n -= this.parseCloseBrackets(n - 1) + 1;
            string = this.tokenizer.getString();
        }
        select.unionDepth = n;
        if (!bl4 && !bl9) {
            bl3 = false;
        }
        boolean bl10 = select.iOrderLen != 0;
        boolean bl5 = bl6 = select.limitCondition != null;
        if (bl3) {
            if (bl6 && !bl10) {
                throw Trace.error(163);
            }
        } else {
            if (bl10 && !bl) {
                throw Trace.error(70);
            }
            if (bl6 && !bl2) {
                throw Trace.error(153);
            }
        }
        if ((n2 = this.parseUnion(string)) != 0) {
            boolean bl7;
            boolean bl52 = false;
            select.unionType = n2;
            if (this.tokenizer.isGetThis("(")) {
                bl7 = true;
                n += this.parseOpenBrackets() + 1;
            }
            this.tokenizer.getThis("SELECT");
            select.unionSelect = this.parseSelect(n, false, false, bl7, false);
            string = this.tokenizer.getString();
        }
        if (bl4 && (bl || bl3) && select.iOrderLen == 0) {
            if (this.tokenizer.wasThis("ORDER")) {
                this.tokenizer.getThis("BY");
                this.parseOrderBy(select, hsqlArrayList);
                string = this.tokenizer.getString();
                select.sortUnion = true;
            }
            if (this.tokenizer.wasThis("LIMIT")) {
                this.parseLimit(string, select, true);
                string = this.tokenizer.getString();
            }
        }
        this.tokenizer.back();
        if (bl4) {
            select.prepareUnions();
        }
        int n3 = hsqlArrayList.size();
        select.exprColumns = new Expression[n3];
        hsqlArrayList.toArray(select.exprColumns);
        return select;
    }

    int parseUnion(String string) throws HsqlException {
        int n = 0;
        if (this.tokenizer.wasSimpleToken()) {
            switch (Token.get(string)) {
                case 227: {
                    string = this.tokenizer.getSimpleToken();
                    if (string.equals("ALL")) {
                        n = 2;
                        break;
                    }
                    if (string.equals("DISTINCT")) {
                        n = 1;
                        break;
                    }
                    n = 1;
                    this.tokenizer.back();
                    break;
                }
                case 115: {
                    this.tokenizer.isGetThis("DISTINCT");
                    n = 3;
                    break;
                }
                case 78: 
                case 311: {
                    this.tokenizer.isGetThis("DISTINCT");
                    n = 4;
                    break;
                }
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseLimit(String string, Select select, boolean bl) throws HsqlException {
        Expression expression;
        if (select.limitCondition != null) {
            return;
        }
        Expression expression2 = null;
        boolean bl2 = false;
        if (bl) {
            if (!string.equals("LIMIT")) return;
            bl2 = true;
            this.read();
            expression = this.readTerm();
            if (this.sToken.equals("OFFSET")) {
                this.read();
                expression2 = this.readTerm();
            }
            this.tokenizer.back();
        } else if (string.equals("LIMIT")) {
            this.read();
            expression2 = this.readTerm();
            expression = this.readTerm();
            bl2 = true;
            this.tokenizer.back();
        } else {
            if (!string.equals("TOP")) return;
            this.read();
            expression = this.readTerm();
            this.tokenizer.back();
        }
        if (expression2 == null) {
            expression2 = new Expression(4, ValuePool.getInt(0));
        }
        if ((expression2.isParam() || expression2.getType() == 1 && expression2.getDataType() == 4 && expression2.getValue(null) != null && (Integer)expression2.getValue(null) >= 0) && (expression.isParam() || expression.getType() == 1 && expression.getDataType() == 4 && expression.getValue(null) != null && (Integer)expression.getValue(null) >= 0)) {
            expression2.setDataType(4);
            expression.setDataType(4);
            select.limitCondition = new Expression(8, expression2, expression);
            return;
        }
        int n = bl2 ? 168 : 169;
        throw Trace.error(16, n);
    }

    private void parseOrderBy(Select select, HsqlArrayList hsqlArrayList) throws HsqlException {
        String string;
        int n = 0;
        do {
            Expression expression = this.parseExpression();
            expression = Parser.resolveOrderByExpression(expression, select, hsqlArrayList);
            string = this.tokenizer.getString();
            if (string.equals("DESC")) {
                expression.setDescending();
                string = this.tokenizer.getString();
            } else if (string.equals("ASC")) {
                string = this.tokenizer.getString();
            }
            hsqlArrayList.add(expression);
            ++n;
        } while (string.equals(","));
        this.tokenizer.back();
        select.iOrderLen = n;
    }

    private void resolveSelectTableFilter(Select select, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) throws HsqlException {
        Object object;
        TableFilter[] tableFilterArray = new TableFilter[hsqlArrayList2.size()];
        hsqlArrayList2.toArray(tableFilterArray);
        select.tFilter = tableFilterArray;
        int n = hsqlArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Expression expression = (Expression)hsqlArrayList.get(n2);
            if (expression.getType() == 6) {
                hsqlArrayList.remove(n2);
                n = hsqlArrayList.size();
                object = expression.getTableName();
                if (object == null) {
                    int n3 = 0;
                    while (n3 < tableFilterArray.length) {
                        n2 = Parser.addFilterColumns(tableFilterArray[n3], hsqlArrayList, n2);
                        n = hsqlArrayList.size();
                        ++n3;
                    }
                    continue;
                }
                TableFilter tableFilter = expression.findTableFilter(tableFilterArray);
                if (tableFilter == null) {
                    throw Trace.error(22, object);
                }
                n2 = Parser.addFilterColumns(tableFilter, hsqlArrayList, n2);
                n = hsqlArrayList.size();
                continue;
            }
            if (expression.getFilter() == null) {
                int n4 = 0;
                while (n4 < tableFilterArray.length) {
                    expression.resolveTables(tableFilterArray[n4]);
                    ++n4;
                }
            }
            ++n2;
        }
        int n5 = 0;
        while (n5 < n) {
            object = (Expression)hsqlArrayList.get(n5);
            ((Expression)object).resolveTypes(this.session);
            ++n5;
        }
        select.iResultLen = n;
    }

    static int addFilterColumns(TableFilter tableFilter, HsqlArrayList hsqlArrayList, int n) {
        Table table = tableFilter.getTable();
        int n2 = table.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            Expression expression = new Expression(tableFilter, table.getColumn(n3));
            hsqlArrayList.add(n++, expression);
            ++n3;
        }
        return n;
    }

    private static Expression resolveOrderByExpression(Expression expression, Select select, HsqlArrayList hsqlArrayList) throws HsqlException {
        boolean bl;
        int n = select.iResultLen;
        boolean bl2 = bl = select.unionSelect != null;
        if (expression.getType() == 1) {
            return Parser.resolveOrderByColumnIndex(expression, hsqlArrayList, n);
        }
        if (expression.getType() != 2) {
            if (bl) {
                throw Trace.error(70);
            }
            return expression;
        }
        String string = expression.getColumnName();
        String string2 = expression.getTableName();
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            Expression expression2 = (Expression)hsqlArrayList.get(n2);
            String string3 = expression2.getDefinedAlias();
            String string4 = expression2.getColumnName();
            String string5 = expression2.getTableName();
            String string6 = expression2.getFilterTableName();
            if ((string.equals(string3) || string.equals(string4)) && (string2 == null || string2.equals(string5) || string2.equals(string6))) {
                expression2.joinedTableColumnIndex = n2;
                return expression2;
            }
            ++n2;
        }
        if (bl) {
            throw Trace.error(70, string);
        }
        return expression;
    }

    private static Expression resolveOrderByColumnIndex(Expression expression, HsqlArrayList hsqlArrayList, int n) throws HsqlException {
        int n2;
        if (expression.getDataType() == 4 && 0 < (n2 = ((Integer)expression.getValue(null)).intValue()) && n2 <= n) {
            Expression expression2 = (Expression)hsqlArrayList.get(n2 - 1);
            expression2.joinedTableColumnIndex = n2 - 1;
            return expression2;
        }
        throw Trace.error(70);
    }

    private TableFilter parseSimpleTableFilter(int n) throws HsqlException {
        String string = null;
        String string2 = this.tokenizer.getName();
        String string3 = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
        Table table = this.database.schemaManager.getTable(this.session, string2, string3);
        this.checkTableWriteAccess(table, n);
        string2 = this.tokenizer.getString();
        if (string2.equals("AS")) {
            string = this.tokenizer.getSimpleName();
        } else if (this.tokenizer.wasSimpleName()) {
            string = string2;
        } else {
            this.tokenizer.back();
        }
        return new TableFilter(table, string, null, false);
    }

    private TableFilter parseTableFilter(boolean bl) throws HsqlException {
        Table table = null;
        SubQuery subQuery = null;
        String string = null;
        BaseHashMap baseHashMap = null;
        if (this.tokenizer.isGetThis("(")) {
            int n = this.parseOpenBrackets();
            this.tokenizer.getThis("SELECT");
            subQuery = this.parseSubquery(n, null, true, 3);
            this.tokenizer.getThis(")");
            table = subQuery.table;
        } else {
            String string2 = this.tokenizer.getName();
            String string3 = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
            table = this.database.schemaManager.getTable(this.session, string2, string3);
            this.session.check(table.getName(), 1);
            if (table.isView()) {
                subQuery = this.getViewSubquery((View)table);
                subQuery.select = ((View)table).viewSelect;
                table = subQuery.table;
                string = string2;
            }
        }
        String string4 = this.tokenizer.getString();
        if (this.tokenizer.wasLongName()) {
            this.tokenizer.throwUnexpected();
        }
        if ((string4.equals("LEFT") || string4.equals("RIGHT")) && !this.tokenizer.wasQuotedIdentifier()) {
            this.tokenizer.back();
        } else if (string4.equals("AS") && !this.tokenizer.wasQuotedIdentifier()) {
            string = this.tokenizer.getSimpleName();
            if (this.tokenizer.isGetThis("(")) {
                this.tokenizer.back();
                baseHashMap = this.parseColumnList();
            }
        } else if (this.tokenizer.wasSimpleName()) {
            string = string4;
            if (this.tokenizer.isGetThis("(")) {
                this.tokenizer.back();
                baseHashMap = this.parseColumnList();
            }
        } else {
            this.tokenizer.back();
        }
        if (baseHashMap != null && table.getColumnCount() != baseHashMap.size()) {
            throw Trace.error(5);
        }
        return new TableFilter(table, string, (HashMappedList)baseHashMap, bl);
    }

    private static Expression addCondition(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(28, expression, expression2);
    }

    private static Expression addJoinCondition(Expression expression, Expression expression2, TableFilter tableFilter, boolean bl) throws HsqlException {
        if (!expression2.setForJoin(tableFilter, bl)) {
            throw Trace.error(64);
        }
        return Parser.addCondition(expression, expression2);
    }

    Expression parseExpression() throws HsqlException {
        this.read();
        Expression expression = this.readOr();
        this.tokenizer.back();
        return expression;
    }

    private Expression readAggregate() throws HsqlException {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.iToken;
        this.read();
        String string = this.tokenizer.getString();
        if (string.equals("DISTINCT")) {
            bl = true;
        } else if (string.equals("ALL")) {
            bl2 = true;
        } else {
            this.tokenizer.back();
        }
        this.readThis(101);
        Expression expression = this.readOr();
        this.readThis(102);
        if ((bl2 || bl) && (n == 47 || n == 48 || n == 49 || n == 50)) {
            throw Trace.error(200);
        }
        Expression expression2 = new Expression(n, expression, null);
        expression2.setDistinctAggregate(bl);
        return expression2;
    }

    private Expression readOr() throws HsqlException {
        Expression expression = this.readAnd();
        while (this.iToken == 29) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() throws HsqlException {
        Expression expression = this.readCondition();
        while (this.iToken == 28) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() throws HsqlException {
        switch (this.iToken) {
            case 20: {
                int n = this.iToken;
                this.read();
                return new Expression(n, this.readCondition(), null);
            }
            case 31: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                int n2 = 0;
                if (this.iToken == 101) {
                    n2 += this.parseOpenBrackets() + 1;
                    this.read();
                }
                Trace.check(this.iToken == 103, 11);
                SubQuery subQuery = this.parseSubquery(n2, null, false, 31);
                Expression expression = new Expression(subQuery);
                this.read();
                this.readThis(102);
                return new Expression(n, expression, null);
            }
        }
        Expression expression = this.readConcat();
        if (this.iToken == 109) {
            boolean bl;
            this.read();
            if (this.iToken == 20) {
                bl = true;
                this.read();
            } else {
                bl = false;
            }
            Trace.check(this.iToken == 1 && this.oData == null, 11);
            this.read();
            expression = new Expression(34, expression, new Expression(0, null));
            if (bl) {
                expression = new Expression(20, expression, null);
            }
            return expression;
        }
        boolean bl = false;
        if (this.iToken == 20) {
            bl = true;
            this.read();
        }
        switch (this.iToken) {
            case 27: {
                expression = this.parseLikePredicate(expression);
                break;
            }
            case 106: {
                expression = this.parseBetweenPredicate(expression);
                break;
            }
            case 30: {
                expression = this.parseInPredicate(expression);
                break;
            }
            default: {
                Trace.check(!bl, 11);
                if (Expression.isCompare(this.iToken)) {
                    int n = this.iToken;
                    this.read();
                    return new Expression(n, expression, this.readConcat());
                }
                return expression;
            }
        }
        if (bl) {
            expression = new Expression(20, expression, null);
        }
        return expression;
    }

    private Expression parseLikePredicate(Expression expression) throws HsqlException {
        this.read();
        Expression expression2 = this.readConcat();
        Character c = null;
        if (this.sToken.equals("ESCAPE")) {
            this.read();
            Expression expression3 = this.readTerm();
            Trace.check(expression3.getType() == 1, 7);
            String string = (String)expression3.getValue(this.session, 12);
            if (string == null || string.length() < 1) {
                throw Trace.error(7, string);
            }
            c = new Character(string.charAt(0));
        }
        boolean bl = this.database.collation.name != null;
        expression = new Expression(expression, expression2, c, bl);
        return expression;
    }

    private Expression parseBetweenPredicate(Expression expression) throws HsqlException {
        this.read();
        Expression expression2 = new Expression(22, expression, this.readConcat());
        this.readThis(28);
        Expression expression3 = new Expression(25, expression, this.readConcat());
        if (expression2.getArg().isParam() && expression2.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        if (expression3.getArg().isParam() && expression3.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        return new Expression(28, expression2, expression3);
    }

    private Expression parseInPredicate(Expression expression) throws HsqlException {
        int n = this.iToken;
        this.read();
        this.readThis(101);
        Expression expression2 = null;
        int n2 = 0;
        if (this.iToken == 101) {
            n2 += this.parseOpenBrackets() + 1;
            this.read();
        }
        if (this.iToken == 103) {
            SubQuery subQuery = this.parseSubquery(n2, null, false, 30);
            Trace.check(subQuery.select.iResultLen == 1, 159);
            expression2 = new Expression(subQuery);
            this.read();
        } else {
            Expression[] expressionArray;
            this.tokenizer.back();
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            do {
                expressionArray = this.parseExpression();
                if (expressionArray.exprType == 1 && expressionArray.valueData == null && !expressionArray.isParam()) {
                    throw Trace.error(79);
                }
                hsqlArrayList.add(expressionArray);
                this.read();
            } while (this.iToken == 104);
            expressionArray = (Expression[])hsqlArrayList.toArray(new Expression[hsqlArrayList.size()]);
            expression2 = new Expression(expressionArray);
        }
        this.readThis(102);
        return new Expression(n, expression, expression2);
    }

    private Expression parseAllAnyPredicate() throws HsqlException {
        int n = this.iToken;
        this.read();
        this.readThis(101);
        Expression expression = null;
        int n2 = 0;
        if (this.iToken == 101) {
            n2 += this.parseOpenBrackets() + 1;
            this.read();
        }
        if (this.iToken != 103) {
            throw Trace.error(74);
        }
        SubQuery subQuery = this.parseSubquery(n2, null, false, n);
        Select select = subQuery.select;
        Trace.check(subQuery.select.iResultLen == 1, 159);
        expression = new Expression(subQuery);
        this.read();
        this.readThis(102);
        return new Expression(n, expression, null);
    }

    private void readThis(int n) throws HsqlException {
        Trace.check(this.iToken == n, 11);
        this.read();
    }

    private Expression readConcat() throws HsqlException {
        Expression expression = this.readSum();
        while (this.iToken == 15) {
            int n = 15;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readSum());
        }
        return expression;
    }

    private Expression readSum() throws HsqlException {
        Expression expression = this.readFactor();
        while (true) {
            int n;
            if (this.iToken == 100) {
                n = 11;
            } else {
                if (this.iToken != 10) break;
                n = 12;
            }
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() throws HsqlException {
        Expression expression = this.readTerm();
        while (this.iToken == 13 || this.iToken == 14) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readTerm());
        }
        return expression;
    }

    private Expression readTerm() throws HsqlException {
        Expression expression = null;
        switch (this.iToken) {
            case 2: {
                expression = this.readColumnExpression();
                break;
            }
            case 10: {
                int n = this.iToken;
                this.read();
                expression = new Expression(n, this.readTerm(), null);
                Trace.check(!expression.getArg().isParam(), 212);
                break;
            }
            case 100: {
                this.read();
                expression = this.readTerm();
                Trace.check(!expression.isParam(), 216, Trace.getMessage(212));
                break;
            }
            case 101: {
                this.read();
                expression = this.readOr();
                if (this.iToken != 102) {
                    throw Trace.error(11, this.sToken);
                }
                this.read();
                break;
            }
            case 1: {
                expression = new Expression(this.iType, this.oData);
                this.read();
                break;
            }
            case 9: {
                expression = new Expression(0, null, true);
                this.parameters.add(expression);
                this.read();
                break;
            }
            case 103: {
                SubQuery subQuery = this.parseSubquery(0, null, false, 103);
                expression = new Expression(subQuery);
                this.read();
                break;
            }
            case 32: 
            case 33: {
                expression = this.parseAllAnyPredicate();
                break;
            }
            case 13: {
                expression = new Expression(this.sSchema, this.sTable, (String)null);
                this.read();
                break;
            }
            case 62: {
                return this.readCaseWhenExpression();
            }
            case 68: {
                return this.readCaseExpression();
            }
            case 67: {
                return this.readNullIfExpression();
            }
            case 60: 
            case 69: {
                return this.readCoalesceExpression();
            }
            case 71: {
                return this.readSequenceExpression();
            }
            case 61: 
            case 107: {
                return this.readCastExpression();
            }
            case 63: {
                return this.readExtractExpression();
            }
            case 65: {
                return this.readTrimExpression();
            }
            case 64: {
                return this.readPositionExpression();
            }
            case 66: {
                return this.readSubstringExpression();
            }
            default: {
                if (Expression.isAggregate(this.iToken)) {
                    return this.readAggregate();
                }
                throw Trace.error(11, this.sToken);
            }
        }
        return expression;
    }

    Expression readCaseExpression() throws HsqlException {
        Expression expression;
        int n = 62;
        Expression expression2 = null;
        Expression expression3 = null;
        this.read();
        if (this.iToken != 110) {
            expression3 = this.readOr();
        }
        Expression expression4 = null;
        do {
            expression = this.parseCaseWhen(expression3);
            if (expression2 == null) {
                expression2 = expression;
            } else {
                expression4.setRightExpression(expression);
            }
            expression4 = expression.getRightExpression();
        } while (this.iToken == 110);
        if (this.iToken == 112) {
            this.readThis(112);
            expression = this.readOr();
            expression4.setRightExpression(expression);
        }
        this.readThis(113);
        return expression2;
    }

    private Expression parseCaseWhen(Expression expression) throws HsqlException {
        this.readThis(110);
        Expression expression2 = expression == null ? this.readOr() : new Expression(21, expression, this.readOr());
        this.readThis(111);
        Expression expression3 = this.readOr();
        Expression expression4 = new Expression(70, expression3, new Expression(0, null));
        Expression expression5 = new Expression(62, expression2, expression4);
        return expression5;
    }

    private Expression readCaseWhenExpression() throws HsqlException {
        int n = this.iToken;
        Expression expression = null;
        this.read();
        this.readThis(101);
        expression = this.readOr();
        this.readThis(104);
        Expression expression2 = this.readOr();
        this.readThis(104);
        expression2 = new Expression(70, expression2, this.readOr());
        expression = new Expression(n, expression, expression2);
        this.readThis(102);
        return expression;
    }

    private Expression readCastExpression() throws HsqlException {
        boolean bl = this.iToken == 61;
        this.read();
        this.readThis(101);
        Expression expression = this.readOr();
        if (bl) {
            this.readThis(104);
        } else {
            this.readThis(122);
        }
        int n = Types.getTypeNr(this.sToken);
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        if (Types.acceptsPrecisionCreateParam(n) && this.tokenizer.isGetThis("(")) {
            n2 = this.tokenizer.getInt();
            bl2 = true;
            if (Types.acceptsScaleCreateParam(n) && this.tokenizer.isGetThis(",")) {
                n3 = this.tokenizer.getInt();
            }
            this.tokenizer.getThis(")");
        }
        if (n == 6 && n2 > 53) {
            throw Trace.error(65);
        }
        if (n == 93) {
            if (!bl2) {
                n2 = 6;
            } else if (n2 != 0 && n2 != 6) {
                throw Trace.error(65);
            }
        }
        if (expression.isParam()) {
            expression.setDataType(n);
        }
        expression = new Expression(expression, n, n2, n3);
        this.read();
        this.readThis(102);
        return expression;
    }

    private Expression readColumnExpression() throws HsqlException {
        String string = this.sToken;
        Expression expression = new Expression(this.sTable, string, this.wasQuoted);
        this.read();
        if (this.iToken == 101) {
            String string2 = this.database.getJavaName(string);
            Function function = new Function(string, string2, false);
            this.session.check(string2, 15);
            int n = function.getArgCount();
            int n2 = 0;
            this.read();
            if (this.iToken != 102) {
                while (true) {
                    function.setArgument(n2++, this.readOr());
                    if (this.iToken != 104) break;
                    this.read();
                }
            }
            this.readThis(102);
            expression = new Expression(function);
        } else {
            String string3 = (String)simpleFunctions.get(string);
            if (string3 != null) {
                Function function = new Function(string, string3, true);
                expression = new Expression(function);
            }
        }
        return expression;
    }

    private Expression readConcatExpression() throws HsqlException {
        int n = this.iToken;
        this.read();
        this.readThis(101);
        Expression expression = this.readOr();
        this.readThis(104);
        expression = new Expression(n, expression, this.readOr());
        this.readThis(102);
        return expression;
    }

    private Expression readNullIfExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        Expression expression = this.readOr();
        this.readThis(104);
        Expression expression2 = new Expression(70, new Expression(0, null), expression);
        expression = new Expression(21, expression, this.readOr());
        expression = new Expression(62, expression, expression2);
        this.readThis(102);
        return expression;
    }

    private Expression readCoalesceExpression() throws HsqlException {
        Expression expression = null;
        this.read();
        this.readThis(101);
        Expression expression2 = null;
        while (true) {
            Expression expression3 = this.readOr();
            Expression expression4 = new Expression(34, expression3, null);
            Expression expression5 = new Expression(70, new Expression(0, null), expression3);
            Expression expression6 = new Expression(62, expression4, expression5);
            if (expression == null) {
                expression = expression6;
            } else {
                expression2.setLeftExpression(expression6);
            }
            expression2 = expression5;
            if (this.iToken == 102) break;
            this.readThis(104);
        }
        this.readThis(102);
        return expression;
    }

    private Expression readExtractExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        String string = this.sToken;
        if (!Expression.SQL_EXTRACT_FIELD_NAMES.contains(string)) {
            throw Trace.error(11, this.sToken);
        }
        this.readToken();
        this.readThis(124);
        Function function = new Function(string, this.database.getJavaName(string), false);
        function.setArgument(0, this.readOr());
        this.readThis(102);
        return new Expression(function);
    }

    private Expression readPositionExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        Function function = new Function("POSITION", "org.hsqldb.Library.position", false);
        function.setArgument(0, this.readTerm());
        this.readThis(30);
        function.setArgument(1, this.readOr());
        this.readThis(102);
        return new Expression(function);
    }

    private Expression readSubstringExpression() throws HsqlException {
        boolean bl = false;
        this.read();
        this.readThis(101);
        Function function = new Function("SUBSTRING", "org.hsqldb.Library.substring", false);
        function.setArgument(0, this.readTerm());
        if (this.iToken == 124) {
            this.readThis(124);
        } else {
            this.readThis(104);
            bl = true;
        }
        function.setArgument(1, this.readOr());
        Expression expression = null;
        if (!bl && this.iToken == 123) {
            this.readThis(123);
            expression = this.readTerm();
        } else if (bl && this.iToken == 104) {
            this.readThis(104);
            expression = this.readTerm();
        }
        function.setArgument(2, expression);
        this.readThis(102);
        return new Expression(function);
    }

    private Expression readSequenceExpression() throws HsqlException {
        this.tokenizer.getThis("VALUE");
        this.tokenizer.getThis("FOR");
        String string = this.tokenizer.getName();
        String string2 = this.tokenizer.getLongNameFirst();
        string2 = this.session.getSchemaName(string2);
        this.tokenizer.getString();
        NumberSequence numberSequence = this.database.schemaManager.getSequence(string, string2);
        return new Expression(numberSequence);
    }

    private Expression readTrimExpression() throws HsqlException {
        Expression expression;
        Expression expression2;
        String string;
        this.read();
        this.readThis(101);
        String string2 = this.sToken;
        if (Expression.SQL_TRIM_SPECIFICATION.contains(string2)) {
            this.read();
        } else {
            string2 = "BOTH";
        }
        if (this.sToken.length() == 1) {
            string = this.sToken;
            this.read();
        } else {
            string = " ";
        }
        this.readThis(124);
        Expression expression3 = new Expression(1, string);
        if (string2.equals("LEADING")) {
            expression2 = new Expression(true);
            expression = new Expression(false);
        } else if (string2.equals("TRAILING")) {
            expression2 = new Expression(false);
            expression = new Expression(true);
        } else {
            expression2 = expression = new Expression(true);
        }
        Function function = new Function("TRIM", "org.hsqldb.Library.trim", false);
        function.setArgument(0, this.readOr());
        function.setArgument(1, expression3);
        function.setArgument(2, expression2);
        function.setArgument(3, expression);
        this.readThis(102);
        return new Expression(function);
    }

    Expression readDefaultClause(int n) throws HsqlException {
        Object var2_2 = null;
        this.read();
        switch (this.iToken) {
            case 2: {
                String string = this.sToken;
                String string2 = (String)simpleFunctions.get(string);
                if (string2 == null) break;
                Function function = new Function(string, string2, true);
                return new Expression(function);
            }
            case 10: {
                int n2 = this.iToken;
                this.read();
                if (this.iToken != 1) break;
                this.oData = Column.convertObject(this.oData, n);
                return new Expression(n2, new Expression(n, this.oData), null);
            }
            case 1: {
                String string = this.sToken.toUpperCase(Locale.ENGLISH);
                String string3 = (String)simpleFunctions.get(string);
                if (Types.isDatetimeType(n) && string3 != null) {
                    Function function = new Function(string, string3, true);
                    return new Expression(function);
                }
                this.oData = Column.convertObject(this.oData, n);
                return new Expression(n, this.oData);
            }
        }
        throw Trace.error(46, this.sToken);
    }

    private void read() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.wasQuoted = this.tokenizer.wasQuotedIdentifier();
        if (this.tokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tokenizer.getAsValue();
            this.iType = this.tokenizer.getType();
        } else if (this.tokenizer.wasSimpleName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tokenizer.wasLongName()) {
            this.sSchema = this.tokenizer.getLongNamePre();
            this.sTable = this.tokenizer.getLongNameFirst();
            this.iToken = this.sToken.equals("*") ? 13 : 2;
        } else if (this.sToken.length() == 0) {
            this.iToken = 108;
        } else {
            this.iToken = tokenSet.get((Object)this.sToken, -1);
            if (this.iToken == -1) {
                this.iToken = 108;
            }
            switch (this.iToken) {
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case 13: {
                    this.sTable = null;
                    break;
                }
                default: {
                    this.iToken = 108;
                }
            }
        }
    }

    private void readToken() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.iToken = tokenSet.get((Object)this.sToken, -1);
    }

    Expression[] getParameters() {
        Expression[] expressionArray = this.parameters.size() == 0 ? noParameters : (Expression[])this.parameters.toArray(new Expression[this.parameters.size()]);
        this.parameters.clear();
        return expressionArray;
    }

    void clearParameters() {
        this.parameters.clear();
    }

    void setAsView(View view) {
        int n = 0;
        while (n < this.subQueryList.size()) {
            SubQuery subQuery = (SubQuery)this.subQueryList.get(n);
            if (subQuery.view == null) {
                subQuery.view = view;
            }
            ++n;
        }
    }

    SubQuery[] getSortedSubqueries() {
        if (this.subQueryList.size() == 0) {
            return noSubqueries;
        }
        this.subQueryList.sort((SubQuery)this.subQueryList.get(0));
        SubQuery[] subQueryArray = new SubQuery[this.subQueryList.size()];
        this.subQueryList.toArray(subQueryArray);
        this.subQueryList.clear();
        return subQueryArray;
    }

    CompiledStatement compileCallStatement() throws HsqlException {
        this.clearParameters();
        Expression expression = this.parseExpression();
        CompiledStatement compiledStatement = new CompiledStatement(this.session, this.database, this.session.currentSchema, expression, this.getSortedSubqueries(), this.getParameters());
        return compiledStatement;
    }

    CompiledStatement compileDeleteStatement() throws HsqlException {
        Expression expression = null;
        this.clearParameters();
        this.tokenizer.getThis("FROM");
        TableFilter tableFilter = this.parseSimpleTableFilter(2);
        String string = this.tokenizer.getString();
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        CompiledStatement compiledStatement = new CompiledStatement(this.session, this.database, this.session.currentSchema, tableFilter, expression, this.getSortedSubqueries(), this.getParameters());
        return compiledStatement;
    }

    private void getInsertColumnValueExpressions(Table table, Expression[] expressionArray, int n) throws HsqlException {
        boolean bl = false;
        int n2 = 0;
        this.tokenizer.getThis("(");
        while (n2 < n) {
            Expression expression = this.parseExpression();
            expression.resolveTables(null);
            expression.resolveTypes(this.session);
            expressionArray[n2] = expression;
            String string = this.tokenizer.getSimpleToken();
            if (!string.equals(",")) {
                if (string.equals(")")) {
                    bl = true;
                    break;
                }
                this.tokenizer.throwUnexpected();
            }
            ++n2;
        }
        if (!bl || n2 != n - 1) {
            throw Trace.error(5);
        }
    }

    CompiledStatement compileInsertStatement() throws HsqlException {
        int n;
        this.clearParameters();
        this.tokenizer.getThis("INTO");
        String string = this.tokenizer.getName();
        String string2 = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
        Table table = this.database.schemaManager.getTable(this.session, string, string2);
        this.checkTableWriteAccess(table, 4);
        HsqlArrayList hsqlArrayList = null;
        boolean[] blArray = null;
        int[] nArray = table.getColumnMap();
        int n2 = table.getColumnCount();
        int n3 = this.parseOpenBrackets();
        string = this.tokenizer.getString();
        if (n3 == 1 && !this.tokenizer.wasThis("SELECT")) {
            n3 = 0;
            this.tokenizer.back();
            hsqlArrayList = Parser.getColumnNames(this.database, table, this.tokenizer, false);
            if (hsqlArrayList.size() > n2) {
                throw Trace.error(5);
            }
            n2 = hsqlArrayList.size();
            blArray = table.getNewColumnCheckList();
            nArray = new int[n2];
            n = 0;
            while (n < n2) {
                int n4;
                nArray[n] = n4 = table.getColumnNr((String)hsqlArrayList.get(n));
                blArray[n4] = true;
                ++n;
            }
            string = this.tokenizer.getSimpleToken();
        } else if (!this.tokenizer.wasSimpleToken()) {
            this.tokenizer.throwUnexpected();
        }
        n = Token.get(string);
        switch (n) {
            case 226: {
                Expression[] expressionArray = new Expression[n2];
                this.getInsertColumnValueExpressions(table, expressionArray, n2);
                CompiledStatement compiledStatement = new CompiledStatement(this.session.currentSchema, table, nArray, expressionArray, blArray, this.getSortedSubqueries(), this.getParameters());
                return compiledStatement;
            }
            case 313: {
                n3 = this.parseOpenBrackets() + 1;
                this.tokenizer.getThis("SELECT");
            }
            case 193: {
                Select select = this.parseSelect(n3, true, false, true, true);
                if (n2 != select.iResultLen) {
                    throw Trace.error(5);
                }
                CompiledStatement compiledStatement = new CompiledStatement(this.session, this.database, this.session.currentSchema, table, nArray, blArray, select, this.getSortedSubqueries(), this.getParameters());
                return compiledStatement;
            }
        }
        throw Trace.error(11, string);
    }

    CompiledStatement compileSelectStatement(int n) throws HsqlException {
        String string;
        Object object;
        this.clearParameters();
        Select select = this.parseSelect(n, true, true, false, true);
        if (select.sIntoTable != null && this.database.schemaManager.findUserTable(this.session, (String)(object = select.sIntoTable.name), string = select.sIntoTable.schema.name) != null) {
            throw Trace.error(21, object);
        }
        object = new CompiledStatement(this.session, this.database, this.session.currentSchema, select, this.getSortedSubqueries(), this.getParameters());
        return object;
    }

    CompiledStatement compileUpdateStatement() throws HsqlException {
        this.clearParameters();
        TableFilter tableFilter = this.parseSimpleTableFilter(8);
        Table table = tableFilter.filterTable;
        this.tokenizer.getThis("SET");
        int[] nArray = table.getNewColumnMap();
        Expression[] expressionArray = new Expression[nArray.length];
        int n = 0;
        String string = null;
        do {
            int n2 = table.getColumnNr(this.tokenizer.getName());
            String string2 = this.tokenizer.getLongNameFirst();
            if (string2 != null && !tableFilter.getName().equals(string2)) {
                throw Trace.error(22);
            }
            this.tokenizer.getThis("=");
            Expression expression = this.parseExpression();
            if (n == nArray.length) {
                throw Trace.error(5);
            }
            nArray[n] = n2;
            expressionArray[n] = expression;
            string = this.tokenizer.getSimpleToken();
            ++n;
        } while (string.equals(","));
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        nArray = (int[])ArrayUtil.resizeArray(nArray, n);
        expressionArray = (Expression[])ArrayUtil.resizeArray(expressionArray, n);
        CompiledStatement compiledStatement = new CompiledStatement(this.session, this.database, this.session.currentSchema, tableFilter, nArray, expressionArray, expression, this.getSortedSubqueries(), this.getParameters());
        return compiledStatement;
    }

    int parseOpenBracketsSelect() throws HsqlException {
        int n = this.parseOpenBrackets();
        this.tokenizer.getThis("SELECT");
        return n;
    }

    int parseOpenBrackets() throws HsqlException {
        int n = 0;
        while (this.tokenizer.isGetThis("(")) {
            ++n;
        }
        return n;
    }

    int parseCloseBrackets(int n) throws HsqlException {
        int n2 = 0;
        while (n2 < n && this.tokenizer.isGetThis(")")) {
            ++n2;
        }
        return n2;
    }

    HashMappedList parseColumnList() throws HsqlException {
        return Parser.processColumnList(this.tokenizer, false);
    }

    static HashMappedList processColumnList(Tokenizer tokenizer, boolean bl) throws HsqlException {
        String string;
        HashMappedList hashMappedList = new HashMappedList();
        tokenizer.getThis("(");
        do {
            boolean bl2;
            if (!(bl2 = hashMappedList.add(string = tokenizer.getSimpleName(), null))) {
                throw Trace.error(27, string);
            }
            string = tokenizer.getSimpleToken();
            if (!bl || !string.equals("DESC") && !string.equals("ASC")) continue;
            string = tokenizer.getSimpleToken();
        } while (string.equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        return hashMappedList;
    }

    static {
        simpleFunctions.put("CURRENT_DATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("CURRENT_TIME", "org.hsqldb.Library.curtime");
        simpleFunctions.put("CURRENT_TIMESTAMP", "org.hsqldb.Library.now");
        simpleFunctions.put("CURRENT_USER", "org.hsqldb.Library.user");
        simpleFunctions.put("SYSDATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("NOW", "org.hsqldb.Library.now");
        simpleFunctions.put("TODAY", "org.hsqldb.Library.curdate");
        tokenSet = new IntValueHashMap(37);
        tokenSet.put(",", 104);
        tokenSet.put("=", 21);
        tokenSet.put("!=", 26);
        tokenSet.put("<>", 26);
        tokenSet.put("<", 24);
        tokenSet.put(">", 23);
        tokenSet.put("<=", 25);
        tokenSet.put(">=", 22);
        tokenSet.put("AND", 28);
        tokenSet.put("NOT", 20);
        tokenSet.put("OR", 29);
        tokenSet.put("ALL", 32);
        tokenSet.put("ANY", 33);
        tokenSet.put("IN", 30);
        tokenSet.put("EXISTS", 31);
        tokenSet.put("BETWEEN", 106);
        tokenSet.put("+", 100);
        tokenSet.put("-", 10);
        tokenSet.put("*", 13);
        tokenSet.put("/", 14);
        tokenSet.put("||", 15);
        tokenSet.put("(", 101);
        tokenSet.put(")", 102);
        tokenSet.put("SELECT", 103);
        tokenSet.put("LIKE", 27);
        tokenSet.put("COUNT", 40);
        tokenSet.put("SUM", 41);
        tokenSet.put("MIN", 42);
        tokenSet.put("MAX", 43);
        tokenSet.put("AVG", 44);
        tokenSet.put("EVERY", 45);
        tokenSet.put("SOME", 46);
        tokenSet.put("STDDEV_POP", 47);
        tokenSet.put("STDDEV_SAMP", 48);
        tokenSet.put("VAR_POP", 49);
        tokenSet.put("VAR_SAMP", 50);
        tokenSet.put("IFNULL", 60);
        tokenSet.put("NVL", 60);
        tokenSet.put("NULLIF", 67);
        tokenSet.put("CONVERT", 61);
        tokenSet.put("CAST", 107);
        tokenSet.put("NEXT", 71);
        tokenSet.put("CASE", 68);
        tokenSet.put("WHEN", 110);
        tokenSet.put("THEN", 111);
        tokenSet.put("ELSE", 112);
        tokenSet.put("END", 113);
        tokenSet.put("CASEWHEN", 62);
        tokenSet.put("COALESCE", 69);
        tokenSet.put("EXTRACT", 63);
        tokenSet.put("POSITION", 64);
        tokenSet.put("FROM", 124);
        tokenSet.put("TRIM", 65);
        tokenSet.put("SUBSTRING", 66);
        tokenSet.put("FOR", 123);
        tokenSet.put("AS", 122);
        tokenSet.put("IS", 109);
        tokenSet.put("?", 9);
        noParameters = new Expression[0];
        noSubqueries = new SubQuery[0];
    }
}

