/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.Collation;
import org.hsqldb.Constraint;
import org.hsqldb.DINameSpace;
import org.hsqldb.DIProcedureInfo;
import org.hsqldb.DITypeInfo;
import org.hsqldb.Database;
import org.hsqldb.DatabaseInformationMain;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.Grantee;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.TextCache;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.store.ValuePool;

final class DatabaseInformationFull
extends DatabaseInformationMain {
    protected DIProcedureInfo pi;

    DatabaseInformationFull(Database database) throws HsqlException {
        super(database);
        this.pi = new DIProcedureInfo(this.ns);
    }

    protected Table generateTable(int n) throws HsqlException {
        switch (n) {
            case 7: {
                return this.SYSTEM_PROCEDURECOLUMNS();
            }
            case 8: {
                return this.SYSTEM_PROCEDURES();
            }
            case 10: {
                return this.SYSTEM_SUPERTABLES();
            }
            case 11: {
                return this.SYSTEM_SUPERTYPES();
            }
            case 16: {
                return this.SYSTEM_UDTATTRIBUTES();
            }
            case 17: {
                return this.SYSTEM_UDTS();
            }
            case 19: {
                return this.SYSTEM_VERSIONCOLUMNS();
            }
            case 20: {
                return this.SYSTEM_ALIASES();
            }
            case 22: {
                return this.SYSTEM_CACHEINFO();
            }
            case 23: {
                return this.SYSTEM_CLASSPRIVILEGES();
            }
            case 24: {
                return this.SYSTEM_SESSIONINFO();
            }
            case 25: {
                return this.SYSTEM_PROPERTIES();
            }
            case 26: {
                return this.SYSTEM_SESSIONS();
            }
            case 27: {
                return this.SYSTEM_TRIGGERCOLUMNS();
            }
            case 28: {
                return this.SYSTEM_TRIGGERS();
            }
            case 30: {
                return this.SYSTEM_VIEWS();
            }
            case 31: {
                return this.SYSTEM_TEXTTABLES();
            }
            case 33: {
                return this.SYSTEM_USAGE_PRIVILEGES();
            }
            case 36: {
                return this.SYSTEM_CHECK_COLUMN_USAGE();
            }
            case 37: {
                return this.SYSTEM_CHECK_ROUTINE_USAGE();
            }
            case 38: {
                return this.SYSTEM_CHECK_TABLE_USAGE();
            }
            case 35: {
                return this.SYSTEM_TABLE_CONSTRAINTS();
            }
            case 40: {
                return this.SYSTEM_VIEW_TABLE_USAGE();
            }
            case 39: {
                return this.SYSTEM_VIEW_COLUMN_USAGE();
            }
            case 41: {
                return this.SYSTEM_VIEW_ROUTINE_USAGE();
            }
            case 42: {
                return this.SYSTEM_AUTHORIZATIONS();
            }
            case 44: {
                return this.SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS();
            }
            case 45: {
                return this.SYSTEM_SCHEMATA();
            }
            case 43: {
                return this.SYSTEM_COLLATIONS();
            }
        }
        return super.generateTable(n);
    }

    Table SYSTEM_ALIASES() throws HsqlException {
        String string;
        String string2;
        String string3;
        String string4;
        Object[] objectArray;
        Table table = this.sysTables[20];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[20]);
            this.addColumn(table, "OBJECT_TYPE", 12, 32, false);
            this.addColumn(table, "OBJECT_CAT", 12);
            this.addColumn(table, "OBJECT_SCHEM", 12);
            this.addColumn(table, "OBJECT_NAME", 12, false);
            this.addColumn(table, "ALIAS_CAT", 12);
            this.addColumn(table, "ALIAS_SCHEM", 12);
            this.addColumn(table, "ALIAS", 12, false);
            table.createPrimaryKey(null, new int[]{0, 3, 6}, true);
            return table;
        }
        HashMap hashMap = this.database.getAliasMap();
        Iterator iterator = hashMap.keySet().iterator();
        String string5 = "ROUTINE";
        while (iterator.hasNext()) {
            String string6;
            objectArray = table.getEmptyRowData();
            string4 = (String)iterator.next();
            string3 = (String)hashMap.get(string4);
            int n = string3.lastIndexOf(46);
            if (n <= 0 || !this.session.isAccessible(string6 = string3.substring(0, n))) continue;
            string2 = this.ns.getCatalogName(string3);
            string = this.ns.getSchemaName(string6);
            objectArray[0] = string5;
            objectArray[1] = string2;
            objectArray[2] = string;
            objectArray[3] = string3;
            objectArray[4] = string2;
            objectArray[5] = string;
            objectArray[6] = string4;
            table.insertSys(objectArray);
        }
        if (this.session.isAdmin()) {
            Iterator iterator2 = Types.typeAliases.keySet().iterator();
            string5 = "DOMAIN";
            while (iterator2.hasNext()) {
                int n;
                objectArray = table.getEmptyRowData();
                string4 = (String)iterator2.next();
                if (string4.equals(string3 = Types.getTypeString(n = Types.typeAliases.get((Object)string4, Integer.MIN_VALUE)))) continue;
                string2 = this.ns.getCatalogName(string3);
                string = this.ns.getSchemaName(string3);
                objectArray[0] = string5;
                objectArray[1] = string2;
                objectArray[2] = string;
                objectArray[3] = string3;
                objectArray[4] = string2;
                objectArray[5] = string;
                objectArray[6] = string4;
                table.insertSys(objectArray);
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_CACHEINFO() throws HsqlException {
        DataFileCache dataFileCache;
        Table table = this.sysTables[22];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[22]);
            this.addColumn(table, "CACHE_FILE", 12, false);
            this.addColumn(table, "MAX_CACHE_COUNT", 4, false);
            this.addColumn(table, "MAX_CACHE_BYTES", -5, false);
            this.addColumn(table, "CACHE_SIZE", 4, false);
            this.addColumn(table, "CACHE_BYTES", -5, false);
            this.addColumn(table, "FILE_FREE_BYTES", 4, false);
            this.addColumn(table, "FILE_FREE_COUNT", 4, false);
            this.addColumn(table, "FILE_FREE_POS", -5, false);
            table.createPrimaryKey(null, new int[]{0}, true);
            return table;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isFileBased() || !this.isAccessibleTable(table2) || (dataFileCache = table2.getCache()) == null) continue;
            hashSet.add(dataFileCache);
        }
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            dataFileCache = (DataFileCache)iterator2.next();
            Object[] objectArray = table.getEmptyRowData();
            boolean bl = false;
            objectArray[0] = FileUtil.canonicalOrAbsolutePath(dataFileCache.getFileName());
            objectArray[1] = ValuePool.getInt(dataFileCache.capacity());
            objectArray[2] = ValuePool.getLong(dataFileCache.bytesCapacity());
            objectArray[3] = ValuePool.getInt(dataFileCache.getCachedObjectCount());
            objectArray[4] = ValuePool.getLong(dataFileCache.getTotalCachedBlockSize());
            objectArray[5] = ValuePool.getInt(dataFileCache.getTotalFreeBlockSize());
            objectArray[6] = ValuePool.getInt(dataFileCache.getFreeBlockCount());
            objectArray[7] = ValuePool.getLong(dataFileCache.getFileFreePos());
            table.insertSys(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_CLASSPRIVILEGES() throws HsqlException {
        Table table = this.sysTables[23];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[23]);
            this.addColumn(table, "CLASS_CAT", 12);
            this.addColumn(table, "CLASS_SCHEM", 12);
            this.addColumn(table, "CLASS_NAME", 12, false);
            this.addColumn(table, "GRANTOR", 12, false);
            this.addColumn(table, "GRANTEE", 12, false);
            this.addColumn(table, "PRIVILEGE", 12, 7, false);
            this.addColumn(table, "IS_GRANTABLE", 12, 3, false);
            table.createPrimaryKey(null, new int[]{2, 4, 5}, true);
            return table;
        }
        String string = "DBA";
        UserManager userManager = this.database.getUserManager();
        HsqlArrayList hsqlArrayList = userManager.listVisibleUsers(this.session, true);
        int n = 0;
        while (n < hsqlArrayList.size()) {
            Object[] objectArray;
            String string2;
            String string3;
            String string4;
            User user = (User)hsqlArrayList.get(n);
            String string5 = user.getName();
            String string6 = user.isAdmin() ? "YES" : "NO";
            HashSet hashSet = user.getGrantedClassNames(false);
            if (user.isPublic()) {
                this.ns.addBuiltinToSet(hashSet);
            }
            Iterator iterator = hashSet.iterator();
            String string7 = "EXECUTE";
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                string3 = this.ns.getCatalogName(string4);
                string2 = this.ns.getSchemaName(string4);
                objectArray = table.getEmptyRowData();
                objectArray[0] = string3;
                objectArray[1] = string2;
                objectArray[2] = string4;
                objectArray[3] = string;
                objectArray[4] = string5;
                objectArray[5] = string7;
                objectArray[6] = string6;
                table.insertSys(objectArray);
            }
            iterator = this.ns.iterateAccessibleTriggerClassNames(user);
            string7 = "TRIGGER";
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                string3 = this.ns.getCatalogName(string4);
                string2 = this.ns.getSchemaName(string4);
                objectArray = table.getEmptyRowData();
                objectArray[0] = string3;
                objectArray[1] = string2;
                objectArray[2] = string4;
                objectArray[3] = string;
                objectArray[4] = string5;
                objectArray[5] = string7;
                objectArray[6] = string6;
                table.insertSys(objectArray);
            }
            ++n;
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_SESSIONINFO() throws HsqlException {
        Table table = this.sysTables[24];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[24]);
            this.addColumn(table, "KEY", 12, false);
            this.addColumn(table, "VALUE", 12, false);
            table.createPrimaryKey(null);
            return table;
        }
        Object[] objectArray = table.getEmptyRowData();
        objectArray[0] = "SESSION_ID";
        objectArray[1] = String.valueOf(this.session.getId());
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "AUTOCOMMIT";
        objectArray[1] = this.session.isAutoCommit() ? "TRUE" : "FALSE";
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "USER";
        objectArray[1] = this.session.getUsername();
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "SESSION_READONLY";
        objectArray[1] = this.session.isReadOnly() ? "TRUE" : "FALSE";
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "DATABASE_READONLY";
        objectArray[1] = this.database.databaseReadOnly ? "TRUE" : "FALSE";
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "MAXROWS";
        objectArray[1] = String.valueOf(this.session.getSQLMaxRows());
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "DATABASE";
        objectArray[1] = this.database.getURI();
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "IDENTITY";
        objectArray[1] = String.valueOf(this.session.getLastIdentity());
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "SCHEMA";
        objectArray[1] = String.valueOf(this.session.getSchemaName(null));
        table.insertSys(objectArray);
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_PROPERTIES() throws HsqlException {
        Object[] objectArray;
        String string;
        Table table = this.sysTables[25];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[25]);
            this.addColumn(table, "PROPERTY_SCOPE", 12, false);
            this.addColumn(table, "PROPERTY_NAMESPACE", 12, false);
            this.addColumn(table, "PROPERTY_NAME", 12, false);
            this.addColumn(table, "PROPERTY_VALUE", 12);
            this.addColumn(table, "PROPERTY_CLASS", 12, false);
            table.createPrimaryKey(null, new int[]{0, 1, 2}, true);
            return table;
        }
        String string2 = "SESSION";
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        String string3 = "database.properties";
        Iterator iterator = hsqlDatabaseProperties.getBooleanPropertyNames().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            objectArray = table.getEmptyRowData();
            objectArray[0] = string2;
            objectArray[1] = string3;
            objectArray[2] = string;
            objectArray[3] = hsqlDatabaseProperties.getProperty(string, "false");
            objectArray[4] = "boolean";
            table.insertSys(objectArray);
        }
        iterator = hsqlDatabaseProperties.getIntegralPropertyNames().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            objectArray = table.getEmptyRowData();
            objectArray[0] = string2;
            objectArray[1] = string3;
            objectArray[2] = string;
            objectArray[3] = hsqlDatabaseProperties.getProperty(string, "0");
            objectArray[4] = "int";
            table.insertSys(objectArray);
        }
        iterator = hsqlDatabaseProperties.getStringPropertyNames().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            objectArray = table.getEmptyRowData();
            objectArray[0] = string2;
            objectArray[1] = string3;
            objectArray[2] = string;
            objectArray[3] = hsqlDatabaseProperties.getProperty(string, "");
            objectArray[4] = "java.lang.String";
            table.insertSys(objectArray);
        }
        objectArray = table.getEmptyRowData();
        objectArray[0] = string2;
        objectArray[1] = string3;
        objectArray[2] = "SCRIPTFORMAT";
        try {
            objectArray[3] = ScriptWriterBase.LIST_SCRIPT_FORMATS[this.database.logger.getScriptType()];
        }
        catch (Exception exception) {
            // empty catch block
        }
        objectArray[4] = "java.lang.String";
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = string2;
        objectArray[1] = string3;
        objectArray[2] = "WRITE_DELAY";
        objectArray[3] = "" + this.database.logger.getWriteDelay();
        objectArray[4] = "int";
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = string2;
        objectArray[1] = string3;
        objectArray[2] = "IGNORECASE";
        objectArray[3] = this.database.isIgnoreCase() ? "true" : "false";
        objectArray[4] = "boolean";
        table.insertSys(objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = string2;
        objectArray[1] = string3;
        objectArray[2] = "REFERENTIAL_INTEGRITY";
        objectArray[3] = this.database.isReferentialIntegrity() ? "true" : "false";
        objectArray[4] = "boolean";
        table.insertSys(objectArray);
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_SESSIONS() throws HsqlException {
        Table table = this.sysTables[26];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[26]);
            this.addColumn(table, "SESSION_ID", 4, false);
            this.addColumn(table, "CONNECTED", 93, false);
            this.addColumn(table, "USER_NAME", 12, false);
            this.addColumn(table, "IS_ADMIN", 16, false);
            this.addColumn(table, "AUTOCOMMIT", 16, false);
            this.addColumn(table, "READONLY", 16, false);
            this.addColumn(table, "MAXROWS", 4, false);
            this.addColumn(table, "LAST_IDENTITY", -5);
            this.addColumn(table, "TRANSACTION_SIZE", 4, false);
            this.addColumn(table, "SCHEMA", 12, false);
            table.createPrimaryKey(null, new int[]{0}, true);
            return table;
        }
        Session[] sessionArray = this.ns.listVisibleSessions(this.session);
        int n = 0;
        while (n < sessionArray.length) {
            Session session = sessionArray[n];
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = ValuePool.getInt(session.getId());
            objectArray[1] = HsqlDateTime.getTimestamp(session.getConnectTime());
            objectArray[2] = session.getUsername();
            objectArray[3] = ValuePool.getBoolean(session.isAdmin());
            objectArray[4] = ValuePool.getBoolean(session.isAutoCommit());
            objectArray[5] = ValuePool.getBoolean(session.isReadOnly());
            objectArray[6] = ValuePool.getInt(session.getSQLMaxRows());
            objectArray[7] = ValuePool.getLong(session.getLastIdentity().longValue());
            objectArray[8] = ValuePool.getInt(session.getTransactionSize());
            objectArray[9] = session.getSchemaName(null);
            table.insertSys(objectArray);
            ++n;
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_SUPERTABLES() throws HsqlException {
        Table table = this.sysTables[10];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[10]);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "SUPERTABLE_NAME", 12, false);
            table.createPrimaryKey(null);
            return table;
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_SUPERTYPES() throws HsqlException {
        Table table = this.sysTables[11];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[11]);
            this.addColumn(table, "TYPE_CAT", 12);
            this.addColumn(table, "TYPE_SCHEM", 12);
            this.addColumn(table, "TYPE_NAME", 12, false);
            this.addColumn(table, "SUPERTYPE_CAT", 12);
            this.addColumn(table, "SUPERTYPE_SCHEM", 12);
            this.addColumn(table, "SUPERTYPE_NAME", 12, false);
            table.createPrimaryKey(null);
            return table;
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_TEXTTABLES() throws HsqlException {
        Table table = this.sysTables[31];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[31]);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "DATA_SOURCE_DEFINTION", 12);
            this.addColumn(table, "FILE_PATH", 12);
            this.addColumn(table, "FILE_ENCODING", 12);
            this.addColumn(table, "FIELD_SEPARATOR", 12);
            this.addColumn(table, "VARCHAR_SEPARATOR", 12);
            this.addColumn(table, "LONGVARCHAR_SEPARATOR", 12);
            this.addColumn(table, "IS_IGNORE_FIRST", 16);
            this.addColumn(table, "IS_ALL_QUOTED", 16);
            this.addColumn(table, "IS_QUOTED", 16);
            this.addColumn(table, "IS_DESC", 16);
            table.createPrimaryKey();
            return table;
        }
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isText() || !this.isAccessibleTable(table2)) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.ns.getCatalogName(table2);
            objectArray[1] = table2.getSchemaName();
            objectArray[2] = table2.getName().name;
            if (table2.getCache() != null && table2.getCache() instanceof TextCache) {
                TextCache textCache = (TextCache)table2.getCache();
                objectArray[3] = table2.getDataSource();
                objectArray[4] = FileUtil.canonicalOrAbsolutePath(textCache.getFileName());
                objectArray[5] = textCache.stringEncoding;
                objectArray[6] = textCache.fs;
                objectArray[7] = textCache.vs;
                objectArray[8] = textCache.lvs;
                objectArray[9] = ValuePool.getBoolean(textCache.ignoreFirst);
                objectArray[10] = ValuePool.getBoolean(textCache.isQuoted);
                objectArray[11] = ValuePool.getBoolean(textCache.isAllQuoted);
                objectArray[12] = ValuePool.getBoolean(table2.isDescDataSource());
            }
            table.insertSys(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_TRIGGERCOLUMNS() throws HsqlException {
        Table table = this.sysTables[27];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[27]);
            this.addColumn(table, "TRIGGER_CAT", 12);
            this.addColumn(table, "TRIGGER_SCHEM", 12);
            this.addColumn(table, "TRIGGER_NAME", 12);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12);
            this.addColumn(table, "COLUMN_NAME", 12);
            this.addColumn(table, "COLUMN_LIST", 12);
            this.addColumn(table, "COLUMN_USAGE", 12);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}, false);
            return table;
        }
        Result result = this.session.sqlExecuteDirectNoPreChecks("select a.TRIGGER_CAT,a.TRIGGER_SCHEM,a.TRIGGER_NAME, a.TABLE_CAT,a.TABLE_SCHEM,a.TABLE_NAME,b.COLUMN_NAME,'Y','IN' from INFORMATION_SCHEMA.SYSTEM_TRIGGERS a, INFORMATION_SCHEMA.SYSTEM_COLUMNS b where a.TABLE_NAME=b.TABLE_NAME and a.TABLE_SCHEMA=b.TABLE_SCHEMA");
        table.insertSys(result);
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_TRIGGERS() throws HsqlException {
        Table table = this.sysTables[28];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[28]);
            this.addColumn(table, "TRIGGER_CAT", 12);
            this.addColumn(table, "TRIGGER_SCHEM", 12);
            this.addColumn(table, "TRIGGER_NAME", 12, false);
            this.addColumn(table, "TRIGGER_TYPE", 12, 15, false);
            this.addColumn(table, "TRIGGERING_EVENT", 12, 10, false);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "BASE_OBJECT_TYPE", 12, 8, false);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "COLUMN_NAME", 12);
            this.addColumn(table, "REFERENCING_NAMES", 12, false);
            this.addColumn(table, "WHEN_CLAUSE", 12);
            this.addColumn(table, "STATUS", 12, 8, false);
            this.addColumn(table, "DESCRIPTION", 12, false);
            this.addColumn(table, "ACTION_TYPE", 12, false);
            this.addColumn(table, "TRIGGER_BODY", 12, false);
            table.createPrimaryKey(null, new int[]{3, 1, 2, 0}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        String string = "CALL";
        String string2 = "TABLE";
        Object var11_5 = null;
        String string3 = "ROW";
        Object var13_7 = null;
        while (iterator.hasNext()) {
            String string4;
            String string5;
            Table table2 = (Table)iterator.next();
            HsqlArrayList[] hsqlArrayListArray = table2.triggerLists;
            if (hsqlArrayListArray == null || !this.isAccessibleTable(table2)) continue;
            String string6 = string5 = this.ns.getCatalogName(table2);
            String string7 = string4 = table2.getSchemaName();
            String string8 = table2.getName().name;
            int n = 0;
            while (n < hsqlArrayListArray.length) {
                HsqlArrayList hsqlArrayList = hsqlArrayListArray[n];
                if (hsqlArrayList != null) {
                    int n2 = 0;
                    while (n2 < hsqlArrayList.size()) {
                        TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n2);
                        if (triggerDef != null) {
                            String string9 = triggerDef.name.name;
                            String string10 = triggerDef.getDDL().toString();
                            String string11 = triggerDef.valid ? "ENABLED" : "DISABLED";
                            String string12 = triggerDef.triggerClassName;
                            String string13 = triggerDef.when;
                            if (triggerDef.forEachRow) {
                                string13 = string13 + " EACH ROW";
                            }
                            String string14 = triggerDef.operation;
                            Object[] objectArray = table.getEmptyRowData();
                            objectArray[0] = string6;
                            objectArray[1] = string7;
                            objectArray[2] = string9;
                            objectArray[3] = string13;
                            objectArray[4] = string14;
                            objectArray[5] = string5;
                            objectArray[6] = string4;
                            objectArray[7] = string2;
                            objectArray[8] = string8;
                            objectArray[9] = var11_5;
                            objectArray[10] = string3;
                            objectArray[11] = var13_7;
                            objectArray[12] = string11;
                            objectArray[13] = string10;
                            objectArray[14] = string;
                            objectArray[15] = string12;
                            table.insertSys(objectArray);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_UDTATTRIBUTES() throws HsqlException {
        Table table = this.sysTables[16];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[16]);
            this.addColumn(table, "TYPE_CAT", 12);
            this.addColumn(table, "TYPE_SCHEM", 12);
            this.addColumn(table, "TYPE_NAME", 12, false);
            this.addColumn(table, "ATTR_NAME", 12, false);
            this.addColumn(table, "DATA_TYPE", 5, false);
            this.addColumn(table, "ATTR_TYPE_NAME", 12, false);
            this.addColumn(table, "ATTR_SIZE", 4);
            this.addColumn(table, "DECIMAL_DIGITS", 4);
            this.addColumn(table, "NUM_PREC_RADIX", 4);
            this.addColumn(table, "NULLABLE", 4);
            this.addColumn(table, "REMARKS", 12);
            this.addColumn(table, "ATTR_DEF", 12);
            this.addColumn(table, "SQL_DATA_TYPE", 4);
            this.addColumn(table, "SQL_DATETIME_SUB", 4);
            this.addColumn(table, "CHAR_OCTET_LENGTH", 4);
            this.addColumn(table, "ORDINAL_POSITION", 4, false);
            this.addColumn(table, "IS_NULLABLE", 12, false);
            this.addColumn(table, "SCOPE_CATALOG", 12);
            this.addColumn(table, "SCOPE_SCHEMA", 12);
            this.addColumn(table, "SCOPE_TABLE", 12);
            this.addColumn(table, "SOURCE_DATA_TYPE", 5);
            table.createPrimaryKey(null);
            return table;
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_UDTS() throws HsqlException {
        Table table = this.sysTables[17];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[17]);
            this.addColumn(table, "TYPE_CAT", 12);
            this.addColumn(table, "TYPE_SCHEM", 12);
            this.addColumn(table, "TYPE_NAME", 12, false);
            this.addColumn(table, "CLASS_NAME", 12, false);
            this.addColumn(table, "DATA_TYPE", 12, false);
            this.addColumn(table, "REMARKS", 12);
            this.addColumn(table, "BASE_TYPE", 5);
            table.createPrimaryKey(null);
            return table;
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_VERSIONCOLUMNS() throws HsqlException {
        Table table = this.sysTables[19];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[19]);
            this.addColumn(table, "SCOPE", 4);
            this.addColumn(table, "COLUMN_NAME", 12, false);
            this.addColumn(table, "DATA_TYPE", 5, false);
            this.addColumn(table, "TYPE_NAME", 12, false);
            this.addColumn(table, "COLUMN_SIZE", 5);
            this.addColumn(table, "BUFFER_LENGTH", 4);
            this.addColumn(table, "DECIMAL_DIGITS", 5);
            this.addColumn(table, "PSEUDO_COLUMN", 5, false);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            table.createPrimaryKey(null);
            return table;
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_VIEWS() throws HsqlException {
        Table table = this.sysTables[30];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[30]);
            this.addColumn(table, "TABLE_CATALOG", 12);
            this.addColumn(table, "TABLE_SCHEMA", 12);
            this.addColumn(table, "TABLE_NAME", 12, true);
            this.addColumn(table, "VIEW_DEFINITION", 12, true);
            this.addColumn(table, "CHECK_OPTION", 12, 8, true);
            this.addColumn(table, "IS_UPDATABLE", 12, 3, true);
            this.addColumn(table, "VALID", 16, true);
            table.createPrimaryKey(null, new int[]{1, 2, 0}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isView() || !this.isAccessibleTable(table2)) continue;
            Object[] objectArray = table.getEmptyRowData();
            String string = ((View)table2).getStatement();
            objectArray[0] = this.ns.getCatalogName(table2);
            objectArray[1] = table2.getSchemaName();
            objectArray[2] = table2.getName().name;
            objectArray[3] = string;
            objectArray[4] = "NONE";
            objectArray[5] = "NO";
            objectArray[6] = Boolean.TRUE;
            table.insertSys(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_PROCEDURECOLUMNS() throws HsqlException {
        Table table = this.sysTables[7];
        if (table == null) {
            return super.SYSTEM_PROCEDURECOLUMNS();
        }
        Iterator iterator = this.ns.iterateAllAccessibleMethods(this.session, true);
        DITypeInfo dITypeInfo = new DITypeInfo();
        dITypeInfo.setTypeSub(1);
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            Method method = (Method)objectArray[0];
            HsqlArrayList hsqlArrayList = (HsqlArrayList)objectArray[1];
            String string = this.ns.getCatalogName(method);
            String string2 = this.ns.getSchemaName(method);
            this.pi.setMethod(method);
            String string3 = this.pi.getSpecificName();
            String string4 = this.pi.getFQN();
            int n = this.pi.getColCount();
            int n2 = 0;
            while (n2 < n) {
                dITypeInfo.setTypeCode(this.pi.getColTypeCode(n2));
                String string5 = this.pi.getColName(n2);
                Integer n3 = this.pi.getColUsage(n2);
                Integer n4 = this.pi.getColDataType(n2);
                String string6 = dITypeInfo.getTypeName();
                Integer n5 = dITypeInfo.getPrecision();
                Integer n6 = this.pi.getColLen(n2);
                Integer n7 = dITypeInfo.getDefaultScale();
                Integer n8 = dITypeInfo.getNumPrecRadix();
                Integer n9 = this.pi.getColNullability(n2);
                String string7 = this.pi.getColRemark(n2);
                int n10 = this.pi.getColSequence(n2);
                this.addPColRows(table, hsqlArrayList, string, string2, string4, string5, n3, n4, string6, n5, n6, n7, n8, n9, string7, string3, n10);
                ++n2;
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_PROCEDURES() throws HsqlException {
        Table table = this.sysTables[8];
        if (table == null) {
            return super.SYSTEM_PROCEDURES();
        }
        Iterator iterator = this.ns.iterateAllAccessibleMethods(this.session, true);
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            Method method = (Method)objectArray[0];
            HsqlArrayList hsqlArrayList = (HsqlArrayList)objectArray[1];
            String string = (String)objectArray[2];
            this.pi.setMethod(method);
            String string2 = this.ns.getCatalogName(method);
            String string3 = this.ns.getSchemaName(method);
            String string4 = this.pi.getFQN();
            Integer n = this.pi.getInputParmCount();
            Integer n2 = this.pi.getOutputParmCount();
            Integer n3 = this.pi.getResultSetCount();
            String string5 = this.pi.getRemark();
            Integer n4 = this.pi.getResultType(string);
            String string6 = this.pi.getOrigin(string);
            String string7 = this.pi.getSpecificName();
            this.addProcRows(table, hsqlArrayList, string2, string3, string4, n, n2, n3, string5, n4, string6, string7);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_USAGE_PRIVILEGES() throws HsqlException {
        Table table = this.sysTables[33];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[33]);
            this.addColumn(table, "GRANTOR", 12, false);
            this.addColumn(table, "GRANTEE", 12, false);
            this.addColumn(table, "OBJECT_CATALOG", 12);
            this.addColumn(table, "OBJECT_SCHEMA", 12);
            this.addColumn(table, "OBJECT_NAME", 12, false);
            this.addColumn(table, "OBJECT_TYPE", 12, 32, false);
            this.addColumn(table, "IS_GRANTABLE", 12, 3, false);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Result result = this.session.sqlExecuteDirectNoPreChecks("SELECT '_SYSTEM', 'PUBLIC', SEQUENCE_CATALOG, SEQUENCE_SCHEMA, SEQUENCE_NAME, 'SEQUENCE', 'FALSE' FROM  INFORMATION_SCHEMA.SYSTEM_SEQUENCES");
        table.insertSys(result);
        result = this.session.sqlExecuteDirectNoPreChecks("SELECT '_SYSTEM', 'PUBLIC', COLLATION_CATALOG, COLLATION_SCHEMA, COLLATION_NAME, 'COLLATION', 'FALSE' FROM  INFORMATION_SCHEMA.SYSTEM_COLLATIONS");
        table.insertSys(result);
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_CHECK_COLUMN_USAGE() throws HsqlException {
        Table table = this.sysTables[36];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[36]);
            this.addColumn(table, "CONSTRAINT_CATALOG", 12);
            this.addColumn(table, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(table, "CONSTRAINT_NAME", 12, false);
            this.addColumn(table, "TABLE_CATALOG", 12);
            this.addColumn(table, "TABLE_SCHEMA", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "COLUMN_NAME", 12, false);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        Expression.Collector collector = new Expression.Collector();
        Result result = new Result(3, 4);
        result.metaData.colTypes[3] = 12;
        result.metaData.colTypes[2] = 12;
        result.metaData.colTypes[1] = 12;
        result.metaData.colTypes[0] = 12;
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!this.isAccessibleTable(table2)) continue;
            Constraint[] constraintArray = table2.getConstraints();
            int n = constraintArray.length;
            String string = this.ns.getCatalogName(table2);
            String string2 = table2.getSchemaName();
            int n2 = 0;
            while (n2 < n) {
                Constraint constraint = constraintArray[n2];
                if (constraint.getType() == 3) {
                    String string3 = constraint.getName().name;
                    result.setRows(null);
                    collector.clear();
                    collector.addAll(constraint.core.check, 2);
                    Iterator iterator2 = collector.iterator();
                    while (iterator2.hasNext()) {
                        Expression expression = (Expression)iterator2.next();
                        TableFilter tableFilter = expression.getFilter();
                        Table table3 = tableFilter.getTable();
                        if (table3.getTableType() == 1 || !this.isAccessibleTable(table3)) continue;
                        result.add(new Object[]{this.ns.getCatalogName(table3), table3.getSchemaName(), table3.getName().name, expression.getColumnName()});
                    }
                    result.removeDuplicates(this.session);
                    iterator2 = result.iterator();
                    while (iterator2.hasNext()) {
                        Object[] objectArray = table.getEmptyRowData();
                        Object[] objectArray2 = (Object[])iterator2.next();
                        objectArray[0] = string;
                        objectArray[1] = string2;
                        objectArray[2] = string3;
                        objectArray[3] = objectArray2[0];
                        objectArray[4] = objectArray2[1];
                        objectArray[5] = objectArray2[2];
                        objectArray[6] = objectArray2[3];
                        table.insertSys(objectArray);
                    }
                }
                ++n2;
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_CHECK_ROUTINE_USAGE() throws HsqlException {
        Table table = this.sysTables[37];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[37]);
            this.addColumn(table, "CONSTRAINT_CATALOG", 12);
            this.addColumn(table, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(table, "CONSTRAINT_NAME", 12, false);
            this.addColumn(table, "SPECIFIC_CATALOG", 12);
            this.addColumn(table, "SPECIFIC_SCHEMA", 12);
            this.addColumn(table, "SPECIFIC_NAME", 12, false);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        Expression.Collector collector = new Expression.Collector();
        while (iterator.hasNext()) {
            collector.clear();
            Table table2 = (Table)iterator.next();
            if (!this.isAccessibleTable(table2)) continue;
            Constraint[] constraintArray = table2.getConstraints();
            int n = constraintArray.length;
            String string = this.ns.getCatalogName(table2);
            String string2 = table2.getSchemaName();
            int n2 = 0;
            while (n2 < n) {
                Constraint constraint = constraintArray[n2];
                if (constraint.getType() == 3) {
                    String string3 = constraint.getName().name;
                    collector.addAll(constraint.core.check, 7);
                    HashSet hashSet = new HashSet();
                    Iterator iterator2 = collector.iterator();
                    while (iterator2.hasNext()) {
                        Expression expression = (Expression)iterator2.next();
                        Function function = expression.function;
                        if (!this.session.isAccessible(function.getMethod().getDeclaringClass().getName())) continue;
                        hashSet.add(function.getMethod());
                    }
                    iterator2 = hashSet.iterator();
                    while (iterator2.hasNext()) {
                        Method method = (Method)iterator2.next();
                        Object[] objectArray = table.getEmptyRowData();
                        objectArray[0] = string;
                        objectArray[1] = string2;
                        objectArray[2] = string3;
                        objectArray[3] = this.ns.getCatalogName(method);
                        objectArray[4] = this.ns.getSchemaName(method);
                        objectArray[5] = DINameSpace.getMethodSpecificName(method);
                        table.insertSys(objectArray);
                    }
                }
                ++n2;
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_CHECK_TABLE_USAGE() throws HsqlException {
        Table table = this.sysTables[38];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[38]);
            this.addColumn(table, "CONSTRAINT_CATALOG", 12);
            this.addColumn(table, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(table, "CONSTRAINT_NAME", 12, false);
            this.addColumn(table, "TABLE_CATALOG", 12);
            this.addColumn(table, "TABLE_SCHEMA", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Result result = this.session.sqlExecuteDirectNoPreChecks("select DISTINCT CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, CONSTRAINT_NAME, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_CHECK_COLUMN_USAGE");
        table.insertSys(result);
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_TABLE_CONSTRAINTS() throws HsqlException {
        Constraint constraint;
        String string;
        String string2;
        Object[] objectArray;
        Table table = this.sysTables[35];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[35]);
            this.addColumn(table, "CONSTRAINT_CATALOG", 12);
            this.addColumn(table, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(table, "CONSTRAINT_NAME", 12, false);
            this.addColumn(table, "CONSTRAINT_TYPE", 12, 11, false);
            this.addColumn(table, "TABLE_CATALOG", 12);
            this.addColumn(table, "TABLE_SCHEMA", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "IS_DEFERRABLE", 12, 3, false);
            this.addColumn(table, "INITIALLY_DEFERRED", 12, 3, false);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        HashSet hashSet = new HashSet();
        Table table2 = null;
        while (iterator.hasNext()) {
            table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(table2)) continue;
            Index index = table2.getPrimaryIndex();
            if (table2.hasPrimaryKey()) {
                objectArray = table.getEmptyRowData();
                string2 = this.ns.getCatalogName(table2);
                string = table2.getSchemaName();
                objectArray[0] = string2;
                objectArray[1] = string;
                objectArray[2] = index.getName().name;
                objectArray[3] = "PRIMARY KEY";
                objectArray[4] = string2;
                objectArray[5] = string;
                objectArray[6] = table2.getName().name;
                objectArray[7] = "NO";
                objectArray[8] = "NO";
                table.insertSys(objectArray);
            }
            Constraint[] constraintArray = table2.getConstraints();
            int n = constraintArray.length;
            int n2 = 0;
            while (n2 < n) {
                constraint = constraintArray[n2];
                if (constraint.getType() != 0 || this.isAccessibleTable(constraint.getRef())) {
                    hashSet.add(constraint);
                }
                ++n2;
            }
        }
        Iterator iterator2 = hashSet.iterator();
        block7: while (iterator2.hasNext()) {
            objectArray = table.getEmptyRowData();
            constraint = (Constraint)iterator2.next();
            switch (constraint.getType()) {
                case 3: {
                    objectArray[3] = "CHECK";
                    table2 = constraint.getMain();
                    break;
                }
                case 2: {
                    objectArray[3] = "UNIQUE";
                    table2 = constraint.getMain();
                    break;
                }
                case 0: {
                    objectArray[3] = "FOREIGN KEY";
                    table2 = constraint.getRef();
                    break;
                }
                default: {
                    continue block7;
                }
            }
            string2 = this.ns.getCatalogName(table2);
            string = table2.getSchemaName();
            objectArray[0] = string2;
            objectArray[1] = string;
            objectArray[2] = constraint.constName.name;
            objectArray[4] = string2;
            objectArray[5] = string;
            objectArray[6] = table2.getName().name;
            objectArray[7] = "NO";
            objectArray[8] = "NO";
            table.insertSys(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_VIEW_TABLE_USAGE() throws HsqlException {
        Table table = this.sysTables[40];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[40]);
            this.addColumn(table, "VIEW_CATALOG", 12);
            this.addColumn(table, "VIEW_SCHEMA", 12);
            this.addColumn(table, "VIEW_NAME", 12, true);
            this.addColumn(table, "TABLE_CATALOG", 12);
            this.addColumn(table, "TABLE_SCHEMA", 12);
            this.addColumn(table, "TABLE_NAME", 12, true);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Result result = this.session.sqlExecuteDirectNoPreChecks("select DISTINCT VIEW_CATALOG, VIEW_SCHEMA, VIEW_NAME, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_VIEW_COLUMN_USAGE");
        table.insertSys(result);
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_VIEW_COLUMN_USAGE() throws HsqlException {
        Table table = this.sysTables[39];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[39]);
            this.addColumn(table, "VIEW_CATALOG", 12);
            this.addColumn(table, "VIEW_SCHEMA", 12);
            this.addColumn(table, "VIEW_NAME", 12, true);
            this.addColumn(table, "TABLE_CATALOG", 12);
            this.addColumn(table, "TABLE_SCHEMA", 12);
            this.addColumn(table, "TABLE_NAME", 12, true);
            this.addColumn(table, "COLUMN_NAME", 12, true);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        Expression.Collector collector = new Expression.Collector();
        Result result = new Result(3, 4);
        result.metaData.colTypes[3] = 12;
        result.metaData.colTypes[2] = 12;
        result.metaData.colTypes[1] = 12;
        result.metaData.colTypes[0] = 12;
        while (iterator.hasNext()) {
            collector.clear();
            result.setRows(null);
            Table table2 = (Table)iterator.next();
            if (!table2.isView() || !this.isAccessibleTable(table2)) continue;
            String string = this.ns.getCatalogName(table2);
            String string2 = table2.getSchemaName();
            String string3 = table2.getName().name;
            View view = (View)table2;
            SubQuery[] subQueryArray = view.viewSubqueries;
            collector.addAll(view.viewSelect, 2);
            int n = 0;
            while (n < subQueryArray.length) {
                collector.addAll(subQueryArray[n].select, 2);
                ++n;
            }
            Iterator iterator2 = collector.iterator();
            while (iterator2.hasNext()) {
                Expression expression = (Expression)iterator2.next();
                TableFilter tableFilter = expression.getFilter();
                Table table3 = tableFilter.getTable();
                if (table3.getTableType() == 1 || !this.isAccessibleTable(table3)) continue;
                result.add(new Object[]{this.ns.getCatalogName(table3), table3.getSchemaName(), table3.getName().name, expression.getColumnName()});
            }
            result.removeDuplicates(this.session);
            iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                Object[] objectArray = table.getEmptyRowData();
                Object[] objectArray2 = (Object[])iterator2.next();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = objectArray2[0];
                objectArray[4] = objectArray2[1];
                objectArray[5] = objectArray2[2];
                objectArray[6] = objectArray2[3];
                table.insertSys(objectArray);
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_VIEW_ROUTINE_USAGE() throws HsqlException {
        Table table = this.sysTables[41];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[41]);
            this.addColumn(table, "TABLE_CATALOG", 12);
            this.addColumn(table, "TABLE_SCHEMA", 12);
            this.addColumn(table, "TABLE_NAME", 12, true);
            this.addColumn(table, "SPECIFIC_CATALOG", 12);
            this.addColumn(table, "SPECIFIC_SCHEMA", 12);
            this.addColumn(table, "SPECIFIC_NAME", 12, true);
            table.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.allTablesIterator();
        Expression.Collector collector = new Expression.Collector();
        while (iterator.hasNext()) {
            collector.clear();
            Table table2 = (Table)iterator.next();
            if (!table2.isView() || !this.isAccessibleTable(table2)) continue;
            String string = this.ns.getCatalogName(table2);
            String string2 = table2.getSchemaName();
            String string3 = table2.getName().name;
            View view = (View)table2;
            SubQuery[] subQueryArray = view.viewSubqueries;
            collector.addAll(view.viewSelect, 7);
            int n = 0;
            while (n < subQueryArray.length) {
                collector.addAll(subQueryArray[n].select, 7);
                ++n;
            }
            HashSet hashSet = new HashSet();
            Iterator iterator2 = collector.iterator();
            while (iterator2.hasNext()) {
                Expression expression = (Expression)iterator2.next();
                Function function = expression.function;
                if (!this.session.isAccessible(function.getMethod().getDeclaringClass().getName())) continue;
                hashSet.add(function.getMethod());
            }
            iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                Method method = (Method)iterator2.next();
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = this.ns.getCatalogName(method);
                objectArray[4] = this.ns.getSchemaName(method);
                objectArray[5] = DINameSpace.getMethodSpecificName(method);
                table.insertSys(objectArray);
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    protected void addPColRows(Table table, HsqlArrayList hsqlArrayList, String string, String string2, String string3, String string4, Integer n, Integer n2, String string5, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, String string6, String string7, int n8) throws HsqlException {
        Object[] objectArray = table.getEmptyRowData();
        Integer n9 = ValuePool.getInt(n8);
        objectArray[0] = string;
        objectArray[1] = string2;
        objectArray[2] = string3;
        objectArray[3] = string4;
        objectArray[4] = n;
        objectArray[5] = n2;
        objectArray[6] = string5;
        objectArray[7] = n3;
        objectArray[8] = n4;
        objectArray[9] = n5;
        objectArray[10] = n6;
        objectArray[11] = n7;
        objectArray[12] = string6;
        objectArray[13] = string7;
        objectArray[14] = n9;
        table.insertSys(objectArray);
        if (hsqlArrayList != null) {
            int n10 = hsqlArrayList.size();
            int n11 = 0;
            while (n11 < n10) {
                objectArray = table.getEmptyRowData();
                string3 = (String)hsqlArrayList.get(n11);
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = string4;
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = string5;
                objectArray[7] = n3;
                objectArray[8] = n4;
                objectArray[9] = n5;
                objectArray[10] = n6;
                objectArray[11] = n7;
                objectArray[12] = string6;
                objectArray[13] = string7;
                objectArray[14] = n9;
                table.insertSys(objectArray);
                ++n11;
            }
        }
    }

    protected void addProcRows(Table table, HsqlArrayList hsqlArrayList, String string, String string2, String string3, Integer n, Integer n2, Integer n3, String string4, Integer n4, String string5, String string6) throws HsqlException {
        Object[] objectArray = table.getEmptyRowData();
        objectArray[0] = string;
        objectArray[1] = string2;
        objectArray[2] = string3;
        objectArray[3] = n;
        objectArray[4] = n2;
        objectArray[5] = n3;
        objectArray[6] = string4;
        objectArray[7] = n4;
        objectArray[8] = string5;
        objectArray[9] = string6;
        table.insertSys(objectArray);
        if (hsqlArrayList != null) {
            int n5 = hsqlArrayList.size();
            int n6 = 0;
            while (n6 < n5) {
                objectArray = table.getEmptyRowData();
                string3 = (String)hsqlArrayList.get(n6);
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = n;
                objectArray[4] = n2;
                objectArray[5] = n3;
                objectArray[6] = string4;
                objectArray[7] = n4;
                objectArray[8] = "ALIAS";
                objectArray[9] = string6;
                table.insertSys(objectArray);
                ++n6;
            }
        }
    }

    Table SYSTEM_AUTHORIZATIONS() throws HsqlException {
        Object[] objectArray;
        Table table = this.sysTables[42];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[42]);
            this.addColumn(table, "AUTHORIZATION_NAME", 12, true);
            this.addColumn(table, "AUTHORIZATION_TYPE", 12, true);
            table.createPrimaryKey(null, new int[]{0}, true);
            return table;
        }
        HsqlArrayList hsqlArrayList = this.database.getUserManager().listVisibleUsers(this.session, false);
        int n = hsqlArrayList.size();
        int n2 = 0;
        while (n2 < hsqlArrayList.size()) {
            objectArray = table.getEmptyRowData();
            User user = (User)hsqlArrayList.get(n2);
            objectArray[0] = user.getName();
            objectArray[1] = "USER";
            table.insertSys(objectArray);
            ++n2;
        }
        Iterator iterator = this.database.getGranteeManager().getRoleNames().iterator();
        while (iterator.hasNext()) {
            objectArray = table.getEmptyRowData();
            objectArray[0] = iterator.next().toString();
            objectArray[1] = "ROLE";
            table.insertSys(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_COLLATIONS() throws HsqlException {
        Table table = this.sysTables[43];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[43]);
            this.addColumn(table, "COLLATION_CATALOG", 12);
            this.addColumn(table, "COLLATION_SCHEMA", 12, true);
            this.addColumn(table, "COLLATION_NAME", 12, true);
            this.addColumn(table, "PAD_ATTRIBUTE", 12, 9, true);
            this.addColumn(table, "COLLATION_TYPE", 12, true);
            this.addColumn(table, "COLLATION_DEFINITION", 12);
            this.addColumn(table, "COLLATION_DICTIONARY", 12);
            this.addColumn(table, "CHARACTER_REPERTOIRE_NAME", 12, true);
            table.createPrimaryKey(null, new int[]{0, 1, 2}, false);
            return table;
        }
        String string = "PUBLIC";
        String string2 = "NO PAD";
        String string3 = "UNICODE";
        Iterator iterator = Collation.nameToJavaName.keySet().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = table.getEmptyRowData();
            String string4 = (String)iterator.next();
            objectArray[0] = this.ns.getCatalogName(string4);
            objectArray[1] = string;
            objectArray[2] = string4;
            objectArray[3] = string2;
            objectArray[7] = string3;
            table.insertSys(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS() throws HsqlException {
        Table table = this.sysTables[44];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[44]);
            this.addColumn(table, "ROLE_NAME", 12, true);
            this.addColumn(table, "GRANTEE", 12, true);
            this.addColumn(table, "GRANTOR", 12, true);
            this.addColumn(table, "IS_GRANTABLE", 12, true);
            table.createPrimaryKey(null, new int[]{0, 1}, true);
            return table;
        }
        String string = "_SYSTEM";
        Iterator iterator = this.database.getGranteeManager().getGrantees().iterator();
        while (iterator.hasNext()) {
            Grantee grantee = (Grantee)iterator.next();
            String string2 = grantee.getName();
            Iterator iterator2 = grantee.getDirectRoles().iterator();
            while (iterator2.hasNext()) {
                Object[] objectArray = table.getEmptyRowData();
                String string3 = (String)iterator2.next();
                String string4 = grantee.hasRole("DBA") ? "YES" : "NO";
                objectArray[0] = string3;
                objectArray[1] = string2;
                objectArray[2] = string;
                objectArray[3] = string4;
                table.insertSys(objectArray);
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_SCHEMATA() throws HsqlException {
        Table table = this.sysTables[45];
        if (table == null) {
            table = this.createBlankTable(DatabaseInformationMain.sysTableHsqlNames[45]);
            this.addColumn(table, "CATALOG_NAME", 12);
            this.addColumn(table, "SCHEMA_NAME", 12, true);
            this.addColumn(table, "SCHEMA_OWNER", 12, true);
            this.addColumn(table, "DEFAULT_CHARACTER_SET_CATALOG", 12);
            this.addColumn(table, "DEFAULT_CHARACTER_SET_SCHEMA", 12, true);
            this.addColumn(table, "DEFAULT_CHARACTER_SET_NAME", 12);
            this.addColumn(table, "SQL_PATH", 12);
            table.createPrimaryKey(null, new int[]{0, 1}, false);
            return table;
        }
        String string = "DBA";
        String string2 = "INFORMATION_SCHEMA";
        String string3 = ValuePool.getString("UTF16");
        Object var7_5 = null;
        Iterator iterator = this.database.schemaManager.fullSchemaNamesIterator();
        while (iterator.hasNext()) {
            Object[] objectArray = table.getEmptyRowData();
            String string4 = (String)iterator.next();
            objectArray[0] = this.ns.getCatalogName(string4);
            objectArray[1] = string4;
            objectArray[2] = string;
            objectArray[3] = this.ns.getCatalogName(string2);
            objectArray[4] = string2;
            objectArray[5] = string3;
            objectArray[6] = var7_5;
            table.insertSys(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }
}

