/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.TablesImpl;
import com.sun.star.helper.writer.WriterTableCellImpl;
import com.sun.star.helper.writer.WriterTableCellsImpl;
import com.sun.star.helper.writer.WriterTableColumnImpl;
import com.sun.star.helper.writer.WriterTableColumnsImpl;
import com.sun.star.helper.writer.WriterTableRowImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XTable;
import com.sun.star.helper.writer.XWriterTableCells;
import com.sun.star.helper.writer.XWriterTableRow;
import com.sun.star.helper.writer.XWriterTableRows;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XCell;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;

public class WriterTableRowsImpl
extends HelperInterfaceAdaptor
implements XWriterTableRows,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Rows";
    protected XTextTable xTable;
    protected XTableRows xRows;
    protected int iFirstRowIndex;
    protected int iLastRowIndex;
    protected Hashtable writerTableRowCache;
    static /* synthetic */ Class class$com$sun$star$helper$writer$XWriterTableRow;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    public WriterTableRowsImpl(TableImpl tableImpl, XTextTable xTextTable) throws IllegalArgumentException {
        this(tableImpl, xTextTable, -1, -1);
    }

    public WriterTableRowsImpl(TableImpl tableImpl, XTextTable xTextTable, int n, int n2) throws IllegalArgumentException {
        super(__serviceName, tableImpl);
        if (xTextTable == null) {
            throw new IllegalArgumentException("Cannot instantiate with a null parameter");
        }
        this.xTable = xTextTable;
        this.xRows = this.xTable.getRows();
        if (n == -1 || n2 == -1) {
            this.iFirstRowIndex = 0;
            this.iLastRowIndex = this.xRows.getCount() - 1;
        } else {
            this.iFirstRowIndex = n;
            this.iLastRowIndex = n2;
        }
        this.writerTableRowCache = new Hashtable();
    }

    public XTable getParent() {
        return (TableImpl)this.getParentHelper();
    }

    public XWriterTableRow Item(Object object) throws IndexOutOfBoundsException {
        XWriterTableRow xWriterTableRow = null;
        int n = -1;
        try {
            if (object != null && !AnyConverter.isVoid((Object)object)) {
                if (AnyConverter.isString((Object)object)) {
                    String string = AnyConverter.toString((Object)object);
                    throw new Exception("Cannot get an item with this Index: " + string);
                }
                n = AnyConverter.toInt((Object)object) - 1;
            }
        }
        catch (Exception exception) {
            throw new IndexOutOfBoundsException(exception.getMessage());
        }
        if (n < this.iFirstRowIndex || n > this.iLastRowIndex) {
            throw new IndexOutOfBoundsException("Could not get an item.");
        }
        xWriterTableRow = this.getRowAtIndex(n);
        return xWriterTableRow;
    }

    public int getAlignment() {
        int n = ((TableImpl)this.getParentHelper()).getAlignment();
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public void setAlignment(int n) throws NoSupportException, IllegalArgumentException {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for row alignment");
            }
        }
        if (this.iLastRowIndex - this.iFirstRowIndex + 1 != this.xTable.getRows().getCount()) {
            throw new NoSupportException("No support of this method for the current rows object");
        }
        try {
            ((TableImpl)this.getParentHelper()).setAlignment(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
    }

    public void Add(Object object) {
        int n = 0;
        if (object != null && !AnyConverter.isVoid((Object)object)) {
            try {
                n = ((XWriterTableRow)OptionalParamUtility.getObject(class$com$sun$star$helper$writer$XWriterTableRow == null ? (class$com$sun$star$helper$writer$XWriterTableRow = WriterTableRowsImpl.class$("com.sun.star.helper.writer.XWriterTableRow")) : class$com$sun$star$helper$writer$XWriterTableRow, object)).Index();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        }
        this.xRows.insertByIndex(n, 1);
    }

    public void setSpaceBetweenColumns(double d) throws IllegalArgumentException {
        if (d < 0.0) {
            throw new IllegalArgumentException("This spaceing is not allowed.");
        }
        int n = WriterUtilities.pointsToHundredthsMillimeter((float)d);
        try {
            int n2 = this.iFirstRowIndex;
            while (n2 <= this.iLastRowIndex) {
                XWriterTableRow xWriterTableRow = this.getRowAtIndex(n2);
                XWriterTableCells xWriterTableCells = xWriterTableRow.Cells();
                int n3 = xWriterTableCells.Count();
                int n4 = 0;
                while (n4 < n3) {
                    WriterTableCellImpl writerTableCellImpl = (WriterTableCellImpl)((WriterTableCellsImpl)xWriterTableCells).getTableCell(n4);
                    XCell xCell = writerTableCellImpl.getTableCell();
                    XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? WriterTableRowsImpl.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet, xCell);
                    try {
                        xPropertySet.setPropertyValue("LeftBorderDistance", (Object)new Integer(n));
                        xPropertySet.setPropertyValue("RightBorderDistance", (Object)new Integer(n));
                    }
                    catch (UnknownPropertyException unknownPropertyException) {
                        HelperUtilities.exception(unknownPropertyException);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        HelperUtilities.exception(propertyVetoException);
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        HelperUtilities.exception(wrappedTargetException);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HelperUtilities.exception(indexOutOfBoundsException);
            throw new IllegalArgumentException("Cannot set spacing.");
        }
    }

    public double getSpaceBetweenColumns() {
        double d = -1.0;
        try {
            XWriterTableRow xWriterTableRow = this.getRowAtIndex(this.iFirstRowIndex);
            XWriterTableCells xWriterTableCells = xWriterTableRow.Cells();
            WriterTableCellImpl writerTableCellImpl = (WriterTableCellImpl)((WriterTableCellsImpl)xWriterTableCells).getTableCell(0);
            XCell xCell = writerTableCellImpl.getTableCell();
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableRowsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xCell);
            Object object = xPropertySet.getPropertyValue("LeftBorderDistance");
            int n = WriterUtilities.getIntFromObject(object);
            d = WriterUtilities.hundredthsMillimeterToPoints(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HelperUtilities.exception(indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
        return d;
    }

    public int Count() {
        return this.iLastRowIndex - this.iFirstRowIndex + 1;
    }

    public void Delete() {
        this.delete(this.iFirstRowIndex, this.Count());
    }

    public void SetLeftIndent(Object object, Object object2) throws IllegalArgumentException, NoSupportException {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("Parameters are mandatory");
        }
        if (this.iLastRowIndex - this.iFirstRowIndex + 1 != this.xTable.getRows().getCount()) {
            throw new NoSupportException("No support of this method for the current rows object");
        }
        int n = NumericalHelper.toInt(object);
        int n2 = NumericalHelper.toInt(object2);
        WriterTableColumnsImpl writerTableColumnsImpl = null;
        try {
            writerTableColumnsImpl = new WriterTableColumnsImpl((TableImpl)this.getParentHelper(), this.xTable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        switch (n2) {
            case 2: {
                this.setIndentWithAdjustFirstColumn(writerTableColumnsImpl, n);
                break;
            }
            case 0: {
                this.setIndentWithAdjustNone(n);
                break;
            }
            case 1: {
                this.setIndentWithAdjustProportional(writerTableColumnsImpl, n);
                break;
            }
            case 3: {
                this.setIndentWithAdjustSameWidth(writerTableColumnsImpl, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Argument for WdRulerStyle");
            }
        }
    }

    protected void delete(int n, int n2) {
        boolean bl = n == 0 && n2 == this.xRows.getCount();
        this.xRows.removeByIndex(n, n2);
        if (bl) {
            TableImpl tableImpl = (TableImpl)this.getParentHelper();
            TablesImpl tablesImpl = (TablesImpl)tableImpl.getParentHelper();
            tablesImpl.removeFromTableCache(tableImpl.getName());
        } else {
            Set set = this.writerTableRowCache.keySet();
            Object[] objectArray = new Integer[set.size()];
            objectArray = set.toArray(objectArray);
            Arrays.sort(objectArray);
            int n3 = 0;
            while (n3 < objectArray.length) {
                int n4 = (Integer)objectArray[n3];
                if (n4 >= n && n4 < n + n2) {
                    this.writerTableRowCache.remove(objectArray[n3]);
                } else if (n4 >= n + n2) {
                    Integer n5 = new Integer(n4 - n2);
                    Object v = this.writerTableRowCache.remove(objectArray[n3]);
                    this.writerTableRowCache.put(n5, v);
                }
                ++n3;
            }
        }
    }

    private XWriterTableRow getRowAtIndex(int n) throws IndexOutOfBoundsException {
        WriterTableRowImpl writerTableRowImpl = (WriterTableRowImpl)this.writerTableRowCache.get(new Integer(n));
        if (writerTableRowImpl == null) {
            try {
                writerTableRowImpl = new WriterTableRowImpl(this, this.xTable, this.xRows, n + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
            }
            this.writerTableRowCache.put(new Integer(n), writerTableRowImpl);
        }
        return writerTableRowImpl;
    }

    private void setIndentWithAdjustFirstColumn(WriterTableColumnsImpl writerTableColumnsImpl, int n) {
        try {
            WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)writerTableColumnsImpl.Item(new Integer(1));
            int n2 = NumericalHelper.toInt(writerTableColumnImpl.getWidth());
            writerTableColumnImpl.setWidth(new Integer(n2 -= n));
            this.setIndentWithAdjustNone(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HelperUtilities.exception(indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
    }

    private void setIndentWithAdjustNone(int n) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableRowsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xTable);
            Object object = xPropertySet.getPropertyValue("LeftMargin");
            int n2 = AnyConverter.toInt((Object)object);
            xPropertySet.setPropertyValue("LeftMargin", (Object)new Integer(n2 += n));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (PropertyVetoException propertyVetoException) {
            HelperUtilities.exception(propertyVetoException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
    }

    private void setIndentWithAdjustProportional(WriterTableColumnsImpl writerTableColumnsImpl, int n) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableRowsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xTable);
            Object object = xPropertySet.getPropertyValue("Width");
            int n2 = AnyConverter.toInt((Object)object);
            int n3 = n2 - n;
            double d = (double)n3 / (double)n2;
            int n4 = this.Count();
            int n5 = 0;
            while (n5 < n4) {
                try {
                    WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)writerTableColumnsImpl.Item(new Integer(n5));
                    int n6 = NumericalHelper.toInt(writerTableColumnImpl.getWidth());
                    int n7 = (int)(d * (double)n6);
                    writerTableColumnImpl.setWidth(new Integer(n7));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    HelperUtilities.exception(indexOutOfBoundsException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    HelperUtilities.exception(illegalArgumentException);
                }
                ++n5;
            }
            this.setIndentWithAdjustNone(n);
            xPropertySet.setPropertyValue("Width", (Object)new Integer(n3));
        }
        catch (PropertyVetoException propertyVetoException) {
            HelperUtilities.exception(propertyVetoException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
    }

    private void setIndentWithAdjustSameWidth(WriterTableColumnsImpl writerTableColumnsImpl, int n) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableRowsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xTable);
            Object object = xPropertySet.getPropertyValue("Width");
            int n2 = AnyConverter.toInt((Object)object);
            int n3 = n2 - n;
            int n4 = this.Count();
            int n5 = (int)((double)n3 / (double)n4);
            int n6 = 0;
            while (n6 < n4) {
                try {
                    WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)writerTableColumnsImpl.Item(new Integer(n6));
                    writerTableColumnImpl.setWidth(new Integer(n5));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    HelperUtilities.exception(indexOutOfBoundsException);
                }
                ++n6;
            }
            this.setIndentWithAdjustNone(n);
            xPropertySet.setPropertyValue("Width", (Object)new Integer(n3));
        }
        catch (PropertyVetoException propertyVetoException) {
            HelperUtilities.exception(propertyVetoException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xRows;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

