/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.WriterTableColumnImpl;
import com.sun.star.helper.writer.XTable;
import com.sun.star.helper.writer.XWriterTableColumn;
import com.sun.star.helper.writer.XWriterTableColumns;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.AnyConverter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;

public class WriterTableColumnsImpl
extends HelperInterfaceAdaptor
implements XWriterTableColumns,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Columns";
    protected XTextTable xTable = null;
    protected XTableColumns xColumns = null;
    protected Hashtable writerTableColumnCache = null;
    protected int iFirstColumnIndex;
    protected int iLastColumnIndex;

    public WriterTableColumnsImpl(TableImpl tableImpl, XTextTable xTextTable) throws IllegalArgumentException {
        this(tableImpl, xTextTable, -1, -1);
    }

    public WriterTableColumnsImpl(TableImpl tableImpl, XTextTable xTextTable, int n, int n2) throws IllegalArgumentException {
        super(__serviceName, tableImpl);
        if (xTextTable == null) {
            throw new IllegalArgumentException("Cannot instantiate with a null parameter");
        }
        this.xTable = xTextTable;
        this.xColumns = this.xTable.getColumns();
        if (n == -1 || n2 == -1) {
            this.iFirstColumnIndex = 0;
            this.iLastColumnIndex = this.xColumns.getCount() - 1;
        } else {
            this.iFirstColumnIndex = n;
            this.iLastColumnIndex = n2;
        }
        this.writerTableColumnCache = new Hashtable();
    }

    public XTable getParent() {
        return (TableImpl)this.getParentHelper();
    }

    public XWriterTableColumn Item(Object object) throws IndexOutOfBoundsException {
        XWriterTableColumn xWriterTableColumn = null;
        int n = -1;
        try {
            if (object != null && !AnyConverter.isVoid((Object)object)) {
                if (AnyConverter.isString((Object)object)) {
                    String string = AnyConverter.toString((Object)object);
                    throw new Exception("Cannot get an item with this Index: " + string);
                }
                n = AnyConverter.toInt((Object)object) - 1;
            }
        }
        catch (Exception exception) {
            throw new IndexOutOfBoundsException(exception.getMessage());
        }
        if (n == -1) {
            throw new IndexOutOfBoundsException("Could not get an item.");
        }
        xWriterTableColumn = this.getColumnAtIndex(n);
        return xWriterTableColumn;
    }

    public int Count() {
        return this.iLastColumnIndex - this.iFirstColumnIndex + 1;
    }

    public void Delete() {
        this.delete(this.iFirstColumnIndex, this.Count());
    }

    XWriterTableColumn getColumnAtIndex(int n) throws IndexOutOfBoundsException {
        WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)this.writerTableColumnCache.get(new Integer(n));
        if (writerTableColumnImpl == null) {
            try {
                writerTableColumnImpl = new WriterTableColumnImpl(this, this.xTable, this.xColumns, n + 1);
                this.writerTableColumnCache.put(new Integer(n), writerTableColumnImpl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
            }
        }
        return writerTableColumnImpl;
    }

    public void delete(int n, int n2) {
        this.xColumns.removeByIndex(n, n2);
        Set set = this.writerTableColumnCache.keySet();
        Object[] objectArray = new Integer[set.size()];
        objectArray = set.toArray(objectArray);
        Arrays.sort(objectArray);
        int n3 = 0;
        while (n3 < objectArray.length) {
            int n4 = (Integer)objectArray[n3];
            if (n4 >= n && n4 < n + n2) {
                this.writerTableColumnCache.remove(objectArray[n3]);
            } else if (n4 >= n + n2) {
                Integer n5 = new Integer(n4 - n2);
                Object v = this.writerTableColumnCache.remove(objectArray[n3]);
                this.writerTableColumnCache.put(n5, v);
            }
            ++n3;
        }
        if (n <= this.iFirstColumnIndex) {
            // empty if block
        }
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xColumns;
    }
}

