/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.PropertySetImplementation;
import com.sun.star.helper.writer.BordersImpl;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.WriterTableCellsImpl;
import com.sun.star.helper.writer.WriterTableColumnsImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XWriterTableCells;
import com.sun.star.helper.writer.XWriterTableColumn;
import com.sun.star.helper.writer.XWriterTableColumns;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.TableColumnSeparator;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;

public class WriterTableColumnImpl
extends HelperInterfaceAdaptor
implements XWriterTableColumn,
XPropertySet {
    private PropertySetImplementation propSet;
    protected static final String __serviceName = "com.sun.star.helper.writer.Column";
    protected static final int RELATIVE_TABLE_WIDTH = 10000;
    protected XTextTable xTable;
    protected XTableColumns xColumns;
    protected int index = -1;
    static /* synthetic */ Class class$com$sun$star$table$XCellRange;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$frame$XDispatchHelper;
    static /* synthetic */ Class class$com$sun$star$frame$XDispatchProvider;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    public WriterTableColumnImpl(WriterTableColumnsImpl writerTableColumnsImpl, XTextTable xTextTable, XTableColumns xTableColumns, int n) throws IllegalArgumentException {
        super(__serviceName, writerTableColumnsImpl);
        this.xTable = xTextTable;
        this.xColumns = xTableColumns;
        this.index = --n;
        if (this.xColumns == null || this.xTable == null || this.index < 0 || this.index >= this.xColumns.getCount()) {
            throw new IllegalArgumentException("Cannot construct cells object with these parameters.");
        }
        Property[] propertyArray = new Property[]{new Property("Width", -1, Type.LONG, 0)};
        this.propSet = new PropertySetImplementation(propertyArray, this);
    }

    public XWriterTableColumns getParent() {
        return (WriterTableColumnsImpl)this.getParentHelper();
    }

    public void Select() {
        String string = TableImpl.getStringForNumber(this.index);
        StringBuffer stringBuffer = new StringBuffer(string);
        XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = WriterTableColumnImpl.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)this.xTable);
        int n = this.xTable.getRows().getCount();
        stringBuffer = stringBuffer.append(1).append(":").append(string).append(n);
        XCellRange xCellRange2 = xCellRange.getCellRangeByName(stringBuffer.toString());
        XModel xModel = this.getXModel();
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = WriterTableColumnImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)xModel.getCurrentController());
        try {
            xSelectionSupplier.select((Object)xCellRange2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
    }

    public XWriterTableCells Cells() {
        try {
            WriterTableCellsImpl writerTableCellsImpl = new WriterTableCellsImpl(this, (TableImpl)this.getParent().getParent(), null);
            return writerTableCellsImpl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
            throw new com.sun.star.uno.RuntimeException("Cannot construct a cells object.");
        }
    }

    public void Delete() {
        ((WriterTableColumnsImpl)this.getParent()).delete(this.index, 1);
    }

    public void AutoFit() {
        try {
            this.Select();
            XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
            Object object = xMultiServiceFactory.createInstance("com.sun.star.frame.DispatchHelper");
            XDispatchHelper xDispatchHelper = (XDispatchHelper)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XDispatchHelper == null ? (class$com$sun$star$frame$XDispatchHelper = WriterTableColumnImpl.class$("com.sun.star.frame.XDispatchHelper")) : class$com$sun$star$frame$XDispatchHelper), (Object)object);
            XFrame xFrame = this.getXModel().getCurrentController().getFrame();
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XDispatchProvider == null ? (class$com$sun$star$frame$XDispatchProvider = WriterTableColumnImpl.class$("com.sun.star.frame.XDispatchProvider")) : class$com$sun$star$frame$XDispatchProvider), (Object)xFrame);
            PropertyValue[] propertyValueArray = new PropertyValue[]{};
            xDispatchHelper.executeDispatch(xDispatchProvider, ".uno:SetOptimalColumnWidth", "", 0, propertyValueArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public XBorders Borders() {
        Object object;
        XCell[][] xCellArray = new XCell[this.xTable.getRows().getCount()][1];
        int n = 0;
        while (n < xCellArray.length) {
            object = new StringBuffer(TableImpl.getStringForNumber(this.index));
            ((StringBuffer)object).append(n + 1);
            xCellArray[n][0] = this.xTable.getCellByName(((StringBuffer)object).toString());
            if (xCellArray[n][0] == null) {
                RuntimeException runtimeException = new RuntimeException("Cannot get a cell from table.");
                HelperUtilities.exception(runtimeException);
            }
            ++n;
        }
        object = null;
        try {
            object = new BordersImpl((TableImpl)this.getParent().getParent(), xCellArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (NoSupportException noSupportException) {
            HelperUtilities.exception(noSupportException);
        }
        return object;
    }

    public void SetWidth(Object object, Object object2) throws BasicErrorException {
        this.setWidth(object);
    }

    public Object getWidth() {
        Object object;
        int n = -1;
        try {
            object = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableColumnImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xTable);
            TableColumnSeparator[] tableColumnSeparatorArray = (TableColumnSeparator[])object.getPropertyValue("TableColumnSeparators");
            Object object2 = object.getPropertyValue("Width");
            int n2 = this.getTableWidth((XPropertySet)object);
            double[] dArray = this.calculateAbsoluteColumnWidth(n2, tableColumnSeparatorArray);
            n = new Double(dArray[this.index]).intValue();
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        if (n == -1) {
            object = new Exception("Cannot determine ColumnWidth");
            HelperUtilities.exception((Throwable)object);
        } else {
            n = (int)WriterUtilities.hundredthsMillimeterToPoints(n);
        }
        return new Integer(n);
    }

    public void setWidth(Object object) {
        int n = -1;
        try {
            int n2 = NumericalHelper.toInt(object);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableColumnImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xTable);
            TableColumnSeparator[] tableColumnSeparatorArray = (TableColumnSeparator[])xPropertySet.getPropertyValue("TableColumnSeparators");
            int n3 = this.getTableWidth(xPropertySet);
            double[] dArray = this.calculateAbsoluteColumnWidth(n3, tableColumnSeparatorArray);
            dArray[this.index] = WriterUtilities.pointsToHundredthsMillimeter(n2);
            double d = 0.0;
            int n4 = 0;
            while (n4 < dArray.length) {
                d += dArray[n4];
                ++n4;
            }
            double[] dArray2 = this.calculateRelativeColumnWidth(dArray);
            int n5 = 0;
            while (n5 < dArray2.length - 1) {
                tableColumnSeparatorArray[n5].Position = new Double(dArray2[n5]).shortValue();
                ++n5;
            }
            xPropertySet.setPropertyValue("TableColumnSeparators", (Object)tableColumnSeparatorArray);
            this.setTableWidth(xPropertySet, new Double(d).intValue());
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (PropertyVetoException propertyVetoException) {
            HelperUtilities.exception(propertyVetoException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
    }

    public int Index() {
        return this.getColumnIndex();
    }

    protected int getColumnIndex() {
        return this.index + 1;
    }

    private double[] calculateAbsoluteColumnWidth(int n, TableColumnSeparator[] tableColumnSeparatorArray) {
        double[] dArray = new double[tableColumnSeparatorArray.length + 1];
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = 0;
            n3 = n2 == 0 ? (tableColumnSeparatorArray.length != 0 ? (int)tableColumnSeparatorArray[0].Position : 10000) : (n2 == dArray.length - 1 ? 10000 - tableColumnSeparatorArray[n2 - 1].Position : tableColumnSeparatorArray[n2].Position - tableColumnSeparatorArray[n2 - 1].Position);
            dArray[n2] = (double)n3 / 10000.0 * (double)n;
            ++n2;
        }
        return dArray;
    }

    private double[] calculateRelativeColumnWidth(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        dArray2[dArray.length - 1] = d;
        int n2 = 0;
        while (n2 < dArray.length - 1) {
            dArray2[n2] = n2 == 0 ? dArray[n2] * 10000.0 / d : dArray2[n2 - 1] + dArray[n2] * 10000.0 / d;
            ++n2;
        }
        return dArray2;
    }

    private int getTableWidth(XPropertySet xPropertySet) throws UnknownPropertyException, IllegalArgumentException, WrappedTargetException {
        Object object = null;
        Object object2 = xPropertySet.getPropertyValue("IsWidthRelative");
        object = HelperUtilities.getBooleanValue(object2) ? xPropertySet.getPropertyValue("RelativeWidth") : xPropertySet.getPropertyValue("Width");
        int n = WriterUtilities.getIntFromObject(object);
        return n;
    }

    private void setTableWidth(XPropertySet xPropertySet, int n) throws UnknownPropertyException, IllegalArgumentException, WrappedTargetException, PropertyVetoException {
        Object object = xPropertySet.getPropertyValue("IsWidthRelative");
        if (HelperUtilities.getBooleanValue(object)) {
            xPropertySet.setPropertyValue("RelativeWidth", (Object)new Integer(n));
        } else {
            xPropertySet.setPropertyValue("Width", (Object)new Integer(n));
        }
    }

    public void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.propSet.addPropertyChangeListener(string, xPropertyChangeListener);
    }

    public void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.propSet.addVetoableChangeListener(string, xVetoableChangeListener);
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.propSet.getPropertySetInfo();
    }

    public Object getPropertyValue(String string) throws UnknownPropertyException, WrappedTargetException {
        return this.propSet.getPropertyValue(string);
    }

    public void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.propSet.removePropertyChangeListener(string, xPropertyChangeListener);
    }

    public void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.propSet.removeVetoableChangeListener(string, xVetoableChangeListener);
    }

    public void setPropertyValue(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.propSet.setPropertyValue(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

