/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.WriterTableCellsImpl;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XTable;
import com.sun.star.helper.writer.XWriterTableCell;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XText;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;

public class WriterTableCellImpl
extends HelperInterfaceAdaptor
implements XWriterTableCell,
XUnoAccess {
    private static final int MS_OFFICE = 0;
    private static final int S_OFFICE = 1;
    private static final String VERT_ORIENT = "VertOrient";
    protected static final String __serviceName = "com.sun.star.helper.writer.Cell";
    private XCell xCell;
    private XPropertySet xProp;
    private String sCellName;
    private static final int[][] iVerticalAlignmentMapping = new int[][]{{3, 3}, {1, 2}, {2, 0}, {0, 1}};
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$text$XText;
    static /* synthetic */ Class class$com$sun$star$table$XCellRange;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;

    public WriterTableCellImpl(TableImpl tableImpl, String string) throws IllegalArgumentException {
        super(__serviceName, tableImpl);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Cannot create a Cell object with these parameters.");
        }
        this.sCellName = string;
        XTextTable xTextTable = tableImpl.getWrappedTable();
        DebugHelper.writeDebug("Get cell: " + string);
        this.xCell = xTextTable.getCellByName(string);
        DebugHelper.writeDebug("Got cell.");
        if (this.xCell == null) {
            throw new IllegalArgumentException("Cannot create a Cell object with these parameters.");
        }
        this.xProp = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableCellImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.xCell);
    }

    public XTable getParent() {
        return (TableImpl)this.getParentHelper();
    }

    public XRange Range() throws BasicErrorException {
        XText xText = (XText)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XText == null ? (class$com$sun$star$text$XText = WriterTableCellImpl.class$("com.sun.star.text.XText")) : class$com$sun$star$text$XText), (Object)this.xCell);
        WriterTableCellsImpl writerTableCellsImpl = null;
        try {
            writerTableCellsImpl = new WriterTableCellsImpl(this, (TableImpl)this.getParent(), this.sCellName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return new RangeImpl((HelperInterfaceAdaptor)((Object)this.getParent().getParent()), xText, xText.getStart(), this.getParent(), writerTableCellsImpl);
    }

    public int getVerticalAlignment() throws BasicErrorException {
        int n = 0;
        try {
            Object object = this.xProp.getPropertyValue(VERT_ORIENT);
            short s = AnyConverter.toShort((Object)object);
            n = this.getVerticalAlignment(s);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return n;
    }

    public void setVerticalAlignment(int n) throws BasicErrorException {
        try {
            this.xProp.setPropertyValue(VERT_ORIENT, (Object)new Short(this.getCellVertJustify(n)));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getWordWrap() {
        return true;
    }

    public void Select() {
        TableImpl tableImpl = (TableImpl)this.getParent();
        int n = tableImpl.Rows().Count();
        int n2 = tableImpl.Columns().Count();
        if (n == 1 && n2 == 1) {
            tableImpl.Select();
        } else {
            int n3 = this.getColumnIndex();
            int n4 = this.getRowIndex();
            int[] nArray = new int[]{-1, -1};
            int n5 = 0;
            boolean bl = false;
            while (!bl && n5 < 4) {
                nArray[0] = n4 + (n5 == 0 ? 1 : 0) - (n5 == 1 ? 1 : 0);
                nArray[1] = n3 + (n5 == 2 ? 1 : 0) - (n5 == 3 ? 1 : 0);
                bl = nArray[0] >= 1 && nArray[1] >= 1 && nArray[0] <= n && nArray[1] <= n2;
                ++n5;
            }
            StringBuffer stringBuffer = new StringBuffer(TableImpl.getStringForNumber(nArray[1] - 1)).append(nArray[0]);
            StringBuffer stringBuffer2 = new StringBuffer(this.sCellName);
            stringBuffer2 = stringBuffer2.append(":").append(stringBuffer);
            DebugHelper.writeInfo(stringBuffer2.toString());
            XTextTable xTextTable = ((TableImpl)this.getParent()).getWrappedTable();
            XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = WriterTableCellImpl.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)xTextTable);
            XCellRange xCellRange2 = xCellRange.getCellRangeByName(stringBuffer2.toString());
            XModel xModel = this.getXModel();
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = WriterTableCellImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)xModel.getCurrentController());
            try {
                xSelectionSupplier.select((Object)xCellRange2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
            String string = null;
            switch (n5) {
                case 1: {
                    string = ".uno:GoUp";
                    break;
                }
                case 2: {
                    string = ".uno:GoDown";
                    break;
                }
                case 3: {
                    string = ".uno:GoLeft";
                    break;
                }
                default: {
                    string = ".uno:GoRight";
                }
            }
            DebugHelper.writeInfo(string);
            PropertyValue[] propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "Count";
            propertyValueArray[0].Value = new Integer(1);
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "Select";
            propertyValueArray[1].Value = Boolean.TRUE;
            DispatchCommand.execute(string, xModel.getCurrentController().getFrame(), propertyValueArray);
        }
    }

    public int getColumnIndex() {
        int n = 0;
        try {
            int n2 = Character.getNumericValue(this.sCellName.charAt(0)) + 56;
            n = n2 - 65;
        }
        catch (NumberFormatException numberFormatException) {
            HelperUtilities.exception(numberFormatException);
        }
        return n;
    }

    public int getRowIndex() {
        int n = 0;
        try {
            n = new Integer(this.sCellName.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            HelperUtilities.exception(numberFormatException);
        }
        return n;
    }

    protected XCell getTableCell() {
        return this.xCell;
    }

    private int getVerticalAlignment(short s) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < iVerticalAlignmentMapping.length && !bl) {
            if (iVerticalAlignmentMapping[n2][1] == s) {
                n = iVerticalAlignmentMapping[n2][0];
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            RuntimeException runtimeException = new RuntimeException("Did not get a mapping for this vertical alignment value.");
            HelperUtilities.exception(runtimeException);
        }
        return n;
    }

    private short getCellVertJustify(int n) {
        short s = -1;
        boolean bl = false;
        int n2 = 0;
        while (n2 < iVerticalAlignmentMapping.length && !bl) {
            if (iVerticalAlignmentMapping[n2][0] == n) {
                s = (short)iVerticalAlignmentMapping[n2][1];
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            RuntimeException runtimeException = new RuntimeException("Did not get a mapping for this vertical alignment value.");
            HelperUtilities.exception(runtimeException);
        }
        return s;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xCell;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

