/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DocumentUtilities;
import com.sun.star.helper.common.Filename;
import com.sun.star.helper.common.WriterFileFormatHelper;
import com.sun.star.helper.writer.AutoTextEntriesImpl;
import com.sun.star.helper.writer.DocumentsImpl;
import com.sun.star.helper.writer.OptionsImpl;
import com.sun.star.helper.writer.WriterImpl;
import com.sun.star.helper.writer.XAutoTextEntries;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XTemplate;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;
import java.io.File;
import java.util.ArrayList;

public class TemplateImpl
extends HelperInterfaceAdaptor
implements XTemplate {
    String m_sName;
    String m_sPath;
    int m_nType;
    private DocumentsImpl m_aDocumentsImpl;
    private AutoTextEntriesImpl m_aAutoTextEntries = null;

    public TemplateImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, String string, String string2, int n) throws BasicErrorException {
        super("com.sun.star.helper.writer.TemplateImpl", helperInterfaceAdaptor);
        this.init(helperInterfaceAdaptor, string, string2, n);
    }

    private void init(HelperInterfaceAdaptor helperInterfaceAdaptor, String string, String string2, int n) throws BasicErrorException {
        ArrayList arrayList = new ArrayList();
        WriterFileFormatHelper writerFileFormatHelper = new WriterFileFormatHelper(1, arrayList);
        String string3 = Filename.getNameNoSuffix(string2);
        string3 = string3 + writerFileFormatHelper.getFileExtension();
        this.m_aDocumentsImpl = (DocumentsImpl)helperInterfaceAdaptor;
        this.m_sName = string3;
        this.m_sPath = string;
        this.m_nType = n;
        String string4 = this.getFullName();
        File file = new File(string4);
        if (!file.exists()) {
            DebugHelper.writeInfo("TemplateImpl.init() create a new template, like normal.dot name is: '" + string4 + "'");
            DocumentUtilities.createDocument("private:factory/swriter", null, string4, arrayList);
        }
    }

    public String getName() {
        return this.m_sName;
    }

    public String getPath() {
        return this.m_sPath;
    }

    public String getFullName() {
        String string = System.getProperty("file.separator");
        String string2 = this.getPath() + string + this.getName();
        return string2;
    }

    public int getType() {
        return this.m_nType;
    }

    public boolean getSaved() {
        return true;
    }

    public void Save() throws BasicErrorException {
        DebugHelper.exception((Exception)((Object)new NoSupportException("Template.Save() not supported yet.")));
    }

    protected XDocument OpenAsDocument_WithProperties(ArrayList arrayList) throws BasicErrorException {
        try {
            return this.m_aDocumentsImpl.openAndRegisterDocument(this.getFullName(), "swriter", true, arrayList);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return null;
        }
    }

    public XDocument OpenAsDocument() throws BasicErrorException {
        return this.OpenAsDocument_WithProperties(null);
    }

    public static TemplateImpl create(DocumentsImpl documentsImpl) throws BasicErrorException {
        DebugHelper.writeInfo("TemplateImpl.create() create a new template.");
        if (documentsImpl == null) {
            DebugHelper.exception((Exception)((Object)new IllegalArgumentException("Error: Documents must given.")));
        }
        WriterImpl writerImpl = (WriterImpl)documentsImpl.getParent();
        OptionsImpl optionsImpl = new OptionsImpl(writerImpl);
        String string = optionsImpl.DefaultFilePath(2);
        TemplateImpl templateImpl = new TemplateImpl(documentsImpl, string, "normal", 0);
        return templateImpl;
    }

    public XAutoTextEntries AutoTextEntries() throws BasicErrorException {
        if (this.m_aAutoTextEntries == null) {
            this.m_aAutoTextEntries = new AutoTextEntriesImpl(this);
        }
        return this.m_aAutoTextEntries;
    }
}

