/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XTable;
import com.sun.star.helper.writer.XTables;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import java.util.Hashtable;
import java.util.Vector;

public class TablesImpl
extends HelperInterfaceAdaptor
implements XTables {
    protected static final String __serviceName = "com.sun.star.helper.writer.Tables";
    private Hashtable documentTableCache = new Hashtable();
    static /* synthetic */ Class class$com$sun$star$text$XTextTablesSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XEnumeration;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$container$XEnumerationAccess;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$text$XTextTable;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$text$XTextContent;

    public TablesImpl(DocumentImpl documentImpl) {
        this((HelperInterfaceAdaptor)documentImpl);
    }

    public TablesImpl(RangeImpl rangeImpl) {
        this((HelperInterfaceAdaptor)rangeImpl);
    }

    private TablesImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
    }

    public XHelperInterface getParent() {
        return this.getParentHelper();
    }

    public int Count() {
        return this.getNumTables();
    }

    public XTable Item(Object object) throws NoSuchElementException, IndexOutOfBoundsException {
        TableImpl tableImpl = null;
        int n = -1;
        String string = "";
        try {
            if (object != null && !AnyConverter.isVoid((Object)object)) {
                if (AnyConverter.isString((Object)object)) {
                    string = AnyConverter.toString((Object)object);
                } else {
                    n = AnyConverter.toInt((Object)object) - 1;
                }
            } else {
                n = 0;
            }
        }
        catch (Exception exception) {
            NoSuchElementException noSuchElementException = new NoSuchElementException("Could not get an item.");
            throw noSuchElementException;
        }
        tableImpl = n != -1 ? this.getTableAtIndex(n) : this.getTableByName(string);
        return tableImpl;
    }

    public XTable Add(XRange xRange, Object object, Object object2, Object object3, Object object4) throws com.sun.star.uno.Exception {
        if (object3 == null) {
            // empty if block
        }
        if (object4 == null) {
            // empty if block
        }
        int n = AnyConverter.toInt((Object)object);
        int n2 = AnyConverter.toInt((Object)object2);
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("No rows or columns given.");
        }
        TableImpl tableImpl = this.createTable(xRange, n, n2, object3, object4);
        return tableImpl;
    }

    protected void deleteTableByName(String string) {
        try {
            XTable xTable = this.Item(string);
            xTable.Rows().Delete();
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    protected void refreshTableCache() {
        XTextTable xTextTable;
        String[] stringArray = null;
        XHelperInterface xHelperInterface = this.getParent();
        XModel xModel = this.getXModel();
        XTextTablesSupplier xTextTablesSupplier = null;
        try {
            xTextTablesSupplier = (XTextTablesSupplier)OptionalParamUtility.getObject(class$com$sun$star$text$XTextTablesSupplier == null ? (class$com$sun$star$text$XTextTablesSupplier = TablesImpl.class$("com.sun.star.text.XTextTablesSupplier")) : class$com$sun$star$text$XTextTablesSupplier, xModel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        XNameAccess xNameAccess = null;
        if (xTextTablesSupplier != null) {
            xNameAccess = xTextTablesSupplier.getTextTables();
            if (xHelperInterface instanceof RangeImpl) {
                XTextCursor xTextCursor = ((RangeImpl)xHelperInterface).getXTextCursor();
                xTextTable = new Vector();
                try {
                    Object object;
                    Object object2;
                    XEnumeration xEnumeration;
                    Object object3;
                    XEnumeration xEnumeration2 = (XEnumeration)OptionalParamUtility.getObject(class$com$sun$star$container$XEnumeration == null ? (class$com$sun$star$container$XEnumeration = TablesImpl.class$("com.sun.star.container.XEnumeration")) : class$com$sun$star$container$XEnumeration, xTextCursor.getText());
                    if (xEnumeration2 != null) {
                        while (xEnumeration2.hasMoreElements()) {
                            object3 = xEnumeration2.nextElement();
                            if (object3 instanceof Any) {
                                xEnumeration = (Any)object3;
                                object3 = xEnumeration.getObject();
                            }
                            if (object3 instanceof XTextTable) continue;
                            xEnumeration = (XTextTable)object3;
                            object2 = (XNamed)OptionalParamUtility.getObject(class$com$sun$star$container$XNamed == null ? TablesImpl.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed, object3);
                            object = object2.getName();
                        }
                    }
                    object3 = (XEnumerationAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = TablesImpl.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess, xTextCursor.getText());
                    xEnumeration = object3.createEnumeration();
                    while (xEnumeration.hasMoreElements()) {
                        object2 = xEnumeration.nextElement();
                        if (object2 instanceof Any) {
                            object = (Any)object2;
                            object2 = object.getObject();
                        }
                        if (!(object2 instanceof XTextTable) && (object = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? TablesImpl.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet, object2)) != null) {
                            try {
                                object2 = object.getPropertyValue("TextTable");
                                if (object2 != null && !AnyConverter.isVoid((Object)object2)) {
                                    object2 = (XTextTable)OptionalParamUtility.getObject(class$com$sun$star$text$XTextTable == null ? TablesImpl.class$("com.sun.star.text.XTextTable") : class$com$sun$star$text$XTextTable, object2);
                                }
                            }
                            catch (UnknownPropertyException unknownPropertyException) {
                                DebugHelper.warning((com.sun.star.uno.Exception)((Object)unknownPropertyException));
                            }
                        }
                        if (!(object2 instanceof XTextTable) || (object = (XNamed)OptionalParamUtility.getObject(class$com$sun$star$container$XNamed == null ? TablesImpl.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed, object2)) == null) continue;
                        xTextTable.add(object.getName());
                    }
                    stringArray = new String[xTextTable.size()];
                    stringArray = xTextTable.toArray(stringArray);
                }
                catch (NullPointerException nullPointerException) {
                    HelperUtilities.exception(nullPointerException);
                }
                catch (ClassCastException classCastException) {
                    HelperUtilities.exception(classCastException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    HelperUtilities.exception(noSuchElementException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    HelperUtilities.exception(illegalArgumentException);
                }
                catch (WrappedTargetException wrappedTargetException) {
                    HelperUtilities.exception(wrappedTargetException);
                }
            } else if (xNameAccess.hasElements()) {
                stringArray = xNameAccess.getElementNames();
            }
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    xTextTable = (XTextTable)OptionalParamUtility.getObject(class$com$sun$star$text$XTextTable == null ? TablesImpl.class$("com.sun.star.text.XTextTable") : class$com$sun$star$text$XTextTable, xNameAccess.getByName(stringArray[n]));
                    this.documentTableCache.put(stringArray[n], new TableImpl(this, xTextTable, stringArray[n]));
                }
                catch (Exception exception) {
                    DebugHelper.writeInfo(exception.getMessage());
                }
                ++n;
            }
        }
    }

    protected void removeFromTableCache(String string) {
        if (string != null) {
            this.documentTableCache.remove(string);
        }
    }

    private TableImpl createTable(XRange xRange, int n, int n2, Object object, Object object2) throws com.sun.star.uno.Exception {
        this.refreshTableCache();
        XModel xModel = ((RangeImpl)xRange).getXModel();
        XTextRange xTextRange = xRange.getXTextRange();
        XTextTable xTextTable = null;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = TablesImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xModel);
        Object object3 = xMultiServiceFactory.createInstance("com.sun.star.text.TextTable");
        xTextTable = (XTextTable)OptionalParamUtility.getObject(class$com$sun$star$text$XTextTable == null ? (class$com$sun$star$text$XTextTable = TablesImpl.class$("com.sun.star.text.XTextTable")) : class$com$sun$star$text$XTextTable, object3);
        xTextTable.initialize(n, n2);
        XText xText = xTextRange.getText();
        XTextContent xTextContent = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = TablesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, xTextTable);
        xText.insertTextContent(xTextRange, xTextContent, true);
        TableImpl tableImpl = null;
        if (xTextTable != null) {
            XNamed xNamed = (XNamed)OptionalParamUtility.getObject(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = TablesImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed, xTextTable);
            tableImpl = new TableImpl(this, xTextTable, xNamed.getName());
            this.documentTableCache.put(xNamed.getName(), tableImpl);
        }
        if (tableImpl == null) {
            throw new com.sun.star.uno.Exception("Could not create a new TextTable.");
        }
        return tableImpl;
    }

    protected TableImpl getTableByName(String string) throws NoSuchElementException {
        this.refreshTableCache();
        TableImpl tableImpl = (TableImpl)this.documentTableCache.get(string);
        if (tableImpl == null) {
            throw new NoSuchElementException("An element with name '" + string + "' was not found.");
        }
        return tableImpl;
    }

    private TableImpl getTableAtIndex(int n) throws IndexOutOfBoundsException {
        this.refreshTableCache();
        try {
            TableImpl[] tableImplArray = new TableImpl[this.documentTableCache.size()];
            tableImplArray = this.documentTableCache.values().toArray(tableImplArray);
            return tableImplArray[n];
        }
        catch (Exception exception) {
            throw new IndexOutOfBoundsException("An element with index '" + n + "' was not found.");
        }
    }

    private int getNumTables() {
        this.refreshTableCache();
        return this.documentTableCache.size();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

