/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.ParagraphFormatHelper;
import com.sun.star.helper.writer.ParagraphFormatImpl;
import com.sun.star.helper.writer.TabStopImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XTabStop;
import com.sun.star.helper.writer.XTabStops;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.TabAlign;
import com.sun.star.style.TabStop;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.uno.Exception;

public class TabStopsImpl
extends HelperInterfaceAdaptor
implements XTabStops,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.TabStops";
    private XParagraphCursor xParagraphCursor;
    private static final int MIDDLE_DOT = 183;

    public TabStopsImpl(ParagraphFormatImpl paragraphFormatImpl, XParagraphCursor xParagraphCursor) {
        super(__serviceName, paragraphFormatImpl);
        this.xParagraphCursor = xParagraphCursor;
    }

    public XHelperInterface getParent() {
        return this.getParentHelper();
    }

    public XTabStop Add(Object object, Object object2, Object object3) throws BasicErrorException {
        if (object == null) {
            DebugHelper.exception(424, "Position");
        }
        TabStopImpl tabStopImpl = null;
        try {
            float f = NumericalHelper.toFloat(object);
            int n = WriterUtilities.pointsToHundredthsMillimeter(f);
            int n2 = 46;
            int n3 = object3 == null ? 32 : (int)this.getFillCharFromLeader(NumericalHelper.toInt(object3));
            TabAlign tabAlign = object2 == null ? TabAlign.LEFT : this.getAlignment(NumericalHelper.toInt(object2));
            TabStop tabStop = new TabStop();
            tabStop.DecimalChar = (char)n2;
            tabStop.FillChar = (char)n3;
            tabStop.Position = n;
            tabStop.Alignment = tabAlign;
            Object[] objectArray = ParagraphFormatHelper.getPropertyValue("ParaTabStops", this.xParagraphCursor);
            TabStop[] tabStopArray = (TabStop[])objectArray[0];
            boolean bl = false;
            TabStop[] tabStopArray2 = null;
            if (tabStopArray != null) {
                tabStopArray2 = new TabStop[tabStopArray.length + 1];
                tabStopArray2[0] = tabStop;
                int n4 = 0;
                while (n4 < tabStopArray.length && !bl) {
                    tabStopArray2[n4 + 1] = tabStopArray[n4];
                    if (tabStopArray[n4].Position == n) {
                        bl = true;
                        tabStopArray[n4] = tabStop;
                    }
                    ++n4;
                }
            } else {
                tabStopArray2 = new TabStop[]{tabStop};
            }
            if (bl) {
                ParagraphFormatHelper.setPropertyValue("ParaTabStops", tabStopArray, this.xParagraphCursor);
            } else {
                ParagraphFormatHelper.setPropertyValue("ParaTabStops", tabStopArray2, this.xParagraphCursor);
            }
            tabStopImpl = new TabStopImpl(this, this.xParagraphCursor, n);
        }
        catch (ClassCastException classCastException) {
            DebugHelper.exception(51, classCastException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return tabStopImpl;
    }

    public int Count() throws BasicErrorException {
        int n = 0;
        Object[] objectArray = ParagraphFormatHelper.getPropertyValue("ParaTabStops", this.xParagraphCursor);
        TabStop[] tabStopArray = (TabStop[])objectArray[0];
        if (tabStopArray != null) {
            n = tabStopArray.length;
        }
        return n;
    }

    protected TabStop[] getStops() throws BasicErrorException {
        Object[] objectArray = ParagraphFormatHelper.getPropertyValue("ParaTabStops", this.xParagraphCursor);
        TabStop[] tabStopArray = null;
        try {
            tabStopArray = (TabStop[])objectArray[0];
        }
        catch (ClassCastException classCastException) {
            DebugHelper.exception(51, classCastException.getMessage());
        }
        return tabStopArray;
    }

    private char getFillCharFromLeader(int n) {
        char c = ' ';
        switch (n) {
            case 2: {
                c = '-';
                break;
            }
            case 1: {
                c = '.';
                break;
            }
            case 3: {
                c = '_';
                break;
            }
            case 4: {
                c = '_';
                break;
            }
            case 5: {
                c = '\u00b7';
                break;
            }
        }
        return c;
    }

    private TabAlign getAlignment(int n) throws BasicErrorException {
        TabAlign tabAlign = TabAlign.LEFT;
        switch (n) {
            case 4: {
                DebugHelper.exception(73, "Alignment");
                break;
            }
            case 1: {
                tabAlign = TabAlign.CENTER;
                break;
            }
            case 3: {
                tabAlign = TabAlign.DECIMAL;
                break;
            }
            case 2: {
                tabAlign = TabAlign.RIGHT;
                break;
            }
        }
        return tabAlign;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xParagraphCursor;
    }
}

