/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XBitmap;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.CollectionHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.GraphicsFilename;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.ShapeImpl;
import com.sun.star.helper.writer.ShapeName;
import com.sun.star.helper.writer.ShapeNameCounter;
import com.sun.star.helper.writer.ShapeRangeImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XShape;
import com.sun.star.helper.writer.XShapeRange;
import com.sun.star.helper.writer.XShapes;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.BorderLine;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.WrapTextMode;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;
import java.util.ArrayList;

public class ShapesImpl
extends HelperInterfaceAdaptor
implements XShapes,
ShapeNameCounter,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Shapes";
    private com.sun.star.drawing.XShapes m_xShapes = null;
    private ShapesHelperCache m_aCurrentShapesList;
    private static int sizeFactorPolyline = 20;
    private static int xyFactorPolyline = 570;
    private static double xyFactorTextbox = 14.35;
    private static short textboxBorderline = (short)5;
    private static int textboxLeftBorderlineDist = 280;
    private static int textboxTopBorderlineDist = 150;
    private static int noShapesSelected = 0;
    private int m_nShapeCount = 0;
    XNameAccess xNamedShapes = null;
    static /* synthetic */ Class class$com$sun$star$drawing$XShapes;
    static /* synthetic */ Class class$com$sun$star$helper$writer$XShape;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$helper$writer$XRange;
    static /* synthetic */ Class class$com$sun$star$text$XTextContent;
    static /* synthetic */ Class class$com$sun$star$awt$XBitmap;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$text$XTextRange;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$drawing$XDrawPageSupplier;

    public ShapesImpl(DocumentImpl documentImpl, com.sun.star.drawing.XShapes xShapes) throws IllegalArgumentException {
        super(__serviceName, documentImpl);
        this.m_xShapes = (com.sun.star.drawing.XShapes)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShapes == null ? (class$com$sun$star$drawing$XShapes = ShapesImpl.class$("com.sun.star.drawing.XShapes")) : class$com$sun$star$drawing$XShapes, xShapes);
        this.m_aCurrentShapesList = new ShapesHelperCache(this);
        this.m_nShapeCount = this.m_aCurrentShapesList.count();
    }

    public XDocument getParent() {
        return (DocumentImpl)this.getParentHelper();
    }

    public int Count() {
        this.m_aCurrentShapesList.updateCache();
        return this.m_aCurrentShapesList.count();
    }

    public XShape Item(Object object) throws BasicErrorException {
        XShape xShape = null;
        if (AnyConverter.isString((Object)object)) {
            String string = "";
            try {
                string = AnyConverter.toString((Object)object);
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
            xShape = this.getItemByName(string);
        } else {
            try {
                int n = NumericalHelper.toInt(object);
                xShape = this.getItemByIndex(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(964, object.getClass().getName());
            }
        }
        if (xShape == null) {
            DebugHelper.exception(5, "");
        }
        return xShape;
    }

    protected XShape getItemByName(String string) throws BasicErrorException {
        Object var2_2 = null;
        this.m_aCurrentShapesList.updateCache();
        int n = this.m_aCurrentShapesList.count();
        int n2 = 0;
        while (n2 < n) {
            ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n2);
            if (shapeImpl.getName().equals(string)) {
                return shapeImpl;
            }
            ++n2;
        }
        return null;
    }

    protected XShape getItemByIndex(int n) throws BasicErrorException {
        Object var2_2 = null;
        XShape xShape = null;
        Object var4_4 = null;
        this.m_aCurrentShapesList.updateCache();
        Object object = this.m_aCurrentShapesList.item(n - 1);
        try {
            xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$helper$writer$XShape == null ? (class$com$sun$star$helper$writer$XShape = ShapesImpl.class$("com.sun.star.helper.writer.XShape")) : class$com$sun$star$helper$writer$XShape, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return xShape;
    }

    public Object AddLine(int n, int n2, int n3, int n4, Object object) throws BasicErrorException {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        com.sun.star.drawing.XShape xShape = null;
        Object var9_9 = null;
        try {
            XDocument xDocument;
            int n7 = WriterUtilities.pointsToHundredthsMillimeter(n6);
            int n8 = WriterUtilities.pointsToHundredthsMillimeter(n5);
            int n9 = WriterUtilities.pointsToHundredthsMillimeter(n);
            int n10 = WriterUtilities.pointsToHundredthsMillimeter(n2);
            xShape = this.createShape("com.sun.star.drawing.LineShape", n9, n10, n8, n7);
            String string = ShapeName.create("Line", this);
            this.incrementShapeCount();
            ShapesImpl.setDefaultShapeProperties(xShape);
            if (AnyConverter.isVoid((Object)object)) {
                xDocument = this.getParent();
                object = xDocument.Range(new Integer(0), new Integer(1));
            }
            ShapesImpl.setShape_NameProperty(xShape, string);
            this.m_xShapes.add(xShape);
            ShapesImpl.setShape_RangeProperty(xShape, object);
            xDocument = xShape.getPosition();
            boolean bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        Point point = xShape.getPosition();
        ShapeImpl shapeImpl = new ShapeImpl(this, xShape, 9);
        return shapeImpl;
    }

    public Object AddPolyline(int[][] nArray, Object object) throws BasicErrorException {
        Object object2;
        Point point;
        XTextDocument xTextDocument;
        XMultiServiceFactory xMultiServiceFactory = null;
        com.sun.star.drawing.XShape xShape = null;
        XPropertySet xPropertySet = null;
        try {
            xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, this.getXModel());
            xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = ShapesImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xTextDocument);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        xTextDocument = null;
        int n = nArray.length;
        Point[] pointArray = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            point = new Point();
            point.X = new Double(sizeFactorPolyline * nArray[n2][0] + xyFactorPolyline).intValue();
            point.Y = new Double(sizeFactorPolyline * nArray[n2][1] + xyFactorPolyline).intValue();
            pointArray[n2] = point;
            ++n2;
        }
        point = new Point[1][1];
        point[0] = pointArray;
        try {
            xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, xMultiServiceFactory.createInstance("com.sun.star.drawing.PolyPolygonShape"));
            object2 = ShapeName.create("Freeform", this);
            this.incrementShapeCount();
            xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xShape);
            this.m_xShapes.add(xShape);
            WriterUtilities.setProperty(xPropertySet, "PolyPolygon", point);
            ShapesImpl.setDefaultShapeProperties(xPropertySet);
            if (AnyConverter.isVoid((Object)object)) {
                XDocument xDocument = this.getParent();
                object = xDocument.Range(null, null);
            }
            ShapesImpl.setShape_RangeProperty(xPropertySet, object);
            ShapesImpl.setShape_NameProperty(xPropertySet, (String)object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        object2 = new ShapeImpl(this, xShape, 5);
        return object2;
    }

    public Object AddTextbox(int n, int n2, int n3, int n4, int n5, Object object) throws BasicErrorException {
        Object object2;
        if (n != 1) {
            DebugHelper.warning((Exception)((Object)new NoSupportException("Parameter textOrientation must be msoTextOrientationHorizontal.")));
        }
        int n6 = 0;
        int n7 = 0;
        com.sun.star.drawing.XShape xShape = null;
        try {
            object2 = this.createBaseFrame("com.sun.star.text.TextFrame");
            xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object2);
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object2);
            this.insertFrame(object2);
            String string = ShapeName.create("Text Box", this);
            this.incrementShapeCount();
            int n8 = new Double(xyFactorTextbox * (double)n2).intValue();
            int n9 = new Double(xyFactorTextbox * (double)n3).intValue();
            this.setFrameProperties(xPropertySet, string, n8, n9);
            n7 = WriterUtilities.pointsToHundredthsMillimeter(n4);
            n6 = WriterUtilities.pointsToHundredthsMillimeter(n5);
            WriterUtilities.setProperty(xPropertySet, "Width", new Integer(n7));
            WriterUtilities.setProperty(xPropertySet, "Height", new Integer(n6));
            BorderLine borderLine = new BorderLine();
            borderLine.OuterLineWidth = textboxBorderline;
            WriterUtilities.setProperty(xPropertySet, "LeftBorder", borderLine);
            WriterUtilities.setProperty(xPropertySet, "RightBorder", borderLine);
            WriterUtilities.setProperty(xPropertySet, "TopBorder", borderLine);
            WriterUtilities.setProperty(xPropertySet, "BottomBorder", borderLine);
            WriterUtilities.setProperty(xPropertySet, "LeftBorderDistance", new Integer(textboxLeftBorderlineDist));
            WriterUtilities.setProperty(xPropertySet, "RightBorderDistance", new Integer(textboxLeftBorderlineDist));
            WriterUtilities.setProperty(xPropertySet, "TopBorderDistance", new Integer(textboxTopBorderlineDist));
            WriterUtilities.setProperty(xPropertySet, "BottomBorderDistance", new Integer(textboxTopBorderlineDist));
            if (!AnyConverter.isVoid((Object)object)) {
                XRange xRange = (XRange)AnyConverter.toObject((Class)(class$com$sun$star$helper$writer$XRange == null ? (class$com$sun$star$helper$writer$XRange = ShapesImpl.class$("com.sun.star.helper.writer.XRange")) : class$com$sun$star$helper$writer$XRange), (Object)object);
                XTextContent xTextContent = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = ShapesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, xPropertySet);
                XTextRange xTextRange = xRange.getXTextRange();
                xTextContent.attach(xTextRange);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        object2 = new ShapeImpl(this, xShape, 17);
        return object2;
    }

    protected void incrementShapeCount() {
        ++this.m_nShapeCount;
        this.getParent().setCountAddedShapes(this.getParent().getCountAddedShapes() + 1);
    }

    protected void decrementShapeCount() {
        this.getParent().setCountAddedShapes(this.getParent().getCountAddedShapes() - 1);
    }

    protected String findFileURL(String string) throws BasicErrorException {
        if (string.startsWith("http:") || string.startsWith("file:") || string.startsWith("ftp:")) {
            return string;
        }
        GraphicsFilename graphicsFilename = new GraphicsFilename(string);
        if (graphicsFilename.checkExistanceForRead()) {
            return graphicsFilename.getURL();
        }
        String string2 = System.getProperty("user.dir");
        String string3 = System.getProperty("file.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        if (!string2.endsWith(string3)) {
            stringBuffer.append(string3);
        }
        stringBuffer.append(string);
        GraphicsFilename graphicsFilename2 = new GraphicsFilename(stringBuffer.toString());
        if (graphicsFilename2.checkExistanceForRead()) {
            return graphicsFilename2.getURL();
        }
        DebugHelper.writeInfo("findFileURL(): File '" + graphicsFilename.getAbsoluteFilename() + "' not found.");
        DebugHelper.writeInfo("findFileURL(): File '" + graphicsFilename2.getAbsoluteFilename() + "' not found.");
        DebugHelper.exception(53, "");
        return "";
    }

    public Object AddPicture(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws BasicErrorException {
        ShapeImpl shapeImpl;
        Object object9 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (!AnyConverter.isVoid((Object)object3)) {
            n4 = OptionalParamUtility.getInt("left", object3, 0, false);
        }
        if (!AnyConverter.isVoid((Object)object4)) {
            n3 = OptionalParamUtility.getInt("top", object4, 0, false);
        }
        if (!AnyConverter.isVoid((Object)object5)) {
            n5 = OptionalParamUtility.getInt("width", object5, 0, false);
        }
        if (!AnyConverter.isVoid((Object)object6)) {
            n6 = OptionalParamUtility.getInt("height", object6, 0, false);
        }
        com.sun.star.drawing.XShape xShape = null;
        try {
            XTextRange xTextRange;
            Object object10;
            Object object11;
            object9 = this.createBaseFrame("com.sun.star.drawing.GraphicObjectShape");
            xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object9);
            shapeImpl = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object9);
            String string2 = this.findFileURL(string);
            WriterUtilities.setProperty((XPropertySet)shapeImpl, "GraphicURL", string2);
            Size size = new Size();
            Point point = new Point();
            size.Height = WriterUtilities.pointsToHundredthsMillimeter(n6);
            size.Width = WriterUtilities.pointsToHundredthsMillimeter(n5);
            point.X = WriterUtilities.pointsToHundredthsMillimeter(n4);
            point.Y = WriterUtilities.pointsToHundredthsMillimeter(n3);
            xShape.setSize(size);
            xShape.setPosition(point);
            String string3 = ShapeName.create("Picture", this);
            this.incrementShapeCount();
            this.setFrameProperties((XPropertySet)shapeImpl, string3, n, n2);
            if (!AnyConverter.isVoid((Object)object7)) {
                object8 = object7;
            }
            if (!AnyConverter.isVoid((Object)object8)) {
                object11 = (XRange)AnyConverter.toObject((Class)(class$com$sun$star$helper$writer$XRange == null ? (class$com$sun$star$helper$writer$XRange = ShapesImpl.class$("com.sun.star.helper.writer.XRange")) : class$com$sun$star$helper$writer$XRange), (Object)object8);
                object10 = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = ShapesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, shapeImpl);
                xTextRange = object11.getXTextRange();
                object10.attach(xTextRange);
            } else {
                this.insertFrame(object9);
            }
            object11 = new PropertySetHelper(shapeImpl);
            object10 = ((PropertySetHelper)object11).getPropertyValueAsObject("GraphicObjectFillBitmap");
            xTextRange = (XBitmap)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XBitmap == null ? (class$com$sun$star$awt$XBitmap = ShapesImpl.class$("com.sun.star.awt.XBitmap")) : class$com$sun$star$awt$XBitmap), (Object)object10);
            if (xTextRange != null) {
                Size size2 = xTextRange.getSize();
                size.Height = WriterUtilities.pointsToHundredthsMillimeter(size2.Height);
                size.Width = WriterUtilities.pointsToHundredthsMillimeter(size2.Width);
                xShape.setSize(size);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        shapeImpl = new ShapeImpl(this, xShape, 13);
        return shapeImpl;
    }

    public void SelectAll() throws BasicErrorException {
        XSelectionSupplier xSelectionSupplier = null;
        com.sun.star.drawing.XShapes xShapes = null;
        try {
            xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = ShapesImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.getXModel().getCurrentController());
            this.m_aCurrentShapesList.updateCache();
            int n = this.m_aCurrentShapesList.count();
            xShapes = this.getEmptyShapesCollection();
            int n2 = 0;
            while (n2 < n) {
                ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n2);
                com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, shapeImpl.getXShape());
                xShapes.add(xShape);
                ++n2;
            }
            xSelectionSupplier.select((Object)xShapes);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public XShapeRange Range(Object object) throws BasicErrorException {
        ShapeRangeImpl shapeRangeImpl;
        block12: {
            shapeRangeImpl = null;
            com.sun.star.drawing.XShapes xShapes = null;
            String string = "";
            int n = -1;
            Object var6_6 = null;
            Object var7_7 = null;
            Object var8_8 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            bl = AnyConverter.isVoid((Object)object);
            bl2 = AnyConverter.isString((Object)object);
            bl3 = AnyConverter.isArray((Object)object);
            bl4 = NumericalHelper.isNumerical(object);
            if (object == null || bl) break block12;
            try {
                if (bl4) {
                    n = NumericalHelper.toInt(object);
                    xShapes = this.getShapeByIndex(n);
                } else if (bl2) {
                    string = AnyConverter.toString((Object)object);
                    xShapes = this.getShapeByName(string);
                } else if (bl3) {
                    String[] stringArray;
                    if (this.isStringArray(object)) {
                        stringArray = NumericalHelper.toStringArray(object);
                        xShapes = this.getShapesByNames(stringArray);
                    } else {
                        stringArray = (String[])NumericalHelper.toIntArray(object);
                        xShapes = this.getShapesByIndex((int[])stringArray);
                    }
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
            if (xShapes.getCount() == noShapesSelected) {
                DebugHelper.exception(366, "The item wasn't found.");
            }
            try {
                shapeRangeImpl = new ShapeRangeImpl(this, xShapes);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
        }
        return shapeRangeImpl;
    }

    private boolean isStringArray(Object object) {
        boolean bl = false;
        if (object instanceof String[]) {
            bl = true;
        }
        return bl;
    }

    private com.sun.star.drawing.XShapes getShapeByIndex(int n) throws Exception, IllegalArgumentException {
        com.sun.star.drawing.XShapes xShapes = null;
        this.m_aCurrentShapesList.updateCache();
        ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n - 1);
        com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getXShape());
        xShapes = this.getEmptyShapesCollection();
        xShapes.add(xShape);
        return xShapes;
    }

    private com.sun.star.drawing.XShapes getShapesByIndex(int[] nArray) throws Exception, IllegalArgumentException {
        com.sun.star.drawing.XShapes xShapes = this.getEmptyShapesCollection();
        this.m_aCurrentShapesList.updateCache();
        int n = 0;
        while (n < nArray.length) {
            ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n);
            com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, shapeImpl.getXShape());
            xShapes.add(xShape);
            ++n;
        }
        return xShapes;
    }

    private com.sun.star.drawing.XShapes getShapeByName(String string) throws Exception, IllegalArgumentException {
        com.sun.star.drawing.XShapes xShapes = null;
        xShapes = this.getEmptyShapesCollection();
        this.m_aCurrentShapesList.updateCache();
        int n = 0;
        while (n < this.m_aCurrentShapesList.count()) {
            ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n);
            com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, shapeImpl.getXShape());
            String string2 = "";
            try {
                string2 = shapeImpl.getName();
            }
            catch (BasicErrorException basicErrorException) {
                // empty catch block
            }
            if (string2.equalsIgnoreCase(string)) {
                xShapes.add(xShape);
                break;
            }
            ++n;
        }
        return xShapes;
    }

    private com.sun.star.drawing.XShapes getShapesByNames(String[] stringArray) throws Exception, IllegalArgumentException {
        com.sun.star.drawing.XShapes xShapes = this.getEmptyShapesCollection();
        this.m_aCurrentShapesList.updateCache();
        int n = 0;
        while (n < stringArray.length) {
            com.sun.star.drawing.XShapes xShapes2 = this.getEmptyShapesCollection();
            String string = stringArray[n];
            xShapes2 = this.getShapeByName(string);
            Object object = xShapes2.getByIndex(0);
            com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, object);
            xShapes.add(xShape);
            ++n;
        }
        return xShapes;
    }

    private com.sun.star.drawing.XShapes getEmptyShapesCollection() throws Exception, IllegalArgumentException {
        XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
        Object object = xMultiServiceFactory.createInstance("com.sun.star.drawing.ShapeCollection");
        com.sun.star.drawing.XShapes xShapes = (com.sun.star.drawing.XShapes)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShapes == null ? (class$com$sun$star$drawing$XShapes = ShapesImpl.class$("com.sun.star.drawing.XShapes")) : class$com$sun$star$drawing$XShapes, object);
        return xShapes;
    }

    private Object createBaseFrame(String string) throws IllegalArgumentException, Exception {
        XTextDocument xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, this.getXModel());
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = ShapesImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xTextDocument);
        Object object = null;
        object = xMultiServiceFactory.createInstance(string);
        return object;
    }

    private void insertFrame(Object object) throws IllegalArgumentException {
        XTextDocument xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, this.getXModel());
        XText xText = xTextDocument.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        XTextContent xTextContent = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = ShapesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, object);
        xText.insertTextContent((XTextRange)xTextCursor, xTextContent, true);
    }

    private com.sun.star.drawing.XShape createShape(String string, int n, int n2, int n3, int n4) throws IllegalArgumentException, Exception, PropertyVetoException {
        XTextDocument xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, this.getXModel());
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = ShapesImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xTextDocument);
        Object object = null;
        object = xMultiServiceFactory.createInstance(string);
        com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
        Point point = new Point();
        point.X = n;
        point.Y = n2;
        xShape.setPosition(point);
        Size size = new Size();
        size.Height = n4;
        size.Width = n3;
        xShape.setSize(size);
        Point point2 = xShape.getPosition();
        return xShape;
    }

    public static void setShape_RangeProperty(Object object, Object object2) {
        XTextRange xTextRange = null;
        PropertySetHelper propertySetHelper = new PropertySetHelper(object);
        if (AnyConverter.isVoid((Object)object2)) {
            propertySetHelper.setPropertyValueDontThrow("AnchorType", TextContentAnchorType.AT_PAGE);
        }
        propertySetHelper.setPropertyValueDontThrow("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
        XRange xRange = (XRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$helper$writer$XRange == null ? (class$com$sun$star$helper$writer$XRange = ShapesImpl.class$("com.sun.star.helper.writer.XRange")) : class$com$sun$star$helper$writer$XRange), (Object)object2);
        if (xRange != null) {
            xTextRange = (XTextRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRange == null ? (class$com$sun$star$text$XTextRange = ShapesImpl.class$("com.sun.star.text.XTextRange")) : class$com$sun$star$text$XTextRange), (Object)xRange.getXTextRange());
            if (xTextRange != null) {
                propertySetHelper.setPropertyValueDontThrow("TextRange", xTextRange.getStart());
            } else {
                DebugHelper.writeInfo("Can't set Shapes.Property 'TextRange'.");
            }
        }
    }

    public static void setShape_NameProperty(Object object, String string) {
        PropertySetHelper propertySetHelper = new PropertySetHelper(object);
        propertySetHelper.setPropertyValueDontThrow("Name", string);
    }

    public static void setDefaultShapeProperties(Object object) throws BasicErrorException {
        try {
            com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
            Point point = xShape.getPosition();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
            WriterUtilities.setProperty(xPropertySet, "FillStyle", "SOLID");
            point = xShape.getPosition();
            WriterUtilities.setProperty(xPropertySet, "FillColor", new Integer(0xFFFFFF));
            WriterUtilities.setProperty(xPropertySet, "TextWrap", WrapTextMode.THROUGHT);
            WriterUtilities.setProperty(xPropertySet, "Opaque", new Boolean(true));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    private void setFrameProperties(XPropertySet xPropertySet, String string, int n, int n2) throws IllegalArgumentException, PropertyVetoException, BasicErrorException {
        WriterUtilities.setProperty(xPropertySet, "FillStyle", "SOLID");
        WriterUtilities.setProperty(xPropertySet, "FillColor", new Integer(0xFFFFFF));
        WriterUtilities.setProperty(xPropertySet, "AnchorType", TextContentAnchorType.AT_PARAGRAPH);
        WriterUtilities.setProperty(xPropertySet, "TextWrap", WrapTextMode.THROUGHT);
        WriterUtilities.setProperty(xPropertySet, "Opaque", new Boolean(true));
        WriterUtilities.setProperty(xPropertySet, "HoriOrient", new Short(0));
        WriterUtilities.setProperty(xPropertySet, "HoriOrientRelation", new Integer(0));
        WriterUtilities.setProperty(xPropertySet, "HoriOrientPosition", new Integer(n));
        WriterUtilities.setProperty(xPropertySet, "VertOrient", new Short(0));
        WriterUtilities.setProperty(xPropertySet, "VertOrientRelation", new Integer(1));
        WriterUtilities.setProperty(xPropertySet, "VertOrientPosition", new Integer(n2));
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = ShapesImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)xPropertySet);
        if (xNamed != null) {
            xNamed.setName(string);
        } else {
            WriterUtilities.setProperty(xPropertySet, "Name", string);
        }
    }

    public void remove(com.sun.star.drawing.XShape xShape) {
        this.m_xShapes.remove(xShape);
    }

    public int getCurrentShapeNameCount() {
        return this.m_nShapeCount;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.m_xShapes;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ShapesHelperCache
    extends CollectionHelper {
        private HelperInterfaceAdaptor shapes;

        ShapesHelperCache(HelperInterfaceAdaptor helperInterfaceAdaptor) {
            super(1);
            this.shapes = helperInterfaceAdaptor;
        }

        public HelperInterfaceAdaptor createHelper(Object object) {
            com.sun.star.drawing.XShape xShape = null;
            ShapeImpl shapeImpl = null;
            try {
                xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
                shapeImpl = new ShapeImpl(this.shapes, xShape, 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((Exception)((Object)illegalArgumentException));
            }
            catch (BasicErrorException basicErrorException) {
                DebugHelper.warning((Exception)((Object)basicErrorException));
            }
            return shapeImpl;
        }

        public void fetchImplementationObjects(ArrayList arrayList) {
            XDrawPageSupplier xDrawPageSupplier = null;
            Object var3_3 = null;
            com.sun.star.drawing.XShape xShape = null;
            XTextDocument xTextDocument = null;
            try {
                xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, ShapesImpl.this.getXModel());
                xDrawPageSupplier = (XDrawPageSupplier)OptionalParamUtility.getObject(class$com$sun$star$drawing$XDrawPageSupplier == null ? (class$com$sun$star$drawing$XDrawPageSupplier = ShapesImpl.class$("com.sun.star.drawing.XDrawPageSupplier")) : class$com$sun$star$drawing$XDrawPageSupplier, xTextDocument);
                ShapesImpl.this.m_xShapes = (com.sun.star.drawing.XShapes)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShapes == null ? (class$com$sun$star$drawing$XShapes = ShapesImpl.class$("com.sun.star.drawing.XShapes")) : class$com$sun$star$drawing$XShapes, xDrawPageSupplier.getDrawPage());
                int n = ShapesImpl.this.m_xShapes.getCount();
                int n2 = 0;
                while (n2 < n) {
                    Object object = ShapesImpl.this.m_xShapes.getByIndex(n2);
                    xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, object);
                    arrayList.add(xShape);
                    ++n2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((Exception)((Object)illegalArgumentException));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DebugHelper.warning((Exception)((Object)indexOutOfBoundsException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.warning((Exception)((Object)wrappedTargetException));
            }
        }

        public boolean isValidImplementationObject(Object object) {
            boolean bl = false;
            com.sun.star.drawing.XShape xShape = null;
            try {
                xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
                String string = xShape.getShapeType();
                if (!string.equalsIgnoreCase("com.sun.star.drawing.ControlShape")) {
                    bl = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((Exception)((Object)illegalArgumentException));
            }
            return bl;
        }
    }
}

