/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.calc.CalcHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.writer.ColorTableHelper;
import com.sun.star.helper.writer.ParagraphFormatImpl;
import com.sun.star.helper.writer.XShading;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;

public class ShadingImpl
extends HelperInterfaceAdaptor
implements XShading {
    protected static final String __serviceName = "com.sun.star.helper.writer.Shading";
    ParagraphFormatImpl parentParagraphFormat = null;

    public ShadingImpl(ParagraphFormatImpl paragraphFormatImpl) {
        super(__serviceName, paragraphFormatImpl);
        this.parentParagraphFormat = paragraphFormatImpl;
    }

    public XHelperInterface getParent() {
        return this.parentParagraphFormat;
    }

    public void setTexture(int n) throws BasicErrorException {
        if (n == 0) {
            this.parentParagraphFormat.setPropertyValue("ParaBackTransparent", Boolean.TRUE);
        } else if (n == 1000) {
            this.parentParagraphFormat.setPropertyValue("ParaBackTransparent", Boolean.FALSE);
        } else {
            DebugHelper.exception(73, "WdTextureIndex");
        }
    }

    public int getTexture() throws BasicErrorException {
        int n;
        block3: {
            n = 0;
            try {
                boolean bl = NumericalHelper.toBoolean(this.parentParagraphFormat.getPropertyValue("ParaBackTransparent"));
                if (bl) {
                    n = 0;
                    break block3;
                }
                n = 1000;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
        }
        return n;
    }

    public void setBackgroundPatternColor(int n) throws BasicErrorException {
        DebugHelper.exception(73, "BackgroundPatternColor");
    }

    public int getBackgroundPatternColor() throws BasicErrorException {
        DebugHelper.exception(73, "BackgroundPatternColor");
        return 0;
    }

    public void setBackgroundPatternColorIndex(int n) throws BasicErrorException {
        DebugHelper.exception(73, "BackgroundPatternColor");
    }

    public int getBackgroundPatternColorIndex() throws BasicErrorException {
        DebugHelper.exception(73, "BackgroundPatternColor");
        return 0;
    }

    public void setForegroundPatternColor(int n) throws BasicErrorException {
        n = n == -16777216 ? 0 : CalcHelper.swapFirstAndThirdByte(n);
        this.parentParagraphFormat.setPropertyValue("ParaBackColor", new Integer(n));
    }

    public int getForegroundPatternColor() throws BasicErrorException {
        int n = 0;
        try {
            Object object = this.parentParagraphFormat.getPropertyValue("ParaBackColor");
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception(51, "ParaBackColor");
        }
        n = CalcHelper.swapFirstAndThirdByte(n);
        return n;
    }

    public void setForegroundPatternColorIndex(int n) throws BasicErrorException {
        try {
            int n2 = ColorTableHelper.getColorForIndex(n);
            this.setForegroundPatternColor(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception(14, "WdColorIndex");
        }
    }

    public int getForegroundPatternColorIndex() throws BasicErrorException {
        int n = this.getForegroundPatternColor();
        return ColorTableHelper.getIndexFromColor(n);
    }
}

