/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.SelectionImpl;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XTables;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.uno.UnoRuntime;

public class RangeHelper {
    static /* synthetic */ Class class$com$sun$star$text$XTextRangeCompare;

    private RangeHelper() {
    }

    public static int getPosition(XText xText, XTextRange xTextRange) {
        int n;
        block4: {
            n = -1;
            if (xText == null || xTextRange == null) break block4;
            n = 0;
            XTextCursor xTextCursor = xText.createTextCursor();
            xTextCursor.collapseToStart();
            XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = RangeHelper.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)xText);
            try {
                short s = xTextRangeCompare.compareRegionStarts(xTextCursor.getStart(), xTextRange);
                boolean bl = true;
                while (s != 0 && bl) {
                    bl = xTextCursor.goRight((short)1, false);
                    s = xTextRangeCompare.compareRegionStarts(xTextCursor.getStart(), xTextRange);
                    ++n;
                }
                if (!bl && s != 0) {
                    n = -1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
                n = -1;
            }
        }
        return n;
    }

    public static int getTableAdjustment(XTables xTables) {
        int n = 0;
        int n2 = 1;
        while (n2 <= xTables.Count()) {
            try {
                int n3 = xTables.Item(new Integer(n2)).Columns().Count();
                int n4 = xTables.Item(new Integer(n2)).Rows().Count();
                n += n4 * (n3 + 1) + 1;
            }
            catch (NullPointerException nullPointerException) {
                DebugHelper.warning(new com.sun.star.uno.Exception(nullPointerException.getMessage()));
            }
            catch (NoSuchElementException noSuchElementException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)noSuchElementException));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)indexOutOfBoundsException));
            }
            ++n2;
        }
        return n;
    }

    public static XTextRange getRangeByPosition(XText xText, int n) {
        XTextRange xTextRange = null;
        if (xText != null) {
            int n2 = 0;
            XTextCursor xTextCursor = xText.createTextCursor();
            xTextCursor.collapseToStart();
            boolean bl = true;
            while (xTextRange == null && bl) {
                if (n == n2) {
                    xTextRange = xTextCursor.getStart();
                    continue;
                }
                bl = xTextCursor.goRight((short)1, false);
                ++n2;
            }
        }
        return xTextRange;
    }

    public static XTextRangeCompare getRangeComparator(XDocument xDocument) throws BasicErrorException {
        XTextRangeCompare xTextRangeCompare = null;
        if (xDocument != null && xDocument instanceof DocumentImpl) {
            DocumentImpl documentImpl = (DocumentImpl)xDocument;
            xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = RangeHelper.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)documentImpl.getXTextRange());
        } else {
            DebugHelper.exception(5, "Got a wrong XDocument implementation");
        }
        return xTextRangeCompare;
    }

    public static int compareStartAndEnd(XTextCursor xTextCursor, XDocument xDocument) throws BasicErrorException {
        XTextRangeCompare xTextRangeCompare = RangeHelper.getRangeComparator(xDocument);
        try {
            return xTextRangeCompare.compareRegionStarts(xTextCursor.getStart(), xTextCursor.getEnd());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            return 0;
        }
    }

    public static void collapseLeftOrRight(boolean bl, XTextCursor xTextCursor, XDocument xDocument) throws BasicErrorException {
        int n = RangeHelper.compareStartAndEnd(xTextCursor, xDocument);
        if (bl) {
            n = -n;
        }
        if (n > 0) {
            xTextCursor.collapseToStart();
        } else if (n < 0) {
            xTextCursor.collapseToEnd();
        }
    }

    public static boolean forceStartPrecedesEnd(XTextCursor xTextCursor, XDocument xDocument) throws BasicErrorException {
        if (RangeHelper.compareStartAndEnd(xTextCursor, xDocument) < 0) {
            RangeHelper.swapDirection(xTextCursor);
            return true;
        }
        return false;
    }

    public static void swapDirection(XTextCursor xTextCursor) throws BasicErrorException {
        XTextRange xTextRange = xTextCursor.getStart();
        xTextCursor.collapseToEnd();
        xTextCursor.gotoRange(xTextRange, true);
    }

    public static boolean compareRanges(XTextRange xTextRange, XTextRange xTextRange2) {
        block3: {
            XTextRangeCompare xTextRangeCompare;
            if (xTextRange == null || xTextRange2 == null || (xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = RangeHelper.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)xTextRange.getText())) == null) break block3;
            try {
                if (xTextRangeCompare.compareRegionStarts(xTextRange, xTextRange2) == 0 && xTextRangeCompare.compareRegionEnds(xTextRange, xTextRange2) == 0) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        }
        return false;
    }

    public static boolean doubleUp(StringBuffer stringBuffer, char c) {
        char[] cArray = new char[]{c};
        String string = new String(cArray);
        int n = stringBuffer.indexOf(string);
        if (n >= 0 && n < stringBuffer.length() - 1 && stringBuffer.charAt(n + 1) != c) {
            stringBuffer.insert(n, c);
            return true;
        }
        return false;
    }

    public static void insertControlCharacter(XTextRange xTextRange, XText xText, short s, boolean bl) throws BasicErrorException {
        try {
            xText.insertControlCharacter(xTextRange, s, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
    }

    public static void insertString(XTextRange xTextRange, XText xText, String string, boolean bl) throws BasicErrorException {
        int n = 0;
        int n2 = 0;
        try {
            while ((n2 = string.indexOf(10, n)) >= 0) {
                xTextRange = xTextRange.getEnd();
                if (n < n2 - 1) {
                    xText.insertString(xTextRange, string.substring(n, n2 - 1), bl);
                    xTextRange = xTextRange.getEnd();
                }
                xText.insertControlCharacter(xTextRange, (short)0, bl);
                n = n2 + 1;
            }
            if (n < string.length()) {
                xTextRange = xTextRange.getEnd();
                String string2 = string.substring(n);
                xText.insertString(xTextRange, string2, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public static int getTextUnit(Object object, int n) throws BasicErrorException {
        try {
            if (NumericalHelper.isNumerical(object)) {
                return NumericalHelper.toInt(object);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public static int getNextExtent(int n) {
        n = n < 0 ? 1 : (n < 4 ? ++n : (n == 4 ? 8 : 6));
        return n;
    }

    public static XTextCursor initCursor(XTextRange xTextRange, XText xText) {
        XTextCursor xTextCursor;
        block7: {
            xTextCursor = null;
            boolean bl = false;
            try {
                xTextCursor = xText.createTextCursorByRange(xTextRange);
                bl = true;
            }
            catch (Throwable throwable) {
                DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
            }
            if (!bl) {
                try {
                    XText xText2 = xTextRange.getText();
                    xTextCursor = xText2.createTextCursor();
                    bl = true;
                }
                catch (Throwable throwable) {
                    DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
                }
            }
            if (bl) break block7;
            try {
                xTextCursor = xText.createTextCursor();
                bl = true;
            }
            catch (Throwable throwable) {
                DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
            }
        }
        return xTextCursor;
    }

    public static RangeImpl syncModelCursorToView(RangeImpl rangeImpl, DocumentImpl documentImpl, XTextViewCursor xTextViewCursor) {
        block3: {
            try {
                if (rangeImpl == null) {
                    rangeImpl = new RangeImpl((HelperInterfaceAdaptor)documentImpl, (XTextRange)xTextViewCursor);
                    break block3;
                }
                rangeImpl.setXTextRange((XTextRange)xTextViewCursor);
            }
            catch (Exception exception) {
                DebugHelper.writeInfo("syncModelCursorToView: Exception : " + exception.toString());
            }
        }
        return rangeImpl;
    }

    public static void syncModelCursorToView(SelectionImpl selectionImpl) {
        DocumentImpl documentImpl = (DocumentImpl)selectionImpl.getParent().getDocument();
        selectionImpl.setRangeImpl(RangeHelper.syncModelCursorToView(selectionImpl.getRangeImpl(), documentImpl, selectionImpl.getTextViewCursor()));
    }

    public static void syncViewCursorToModel(XTextViewCursor xTextViewCursor, RangeImpl rangeImpl) {
        try {
            RangeHelper.setXTextRange(xTextViewCursor, rangeImpl.getXTextRange());
        }
        catch (Exception exception) {
            DebugHelper.writeInfo("syncViewCursorToModel: Exception : " + exception.toString());
        }
    }

    public static void setXTextRange(XTextViewCursor xTextViewCursor, XTextRange xTextRange, XTextRange xTextRange2) {
        xTextViewCursor.gotoRange(xTextRange, false);
        xTextViewCursor.gotoRange(xTextRange2, true);
    }

    public static void setXTextRange(XTextViewCursor xTextViewCursor, XTextRange xTextRange) {
        xTextViewCursor.gotoRange(xTextRange.getStart(), false);
        xTextViewCursor.gotoRange(xTextRange.getEnd(), true);
    }

    public static short getRotationFromOrientation(int n) throws NoSupportException {
        short s = 0;
        switch (n) {
            case 0: {
                s = 0;
                break;
            }
            case 3: {
                s = 2700;
                break;
            }
            case 2: {
                s = 900;
                break;
            }
            default: {
                throw new NoSupportException("Unsopported Orientation");
            }
        }
        return s;
    }

    public static int getOrientationFromRotation(short s) {
        int n = 0;
        if (450 <= s && s <= 1350) {
            n = 2;
        } else if (1350 < s && s <= 3050) {
            n = 3;
        }
        return n;
    }

    public static boolean InRangesR2InR1(XTextRange xTextRange, XTextRange xTextRange2) {
        block3: {
            XTextRangeCompare xTextRangeCompare;
            if (xTextRange == null || xTextRange2 == null || (xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = RangeHelper.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)xTextRange.getText())) == null) break block3;
            try {
                if (xTextRangeCompare.compareRegionStarts(xTextRange, xTextRange2) >= 0 && xTextRangeCompare.compareRegionEnds(xTextRange, xTextRange2) <= 0) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

