/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.XApplication;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BordersImpl;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.StylesImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XParagraph;
import com.sun.star.helper.writer.XRange;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;

public class ParagraphImpl
extends HelperInterfaceAdaptor
implements XParagraph,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Paragraph";
    XTextRange xParagraphRange = null;
    private int paraIndex;
    RangeImpl cacheRange;
    static /* synthetic */ Class class$com$sun$star$text$XParagraphCursor;
    static /* synthetic */ Class class$com$sun$star$container$XEnumerationAccess;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$java$lang$Integer;

    public ParagraphImpl(DocumentImpl documentImpl, XTextRange xTextRange, int n) {
        super(__serviceName, documentImpl);
        this.xParagraphRange = xTextRange;
        this.paraIndex = n;
    }

    private void initRange() {
        if (this.cacheRange == null) {
            this.cacheRange = new RangeImpl((HelperInterfaceAdaptor)this, this.xParagraphRange, true);
        }
    }

    public XDocument getParent() {
        return (DocumentImpl)this.getParentHelper();
    }

    private void syncRange() throws BasicErrorException {
        this.initRange();
        this.cacheRange.StartOf(new Integer(4), Boolean.FALSE);
        this.cacheRange.EndOf(new Integer(4), Boolean.TRUE);
    }

    public XTextRange getXTextRange() {
        try {
            this.syncRange();
        }
        catch (BasicErrorException basicErrorException) {
            DebugHelper.warning((Exception)((Object)basicErrorException));
        }
        return this.xParagraphRange;
    }

    public XParagraph Next(Object object) throws BasicErrorException {
        int n = (int)OptionalParamUtility.getAnyNumber("Count", object, 1L, false);
        return this.getParent().getParagraphs().Item(this.paraIndex + n);
    }

    public XParagraph Previous(Object object) throws BasicErrorException {
        int n = (int)OptionalParamUtility.getAnyNumber("Count", object, 1L, false);
        return this.getParent().getParagraphs().Item(this.paraIndex - n);
    }

    public XRange Range() throws BasicErrorException {
        this.syncRange();
        XRange xRange = this.cacheRange.Duplicate();
        return xRange;
    }

    public XApplication Application() {
        return ApplicationImpl.getInstance();
    }

    public Object getStyle() {
        String string = StylesImpl.getHelperStyleName(this.getParent(), this);
        return ((StylesImpl)this.getParent().getStyles()).getStyleByName(string);
    }

    public void setStyle(Object object) throws BasicErrorException {
        StylesImpl.setHelperStyleAny(this.getParent(), this, object);
    }

    public XBorders Borders() {
        try {
            XParagraphCursor xParagraphCursor = (XParagraphCursor)OptionalParamUtility.getObject(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = ParagraphImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor, this.xParagraphRange);
            return new BordersImpl(this, xParagraphCursor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (NoSupportException noSupportException) {
            HelperUtilities.exception(noSupportException);
        }
        return null;
    }

    public float getSpaceAfter() throws BasicErrorException {
        int n = 9999999;
        try {
            Object object;
            XServiceInfo xServiceInfo;
            XParagraphCursor xParagraphCursor = (XParagraphCursor)OptionalParamUtility.getObject(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = ParagraphImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor, this.xParagraphRange);
            XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = ParagraphImpl.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess, xParagraphCursor);
            XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
            int n2 = -1;
            if (xEnumeration.hasMoreElements() && !(xServiceInfo = (XServiceInfo)OptionalParamUtility.getObject(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = ParagraphImpl.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, object = xEnumeration.nextElement())).supportsService("com.sun.star.text.TextTable")) {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ParagraphImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xServiceInfo);
                Integer n3 = (Integer)OptionalParamUtility.getObject(class$java$lang$Integer == null ? (class$java$lang$Integer = ParagraphImpl.class$("java.lang.Integer")) : class$java$lang$Integer, WriterUtilities.getProperty(xPropertySet, "ParaBottomMargin"));
                n2 = n3;
                n = (int)WriterUtilities.hundredthsMillimeterToPoints(n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (NoSuchElementException noSuchElementException) {
            DebugHelper.exception((Exception)((Object)noSuchElementException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        return n;
    }

    public void setSpaceAfter(float f) throws BasicErrorException {
        try {
            Object object;
            XServiceInfo xServiceInfo;
            XParagraphCursor xParagraphCursor;
            XEnumerationAccess xEnumerationAccess;
            XEnumeration xEnumeration;
            if (f < 0.0f || f > 1584.0f) {
                DebugHelper.exception(9, "The measurement must be between 0pt and 1584");
            }
            if ((xEnumeration = (xEnumerationAccess = (XEnumerationAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = ParagraphImpl.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess, xParagraphCursor = (XParagraphCursor)OptionalParamUtility.getObject(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = ParagraphImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor, this.xParagraphRange))).createEnumeration()).hasMoreElements() && !(xServiceInfo = (XServiceInfo)OptionalParamUtility.getObject(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = ParagraphImpl.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, object = xEnumeration.nextElement())).supportsService("com.sun.star.text.TextTable")) {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ParagraphImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xServiceInfo);
                xPropertySet.setPropertyValue("ParaBottomMargin", (Object)new Integer(WriterUtilities.pointsToHundredthsMillimeter(f)));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.exception((Exception)((Object)propertyVetoException));
        }
        catch (NoSuchElementException noSuchElementException) {
            DebugHelper.exception((Exception)((Object)noSuchElementException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xParagraphRange;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

