/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BordersImpl;
import com.sun.star.helper.writer.ParagraphFormatHelper;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.ShadingImpl;
import com.sun.star.helper.writer.TabStopsImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XParagraphFormat;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XShading;
import com.sun.star.helper.writer.XTabStops;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.BreakType;
import com.sun.star.style.LineSpacing;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.style.TabStop;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.util.Vector;

public class ParagraphFormatImpl
extends HelperInterfaceAdaptor
implements XParagraphFormat,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.ParagraphFormat";
    private RangeImpl m_rangeImpl;
    private XParagraphCursor xParaCursor;
    private static final int CHARACTER_INDENT_FACTOR = 12;
    private static final int AUTO_MARGIN = 423;
    private static final int PERCENT100 = 100;
    private static final int PERCENT150 = 150;
    private static final int PERCENT200 = 200;
    private static final String HEADING = "Heading";
    private static final int MAX_GRID_LINE = Short.MAX_VALUE;
    private static final int MAX_SPACE = 1584;
    private static final int MODE = 0;
    private static final int HEIGHT = 1;
    private static boolean bCharacterUnitIndentIsSet = false;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$text$XParagraphCursor;

    public ParagraphFormatImpl(RangeImpl rangeImpl) {
        super(__serviceName, rangeImpl);
        this.m_rangeImpl = rangeImpl;
        XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ParagraphFormatImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)this.m_rangeImpl.getXModel());
        XText xText = xTextDocument.getText();
        XTextCursor xTextCursor = xText.createTextCursorByRange(this.getXTextRange());
        this.xParaCursor = (XParagraphCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = ParagraphFormatImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor), (Object)xTextCursor);
    }

    public XRange getParent() {
        return (XRange)((Object)this.getParentHelper());
    }

    public XBorders getBorders() throws BasicErrorException {
        XRange xRange = this.getParent();
        BordersImpl bordersImpl = null;
        Throwable throwable = null;
        try {
            if (xRange instanceof RangeImpl) {
                bordersImpl = new BordersImpl(this, this.xParaCursor);
            } else {
                throwable = new NoSupportException("Cannot create borders object");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throwable = illegalArgumentException;
        }
        catch (NoSupportException noSupportException) {
            throwable = noSupportException;
        }
        if (throwable != null) {
            DebugHelper.exception((Exception)throwable);
        }
        return bordersImpl;
    }

    public void setAlignment(int n) throws BasicErrorException {
        ParagraphAdjust paragraphAdjust = this.getStarOfficeAlignment(n);
        this.setPropertyValue("ParaAdjust", paragraphAdjust);
    }

    public int getAlignment() throws BasicErrorException {
        int n = 0;
        Object object = this.getPropertyValue("ParaAdjust");
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return this.getMSWordAlignment(n);
    }

    public double getCharacterUnitFirstLineIndent() throws BasicErrorException {
        int n = 0;
        Object object = this.getPropertyValue("ParaFirstLineIndent");
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return (double)WriterUtilities.hundredthsMillimeterToPoints(n) / 12.0;
    }

    public void setCharacterUnitFirstLineIndent(double d) throws BasicErrorException {
        int n = WriterUtilities.pointsToHundredthsMillimeter((float)(d * 12.0));
        this.setPropertyValue("ParaFirstLineIndent", new Integer(n));
        bCharacterUnitIndentIsSet = true;
    }

    public double getCharacterUnitLeftIndent() throws BasicErrorException {
        int n = 0;
        Object object = this.getPropertyValue("ParaLeftMargin");
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return (double)WriterUtilities.hundredthsMillimeterToPoints(n) / 12.0;
    }

    public void setCharacterUnitLeftIndent(double d) throws BasicErrorException {
        int n = WriterUtilities.pointsToHundredthsMillimeter((float)d * 12.0f);
        this.setPropertyValue("ParaLeftMargin", new Integer(n));
        bCharacterUnitIndentIsSet = true;
    }

    public double getCharacterUnitRightIndent() throws BasicErrorException {
        int n = 0;
        Object object = this.getPropertyValue("ParaRightMargin");
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return (double)WriterUtilities.hundredthsMillimeterToPoints(n) / 12.0;
    }

    public void setCharacterUnitRightIndent(double d) throws BasicErrorException {
        int n = WriterUtilities.pointsToHundredthsMillimeter((float)d * 12.0f);
        this.setPropertyValue("ParaRightMargin", new Integer(n));
        bCharacterUnitIndentIsSet = true;
    }

    public double getFirstLineIndent() throws BasicErrorException {
        int n = 0;
        Object object = this.getPropertyValue("ParaFirstLineIndent");
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return WriterUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setFirstLineIndent(double d) throws BasicErrorException {
        if (!bCharacterUnitIndentIsSet) {
            int n = WriterUtilities.pointsToHundredthsMillimeter((float)d);
            this.setPropertyValue("ParaFirstLineIndent", new Integer(n));
        }
    }

    public double getLeftIndent() throws BasicErrorException {
        int n = 0;
        Object object = this.getPropertyValue("ParaLeftMargin");
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return WriterUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setLeftIndent(double d) throws BasicErrorException {
        if (!bCharacterUnitIndentIsSet) {
            int n = WriterUtilities.pointsToHundredthsMillimeter((float)d);
            this.setPropertyValue("ParaLeftMargin", new Integer(n));
        }
    }

    public double getRightIndent() throws BasicErrorException {
        int n = 0;
        Object object = this.getPropertyValue("ParaRightMargin");
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return WriterUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setRightIndent(double d) throws BasicErrorException {
        if (!bCharacterUnitIndentIsSet) {
            int n = WriterUtilities.pointsToHundredthsMillimeter((float)d);
            this.setPropertyValue("ParaRightMargin", new Integer(n));
        }
    }

    public void setHyphenation(boolean bl) throws BasicErrorException {
        this.setPropertyValue("ParaIsHyphenation", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getHyphenation() throws BasicErrorException {
        boolean bl = false;
        try {
            bl = NumericalHelper.toBoolean(this.getPropertyValue("ParaIsHyphenation"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return bl;
    }

    public void setKeepTogether(boolean bl) throws BasicErrorException {
        this.setPropertyValue("ParaSplit", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getKeepTogether() throws BasicErrorException {
        boolean bl = false;
        try {
            bl = NumericalHelper.toBoolean(this.getPropertyValue("ParaSplit"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return bl;
    }

    public void setKeepWithNext(boolean bl) throws BasicErrorException {
        this.setPropertyValue("ParaKeepTogether", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getKeepWithNext() throws BasicErrorException {
        boolean bl = false;
        try {
            bl = NumericalHelper.toBoolean(this.getPropertyValue("ParaKeepTogether"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return bl;
    }

    public void setNoLineNumber(boolean bl) throws BasicErrorException {
        this.setPropertyValue("ParaLineNumberCount", bl ? Boolean.FALSE : Boolean.TRUE);
    }

    public boolean getNoLineNumber() throws BasicErrorException {
        boolean bl = false;
        try {
            bl = NumericalHelper.toBoolean(this.getPropertyValue("ParaLineNumberCount"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return !bl;
    }

    public void setPageBreakBefore(boolean bl) throws BasicErrorException {
        BreakType breakType = (BreakType)this.getPropertyValue("BreakType");
        int n = breakType.getValue();
        if (!bl) {
            if (n == 6) {
                breakType = BreakType.PAGE_AFTER;
            } else if (n == 4) {
                breakType = BreakType.NONE;
            }
        } else if (n == 0) {
            breakType = BreakType.PAGE_BEFORE;
        } else if (n == 5) {
            breakType = BreakType.PAGE_BOTH;
        }
        this.setPropertyValue("BreakType", breakType);
    }

    public boolean getPageBreakBefore() throws BasicErrorException {
        boolean bl = false;
        BreakType breakType = (BreakType)this.getPropertyValue("BreakType");
        int n = breakType.getValue();
        bl = n == 4 || n == 6;
        return bl;
    }

    public void setOutlineLevel(int n) throws BasicErrorException {
        if (n != 10) {
            DebugHelper.exception(73, "OutlineLevel");
        }
    }

    public int getOutlineLevel() throws BasicErrorException {
        int n = 10;
        try {
            String string = NumericalHelper.toString(this.getPropertyValue("ParaStyleName"));
            if (string.startsWith(HEADING)) {
                String string2 = string.substring(HEADING.length() + 1);
                n = NumericalHelper.toInt(string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public float getLineUnitBefore() throws BasicErrorException {
        float f = this.getSpaceBefore();
        return f /= 12.0f;
    }

    public void setLineUnitBefore(float f) throws BasicErrorException {
        if (f < 0.0f || f > 32767.0f) {
            DebugHelper.exception(14, "GridLine");
        }
        this.setSpaceBefore(f * 12.0f);
    }

    public float getLineUnitAfter() throws BasicErrorException {
        float f = this.getSpaceAfter();
        return f /= 12.0f;
    }

    public void setLineUnitAfter(float f) throws BasicErrorException {
        if (f < 0.0f || f > 32767.0f) {
            DebugHelper.exception(14, "GridLine");
        }
        this.setSpaceAfter(f * 12.0f);
    }

    public void setSpaceAfter(float f) throws BasicErrorException {
        if (f < 0.0f || f > 1584.0f) {
            DebugHelper.exception(14, "GridLine");
        }
        int n = WriterUtilities.pointsToHundredthsMillimeter(f);
        this.setPropertyValue("ParaBottomMargin", new Integer(n));
    }

    public float getSpaceAfter() throws BasicErrorException {
        int n = 0;
        try {
            n = NumericalHelper.toInt(this.getPropertyValue("ParaBottomMargin"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        float f = WriterUtilities.hundredthsMillimeterToPoints(n);
        return f;
    }

    public void setSpaceAfterAuto(boolean bl) throws BasicErrorException {
        if (bl) {
            this.setLineUnitAfter(1.0f);
        } else {
            this.setLineUnitAfter(0.0f);
        }
    }

    public boolean getSpaceAfterAuto() throws BasicErrorException {
        int n = 0;
        try {
            n = NumericalHelper.toInt(this.getPropertyValue("ParaBottomMargin"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return n == 423;
    }

    public void setSpaceBefore(float f) throws BasicErrorException {
        if (f < 0.0f || f > 1584.0f) {
            DebugHelper.exception(14, "GridLine");
        }
        int n = WriterUtilities.pointsToHundredthsMillimeter(f);
        this.setPropertyValue("ParaTopMargin", new Integer(n));
    }

    public float getSpaceBefore() throws BasicErrorException {
        int n = 0;
        try {
            n = NumericalHelper.toInt(this.getPropertyValue("ParaTopMargin"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        float f = WriterUtilities.hundredthsMillimeterToPoints(n);
        return f;
    }

    public void setSpaceBeforeAuto(boolean bl) throws BasicErrorException {
        if (bl) {
            this.setLineUnitBefore(1.0f);
        } else {
            this.setLineUnitBefore(0.0f);
        }
    }

    public boolean getSpaceBeforeAuto() throws BasicErrorException {
        int n = 0;
        try {
            n = NumericalHelper.toInt(this.getPropertyValue("ParaTopMargin"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return n == 423;
    }

    public XShading Shading() {
        return new ShadingImpl(this);
    }

    public XTabStops getTabStops() throws BasicErrorException {
        return new TabStopsImpl(this, this.xParaCursor);
    }

    public void setTabStops(XTabStops xTabStops) throws BasicErrorException {
        if (xTabStops instanceof TabStopsImpl) {
            Vector vector = new Vector();
            TabStopsImpl tabStopsImpl = (TabStopsImpl)xTabStops;
            TabStop[] tabStopArray = tabStopsImpl.getStops();
            this.setPropertyValue("ParaTabStops", tabStopArray);
        } else {
            DebugHelper.exception(14, "TabStops");
        }
    }

    public boolean getWidowControl() throws BasicErrorException {
        boolean bl = false;
        try {
            byte by = NumericalHelper.toByte(this.getPropertyValue("ParaWidows"));
            byte by2 = NumericalHelper.toByte(this.getPropertyValue("ParaOrphans"));
            bl = by > 1 && by2 == by;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return bl;
    }

    public void setWidowControl(boolean bl) throws BasicErrorException {
        Byte by = new Byte((byte)(bl ? 2 : 1));
        this.setPropertyValue("ParaOrphans", by);
        this.setPropertyValue("ParaWidows", by);
    }

    public void setLineSpacingRule(int n) throws BasicErrorException {
        LineSpacing lineSpacing = new LineSpacing();
        short[] sArray = this.getStarOfficeLineSpacingFromRule(n);
        lineSpacing.Mode = sArray[0];
        lineSpacing.Height = sArray[1];
        this.setPropertyValue("ParaLineSpacing", lineSpacing);
    }

    public int getLineSpacingRule() throws BasicErrorException {
        int n = 0;
        LineSpacing lineSpacing = (LineSpacing)this.getPropertyValue("ParaLineSpacing");
        n = this.getMSWordLineSpacingRule(new short[]{lineSpacing.Mode, lineSpacing.Height});
        return n;
    }

    public void setLineSpacing(float f) throws BasicErrorException {
        LineSpacing lineSpacing = (LineSpacing)this.getPropertyValue("ParaLineSpacing");
        short[] sArray = this.getStarOfficeLineSpacing(f, lineSpacing.Mode);
        lineSpacing.Mode = sArray[0];
        lineSpacing.Height = sArray[1];
        this.setPropertyValue("ParaLineSpacing", lineSpacing);
    }

    public float getLineSpacing() throws BasicErrorException {
        LineSpacing lineSpacing = (LineSpacing)this.getPropertyValue("ParaLineSpacing");
        float f = this.getMSWordLineSpacing(new short[]{lineSpacing.Mode, lineSpacing.Height});
        return f;
    }

    private short[] getStarOfficeLineSpacing(float f, short s) {
        short[] sArray = new short[2];
        if (s != 1 && s != 3) {
            if (f == 12.0f) {
                sArray[0] = 0;
                sArray[1] = 100;
            } else if (f == 18.0f) {
                sArray[0] = 0;
                sArray[1] = 150;
            } else if (f == 24.0f) {
                sArray[0] = 0;
                sArray[1] = 200;
            } else {
                sArray[0] = 3;
                sArray[1] = (short)WriterUtilities.pointsToHundredthsMillimeter(f);
            }
        } else {
            sArray[0] = s;
            sArray[1] = (short)WriterUtilities.pointsToHundredthsMillimeter(f);
        }
        return sArray;
    }

    private float getMSWordLineSpacing(short[] sArray) throws BasicErrorException {
        float f = 0.0f;
        f = sArray[0] != 0 ? WriterUtilities.hundredthsMillimeterToPoints(sArray[1]) : (float)(12 * sArray[1]) / 100.0f;
        return f;
    }

    private short[] getStarOfficeLineSpacingFromRule(int n) throws BasicErrorException {
        short[] sArray = new short[2];
        try {
            switch (n) {
                case 1: {
                    sArray[0] = 0;
                    sArray[1] = 150;
                    break;
                }
                case 3: {
                    sArray[0] = 1;
                    sArray[1] = this.getCharHeight();
                    break;
                }
                case 2: {
                    sArray[0] = 0;
                    sArray[1] = 200;
                    break;
                }
                case 4: {
                    sArray[0] = 3;
                    sArray[1] = this.getCharHeight();
                    break;
                }
                case 5: {
                    sArray[0] = 3;
                    sArray[1] = this.getCharHeight();
                    break;
                }
                case 0: {
                    sArray[0] = 0;
                    sArray[1] = 100;
                    break;
                }
                default: {
                    DebugHelper.exception(14, "WdLineSpacing");
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return sArray;
    }

    private int getMSWordLineSpacingRule(short[] sArray) throws BasicErrorException {
        int n = 0;
        block0 : switch (sArray[0]) {
            case 0: {
                switch (sArray[1]) {
                    case 100: {
                        n = 0;
                        break block0;
                    }
                    case 150: {
                        n = 1;
                        break block0;
                    }
                    case 200: {
                        n = 2;
                        break block0;
                    }
                }
                n = 5;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            default: {
                DebugHelper.exception(14, "");
            }
        }
        return n;
    }

    private ParagraphAdjust getStarOfficeAlignment(int n) throws BasicErrorException {
        ParagraphAdjust paragraphAdjust = null;
        switch (n) {
            case 1: {
                paragraphAdjust = ParagraphAdjust.CENTER;
                break;
            }
            case 3: {
                paragraphAdjust = ParagraphAdjust.BLOCK;
                break;
            }
            case 0: {
                paragraphAdjust = ParagraphAdjust.LEFT;
                break;
            }
            case 2: {
                paragraphAdjust = ParagraphAdjust.RIGHT;
                break;
            }
            default: {
                DebugHelper.exception(14, "WdLineSpacing");
            }
        }
        return paragraphAdjust;
    }

    private int getMSWordAlignment(int n) throws BasicErrorException {
        int n2 = 0;
        switch (n) {
            case 3: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                DebugHelper.exception(14, "");
            }
        }
        return n2;
    }

    private short getCharHeight() throws IllegalArgumentException, BasicErrorException {
        Object object = this.getPropertyValue("CharHeight");
        float f = NumericalHelper.toFloat(object);
        int n = WriterUtilities.pointsToHundredthsMillimeter(f);
        return (short)n;
    }

    protected void setPropertyValue(String string, Object object) throws BasicErrorException {
        ParagraphFormatHelper.setPropertyValue(string, object, this.xParaCursor);
    }

    protected Object getPropertyValue(String string) throws BasicErrorException {
        Object[] objectArray = ParagraphFormatHelper.getPropertyValue(string, this.xParaCursor);
        return objectArray[0];
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xParaCursor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

