/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class HeaderFooterUtilities {
    private static final int FIRST_PAGE = 1;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$text$XText;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$style$XStyleFamiliesSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$style$XStyle;

    private HeaderFooterUtilities() {
    }

    public static boolean isHeaderOrFooter(XModel xModel, XText xText) throws BasicErrorException {
        XTextViewCursor xTextViewCursor = WriterUtilities.getXTextViewCursor(xModel);
        XServiceInfo xServiceInfo = null;
        try {
            xServiceInfo = (XServiceInfo)OptionalParamUtility.getObject(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = HeaderFooterUtilities.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, xText);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        String string = xServiceInfo.getImplementationName();
        return string.equals("SwXHeadFootText");
    }

    public static boolean isHeader(XModel xModel, XText xText) throws BasicErrorException {
        String string = "HeaderIsOn";
        String string2 = "HeaderIsShared";
        String string3 = "HeaderText";
        XPageCursor xPageCursor = WriterUtilities.getXPageCursor(xModel);
        XStyle xStyle = HeaderFooterUtilities.getCurrentStyle(xModel);
        boolean bl = HelperUtilities.getBooleanProperty(xStyle, string);
        if (!bl) {
            return false;
        }
        boolean bl2 = HelperUtilities.getBooleanProperty(xStyle, string2);
        if (!bl2) {
            string3 = 0 == xPageCursor.getPage() % 2 ? "HeaderTextLeft" : "HeaderTextRight";
        }
        XText xText2 = null;
        Object object = HelperUtilities.getProperty(xStyle, string3);
        try {
            xText2 = (XText)AnyConverter.toObject((Class)(class$com$sun$star$text$XText == null ? (class$com$sun$star$text$XText = HeaderFooterUtilities.class$("com.sun.star.text.XText")) : class$com$sun$star$text$XText), (Object)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return xText2 == xText;
    }

    public static boolean isHeaderShared(XStyle xStyle) {
        return HelperUtilities.getBooleanProperty(xStyle, "HeaderIsShared");
    }

    public static boolean isFirstPageHeader(XModel xModel, XText xText) throws BasicErrorException {
        if (HeaderFooterUtilities.isHeader(xModel, xText)) {
            short s = WriterUtilities.getXPageCursor(xModel).getPage();
            return 1 == s;
        }
        return false;
    }

    public static boolean isEvenPagesHeader(XModel xModel, XText xText, XStyle xStyle) throws BasicErrorException {
        if (xStyle == null) {
            xStyle = HeaderFooterUtilities.getCurrentStyle(xModel);
        }
        boolean bl = HeaderFooterUtilities.isHeader(xModel, xText);
        boolean bl2 = HeaderFooterUtilities.isHeaderShared(xStyle);
        if (bl && !bl2) {
            short s = WriterUtilities.getXPageCursor(xModel).getPage();
            return 0 == s % 2;
        }
        return false;
    }

    public static boolean isPrimaryHeader(XModel xModel, XText xText, XStyle xStyle) throws BasicErrorException {
        if (xStyle == null) {
            xStyle = HeaderFooterUtilities.getCurrentStyle(xModel);
        }
        if (HeaderFooterUtilities.isHeader(xModel, xText)) {
            return !HeaderFooterUtilities.isFirstPageHeader(xModel, xText) || !HeaderFooterUtilities.isEvenPagesHeader(xModel, xText, xStyle);
        }
        return false;
    }

    public static boolean isFooter(XModel xModel, XText xText) throws BasicErrorException {
        String string = "FooterIsOn";
        String string2 = "FooterIsShared";
        String string3 = "FooterText";
        XPageCursor xPageCursor = WriterUtilities.getXPageCursor(xModel);
        XStyle xStyle = HeaderFooterUtilities.getCurrentStyle(xModel);
        boolean bl = HelperUtilities.getBooleanProperty(xStyle, string);
        if (!bl) {
            return false;
        }
        boolean bl2 = HelperUtilities.getBooleanProperty(xStyle, string2);
        if (!bl2) {
            string3 = 0 == xPageCursor.getPage() % 2 ? "FooterTextLeft" : "FooterTextRight";
        }
        XText xText2 = null;
        Object object = HelperUtilities.getProperty(xStyle, string3);
        try {
            xText2 = (XText)AnyConverter.toObject((Class)(class$com$sun$star$text$XText == null ? (class$com$sun$star$text$XText = HeaderFooterUtilities.class$("com.sun.star.text.XText")) : class$com$sun$star$text$XText), (Object)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return xText2 == xText;
    }

    public static boolean isFooterShared(XStyle xStyle) {
        return HelperUtilities.getBooleanProperty(xStyle, "FooterIsShared");
    }

    public static boolean isFirstPageFooter(XModel xModel, XText xText) throws BasicErrorException {
        if (HeaderFooterUtilities.isFooter(xModel, xText)) {
            short s = WriterUtilities.getXPageCursor(xModel).getPage();
            return 1 == s;
        }
        return false;
    }

    public static boolean isEvenPagesFooter(XModel xModel, XText xText, XStyle xStyle) throws BasicErrorException {
        if (xStyle == null) {
            xStyle = HeaderFooterUtilities.getCurrentStyle(xModel);
        }
        if (HeaderFooterUtilities.isFooter(xModel, xText) && !HeaderFooterUtilities.isFooterShared(xStyle)) {
            short s = WriterUtilities.getXPageCursor(xModel).getPage();
            return 0 == s % 2;
        }
        return false;
    }

    public static boolean isPrimaryFooter(XModel xModel, XText xText, XStyle xStyle) throws BasicErrorException {
        if (xStyle == null) {
            xStyle = HeaderFooterUtilities.getCurrentStyle(xModel);
        }
        if (HeaderFooterUtilities.isFooter(xModel, xText)) {
            return !HeaderFooterUtilities.isFirstPageFooter(xModel, xText) || !HeaderFooterUtilities.isEvenPagesFooter(xModel, xText, xStyle);
        }
        return false;
    }

    public static XStyle getCurrentStyle(XModel xModel) throws BasicErrorException {
        XTextViewCursor xTextViewCursor = WriterUtilities.getXTextViewCursor(xModel);
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = HeaderFooterUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextViewCursor);
        XStyle xStyle = null;
        try {
            String string = WriterUtilities.getPageStyleName(xPropertySet);
            XStyleFamiliesSupplier xStyleFamiliesSupplier = (XStyleFamiliesSupplier)OptionalParamUtility.getObject(class$com$sun$star$style$XStyleFamiliesSupplier == null ? (class$com$sun$star$style$XStyleFamiliesSupplier = HeaderFooterUtilities.class$("com.sun.star.style.XStyleFamiliesSupplier")) : class$com$sun$star$style$XStyleFamiliesSupplier, xModel);
            XNameAccess xNameAccess = (XNameAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = HeaderFooterUtilities.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess, xStyleFamiliesSupplier.getStyleFamilies());
            XNameAccess xNameAccess2 = (XNameAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = HeaderFooterUtilities.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess, xNameAccess.getByName("PageStyles"));
            xStyle = (XStyle)OptionalParamUtility.getObject(class$com$sun$star$style$XStyle == null ? (class$com$sun$star$style$XStyle = HeaderFooterUtilities.class$("com.sun.star.style.XStyle")) : class$com$sun$star$style$XStyle, xNameAccess2.getByName(string));
        }
        catch (NoSuchElementException noSuchElementException) {
            DebugHelper.exception((Exception)((Object)noSuchElementException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return xStyle;
    }

    public static XText[] getAllXTextFromStyle(XStyle xStyle) throws BasicErrorException {
        int n;
        boolean bl;
        XText[] xTextArray = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl2 = HelperUtilities.getBooleanProperty(xStyle, "HeaderIsOn");
        if (bl2) {
            bl = HelperUtilities.getBooleanProperty(xStyle, "HeaderIsShared");
            if (bl) {
                arrayList.add(HelperUtilities.getProperty(xStyle, "HeaderText"));
            } else {
                arrayList.add(HelperUtilities.getProperty(xStyle, "HeaderTextLeft"));
                arrayList.add(HelperUtilities.getProperty(xStyle, "HeaderTextRight"));
            }
        }
        if (bl = HelperUtilities.getBooleanProperty(xStyle, "FooterIsOn")) {
            n = HelperUtilities.getBooleanProperty(xStyle, "FooterIsShared");
            if (n != 0) {
                arrayList.add(HelperUtilities.getProperty(xStyle, "FooterText"));
            } else {
                arrayList.add(HelperUtilities.getProperty(xStyle, "FooterTextLeft"));
                arrayList.add(HelperUtilities.getProperty(xStyle, "FooterTextRight"));
            }
        }
        xTextArray = new XText[arrayList.size()];
        try {
            n = 0;
            while (n < arrayList.size()) {
                xTextArray[n] = (XText)OptionalParamUtility.getObject(class$com$sun$star$text$XText == null ? HeaderFooterUtilities.class$("com.sun.star.text.XText") : class$com$sun$star$text$XText, arrayList.get(n));
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return xTextArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

