/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.writer.XFoundFiles;
import com.sun.star.script.BasicErrorException;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FoundFilesImpl
extends HelperInterfaceAdaptor
implements XFoundFiles {
    protected static final String __serviceName = "com.sun.star.helper.writer.FoundFiles";
    private ArrayList m_files = new ArrayList();

    public XHelperInterface getParent() {
        return this.getParentHelper();
    }

    public FoundFilesImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
    }

    public int Count() {
        return this.m_files.size();
    }

    public String Item(int n) throws BasicErrorException {
        if (n <= 0 || n > this.Count()) {
            DebugHelper.exception(5, "Index");
        }
        return ((File)this.m_files.get(n - 1)).getAbsolutePath();
    }

    public void Add(File[] fileArray) {
        int n = 0;
        while (n < fileArray.length) {
            this.m_files.add(fileArray[n]);
            ++n;
        }
    }

    public void Sort(int n, int n2) {
        switch (n) {
            case 2: {
                FileSizeComparator fileSizeComparator = new FileSizeComparator();
                Collections.sort(this.m_files, fileSizeComparator);
                break;
            }
            case 4: {
                FileModComparator fileModComparator = new FileModComparator();
                Collections.sort(this.m_files, fileModComparator);
                break;
            }
            case 3: {
                FileTypeComparator fileTypeComparator = new FileTypeComparator();
                Collections.sort(this.m_files, fileTypeComparator);
                break;
            }
            case 5: {
                break;
            }
            default: {
                FileNameComparator fileNameComparator = new FileNameComparator();
                Collections.sort(this.m_files, fileNameComparator);
            }
        }
        if (n2 == 2) {
            Collections.reverse(this.m_files);
        }
    }

    class FileTypeComparator
    implements Comparator {
        FileTypeComparator() {
        }

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            String[] stringArray = file.getName().split("\\.");
            String string = stringArray[stringArray.length - 1];
            String[] stringArray2 = file2.getName().split("\\.");
            String string2 = stringArray2[stringArray2.length - 1];
            return string.compareTo(string2);
        }
    }

    class FileModComparator
    implements Comparator {
        FileModComparator() {
        }

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            return (int)(file.lastModified() - file2.lastModified());
        }
    }

    class FileSizeComparator
    implements Comparator {
        FileSizeComparator() {
        }

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            return (int)(file.length() - file2.length());
        }
    }

    class FileNameComparator
    implements Comparator {
        FileNameComparator() {
        }

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            Collator collator = Collator.getInstance();
            return collator.compare(file.getName(), file2.getName());
        }
    }
}

