/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XModel;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.ReplacementImpl;
import com.sun.star.helper.writer.SelectionImpl;
import com.sun.star.helper.writer.WriterImpl;
import com.sun.star.helper.writer.XFind;
import com.sun.star.helper.writer.XReplacement;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.view.XSelectionSupplier;

public class FindImpl
extends HelperInterfaceAdaptor
implements XFind {
    protected static final String __serviceName = "com.sun.star.helper.writer.Find";
    private XModel xModel;
    private DocumentImpl docImpl;
    private XReplaceDescriptor xReplaceDescriptor;
    private XReplaceable xReplaceable;
    private XTextRange xTextRange;
    private XText xParentText;
    private XTextViewCursor xTVC;
    private final XSelectionSupplier xSel;
    public String Text;
    public boolean MatchCase;
    public boolean MatchWholeWord;
    public boolean MatchWildcards;
    public boolean MatchSoundsLike;
    public boolean MatchAllWordForms = false;
    public boolean Forward;
    public int Replace;
    private boolean replaceDecision = false;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$util$XReplaceable;
    static /* synthetic */ Class class$com$sun$star$helper$writer$DocumentImpl;
    static /* synthetic */ Class class$com$sun$star$text$XTextRange;
    static /* synthetic */ Class class$com$sun$star$text$XTextViewCursorSupplier;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$text$XTextCursor;
    static /* synthetic */ Class class$com$sun$star$text$XTextRangeCompare;

    public FindImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) throws IllegalArgumentException {
        super(__serviceName, helperInterfaceAdaptor);
        this.xModel = (XModel)OptionalParamUtility.getObject(helperInterfaceAdaptor.getXModel(), new Type(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = FindImpl.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel));
        this.xReplaceable = (XReplaceable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XReplaceable == null ? (class$com$sun$star$util$XReplaceable = FindImpl.class$("com.sun.star.util.XReplaceable")) : class$com$sun$star$util$XReplaceable), (Object)this.xModel);
        ApplicationImpl.getWriterImpl();
        this.docImpl = (DocumentImpl)OptionalParamUtility.getObject(WriterImpl.getDocument(this.xModel), new Type(class$com$sun$star$helper$writer$DocumentImpl == null ? (class$com$sun$star$helper$writer$DocumentImpl = FindImpl.class$("com.sun.star.helper.writer.DocumentImpl")) : class$com$sun$star$helper$writer$DocumentImpl));
        this.xReplaceDescriptor = this.docImpl.getReplaceDescriptor();
        this.xTextRange = (XTextRange)OptionalParamUtility.getObject(helperInterfaceAdaptor.getXTextRange(), new Type(class$com$sun$star$text$XTextRange == null ? (class$com$sun$star$text$XTextRange = FindImpl.class$("com.sun.star.text.XTextRange")) : class$com$sun$star$text$XTextRange));
        this.xParentText = this.xTextRange.getText();
        XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)OptionalParamUtility.getObject(this.xModel.getCurrentController(), new Type(class$com$sun$star$text$XTextViewCursorSupplier == null ? (class$com$sun$star$text$XTextViewCursorSupplier = FindImpl.class$("com.sun.star.text.XTextViewCursorSupplier")) : class$com$sun$star$text$XTextViewCursorSupplier));
        this.xTVC = xTextViewCursorSupplier.getViewCursor();
        this.xSel = (XSelectionSupplier)OptionalParamUtility.getObject(this.xModel.getCurrentController(), new Type(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = FindImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier));
    }

    public boolean Execute(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15) throws IllegalArgumentException {
        boolean bl = false;
        if (!AnyConverter.isVoid((Object)object)) {
            this.setText(OptionalParamUtility.getString("findText", object, "", true));
        }
        if (!AnyConverter.isVoid((Object)object2)) {
            this.setMatchCase(OptionalParamUtility.getBoolean("matchCase", object2, false, true));
        }
        if (!AnyConverter.isVoid((Object)object3)) {
            this.setMatchWholeWord(OptionalParamUtility.getBoolean("MatchWholeWord", object3, false, true));
        }
        if (!AnyConverter.isVoid((Object)object4)) {
            this.setMatchWildcards(OptionalParamUtility.getBoolean("matchWildcards", object4, false, true));
        }
        if (!AnyConverter.isVoid((Object)object5)) {
            this.setMatchSoundsLike(OptionalParamUtility.getBoolean("matchSoundsLike", object5, false, true));
        }
        if (!AnyConverter.isVoid((Object)object6)) {
            this.setMatchAllWordForms(OptionalParamUtility.getBoolean("matchAllWordForms", object6, false, true));
        }
        if (!AnyConverter.isVoid((Object)object7)) {
            this.setForward(OptionalParamUtility.getBoolean("forward", object7, false, true));
        }
        if (!AnyConverter.isVoid((Object)object8)) {
            this.setWrap(OptionalParamUtility.getInt("wrap", object8, 0, true));
        }
        if (!AnyConverter.isVoid((Object)object9)) {
            this.setFormat(OptionalParamUtility.getBoolean("format", object9, false, true));
        }
        if (!AnyConverter.isVoid((Object)object10)) {
            this.setReplaceWith(OptionalParamUtility.getString("replaceWith", object10, "", true));
        }
        if (!AnyConverter.isVoid((Object)object11)) {
            this.setReplace(OptionalParamUtility.getInt("replace", object11, 0, true));
        }
        bl = this.searchReplace();
        HelperInterfaceAdaptor helperInterfaceAdaptor = this.getParentAdaptor();
        if (helperInterfaceAdaptor instanceof SelectionImpl) {
            SelectionImpl selectionImpl = (SelectionImpl)helperInterfaceAdaptor;
            selectionImpl.getRangeImpl().setMaySpanEndOfDocument(false);
        }
        this.docImpl.getUnsupportedReplaceProp().put("Found", bl);
        return bl;
    }

    private boolean searchReplace() {
        boolean bl = false;
        String string = this.getText();
        if (this.getMatchWildcards()) {
            String string2 = this.getText();
            string2 = this.replaceWildcards(string2);
            this.setText(string2);
            this.setMatchCase(true);
        }
        bl = this.replaceDecision ? this.replaceble() : this.searchable();
        if (this.getMatchWildcards()) {
            this.setText(string);
            this.setMatchCase(false);
        }
        return bl;
    }

    private boolean searchable() {
        boolean bl;
        block2: {
            bl = false;
            XTextCursor xTextCursor = null;
            if ((xTextCursor = this.findOneElement(xTextCursor)) == null) break block2;
            try {
                bl = this.xSel.select((Object)xTextCursor);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
                HelperUtilities.exception(illegalArgumentException);
            }
        }
        return bl;
    }

    private boolean replaceble() {
        boolean bl = false;
        switch (this.getReplace()) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                XTextCursor xTextCursor = null;
                xTextCursor = this.findOneElement(xTextCursor);
                if (xTextCursor == null) break;
                xTextCursor.setString(this.getReplaceWith());
                try {
                    bl = this.xSel.select((Object)xTextCursor);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = false;
                    HelperUtilities.exception(illegalArgumentException);
                }
                break;
            }
            case 2: {
                XIndexAccess xIndexAccess = this.xReplaceable.findAll((XSearchDescriptor)this.xReplaceDescriptor);
                try {
                    if (xIndexAccess.getCount() <= 0) break;
                    int n = 0;
                    while (n < xIndexAccess.getCount()) {
                        XTextRange xTextRange = (XTextRange)AnyConverter.toObject((Class)(class$com$sun$star$text$XTextRange == null ? FindImpl.class$("com.sun.star.text.XTextRange") : class$com$sun$star$text$XTextRange), (Object)xIndexAccess.getByIndex(n));
                        if (this.getWrap() == 1 || this.getWrap() == 2 || this.InRange(xTextRange)) {
                            xTextRange.setString(this.getReplaceWith());
                            bl = true;
                        }
                        ++n;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    bl = false;
                    HelperUtilities.exception(indexOutOfBoundsException);
                }
                catch (WrappedTargetException wrappedTargetException) {
                    bl = false;
                    HelperUtilities.exception(wrappedTargetException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = false;
                    HelperUtilities.exception(illegalArgumentException);
                }
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private XTextCursor findOneElement(XTextCursor xTextCursor) {
        if (this.xTVC.getString().compareTo("") != 0) {
            xTextCursor = this.getForward() ? (XTextCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextCursor == null ? (class$com$sun$star$text$XTextCursor = FindImpl.class$("com.sun.star.text.XTextCursor")) : class$com$sun$star$text$XTextCursor), (Object)this.xReplaceable.findNext((Object)this.xTextRange.getStart(), (XSearchDescriptor)this.xReplaceDescriptor)) : (XTextCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextCursor == null ? (class$com$sun$star$text$XTextCursor = FindImpl.class$("com.sun.star.text.XTextCursor")) : class$com$sun$star$text$XTextCursor), (Object)this.xReplaceable.findNext((Object)this.xTextRange.getEnd(), (XSearchDescriptor)this.xReplaceDescriptor));
            if (xTextCursor != null && this.IsEqualRange((XTextRange)xTextCursor)) {
                xTextCursor = (XTextCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextCursor == null ? (class$com$sun$star$text$XTextCursor = FindImpl.class$("com.sun.star.text.XTextCursor")) : class$com$sun$star$text$XTextCursor), (Object)this.xReplaceable.findNext((Object)xTextCursor, (XSearchDescriptor)this.xReplaceDescriptor));
            } else if (xTextCursor != null && !this.InRange((XTextRange)xTextCursor)) {
                xTextCursor = null;
            }
        } else {
            xTextCursor = (XTextCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextCursor == null ? (class$com$sun$star$text$XTextCursor = FindImpl.class$("com.sun.star.text.XTextCursor")) : class$com$sun$star$text$XTextCursor), (Object)this.xReplaceable.findNext((Object)this.xTextRange, (XSearchDescriptor)this.xReplaceDescriptor));
        }
        if (xTextCursor == null && (this.getWrap() == 1 || this.getWrap() == 2)) {
            if (this.getForward()) {
                this.xTVC.gotoStart(false);
                xTextCursor = (XTextCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextCursor == null ? (class$com$sun$star$text$XTextCursor = FindImpl.class$("com.sun.star.text.XTextCursor")) : class$com$sun$star$text$XTextCursor), (Object)this.xReplaceable.findNext((Object)this.xTextRange.getStart(), (XSearchDescriptor)this.xReplaceDescriptor));
            } else {
                this.xTVC.gotoEnd(false);
                xTextCursor = (XTextCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextCursor == null ? (class$com$sun$star$text$XTextCursor = FindImpl.class$("com.sun.star.text.XTextCursor")) : class$com$sun$star$text$XTextCursor), (Object)this.xReplaceable.findNext((Object)this.xTextRange.getEnd(), (XSearchDescriptor)this.xReplaceDescriptor));
            }
        }
        return xTextCursor;
    }

    private void setFindPropertyValue(String string, Object object) {
        try {
            this.xReplaceDescriptor.setPropertyValue(string, object);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (PropertyVetoException propertyVetoException) {
            HelperUtilities.exception(propertyVetoException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
    }

    private boolean InRange(XTextRange xTextRange) {
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = FindImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)this.xParentText);
        try {
            if (xTextRangeCompare.compareRegionStarts(this.xTextRange, xTextRange) >= 0 && xTextRangeCompare.compareRegionEnds(this.xTextRange, xTextRange) <= 0) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return false;
    }

    private boolean IsEqualRange(XTextRange xTextRange) {
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = FindImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)this.xParentText);
        try {
            if (xTextRangeCompare.compareRegionStarts(this.xTextRange, xTextRange) == 0 && xTextRangeCompare.compareRegionEnds(this.xTextRange, xTextRange) == 0) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return false;
    }

    public String getText() {
        return this.getXReplaceDescriptor().getSearchString();
    }

    public boolean getFormat() {
        return this.docImpl.getPropertyReplace().getValueSearch();
    }

    public boolean getForward() {
        return !this.getRDPropertyValue("SearchBackwards");
    }

    public boolean getMatchAllWordForms() {
        return false;
    }

    public boolean getMatchCase() {
        return this.getRDPropertyValue("SearchCaseSensitive");
    }

    public boolean getMatchSoundsLike() {
        return this.getRDPropertyValue("SearchSimilarity");
    }

    public boolean getMatchWholeWord() {
        return this.getRDPropertyValue("SearchWords");
    }

    public boolean getMatchWildcards() {
        return this.getRDPropertyValue("SearchRegularExpression");
    }

    private int getReplace() {
        return this.Replace;
    }

    private String getReplaceWith() {
        return this.getXReplaceDescriptor().getReplaceString();
    }

    public int getWrap() {
        return (Integer)this.docImpl.getUnsupportedReplaceProp().get("Wrap");
    }

    public void setText(String string) {
        this.getXReplaceDescriptor().setSearchString(string);
    }

    public void setFormat(boolean bl) {
        this.docImpl.getPropertyReplace().setValueSearch(bl);
    }

    public void setForward(boolean bl) {
        this.setFindPropertyValue("SearchBackwards", !bl);
    }

    public void setMatchAllWordForms(boolean bl) {
    }

    public void setMatchCase(boolean bl) {
        this.setFindPropertyValue("SearchCaseSensitive", bl);
    }

    public void setMatchSoundsLike(boolean bl) {
        this.setFindPropertyValue("SearchSimilarity", bl);
    }

    public void setMatchWholeWord(boolean bl) {
        this.setFindPropertyValue("SearchWords", bl);
    }

    public void setMatchWildcards(boolean bl) {
        this.setFindPropertyValue("SearchRegularExpression", bl);
    }

    private void setReplace(int n) {
        if (0 == n || 1 == n || 2 == n) {
            this.Replace = n;
            this.replaceDecision = true;
        } else {
            this.Replace = 1;
            this.replaceDecision = true;
        }
    }

    private void setReplaceWith(String string) {
        this.getXReplaceDescriptor().setReplaceString(string);
        this.replaceDecision = true;
    }

    public void setWrap(int n) throws IllegalArgumentException {
        if (0 != n && 1 != n && 2 != n) {
            throw new IllegalArgumentException(n + "is illegal argument of Find.Wrap");
        }
        this.docImpl.getUnsupportedReplaceProp().put("Wrap", new Integer(n));
    }

    private XReplaceDescriptor getXReplaceDescriptor() {
        return this.xReplaceDescriptor;
    }

    private void setXReplaceDescriptor(XReplaceDescriptor xReplaceDescriptor) {
        this.docImpl.setReplaceDescriptor(xReplaceDescriptor);
    }

    private String replaceWildcards(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        int n = stringBuffer.indexOf("?");
        while (n >= 0) {
            stringBuffer2.replace(n, n + 1, ".");
            n = stringBuffer.indexOf("?", n + 1);
        }
        stringBuffer = new StringBuffer(stringBuffer2.toString());
        n = stringBuffer.indexOf("*");
        while (n >= 0) {
            String string2 = "[^" + stringBuffer.substring(n + 1, n + 2) + "]*";
            stringBuffer2.replace(n, n + 1, string2);
            n = stringBuffer.indexOf("*", n + 1);
        }
        stringBuffer = new StringBuffer(stringBuffer2.toString());
        n = stringBuffer.indexOf("!");
        while (n >= 0) {
            stringBuffer2.replace(n, n + 1, "^");
            n = stringBuffer.indexOf("!", n + 1);
        }
        stringBuffer = new StringBuffer(stringBuffer2.toString());
        n = stringBuffer.indexOf(";");
        while (n >= 0) {
            stringBuffer2.replace(n, n + 1, ",");
            n = stringBuffer.indexOf(";", n + 1);
        }
        stringBuffer = new StringBuffer(stringBuffer2.toString());
        n = stringBuffer.indexOf("@");
        while (n >= 0) {
            stringBuffer2.replace(n, n + 1, "+");
            n = stringBuffer.indexOf("@", n + 1);
        }
        stringBuffer = new StringBuffer(stringBuffer2.toString());
        n = stringBuffer.indexOf("<");
        while (n >= 0) {
            stringBuffer2.insert(n, "\\");
            n = stringBuffer.indexOf("<", n + 1);
        }
        stringBuffer = new StringBuffer(stringBuffer2.toString());
        n = stringBuffer.indexOf(">");
        while (n >= 0) {
            stringBuffer2.insert(n, "\\");
            n = stringBuffer.indexOf(">", n + 1);
        }
        return stringBuffer2.toString();
    }

    private boolean getRDPropertyValue(String string) {
        try {
            Object object = this.getXReplaceDescriptor().getPropertyValue(string);
            if (!AnyConverter.isVoid((Object)object)) {
                return OptionalParamUtility.getBoolean(string, object, false, true);
            }
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
        return false;
    }

    public XReplacement Replacement() throws IllegalArgumentException {
        return new ReplacementImpl(this, this.docImpl);
    }

    public void ClearFormatting() {
        try {
            PropertyValue[] propertyValueArray = new PropertyValue[]{};
            this.docImpl.getPropertyReplace().setSearchAttributes(propertyValueArray);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
    }

    public boolean getFound() {
        return (Boolean)this.docImpl.getUnsupportedReplaceProp().get("Found");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

