/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.FoundFilesImpl;
import com.sun.star.helper.writer.XFileSearch;
import com.sun.star.helper.writer.XFoundFiles;
import com.sun.star.script.BasicErrorException;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class FileSearchImpl
extends HelperInterfaceAdaptor
implements XFileSearch,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.FileSearch";
    private String m_fileName = "*";
    private String m_lookIn = null;
    private FoundFilesImpl m_foundFiles = null;
    private MyFileFilter m_fileFilter = new MyFileFilter("*");

    public FileSearchImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
        this.NewSearch();
    }

    public XHelperInterface getParent() {
        return this.getParentHelper();
    }

    public void NewSearch() {
        this.m_fileName = this.defaultSearchPattern();
        this.m_lookIn = this.defaultLookInPath();
        this.m_foundFiles = new FoundFilesImpl(this);
        this.m_fileFilter.setNewPattern(this.m_fileName);
    }

    public void setLookIn(String string) {
        this.m_lookIn = string;
    }

    public String getLookIn() {
        return this.m_lookIn;
    }

    public void setFileName(String string) {
        this.m_fileName = string;
        this.m_fileFilter.setNewPattern(this.m_fileName);
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public XFoundFiles getFoundFiles() {
        if (this.m_foundFiles == null) {
            this.m_foundFiles = new FoundFilesImpl(this);
        }
        return this.m_foundFiles;
    }

    public Object getUnoObject() throws BasicErrorException {
        return null;
    }

    public int Execute(Object object, Object object2, Object object3) {
        int n = (int)OptionalParamUtility.getAnyNumber("SortBy", object, 1L, false);
        int n2 = (int)OptionalParamUtility.getAnyNumber("SortOrder", object2, 1L, false);
        boolean bl = OptionalParamUtility.getBoolean("AlwaysAccurate", object3, true, false);
        this.m_foundFiles = new FoundFilesImpl(this);
        File file = new File(this.m_lookIn);
        File[] fileArray = file.listFiles(this.m_fileFilter);
        this.m_foundFiles.Add(fileArray);
        this.m_foundFiles.Sort(n, n2);
        return this.m_foundFiles.Count();
    }

    private String defaultLookInPath() {
        return System.getProperty("user.home");
    }

    private String defaultSearchPattern() {
        return "*";
    }

    private class MyFileFilter
    implements FileFilter {
        private String m_pattern = null;

        public MyFileFilter(String string) {
            this.setNewPattern(string);
        }

        public void setNewPattern(String string) {
            this.m_pattern = this.rewriteFileNameToRegex(string);
        }

        private String rewriteFileNameToRegex(String string) {
            String string2 = new String();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                string2 = c == '*' ? string2 + "(.)*" : (c == '?' ? string2 + "." : (c == '.' ? string2 + "\\." : string2 + c));
                ++n;
            }
            return string2;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            return Pattern.matches(this.m_pattern, file.getName());
        }
    }
}

