/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.writer.FieldImpl;
import com.sun.star.helper.writer.XField;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XDocumentIndexMark;
import com.sun.star.text.XTextColumns;
import com.sun.star.text.XTextField;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.MalformedNumberFormatException;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class FieldUtilities {
    public static TextFieldMap textFieldHelper = new TextFieldMap();
    public static DocumentIndexMap documentIndexHelper = new DocumentIndexMap();
    public static TextFieldCommandSet textFieldCommands = new TextFieldCommandSet();
    public static IndexCommandSet indexCommands = new IndexCommandSet();
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$text$XTextField;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatsSupplier;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatTypes;
    static /* synthetic */ Class class$com$sun$star$text$XTextColumns;

    private FieldUtilities() {
    }

    public static String TextFieldToMSFieldCode(XModel xModel, XTextField xTextField) throws BasicErrorException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        String string = FieldUtilities.TextFieldServiceName(xTextField);
        HelperObject helperObject = textFieldHelper.getHelperObject(string);
        stringBuffer.append(helperObject.getString(xModel, xTextField));
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public static XField MSFieldCodeToField(XModel xModel, String string) throws BasicErrorException {
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals("")) {
                boolean bl;
                boolean bl2 = bl = stringArray[n].startsWith("\"") && (!stringArray[n].endsWith("\"") || stringArray[n].endsWith("\\\""));
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(stringArray[n]);
                    do {
                        stringBuffer.append(" ").append(stringArray[++n]);
                    } while (!stringArray[n].endsWith("\"") || stringArray[n].endsWith("\\\""));
                    stringArray[n] = stringBuffer.toString();
                }
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        String string2 = (String)arrayList.get(0);
        if (textFieldCommands.contains(string2.toLowerCase())) {
            return new FieldImpl(null, FieldUtilities.TextFieldFactory(xModel, arrayList));
        }
        if (indexCommands.contains(string2.toLowerCase())) {
            return new FieldImpl(null, FieldUtilities.IndexFactory(xModel, arrayList), 2);
        }
        return null;
    }

    public static String DocumentIndexToMSFieldCode(XModel xModel, XPropertySet xPropertySet) throws BasicErrorException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        String string = FieldUtilities.DocumentIndexServiceName(xPropertySet);
        HelperObject helperObject = documentIndexHelper.getHelperObject(string);
        stringBuffer.append(helperObject.getString(xModel, xPropertySet));
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public static String DocumentIndexMarkToMSFieldCode(XModel xModel, XDocumentIndexMark xDocumentIndexMark) throws BasicErrorException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        stringBuffer.append("XE");
        stringBuffer.append(" \"").append(xDocumentIndexMark.getMarkEntry()).append("\"");
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private static XTextField TextFieldFactory(XModel xModel, ArrayList arrayList) throws BasicErrorException {
        XTextField xTextField;
        block30: {
            XMultiServiceFactory xMultiServiceFactory = null;
            xTextField = null;
            try {
                xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = FieldUtilities.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xModel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
            String string = (String)arrayList.get(0);
            try {
                if (string.toLowerCase().equals("author")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.CreateAuthor"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    break block30;
                }
                if (string.toLowerCase().equals("createdate")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.CreateDateTime"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    if (!arrayList.contains("\\@")) break block30;
                    DateTimeHelperObject.handleDateOptions(xModel, xPropertySet, arrayList);
                    break block30;
                }
                if (string.toLowerCase().equals("date")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DateTime"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    if (arrayList.contains("\\@")) {
                        DateTimeHelperObject.handleDateOptions(xModel, xPropertySet, arrayList);
                    }
                    xPropertySet.setPropertyValue("IsDate", (Object)Boolean.TRUE);
                    break block30;
                }
                if (string.toLowerCase().equals("edittime")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.EditTime"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    if (!arrayList.contains("\\@")) break block30;
                    DateTimeHelperObject.handleDateOptions(xModel, xPropertySet, arrayList);
                    break block30;
                }
                if (string.toLowerCase().equals("filename")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.FileName"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    if (arrayList.contains("\\p")) {
                        xPropertySet.setPropertyValue("FileFormat", (Object)new Short(0));
                    } else {
                        xPropertySet.setPropertyValue("FileFormat", (Object)new Short(3));
                    }
                    break block30;
                }
                if (string.toLowerCase().equals("lastsavedby")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.ChangeAuthor"));
                    break block30;
                }
                if (string.toLowerCase().equals("numchars")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.CharacterCount"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    String string2 = "";
                    if (arrayList.contains("\\*")) {
                        int n = arrayList.indexOf("\\*");
                        StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(n));
                        stringBuffer.append(" ").append(arrayList.get(n + 1));
                        string2 = stringBuffer.toString();
                    }
                    xPropertySet.setPropertyValue("NumberingType", (Object)new Short(FieldUtilities.MSFormatToNumberingType(string2)));
                    break block30;
                }
                if (string.toLowerCase().equals("numpages")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.PageCount"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    String string3 = "";
                    if (arrayList.contains("\\*")) {
                        int n = arrayList.indexOf("\\*");
                        StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(n));
                        stringBuffer.append(" ").append(arrayList.get(n + 1));
                        string3 = stringBuffer.toString();
                    }
                    xPropertySet.setPropertyValue("NumberingType", (Object)new Short(FieldUtilities.MSFormatToNumberingType(string3)));
                    break block30;
                }
                if (string.toLowerCase().equals("numwords")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.WordCount"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    String string4 = "";
                    if (arrayList.contains("\\*")) {
                        int n = arrayList.indexOf("\\*");
                        StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(n));
                        stringBuffer.append(" ").append(arrayList.get(n + 1));
                        string4 = stringBuffer.toString();
                    }
                    xPropertySet.setPropertyValue("NumberingType", (Object)new Short(FieldUtilities.MSFormatToNumberingType(string4)));
                    break block30;
                }
                if (string.toLowerCase().equals("page")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.PageNumber"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    String string5 = "";
                    if (arrayList.contains("\\*")) {
                        int n = arrayList.indexOf("\\*");
                        StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(n));
                        stringBuffer.append(" ").append(arrayList.get(n + 1));
                        string5 = stringBuffer.toString();
                    }
                    xPropertySet.setPropertyValue("NumberingType", (Object)new Short(FieldUtilities.MSFormatToNumberingType(string5)));
                    xPropertySet.setPropertyValue("Offset", (Object)new Short(0));
                    xPropertySet.setPropertyValue("SubType", (Object)new Short(1));
                    break block30;
                }
                if (string.toLowerCase().equals("printdate")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.PrintDateTime"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    if (!arrayList.contains("\\@")) break block30;
                    DateTimeHelperObject.handleDateOptions(xModel, xPropertySet, arrayList);
                    break block30;
                }
                if (string.toLowerCase().equals("revnum")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.Revision"));
                    break block30;
                }
                if (string.toLowerCase().equals("savedate")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.ChangeDateTime"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    if (!arrayList.contains("\\@")) break block30;
                    DateTimeHelperObject.handleDateOptions(xModel, xPropertySet, arrayList);
                    break block30;
                }
                if (string.toLowerCase().equals("subject")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.Subject"));
                } else if (string.toLowerCase().equals("time")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DateTime"));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                    if (arrayList.contains("\\@")) {
                        DateTimeHelperObject.handleDateOptions(xModel, xPropertySet, arrayList);
                    }
                    xPropertySet.setPropertyValue("IsDate", (Object)Boolean.FALSE);
                } else if (string.toLowerCase().equals("title")) {
                    xTextField = (XTextField)OptionalParamUtility.getObject(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = FieldUtilities.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField, xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DocInfo.Title"));
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return xTextField;
    }

    private static Object IndexFactory(XModel xModel, ArrayList arrayList) throws BasicErrorException {
        XMultiServiceFactory xMultiServiceFactory = null;
        Object object = null;
        try {
            xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = FieldUtilities.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xModel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        String string = (String)arrayList.get(0);
        try {
            if (string.toLowerCase().equals("index")) {
                object = xMultiServiceFactory.createInstance("com.sun.star.text.DocumentIndex");
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return object;
    }

    public static String TextFieldServiceName(XTextField xTextField) {
        String string = null;
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = FieldUtilities.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)xTextField);
        String[] stringArray = xServiceInfo.getSupportedServiceNames();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf("TextField") > 0 && !stringArray[n].endsWith("TextFields")) {
                string = stringArray[n];
                break;
            }
            ++n;
        }
        return string;
    }

    public static String DocumentIndexServiceName(XPropertySet xPropertySet) {
        String string = "";
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = FieldUtilities.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)xPropertySet);
        String[] stringArray = xServiceInfo.getSupportedServiceNames();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf("Index") > 0 && stringArray[n].indexOf("BaseIndex") < 0 || stringArray[n].indexOf("Bibliography") > 0) {
                string = stringArray[n];
                break;
            }
            ++n;
        }
        return string;
    }

    public static String NumberingTypeToMSFormat(int n) {
        String string;
        switch (n) {
            case 4: {
                string = "\\* Arabic";
                break;
            }
            case 3: {
                string = "\\* roman";
                break;
            }
            case 2: {
                string = "\\* ROMAN";
                break;
            }
            case 14: {
                string = "\\* CircleNum";
                break;
            }
            case 1: {
                string = "\\* alphabetic";
                break;
            }
            case 10: {
                string = "\\* alphabetic";
                break;
            }
            case 0: {
                string = "\\* ALPHABETIC";
                break;
            }
            case 9: {
                string = "\\* ALPHABETIC";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static short MSFormatToNumberingType(String string) {
        if (string.toLowerCase().equals("\\* arabic")) {
            return 4;
        }
        if (string.equals("\\* roman")) {
            return 3;
        }
        if (string.equals("\\* ROMAN")) {
            return 2;
        }
        if (string.toLowerCase().equals("\\* circlenum")) {
            return 14;
        }
        if (string.equals("\\* alphabetic")) {
            return 10;
        }
        if (string.equals("\\* ALPHABETIC")) {
            return 9;
        }
        if (string.toLowerCase().equals("\\* mergeformat")) {
            return 7;
        }
        return 4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class IndexCommandSet
    extends CommandSet {
        private IndexCommandSet() {
        }

        private void lazyInit() {
            ((CommandSet)this).lazyInit();
            this.commandSet.add("index");
            this.commandSet.add("toc");
        }

        public boolean contains(String string) {
            if (this.commandSet == null) {
                this.lazyInit();
            }
            return this.commandSet.contains(string);
        }
    }

    private static class TextFieldCommandSet
    extends CommandSet {
        private TextFieldCommandSet() {
        }

        private void lazyInit() {
            ((CommandSet)this).lazyInit();
            this.commandSet.add("author");
            this.commandSet.add("createdate");
            this.commandSet.add("date");
            this.commandSet.add("edittime");
            this.commandSet.add("filename");
            this.commandSet.add("lastsavedby");
            this.commandSet.add("numchars");
            this.commandSet.add("numpages");
            this.commandSet.add("numwords");
            this.commandSet.add("page");
            this.commandSet.add("printdate");
            this.commandSet.add("revnum");
            this.commandSet.add("savedate");
            this.commandSet.add("subject");
            this.commandSet.add("time");
            this.commandSet.add("title");
            this.commandSet.add("useraddress");
            this.commandSet.add("userinitials");
            this.commandSet.add("username");
        }

        public boolean contains(String string) {
            if (this.commandSet == null) {
                this.lazyInit();
            }
            return this.commandSet.contains(string);
        }
    }

    private static class CommandSet {
        TreeSet commandSet = null;

        private CommandSet() {
        }

        private void lazyInit() {
            this.commandSet = new TreeSet();
        }
    }

    private static class TOCHelperObject
    extends HelperObject {
        private TOCHelperObject() {
        }

        public String getString(XModel xModel, XPropertySet xPropertySet) throws BasicErrorException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TOC");
            try {
                Object object;
                Boolean bl = (Boolean)xPropertySet.getPropertyValue("CreateFromOutline");
                if (bl.booleanValue()) {
                    stringBuffer.append(" \\o");
                }
                if (!AnyConverter.isVoid((Object)(object = xPropertySet.getPropertyValue("Level")))) {
                    int n = AnyConverter.toInt((Object)object);
                    stringBuffer.append(" \\l ").append(n);
                }
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((Exception)((Object)wrappedTargetException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
            return stringBuffer.toString();
        }
    }

    private static class DocumentIndexHelperObject
    extends HelperObject {
        private DocumentIndexHelperObject() {
        }

        public String getString(XModel xModel, XPropertySet xPropertySet) throws BasicErrorException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INDEX");
            try {
                Object object = xPropertySet.getPropertyValue("TextColumns");
                XTextColumns xTextColumns = (XTextColumns)OptionalParamUtility.getObject(class$com$sun$star$text$XTextColumns == null ? (class$com$sun$star$text$XTextColumns = FieldUtilities.class$("com.sun.star.text.XTextColumns")) : class$com$sun$star$text$XTextColumns, object);
                if (xTextColumns.getColumnCount() > 1) {
                    stringBuffer.append(" \\c ").append(xTextColumns.getColumnCount());
                }
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((Exception)((Object)wrappedTargetException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
            return stringBuffer.toString();
        }
    }

    private static class DocumentIndexMap {
        Map m_soHelperObjects = null;

        private DocumentIndexMap() {
        }

        private void lazyInit() {
            this.m_soHelperObjects = new HashMap();
            HelperObject helperObject = new HelperObject();
            this.m_soHelperObjects.put("com.sun.star.text.Bibliography".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.ContentIndex".toLowerCase(), new TOCHelperObject());
            this.m_soHelperObjects.put("com.sun.star.text.DocumentIndex".toLowerCase(), new DocumentIndexHelperObject());
            this.m_soHelperObjects.put("com.sun.star.text.IllustrationIndex".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.ObjectIndex".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TableIndex".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.UserIndex".toLowerCase(), helperObject);
        }

        public HelperObject getHelperObject(String string) {
            if (this.m_soHelperObjects == null) {
                this.lazyInit();
            }
            return (HelperObject)this.m_soHelperObjects.get(string.toLowerCase());
        }
    }

    private static class UserHelperObject
    extends HelperObject {
        private UserHelperObject() {
        }

        public String getString(XModel xModel, XTextField xTextField) throws BasicErrorException {
            StringBuffer stringBuffer;
            block8: {
                stringBuffer = new StringBuffer();
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                String string = FieldUtilities.TextFieldServiceName(xTextField).toLowerCase();
                if (!"com.sun.star.text.TextField.ExtendedUser".toLowerCase().equals(string)) break block8;
                try {
                    short s = (Short)xPropertySet.getPropertyValue("UserDataType");
                    if (s == 4) {
                        stringBuffer.append("USERADDRESS");
                    } else if (s == 3) {
                        stringBuffer.append("USERINITIALS");
                    } else if (s == 2) {
                        stringBuffer.append("USERNAME");
                    }
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    DebugHelper.exception((Exception)((Object)unknownPropertyException));
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.exception((Exception)((Object)wrappedTargetException));
                }
            }
            return stringBuffer.toString();
        }
    }

    private static class SimpleStringHelperObject
    extends HelperObject {
        private SimpleStringHelperObject() {
        }

        public String getString(XModel xModel, XTextField xTextField) throws BasicErrorException {
            StringBuffer stringBuffer = new StringBuffer();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
            String string = FieldUtilities.TextFieldServiceName(xTextField).toLowerCase();
            if ("com.sun.star.text.TextField.DocInfo.Title".toLowerCase().equals(string)) {
                stringBuffer.append("TITLE");
            } else if ("com.sun.star.text.TextField.DocInfo.Subject".toLowerCase().equals(string)) {
                stringBuffer.append("SUBJECT");
            }
            return stringBuffer.toString();
        }
    }

    private static class PageNumberHelperObject
    extends HelperObject {
        private PageNumberHelperObject() {
        }

        public String getString(XModel xModel, XTextField xTextField) throws BasicErrorException {
            StringBuffer stringBuffer = new StringBuffer();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
            stringBuffer.append("PAGE");
            try {
                int n = ((Short)xPropertySet.getPropertyValue("NumberingType")).intValue();
                String string = FieldUtilities.NumberingTypeToMSFormat(n);
                stringBuffer.append(" ").append(string);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((Exception)((Object)wrappedTargetException));
            }
            return stringBuffer.toString();
        }
    }

    private static class CountHelperObject
    extends HelperObject {
        private CountHelperObject() {
        }

        public String getString(XModel xModel, XTextField xTextField) throws BasicErrorException {
            StringBuffer stringBuffer = new StringBuffer();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
            String string = FieldUtilities.TextFieldServiceName(xTextField).toLowerCase();
            if ("com.sun.star.text.TextField.CharacterCount".toLowerCase().equals(string)) {
                stringBuffer.append("NUMCHARS");
            } else if ("com.sun.star.text.TextField.PageCount".toLowerCase().equals(string)) {
                stringBuffer.append("NUMPAGES");
            } else if ("com.sun.star.text.TextField.WordCount".toLowerCase().equals(string)) {
                stringBuffer.append("NUMWORDS");
            } else if ("com.sun.star.text.TextField.DocInfo.Revision".toLowerCase().equals(string)) {
                stringBuffer.append("REVNUM");
                return stringBuffer.toString();
            }
            try {
                int n = ((Short)xPropertySet.getPropertyValue("NumberingType")).intValue();
                String string2 = FieldUtilities.NumberingTypeToMSFormat(n);
                stringBuffer.append(" ").append(string2);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((Exception)((Object)wrappedTargetException));
            }
            return stringBuffer.toString();
        }
    }

    private static class FileNameHelperObject
    extends HelperObject {
        private FileNameHelperObject() {
        }

        public String getString(XModel xModel, XTextField xTextField) throws BasicErrorException {
            StringBuffer stringBuffer = new StringBuffer();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
            String string = FieldUtilities.TextFieldServiceName(xTextField).toLowerCase();
            if ("com.sun.star.text.TextField.TemplateName".toLowerCase().equals(string)) {
                stringBuffer.append("TEMPLATE");
            } else if ("com.sun.star.text.TextField.FileName".toLowerCase().equals(string)) {
                stringBuffer.append("FILENAME");
            }
            try {
                int n = ((Short)xPropertySet.getPropertyValue("FileFormat")).intValue();
                if (n == 0 || n == 1) {
                    stringBuffer.append(" \\p");
                }
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((Exception)((Object)wrappedTargetException));
            }
            return stringBuffer.toString();
        }
    }

    private static class DateTimeHelperObject
    extends HelperObject {
        private DateTimeHelperObject() {
        }

        public String getString(XModel xModel, XTextField xTextField) throws BasicErrorException {
            StringBuffer stringBuffer;
            block19: {
                stringBuffer = new StringBuffer();
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
                String string = FieldUtilities.TextFieldServiceName(xTextField).toLowerCase();
                if ("com.sun.star.text.TextField.DocInfo.CreateDateTime".toLowerCase().equals(string)) {
                    stringBuffer.append("CREATEDATE");
                } else if ("com.sun.star.text.TextField.DocInfo.EditTime".toLowerCase().equals(string)) {
                    stringBuffer.append("EDITTIME");
                } else if ("com.sun.star.text.TextField.DocInfo.PrintDateTime".toLowerCase().equals(string)) {
                    stringBuffer.append("PRINTDATE");
                } else if ("com.sun.star.text.TextField.DocInfo.ChangeDateTime".toLowerCase().equals(string)) {
                    stringBuffer.append("SAVEDATE");
                } else {
                    boolean bl = HelperUtilities.getBooleanProperty(xPropertySet, "IsDate");
                    if (bl) {
                        stringBuffer.append("DATE");
                    } else {
                        stringBuffer.append("TIME");
                    }
                }
                try {
                    Integer n = (Integer)xPropertySet.getPropertyValue("NumberFormat");
                    if (n == null) break block19;
                    XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatsSupplier == null ? (class$com$sun$star$util$XNumberFormatsSupplier = FieldUtilities.class$("com.sun.star.util.XNumberFormatsSupplier")) : class$com$sun$star$util$XNumberFormatsSupplier), (Object)xModel);
                    XNumberFormats xNumberFormats = xNumberFormatsSupplier.getNumberFormats();
                    XPropertySet xPropertySet2 = xNumberFormats.getByKey(n.intValue());
                    Locale locale = (Locale)xPropertySet2.getPropertyValue("Locale");
                    String string2 = (String)xPropertySet2.getPropertyValue("FormatString");
                    if (!locale.Language.equalsIgnoreCase("en")) {
                        Locale locale2 = new Locale("en", "US", "");
                        XNumberFormatTypes xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatTypes == null ? (class$com$sun$star$util$XNumberFormatTypes = FieldUtilities.class$("com.sun.star.util.XNumberFormatTypes")) : class$com$sun$star$util$XNumberFormatTypes), (Object)xNumberFormats);
                        int n2 = xNumberFormatTypes.getFormatForLocale(n.intValue(), locale2);
                        if (n2 == n) {
                            string2 = (String)xPropertySet2.getPropertyValue("FormatString");
                            try {
                                n2 = xNumberFormats.addNewConverted(string2, locale, locale2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        xPropertySet2 = xNumberFormats.getByKey(n2);
                        string2 = (String)xPropertySet2.getPropertyValue("FormatString");
                    }
                    if (string2 != null) {
                        stringBuffer.append(" \\@ \"").append(string2).append("\"");
                    }
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    DebugHelper.exception((Exception)((Object)unknownPropertyException));
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.exception((Exception)((Object)wrappedTargetException));
                }
                catch (Exception exception) {
                    DebugHelper.exception(445, "");
                }
            }
            return stringBuffer.toString();
        }

        public static void handleDateOptions(XModel xModel, XPropertySet xPropertySet, ArrayList arrayList) throws MalformedNumberFormatException, UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
            Locale locale;
            int n = arrayList.indexOf("\\@");
            String string = (String)arrayList.get(n + 1);
            string = string.substring(1, string.length() - 1).toUpperCase();
            XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatsSupplier == null ? (class$com$sun$star$util$XNumberFormatsSupplier = FieldUtilities.class$("com.sun.star.util.XNumberFormatsSupplier")) : class$com$sun$star$util$XNumberFormatsSupplier), (Object)xModel);
            XNumberFormats xNumberFormats = xNumberFormatsSupplier.getNumberFormats();
            int n2 = xNumberFormats.queryKey(string, locale = new Locale("en", "US", ""), false);
            if (-1 == n2) {
                n2 = xNumberFormats.addNew(string, locale);
            }
            xPropertySet.setPropertyValue("NumberFormat", (Object)new Integer(n2));
        }
    }

    private static class AuthorHelperObject
    extends HelperObject {
        private AuthorHelperObject() {
        }

        public String getString(XModel xModel, XTextField xTextField) throws BasicErrorException {
            StringBuffer stringBuffer = new StringBuffer();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FieldUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
            String string = FieldUtilities.TextFieldServiceName(xTextField).toLowerCase();
            if ("com.sun.star.text.TextField.DocInfo.ChangeAuthor".toLowerCase().equals(string)) {
                stringBuffer.append("LASTSAVEDBY");
            } else {
                stringBuffer.append("AUTHOR");
            }
            return stringBuffer.toString();
        }
    }

    private static class HelperObject {
        private HelperObject() {
        }

        public String getString(XModel xModel, XTextField xTextField) throws BasicErrorException {
            DebugHelper.exception(73, "");
            return null;
        }

        public String getString(XModel xModel, XPropertySet xPropertySet) throws BasicErrorException {
            DebugHelper.exception(73, "");
            return null;
        }
    }

    private static class TextFieldMap {
        Map m_soHelperObjects = null;

        private TextFieldMap() {
        }

        private void lazyInit() {
            this.m_soHelperObjects = new HashMap();
            HelperObject helperObject = new HelperObject();
            DateTimeHelperObject dateTimeHelperObject = new DateTimeHelperObject();
            AuthorHelperObject authorHelperObject = new AuthorHelperObject();
            CountHelperObject countHelperObject = new CountHelperObject();
            SimpleStringHelperObject simpleStringHelperObject = new SimpleStringHelperObject();
            FileNameHelperObject fileNameHelperObject = new FileNameHelperObject();
            this.m_soHelperObjects.put("com.sun.star.text.TextField.Annotation".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.Author".toLowerCase(), authorHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.Bibliography".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.Chapter".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.CharacterCount".toLowerCase(), countHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.CombinedCharacters".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.ConditionalText".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DDE".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.Database".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DatabaseName".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DatabaseNextSet".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DatabaseNumberOfSet".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DatabaseSetNumber".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DateTime".toLowerCase(), dateTimeHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DropDown".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.EmbeddedObjectCount".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.ExtendedUser".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.FileName".toLowerCase(), fileNameHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.GetExpression".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.GetReference".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.GraphicObjectCount".toLowerCase(), countHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.HiddenParagraph".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.HiddenText".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.Input".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.InputUser".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.JumpEdit".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.Macro".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.PageCount".toLowerCase(), countHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.PageNumber".toLowerCase(), new PageNumberHelperObject());
            this.m_soHelperObjects.put("com.sun.star.text.TextField.ParagraphCount".toLowerCase(), countHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.ReferencePageGet".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.ReferencePageSet".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.Script".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.SetExpression".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.TableCount".toLowerCase(), countHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.TableFormula".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.TemplateName".toLowerCase(), fileNameHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.URL".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.User".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.WordCount".toLowerCase(), countHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.ChangeAuthor".toLowerCase(), authorHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.ChangeDateTime".toLowerCase(), dateTimeHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.CreateAuthor".toLowerCase(), authorHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.CreateDateTime".toLowerCase(), dateTimeHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Description".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.EditTime".toLowerCase(), dateTimeHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Info0".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Info1".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Info2".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Info3".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Keywords".toLowerCase(), helperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.PrintAuthor".toLowerCase(), authorHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.PrintDateTime".toLowerCase(), dateTimeHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Revision".toLowerCase(), countHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Subject".toLowerCase(), simpleStringHelperObject);
            this.m_soHelperObjects.put("com.sun.star.text.TextField.DocInfo.Title".toLowerCase(), simpleStringHelperObject);
        }

        public HelperObject getHelperObject(String string) {
            if (this.m_soHelperObjects == null) {
                this.lazyInit();
            }
            return (HelperObject)this.m_soHelperObjects.get(string.toLowerCase());
        }
    }

    public static interface SODocumentIndexURL {
        public static final String BIBLIOGRAPHY = "com.sun.star.text.Bibliography";
        public static final String CONTENT = "com.sun.star.text.ContentIndex";
        public static final String DOCUMENT = "com.sun.star.text.DocumentIndex";
        public static final String ILLUSTRATION = "com.sun.star.text.IllustrationIndex";
        public static final String OBJECT = "com.sun.star.text.ObjectIndex";
        public static final String TABLE = "com.sun.star.text.TableIndex";
        public static final String USER = "com.sun.star.text.UserIndex";
    }

    public static interface SOFieldURL {
        public static final String ANNOTATION = "com.sun.star.text.TextField.Annotation";
        public static final String AUTHOR = "com.sun.star.text.TextField.Author";
        public static final String BIBLIOGRAPHY = "com.sun.star.text.TextField.Bibliography";
        public static final String CHAPTER = "com.sun.star.text.TextField.Chapter";
        public static final String CHARACTER_COUNT = "com.sun.star.text.TextField.CharacterCount";
        public static final String COMBINED_CHARACTERS = "com.sun.star.text.TextField.CombinedCharacters";
        public static final String CONDITIONAL_TEXT = "com.sun.star.text.TextField.ConditionalText";
        public static final String DDE = "com.sun.star.text.TextField.DDE";
        public static final String DATABASE = "com.sun.star.text.TextField.Database";
        public static final String DATABASE_NAME = "com.sun.star.text.TextField.DatabaseName";
        public static final String DATABASE_NEXT_SET = "com.sun.star.text.TextField.DatabaseNextSet";
        public static final String DATABASE_NUMBER_OF_SET = "com.sun.star.text.TextField.DatabaseNumberOfSet";
        public static final String DATABASE_SET_NUMBER = "com.sun.star.text.TextField.DatabaseSetNumber";
        public static final String DATE_TIME = "com.sun.star.text.TextField.DateTime";
        public static final String DROP_DOWN = "com.sun.star.text.TextField.DropDown";
        public static final String EMBEDDED_OBJECT_COUNT = "com.sun.star.text.TextField.EmbeddedObjectCount";
        public static final String EXTENDED_USER = "com.sun.star.text.TextField.ExtendedUser";
        public static final String FILE_NAME = "com.sun.star.text.TextField.FileName";
        public static final String GET_EXPRESSION = "com.sun.star.text.TextField.GetExpression";
        public static final String GET_REFERENCE = "com.sun.star.text.TextField.GetReference";
        public static final String GRAPHIC_OBJECT_COUNT = "com.sun.star.text.TextField.GraphicObjectCount";
        public static final String HIDDEN_PARAGRAPH = "com.sun.star.text.TextField.HiddenParagraph";
        public static final String HIDDEN_TEXT = "com.sun.star.text.TextField.HiddenText";
        public static final String INPUT = "com.sun.star.text.TextField.Input";
        public static final String INPUT_USER = "com.sun.star.text.TextField.InputUser";
        public static final String JUMP_EDIT = "com.sun.star.text.TextField.JumpEdit";
        public static final String MACRO = "com.sun.star.text.TextField.Macro";
        public static final String PAGE_COUNT = "com.sun.star.text.TextField.PageCount";
        public static final String PAGE_NUMBER = "com.sun.star.text.TextField.PageNumber";
        public static final String PARAGRAPH_COUNT = "com.sun.star.text.TextField.ParagraphCount";
        public static final String REFERENCE_PAGE_GET = "com.sun.star.text.TextField.ReferencePageGet";
        public static final String REFERENCE_PAGE_SET = "com.sun.star.text.TextField.ReferencePageSet";
        public static final String SCRIPT = "com.sun.star.text.TextField.Script";
        public static final String SET_EXPRESSION = "com.sun.star.text.TextField.SetExpression";
        public static final String TABLE_COUNT = "com.sun.star.text.TextField.TableCount";
        public static final String TABLE_FORMULA = "com.sun.star.text.TextField.TableFormula";
        public static final String TEMPLATE_NAME = "com.sun.star.text.TextField.TemplateName";
        public static final String URL = "com.sun.star.text.TextField.URL";
        public static final String USER = "com.sun.star.text.TextField.User";
        public static final String WORD_COUNT = "com.sun.star.text.TextField.WordCount";

        public static interface DocInfo {
            public static final String CHANGE_AUTHOR = "com.sun.star.text.TextField.DocInfo.ChangeAuthor";
            public static final String CHANGE_DATE_TIME = "com.sun.star.text.TextField.DocInfo.ChangeDateTime";
            public static final String CREATE_AUTHOR = "com.sun.star.text.TextField.DocInfo.CreateAuthor";
            public static final String CREATE_DATE_TIME = "com.sun.star.text.TextField.DocInfo.CreateDateTime";
            public static final String DESCRIPTION = "com.sun.star.text.TextField.DocInfo.Description";
            public static final String EDIT_TIME = "com.sun.star.text.TextField.DocInfo.EditTime";
            public static final String INFO0 = "com.sun.star.text.TextField.DocInfo.Info0";
            public static final String INFO1 = "com.sun.star.text.TextField.DocInfo.Info1";
            public static final String INFO2 = "com.sun.star.text.TextField.DocInfo.Info2";
            public static final String INFO3 = "com.sun.star.text.TextField.DocInfo.Info3";
            public static final String KEYWORDS = "com.sun.star.text.TextField.DocInfo.Keywords";
            public static final String PRINT_AUTHOR = "com.sun.star.text.TextField.DocInfo.PrintAuthor";
            public static final String PRINT_DATE_TIME = "com.sun.star.text.TextField.DocInfo.PrintDateTime";
            public static final String REVISION = "com.sun.star.text.TextField.DocInfo.Revision";
            public static final String SUBJECT = "com.sun.star.text.TextField.DocInfo.Subject";
            public static final String TITLE = "com.sun.star.text.TextField.DocInfo.Title";
        }
    }

    public static interface Type {
        public static final int TEXTFIELD = 1;
        public static final int DOCUMENT_INDEX = 2;
        public static final int DOCUMENT_INDEX_MARK = 3;
    }
}

