/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.awt.XTopWindow;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.DocumentPropertiesImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.XApplication;
import com.sun.star.helper.XDocumentProperties;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.ComputeStatisticsHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.Filename;
import com.sun.star.helper.common.Millimeter;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.WriterFileFormatHelper;
import com.sun.star.helper.common.WriterFilename;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BookmarksImpl;
import com.sun.star.helper.writer.CommandBarsImpl;
import com.sun.star.helper.writer.DocumentsImpl;
import com.sun.star.helper.writer.FieldsImpl;
import com.sun.star.helper.writer.MailMergeImpl;
import com.sun.star.helper.writer.PageSetupImpl;
import com.sun.star.helper.writer.ParagraphsImpl;
import com.sun.star.helper.writer.PrintOutHelper;
import com.sun.star.helper.writer.RangeHelper;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.SectionsImpl;
import com.sun.star.helper.writer.ShapesImpl;
import com.sun.star.helper.writer.StylesImpl;
import com.sun.star.helper.writer.TablesImpl;
import com.sun.star.helper.writer.TablesOfContentsImpl;
import com.sun.star.helper.writer.TemplateImpl;
import com.sun.star.helper.writer.VariablesImpl;
import com.sun.star.helper.writer.WindowsImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XBookmarks;
import com.sun.star.helper.writer.XCommandBars;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XDocuments;
import com.sun.star.helper.writer.XFields;
import com.sun.star.helper.writer.XMailMerge;
import com.sun.star.helper.writer.XPageSetup;
import com.sun.star.helper.writer.XParagraphs;
import com.sun.star.helper.writer.XPrintable;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XSections;
import com.sun.star.helper.writer.XShapes;
import com.sun.star.helper.writer.XStyles;
import com.sun.star.helper.writer.XTables;
import com.sun.star.helper.writer.XTablesOfContents;
import com.sun.star.helper.writer.XTemplate;
import com.sun.star.helper.writer.XVariables;
import com.sun.star.helper.writer.XWindow;
import com.sun.star.helper.writer.XWindows;
import com.sun.star.helper.writer.XWriter;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.TabStop;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.table.XCell;
import com.sun.star.text.XEndnotesSupplier;
import com.sun.star.text.XFootnotesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XModifiable;
import com.sun.star.util.XPropertyReplace;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import java.util.ArrayList;
import java.util.HashMap;

public class DocumentImpl
extends HelperInterfaceAdaptor
implements XDocument,
XPrintable,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Document";
    private final XTextDocument m_xTextDocument;
    private int m_nGutterValue;
    private int m_nGutterPosition;
    private StylesImpl m_aCacheStyles = null;
    private boolean m_bTwoPages = false;
    private XReplaceDescriptor m_xReplaceDescriptor;
    private XMailMerge m_MailMerge;
    private HashMap m_aUnsupportedReplaceProp;
    private XPropertyReplace m_xPropertyReplace;
    protected ParagraphsImpl m_aCacheParagraphs = null;
    private XWriter m_xWriter;
    private int m_addedShapes = 0;
    private WindowsImpl m_aCacheWindows;
    private DocumentPropertiesImpl m_aCacheBuiltInProperties;
    private DocumentPropertiesImpl m_aCacheCustomProperties;
    private BookmarksImpl m_aCacheBookmarks;
    private TablesOfContentsImpl m_aCacheTablesOfContents;
    private VariablesImpl m_aCacheVariables;
    private TemplateImpl m_aCacheTemplate;
    private ShapesImpl m_aCacheShapes;
    TablesImpl m_aCacheTables = null;
    private RangeImpl m_aCacheRange = null;
    private boolean m_bReadOnlyRecommended = false;
    private boolean m_bUserControl = true;
    private boolean m_bControllerIsLocked = false;
    private XCommandBars m_xCommandBarsCache = null;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$util$XReplaceable;
    static /* synthetic */ Class class$com$sun$star$util$XPropertyReplace;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$util$XModifiable;
    static /* synthetic */ Class class$com$sun$star$text$XTextSectionsSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$drawing$XDrawPageSupplier;
    static /* synthetic */ Class class$com$sun$star$drawing$XShapes;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$awt$XTopWindow;
    static /* synthetic */ Class class$com$sun$star$text$XFootnotesSupplier;
    static /* synthetic */ Class class$com$sun$star$text$XEndnotesSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XEnumerationAccess;
    static /* synthetic */ Class class$com$sun$star$text$XTextContent;
    static /* synthetic */ Class class$com$sun$star$text$XTextTable;
    static /* synthetic */ Class class$com$sun$star$text$XText;
    static /* synthetic */ Class class$com$sun$star$style$XStyleFamiliesSupplier;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$sun$star$container$XNameContainer;
    static /* synthetic */ Class class$com$sun$star$style$XStyle;

    public DocumentImpl(DocumentsImpl documentsImpl, XModel xModel, XWriter xWriter) {
        super(__serviceName, documentsImpl);
        this.m_xWriter = xWriter;
        this.m_xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = DocumentImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)xModel);
        XReplaceable xReplaceable = (XReplaceable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XReplaceable == null ? (class$com$sun$star$util$XReplaceable = DocumentImpl.class$("com.sun.star.util.XReplaceable")) : class$com$sun$star$util$XReplaceable), (Object)this.getXModel());
        if (xReplaceable != null) {
            this.m_xReplaceDescriptor = xReplaceable.createReplaceDescriptor();
            this.m_xPropertyReplace = (XPropertyReplace)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XPropertyReplace == null ? (class$com$sun$star$util$XPropertyReplace = DocumentImpl.class$("com.sun.star.util.XPropertyReplace")) : class$com$sun$star$util$XPropertyReplace), (Object)this.m_xReplaceDescriptor);
            this.m_xPropertyReplace.setValueSearch(false);
        }
        this.m_aUnsupportedReplaceProp = new HashMap();
        this.m_aUnsupportedReplaceProp.put("Wrap", new Integer(0));
        this.m_aUnsupportedReplaceProp.put("Found", Boolean.TRUE);
    }

    public XMultiServiceFactory getXMultiServiceFactory() {
        return (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = DocumentImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)this.m_xTextDocument);
    }

    public XDocuments getParent() {
        return (DocumentsImpl)this.getParentHelper();
    }

    public Object getUnoObject() {
        return this.m_xTextDocument;
    }

    public XStyles getStyles() {
        if (this.m_aCacheStyles == null) {
            this.m_aCacheStyles = new StylesImpl(this);
        }
        return this.m_aCacheStyles;
    }

    public XParagraphs getParagraphs() {
        if (this.m_aCacheParagraphs == null) {
            this.m_aCacheParagraphs = new ParagraphsImpl(this);
        }
        return this.m_aCacheParagraphs;
    }

    public XWindows getWindows() {
        return this.getWindowsImpl();
    }

    public XWriter getWriter() {
        return this.m_xWriter;
    }

    public WindowsImpl getWindowsImpl() {
        if (this.m_aCacheWindows == null) {
            this.m_aCacheWindows = new WindowsImpl(this);
        }
        return this.m_aCacheWindows;
    }

    public XDocumentProperties getBuiltInDocumentProperties() {
        if (this.m_aCacheBuiltInProperties == null) {
            this.m_aCacheBuiltInProperties = new DocumentPropertiesImpl(this, false);
        }
        this.m_aCacheBuiltInProperties.refreshCachedValues();
        return this.m_aCacheBuiltInProperties;
    }

    public XDocumentProperties getCustomDocumentProperties() {
        if (this.m_aCacheCustomProperties == null) {
            this.m_aCacheCustomProperties = new DocumentPropertiesImpl(this, true);
        }
        this.m_aCacheCustomProperties.refreshCachedValues();
        return this.m_aCacheCustomProperties;
    }

    public boolean isRangeEntireDocument(XTextRange xTextRange) {
        return RangeHelper.compareRanges(xTextRange, this.getContent().getXTextRange());
    }

    public String getActivePrinter() {
        return ApplicationImpl.getActivePrinter();
    }

    public void setActivePrinter(String string) throws java.lang.IllegalArgumentException {
        ApplicationImpl.setActivePrinter(string);
    }

    public void PrintOut(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16, Object object17, Object object18, Object object19) throws java.lang.IllegalArgumentException, NoSupportException {
        PrintOutHelper printOutHelper = new PrintOutHelper(object, object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13, object14, object15, object16, object17, object18, object19);
        printOutHelper.execute();
    }

    public XWindow getActiveWindow() {
        XModel xModel;
        XFrame xFrame = ApplicationImpl.getXDesktop().getCurrentFrame();
        if (xFrame != null && (xModel = xFrame.getController().getModel()) == this.getXModel()) {
            return this.getWindowsImpl().getWindow(xFrame);
        }
        return ((WindowsImpl)this.getWindows()).Item(1);
    }

    public void Save() throws BasicErrorException {
        HelperUtilities.saveDocument(this.getXModel());
    }

    public XApplication Application() {
        return ApplicationImpl.getInstance();
    }

    private String getWindowCaption() {
        XWindow xWindow = ((WindowsImpl)this.getWindows()).Item(1);
        if (xWindow != null) {
            String string = xWindow.getCaption();
            return string;
        }
        return "";
    }

    public String getName() {
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DocumentImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.getXModel());
        String string = xStorable.getLocation();
        if (string.length() == 0) {
            return this.getWindowCaption();
        }
        WriterFilename writerFilename = new WriterFilename(string);
        return writerFilename.getName();
    }

    public String getPath() {
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DocumentImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.getXModel());
        String string = xStorable.getLocation();
        WriterFilename writerFilename = new WriterFilename(string);
        return writerFilename.getPath();
    }

    public String getFullName() {
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DocumentImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.getXModel());
        String string = xStorable.getLocation();
        if (string.length() == 0) {
            return this.getWindowCaption();
        }
        WriterFilename writerFilename = new WriterFilename(string);
        string = writerFilename.getAbsoluteFilename();
        return string;
    }

    public boolean getSaved() {
        XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XModifiable == null ? (class$com$sun$star$util$XModifiable = DocumentImpl.class$("com.sun.star.util.XModifiable")) : class$com$sun$star$util$XModifiable), (Object)this.getXModel());
        return !xModifiable.isModified();
    }

    public XRange getContent() {
        return new RangeImpl((HelperInterfaceAdaptor)this, this.getXTextRange(), true);
    }

    public boolean getReadOnly() {
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DocumentImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.getXModel());
        return xStorable.isReadonly();
    }

    public void setReadOnly(boolean bl) {
    }

    public XBookmarks getBookmarks() throws BasicErrorException {
        if (this.m_aCacheBookmarks == null) {
            this.m_aCacheBookmarks = new BookmarksImpl(this);
        }
        return this.m_aCacheBookmarks;
    }

    public XTablesOfContents getTablesOfContents() throws BasicErrorException {
        if (this.m_aCacheTablesOfContents == null) {
            this.m_aCacheTablesOfContents = new TablesOfContentsImpl(this);
        }
        return this.m_aCacheTablesOfContents;
    }

    public XVariables getVariables() throws BasicErrorException {
        if (this.m_aCacheVariables == null) {
            this.m_aCacheVariables = new VariablesImpl(this);
        }
        return this.m_aCacheVariables;
    }

    public void Close(Object object, Object object2, Object object3) throws BasicErrorException {
        int n = NumericalHelper.toInt(object, -2);
        int n2 = NumericalHelper.toInt(object2, 1);
        boolean bl = NumericalHelper.toBoolean(object3, false);
        if (n == -2 && this.getWriter().getDisplayAlerts() == 0) {
            n = 0;
        }
        HelperUtilities.closeDocument(this.getXModel(), n, n2);
    }

    public void Select() {
        try {
            this.getContent().Select();
        }
        catch (BasicErrorException basicErrorException) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)basicErrorException));
        }
    }

    public XRange Range(Object object, Object object2) throws BasicErrorException {
        if (object == null && object2 == null || AnyConverter.isVoid((Object)object) && AnyConverter.isVoid((Object)object2)) {
            return this.getContent();
        }
        XTextRange xTextRange = null;
        XTextRange xTextRange2 = null;
        try {
            int n = NumericalHelper.toInt(object);
            int n2 = NumericalHelper.toInt(object2);
            xTextRange = RangeHelper.getRangeByPosition(this.m_xTextDocument.getText(), n);
            xTextRange2 = RangeHelper.getRangeByPosition(this.m_xTextDocument.getText(), n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        if (xTextRange == null && xTextRange2 == null) {
            try {
                if (object != null) {
                    xTextRange = ((XRange)object).getXTextRange();
                    xTextRange2 = ((XRange)object).getXTextRange();
                } else {
                    xTextRange = this.m_xTextDocument.getText().getStart();
                    xTextRange2 = this.m_xTextDocument.getText().getEnd();
                }
            }
            catch (ClassCastException classCastException) {
                DebugHelper.exception(new com.sun.star.uno.Exception(classCastException.getMessage()));
            }
        }
        return new RangeImpl((HelperInterfaceAdaptor)this, xTextRange, xTextRange2);
    }

    public XModel getXModel() {
        return this.m_xTextDocument;
    }

    public XTables getTables() {
        if (this.m_aCacheTables == null) {
            this.m_aCacheTables = new TablesImpl(this);
        } else {
            this.m_aCacheTables.refreshTableCache();
        }
        return this.m_aCacheTables;
    }

    public XSections getSections() throws BasicErrorException {
        XTextSectionsSupplier xTextSectionsSupplier = null;
        XNameAccess xNameAccess = null;
        SectionsImpl sectionsImpl = null;
        try {
            xTextSectionsSupplier = (XTextSectionsSupplier)OptionalParamUtility.getObject(class$com$sun$star$text$XTextSectionsSupplier == null ? (class$com$sun$star$text$XTextSectionsSupplier = DocumentImpl.class$("com.sun.star.text.XTextSectionsSupplier")) : class$com$sun$star$text$XTextSectionsSupplier, this.getXModel());
            XNameAccess xNameAccess2 = xTextSectionsSupplier.getTextSections();
            xNameAccess = (XNameAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = DocumentImpl.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess, xNameAccess2);
            sectionsImpl = new SectionsImpl(this, xNameAccess);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return sectionsImpl;
    }

    public XTextRange getXTextRange() {
        return this.m_xTextDocument.getText();
    }

    public int getStatisticLineCount(int n) {
        if (this.m_aCacheRange == null) {
            this.m_aCacheRange = (RangeImpl)this.getContent();
        } else {
            this.m_aCacheRange.setXTextRange(this.getXTextRange());
        }
        return this.m_aCacheRange.getStatisticLineCount(n);
    }

    public XShapes getShapes() throws BasicErrorException {
        block2: {
            if (this.m_aCacheShapes != null) break block2;
            try {
                XDrawPageSupplier xDrawPageSupplier = (XDrawPageSupplier)OptionalParamUtility.getObject(class$com$sun$star$drawing$XDrawPageSupplier == null ? (class$com$sun$star$drawing$XDrawPageSupplier = DocumentImpl.class$("com.sun.star.drawing.XDrawPageSupplier")) : class$com$sun$star$drawing$XDrawPageSupplier, this.m_xTextDocument);
                com.sun.star.drawing.XShapes xShapes = (com.sun.star.drawing.XShapes)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShapes == null ? (class$com$sun$star$drawing$XShapes = DocumentImpl.class$("com.sun.star.drawing.XShapes")) : class$com$sun$star$drawing$XShapes, xDrawPageSupplier.getDrawPage());
                this.m_aCacheShapes = new ShapesImpl(this, xShapes);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        }
        return this.m_aCacheShapes;
    }

    public XPageSetup getPageSetup() throws java.lang.IllegalArgumentException {
        XModel xModel = this.getXModel();
        XPropertySet xPropertySet = null;
        XStyle xStyle = null;
        PageSetupImpl pageSetupImpl = null;
        try {
            xStyle = WriterUtilities.getCurrentPageStyle(xModel);
            xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DocumentImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xStyle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HelperUtilities.exception(exception);
        }
        try {
            try {
                pageSetupImpl = new PageSetupImpl(this, xPropertySet);
            }
            catch (Exception exception) {
                throw new java.lang.IllegalArgumentException("PageSetup could't be created.");
            }
            Object var7_7 = null;
            xModel = null;
            xPropertySet = null;
            xStyle = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            xModel = null;
            xPropertySet = null;
            xStyle = null;
            throw throwable;
        }
        return pageSetupImpl;
    }

    public int getGutterValue() {
        return this.m_nGutterValue;
    }

    public void setGutterValue(int n) {
        this.m_nGutterValue = n;
    }

    public int getGutterPosition() {
        return this.m_nGutterPosition;
    }

    public void setGutterPosition(int n) {
        this.m_nGutterPosition = n;
    }

    public boolean isTwoPages() {
        return this.m_bTwoPages;
    }

    public void setTwoPages(boolean bl) {
        this.m_bTwoPages = bl;
    }

    public int getCountAddedShapes() {
        return this.m_addedShapes;
    }

    public void setCountAddedShapes(int n) {
        this.m_addedShapes = n;
    }

    public void Activate() {
        XModel xModel = this.getXModel();
        XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XTopWindow == null ? (class$com$sun$star$awt$XTopWindow = DocumentImpl.class$("com.sun.star.awt.XTopWindow")) : class$com$sun$star$awt$XTopWindow), (Object)xModel.getCurrentController().getFrame().getContainerWindow());
        xTopWindow.toFront();
    }

    public XReplaceDescriptor getReplaceDescriptor() {
        return this.m_xReplaceDescriptor;
    }

    public void setReplaceDescriptor(XReplaceDescriptor xReplaceDescriptor) {
        this.m_xReplaceDescriptor = xReplaceDescriptor;
    }

    protected HashMap getUnsupportedReplaceProp() {
        return this.m_aUnsupportedReplaceProp;
    }

    protected void setUnsupportedReplaceProp(HashMap hashMap) {
        this.m_aUnsupportedReplaceProp = hashMap;
    }

    public int ComputeStatistics(int n, Object object) throws BasicErrorException {
        XIndexAccess xIndexAccess;
        XFootnotesSupplier xFootnotesSupplier;
        boolean bl = OptionalParamUtility.getBoolean("IncludeFootnotesAndEndnotes", object, false, false);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        int n7 = 0;
        ComputeStatisticsHelper computeStatisticsHelper = new ComputeStatisticsHelper();
        if (bl) {
            XIndexAccess xIndexAccess2;
            int n8;
            int n9;
            xFootnotesSupplier = (XFootnotesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XFootnotesSupplier == null ? (class$com$sun$star$text$XFootnotesSupplier = DocumentImpl.class$("com.sun.star.text.XFootnotesSupplier")) : class$com$sun$star$text$XFootnotesSupplier), (Object)this.getXModel());
            if (xFootnotesSupplier != null && (n9 = (xIndexAccess = xFootnotesSupplier.getFootnotes()).getCount()) > 0) {
                n8 = 0;
                while (n8 < n9) {
                    computeStatisticsHelper.handleFootnoteOrEndnote(xIndexAccess, n8);
                    ++n8;
                }
            }
            if ((xIndexAccess = (XEndnotesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XEndnotesSupplier == null ? (class$com$sun$star$text$XEndnotesSupplier = DocumentImpl.class$("com.sun.star.text.XEndnotesSupplier")) : class$com$sun$star$text$XEndnotesSupplier), (Object)this.getXModel())) != null && (n8 = (xIndexAccess2 = xIndexAccess.getEndnotes()).getCount()) > 0) {
                int n10 = 0;
                while (n10 < n8) {
                    computeStatisticsHelper.handleFootnoteOrEndnote(xIndexAccess2, n10);
                    ++n10;
                }
            }
        }
        if (n == 1) {
            n7 = ComputeStatisticsHelper.getLinesNoTablesFromDocument(this.getXModel());
        }
        if ((xFootnotesSupplier = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = DocumentImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)this.getXModel())) != null) {
            xIndexAccess = xFootnotesSupplier.getText();
            xFootnotesSupplier = null;
            XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = DocumentImpl.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess), (Object)xIndexAccess);
            xIndexAccess = null;
            if (xEnumerationAccess != null) {
                XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
                xEnumerationAccess = null;
                while (xEnumeration.hasMoreElements()) {
                    try {
                        Object object2;
                        Object object3;
                        Object object4 = xEnumeration.nextElement();
                        XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextContent == null ? DocumentImpl.class$("com.sun.star.text.XTextContent") : class$com$sun$star$text$XTextContent), (Object)object4);
                        if (xTextContent == null) continue;
                        XTextTable xTextTable = (XTextTable)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextTable == null ? DocumentImpl.class$("com.sun.star.text.XTextTable") : class$com$sun$star$text$XTextTable), (Object)object4);
                        if (xTextTable != null) {
                            object3 = xTextTable.getCellNames();
                            int n11 = ((String[])object3).length;
                            object2 = new ComputeStatisticsHelper();
                            int n12 = 0;
                            while (n12 < ((Object)object3).length) {
                                XCell xCell;
                                xIndexAccess = (XText)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XText == null ? DocumentImpl.class$("com.sun.star.text.XText") : class$com$sun$star$text$XText), (Object)(xCell = xTextTable.getCellByName((String)object3[n12])));
                                if (xIndexAccess != null) {
                                    String string = xIndexAccess.getString();
                                    ((ComputeStatisticsHelper)object2).Analysis(string);
                                }
                                ++n12;
                            }
                            n7 += ((ComputeStatisticsHelper)object2).m_nLines;
                            n6 += ((ComputeStatisticsHelper)object2).m_nParagraph;
                            n5 += ((ComputeStatisticsHelper)object2).m_nCharactersNoWhiteSpaces;
                            n4 += ((ComputeStatisticsHelper)object2).m_nCharactersWithSpaces;
                            n3 += ((ComputeStatisticsHelper)object2).m_nWord;
                            continue;
                        }
                        object3 = new ComputeStatisticsHelper();
                        XTextRange xTextRange = xTextContent.getAnchor();
                        object2 = xTextRange.getString();
                        ((ComputeStatisticsHelper)object3).Analysis((String)object2);
                        n6 += ((ComputeStatisticsHelper)object3).m_nParagraph;
                        n5 += ((ComputeStatisticsHelper)object3).m_nCharactersNoWhiteSpaces;
                        n4 += ((ComputeStatisticsHelper)object3).m_nCharactersWithSpaces;
                        n3 += ((ComputeStatisticsHelper)object3).m_nWord;
                    }
                    catch (Exception exception) {
                        HelperUtilities.exception(exception);
                    }
                }
            }
        }
        if (bl) {
            n3 += computeStatisticsHelper.m_nWord;
            n4 += computeStatisticsHelper.m_nCharactersWithSpaces;
            n5 += computeStatisticsHelper.m_nCharactersNoWhiteSpaces;
            n7 += computeStatisticsHelper.m_nLines;
            n6 += computeStatisticsHelper.m_nParagraph;
        }
        switch (n) {
            case 0: {
                n2 = n3;
                break;
            }
            case 1: {
                n2 = n7;
                break;
            }
            case 2: {
                n2 = ComputeStatisticsHelper.getPagesFromDocument(this.getXModel());
                break;
            }
            case 3: {
                n2 = n5;
                break;
            }
            case 4: {
                n2 = n6;
                break;
            }
            case 5: {
                n2 = n4;
                break;
            }
            case 6: {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter: The value 6 isn't handled yet.")));
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    protected XPropertyReplace getPropertyReplace() {
        return this.m_xPropertyReplace;
    }

    protected void setPropertyReplace(XPropertyReplace xPropertyReplace) {
        this.m_xPropertyReplace = xPropertyReplace;
    }

    public int getSaveFormat() {
        return 0;
    }

    private Object getCSS_TextDefaults(XModel xModel) {
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = DocumentImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)xModel);
        Object object = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.text.Defaults");
        }
        catch (com.sun.star.uno.Exception exception) {
            HelperUtilities.exception(exception);
        }
        return object;
    }

    public void setDefaultTabStop(double d) {
        XPropertySet xPropertySet;
        XModel xModel = this.getXModel();
        Object object = this.getCSS_TextDefaults(xModel);
        Millimeter millimeter = new Millimeter();
        millimeter.setInPoints(d);
        if (object != null) {
            xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DocumentImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
            if (xPropertySet != null) {
                try {
                    xPropertySet.setPropertyValue("TabStopDistance", (Object)new Integer((int)millimeter.getInHundrethsOfOneMillimeter()));
                }
                catch (com.sun.star.uno.Exception exception) {
                    HelperUtilities.exception(exception);
                }
            } else {
                HelperUtilities.error("Object " + object + " does not support XPropertySet!");
            }
        } else {
            DebugHelper.writeInfo("setDefaultTabStop() there exist no com.sun.star.text.Defaults");
        }
        object = null;
        xPropertySet = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = DocumentImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)xModel);
        if (xPropertySet != null) {
            XText xText = xPropertySet.getText();
            xPropertySet = null;
            XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = DocumentImpl.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess), (Object)xText);
            xText = null;
            if (xEnumerationAccess != null) {
                XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
                xEnumerationAccess = null;
                while (xEnumeration.hasMoreElements()) {
                    try {
                        XTextRange xTextRange;
                        XPropertySet xPropertySet2;
                        Object object2 = xEnumeration.nextElement();
                        XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextContent == null ? DocumentImpl.class$("com.sun.star.text.XTextContent") : class$com$sun$star$text$XTextContent), (Object)object2);
                        if (xTextContent == null || (xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? DocumentImpl.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet), (Object)(xTextRange = xTextContent.getAnchor()))) == null) continue;
                        try {
                            TabStop[] tabStopArray = (TabStop[])xPropertySet2.getPropertyValue("ParaTabStops");
                            int n = 0;
                            while (n < tabStopArray.length) {
                                if (tabStopArray[n] != null) {
                                    int n2;
                                    tabStopArray[n].Position = n2 = (n + 1) * (int)millimeter.getInHundrethsOfOneMillimeter();
                                }
                                ++n;
                            }
                        }
                        catch (UnknownPropertyException unknownPropertyException) {
                            HelperUtilities.exception(unknownPropertyException);
                        }
                        catch (WrappedTargetException wrappedTargetException) {
                            HelperUtilities.exception(wrappedTargetException);
                        }
                    }
                    catch (Exception exception) {
                        HelperUtilities.exception(exception);
                    }
                }
            }
        }
    }

    public double getDefaultTabStop() {
        XModel xModel = this.getXModel();
        Object object = this.getCSS_TextDefaults(xModel);
        Millimeter millimeter = new Millimeter();
        if (object != null) {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DocumentImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
            if (xPropertySet != null) {
                try {
                    int n = (Integer)xPropertySet.getPropertyValue("TabStopDistance");
                    millimeter.setInHundrethsOfOneMillimeter(n);
                }
                catch (com.sun.star.uno.Exception exception) {
                    HelperUtilities.exception(exception);
                }
            } else {
                HelperUtilities.error("Object " + object + " does not support XPropertySet!");
            }
        }
        return millimeter.getInPoints();
    }

    private Object getDocumentStyles(Object object, String string) throws BasicErrorException {
        XStyleFamiliesSupplier xStyleFamiliesSupplier;
        XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = DocumentImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)object);
        if (xTextDocument != null && (xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$style$XStyleFamiliesSupplier == null ? (class$com$sun$star$style$XStyleFamiliesSupplier = DocumentImpl.class$("com.sun.star.style.XStyleFamiliesSupplier")) : class$com$sun$star$style$XStyleFamiliesSupplier), (Object)xTextDocument)) != null) {
            XNameAccess xNameAccess = xStyleFamiliesSupplier.getStyleFamilies();
            Object object2 = null;
            try {
                String[] stringArray = xNameAccess.getElementNames();
                object2 = xNameAccess.getByName(string);
            }
            catch (NoSuchElementException noSuchElementException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)noSuchElementException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
            return object2;
        }
        return null;
    }

    private XNameAccess getParagraphStyles(XModel xModel) {
        try {
            Object object = this.getDocumentStyles(xModel, "ParagraphStyles");
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = DocumentImpl.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)object);
            return xNameAccess;
        }
        catch (BasicErrorException basicErrorException) {
            return null;
        }
    }

    public void setAutoHyphenation(boolean bl) {
        XModel xModel = this.getXModel();
        XNameAccess xNameAccess = this.getParagraphStyles(xModel);
        if (xNameAccess != null) {
            String[] stringArray = xNameAccess.getElementNames();
            int n = 0;
            while (n < stringArray.length) {
                block11: {
                    try {
                        XPropertySet xPropertySet;
                        Object object = xNameAccess.getByName(stringArray[n]);
                        if (object == null || (xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? DocumentImpl.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet), (Object)object)) == null) break block11;
                        try {
                            boolean bl2 = (Boolean)xPropertySet.getPropertyValue("ParaIsHyphenation");
                            if (bl2 != bl) {
                                xPropertySet.setPropertyValue("ParaIsHyphenation", (Object)new Boolean(bl));
                            }
                        }
                        catch (UnknownPropertyException unknownPropertyException) {
                            HelperUtilities.exception(unknownPropertyException);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            HelperUtilities.exception(propertyVetoException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            HelperUtilities.exception(illegalArgumentException);
                        }
                        catch (WrappedTargetException wrappedTargetException) {
                            HelperUtilities.exception(wrappedTargetException);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        HelperUtilities.exception(noSuchElementException);
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        HelperUtilities.exception(wrappedTargetException);
                    }
                }
                ++n;
            }
        }
    }

    public boolean getAutoHyphenation() {
        boolean bl;
        block6: {
            bl = false;
            XModel xModel = this.getXModel();
            XNameAccess xNameAccess = this.getParagraphStyles(xModel);
            if (xNameAccess == null) break block6;
            try {
                XPropertySet xPropertySet;
                Object object = xNameAccess.getByName("Standard");
                if (object == null || (xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DocumentImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object)) == null) break block6;
                try {
                    bl = (Boolean)xPropertySet.getPropertyValue("ParaIsHyphenation");
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    HelperUtilities.exception(unknownPropertyException);
                }
                catch (WrappedTargetException wrappedTargetException) {
                    HelperUtilities.exception(wrappedTargetException);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                HelperUtilities.exception(noSuchElementException);
            }
            catch (WrappedTargetException wrappedTargetException) {
                HelperUtilities.exception(wrappedTargetException);
            }
        }
        return bl;
    }

    public void setReadOnlyRecommended(boolean bl) {
        this.m_bReadOnlyRecommended = bl;
    }

    public boolean getReadOnlyRecommended() {
        return this.m_bReadOnlyRecommended;
    }

    public int getType() {
        int n = 0;
        XModel xModel = this.getXModel();
        if (xModel != null) {
            PropertyValue[] propertyValueArray = xModel.getArgs();
            int n2 = 0;
            while (n2 < propertyValueArray.length) {
                PropertyValue propertyValue = propertyValueArray[n2];
                if (propertyValue.Name.equals("AsTemplate") && propertyValue.Value == Boolean.TRUE) {
                    n = 1;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    public void SaveAs(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16) throws BasicErrorException, IllegalArgumentException {
        String string;
        Object object17;
        boolean bl;
        String string2 = OptionalParamUtility.getString("FileName", object, "local:default", false);
        if (string2.equals("local:default")) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("Parameter FileName not set.")));
        }
        if (!AnyConverter.isVoid((Object)object3)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter LockComment is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object6)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter WritePassword is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object11)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter SaveAsAOCELetter is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object9)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter SaveNativePictureFormat is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object8)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter EmbedTrueTypeFonts is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object7)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter ReadOnlyRecommended is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object5) && (bl = OptionalParamUtility.getBoolean("AddToRecentFiles", object5, false, false))) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter AddToRecentFiles:=true is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object10)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter SaveFormsData is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object16)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter AddBiDiMarks is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object14)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter AllowSubstitutions is not supported.")));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        WriterFilename writerFilename = new WriterFilename(string2);
        int n = 0;
        if (!AnyConverter.isVoid((Object)object2)) {
            n = AnyConverter.toInt((Object)object2);
        }
        WriterFileFormatHelper writerFileFormatHelper = new WriterFileFormatHelper(n, arrayList);
        String string3 = writerFileFormatHelper.getFileFormat();
        String string4 = writerFileFormatHelper.getFileExtension();
        if (string3.length() > 0) {
            writerFilename.prepareToWrite(string4);
        } else {
            writerFilename.prepareToWrite("");
        }
        if (!AnyConverter.isVoid((Object)object12) && writerFileFormatHelper.storeAsText()) {
            int n2 = OptionalParamUtility.getInt("Encoding", object12, 0, false);
            try {
                int n3;
                object17 = CommonUtilities.getConvertMsoEncodingToSOCharSet(n2);
                string = "CRLF";
                if (!AnyConverter.isVoid((Object)object15) && (n3 = OptionalParamUtility.getInt("LineEnding", object15, 0, false)) == 1) {
                    string = "CR";
                }
                if (object17 != null) {
                    object17 = (String)object17 + ",";
                    object17 = (String)object17 + string;
                    PropertyValue propertyValue = new PropertyValue();
                    propertyValue.Name = "FilterOptions";
                    propertyValue.Value = object17;
                    arrayList.add(propertyValue);
                    DebugHelper.writeInfo("Document.SaveAs(): Property 'FilterOptions' := '" + (String)object17 + "'");
                }
            }
            catch (NoSupportException noSupportException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)noSupportException));
            }
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "Overwrite";
        propertyValue.Value = Boolean.TRUE;
        arrayList.add(propertyValue);
        DebugHelper.writeInfo("Document.SaveAs(): Property 'Overwrite' := 'true'");
        if (!AnyConverter.isVoid((Object)object4) && ((String)(object17 = OptionalParamUtility.getString("Password", object4, "", false))).length() > 0) {
            string = new PropertyValue();
            ((PropertyValue)string).Name = "Password";
            ((PropertyValue)string).Value = object17;
            arrayList.add(string);
            DebugHelper.writeInfo("Document.SaveAs(): Property 'Password' := 'XXXXXX'");
        }
        object17 = CommonUtilities.createPropertyValueArrayFormArrayList(arrayList);
        string = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DocumentImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.getXModel());
        String string5 = writerFilename.getURL();
        DebugHelper.writeInfo("Document.SaveAs(): storeAsURL '" + string5 + "'");
        try {
            string.storeAsURL(string5, (PropertyValue[])object17);
        }
        catch (IOException iOException) {
            DebugHelper.writeInfo("Document.SaveAs(): File '" + string5 + "' can't store.");
            DebugHelper.writeInfo("Document.SaveAs(): Exception caught from storeAsURL(): '" + iOException.getMessage() + "'");
            DebugHelper.exception(57, "");
        }
    }

    public void Undo() throws BasicErrorException {
        DispatchCommand.execute(".uno:Undo", this.getXModel().getCurrentController().getFrame());
    }

    public XFields Fields() throws BasicErrorException {
        FieldsImpl fieldsImpl = new FieldsImpl(this);
        if (fieldsImpl == null) {
            return null;
        }
        return fieldsImpl;
    }

    void setTemplate(TemplateImpl templateImpl) {
        this.m_aCacheTemplate = templateImpl;
    }

    public XTemplate AttachedTemplate() throws BasicErrorException {
        if (this.m_aCacheTemplate == null) {
            Object object = this.getVariables().Item("Template").getValue();
            String string = "";
            if (AnyConverter.isString((Object)object)) {
                try {
                    string = AnyConverter.toString((Object)object);
                }
                catch (com.sun.star.uno.Exception exception) {
                    DebugHelper.exception(exception);
                }
            }
            DocumentsImpl documentsImpl = (DocumentsImpl)this.getParentAdaptor();
            if (string.length() == 0) {
                this.m_aCacheTemplate = TemplateImpl.create(documentsImpl);
            } else {
                String string2 = "";
                String string3 = Filename.getBasename(string);
                this.m_aCacheTemplate = new TemplateImpl(documentsImpl, string2, string3, 2);
            }
        }
        return this.m_aCacheTemplate;
    }

    public XMailMerge MailMerge() throws BasicErrorException {
        if (this.m_MailMerge == null) {
            this.m_MailMerge = new MailMergeImpl(this);
        }
        return this.m_MailMerge;
    }

    public void Protect(Object object, Object object2, Object object3) throws BasicErrorException {
        if (AnyConverter.isVoid((Object)object)) {
            DebugHelper.exception(969, "Parameter: Type is required.");
        }
        int n = OptionalParamUtility.getInt("Type", object, -1, false);
        switch (n) {
            case -1: 
            case 0: {
                break;
            }
            default: {
                DebugHelper.exception(969, "Parameter: This value in Type is not supported.");
            }
        }
        boolean bl = OptionalParamUtility.getBoolean("NoReset", object2, false, false);
        String string = null;
        if (!AnyConverter.isVoid((Object)object3)) {
            string = OptionalParamUtility.getString("Password", object3, "", false);
        }
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DocumentImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.getXModel());
            try {
                Object object4 = xPropertySet.getPropertyValue("ShowChanges");
                if (object4 != null) {
                    boolean bl2 = (Boolean)OptionalParamUtility.getObject(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DocumentImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean, object4);
                    if (!bl2) {
                        xPropertySet.setPropertyValue("ShowChanges", (Object)Boolean.TRUE);
                    } else {
                        xPropertySet.setPropertyValue("ShowChanges", (Object)Boolean.FALSE);
                    }
                } else {
                    DebugHelper.writeInfo("There is no such property 'ShowChanges'.");
                }
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public void Unprotect(Object object) throws BasicErrorException {
        String string = null;
        if (!AnyConverter.isVoid((Object)object)) {
            string = OptionalParamUtility.getString("Password", object, "", false);
        }
    }

    public int getProtectionType() {
        return -1;
    }

    public boolean getUserControl() {
        return this.m_bUserControl;
    }

    public void setUserControl(boolean bl) {
        this.m_bUserControl = bl;
    }

    public XRange GoTo(Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        XRange xRange = this.getContent().GoTo(object, object2, object3, object4);
        return xRange.Duplicate();
    }

    protected void lockControllers() {
        if (!this.m_bControllerIsLocked) {
            this.m_bControllerIsLocked = true;
            XModel xModel = this.getXModel();
            xModel.lockControllers();
        } else {
            DebugHelper.writeInfo("Don't try to lock a document more than once.");
        }
    }

    protected void unlockControllers() {
        if (this.m_bControllerIsLocked) {
            this.m_bControllerIsLocked = false;
            try {
                XModel xModel = this.getXModel();
                xModel.unlockControllers();
            }
            catch (RuntimeException runtimeException) {
                String string = runtimeException.getMessage();
                DebugHelper.writeInfo("Internal problem: unlockControllers() must use in pairs");
            }
        } else {
            DebugHelper.writeInfo("Don't try to unlock a document more than once.");
        }
    }

    private void copyPropertySet(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        try {
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DocumentImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object2);
            Property[] propertyArray = xPropertySet.getPropertySetInfo().getProperties();
            XPropertySet xPropertySet2 = null;
            PropertySetHelper propertySetHelper = null;
            if (object != null) {
                xPropertySet2 = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DocumentImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object);
                propertySetHelper = new PropertySetHelper(xPropertySet2);
            }
            PropertySetHelper propertySetHelper2 = new PropertySetHelper(xPropertySet);
            int n = 0;
            while (n < propertyArray.length) {
                String string = propertyArray[n].Name;
                Object object3 = propertySetHelper.getPropertyValueAsObject(string);
                if (propertySetHelper != null) {
                    propertySetHelper2.setPropertyValueDontThrow(string, object3);
                }
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void copyUsedStyles(String string, Object object, Object object2) {
        if (object == null) {
            return;
        }
        if (object2 == null) {
            return;
        }
        try {
            String string2;
            Object object3;
            XNameContainer xNameContainer = (XNameContainer)OptionalParamUtility.getObject(class$com$sun$star$container$XNameContainer == null ? (class$com$sun$star$container$XNameContainer = DocumentImpl.class$("com.sun.star.container.XNameContainer")) : class$com$sun$star$container$XNameContainer, object);
            String[] stringArray = xNameContainer.getElementNames();
            Object object4 = null;
            Object object5 = null;
            try {
                object4 = this.getDocumentStyles(object2, string);
            }
            catch (BasicErrorException basicErrorException) {
                DebugHelper.writeInfo("Can't get StyleFamily from template " + string);
            }
            XNameContainer xNameContainer2 = (XNameContainer)OptionalParamUtility.getObject(class$com$sun$star$container$XNameContainer == null ? (class$com$sun$star$container$XNameContainer = DocumentImpl.class$("com.sun.star.container.XNameContainer")) : class$com$sun$star$container$XNameContainer, object4);
            int n = 0;
            while (n < stringArray.length) {
                Object object6;
                string2 = (XStyle)OptionalParamUtility.getObject(class$com$sun$star$style$XStyle == null ? DocumentImpl.class$("com.sun.star.style.XStyle") : class$com$sun$star$style$XStyle, object6 = xNameContainer.getByName((String)(object3 = stringArray[n])));
                if (string2.isInUse()) {
                    if (string2.isUserDefined()) {
                        xNameContainer.removeByName((String)object3);
                    } else {
                        object5 = xNameContainer2.getByName((String)object3);
                        this.copyPropertySet(object5, object6);
                    }
                }
                ++n;
            }
            object3 = xNameContainer2.getElementNames();
            int n2 = 0;
            while (n2 < ((String[])object3).length) {
                XStyle xStyle = (XStyle)OptionalParamUtility.getObject(class$com$sun$star$style$XStyle == null ? DocumentImpl.class$("com.sun.star.style.XStyle") : class$com$sun$star$style$XStyle, object5 = xNameContainer2.getByName(string2 = stringArray[n2]));
                if (xStyle.isInUse() && !xStyle.isUserDefined()) {
                    Object object7 = xNameContainer.getByName(string2);
                    this.copyPropertySet(object5, object7);
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (WrappedTargetException wrappedTargetException) {}
    }

    public void UpdateStyles() throws BasicErrorException {
        XModel xModel = null;
        xModel = this.getXModel();
        try {
            xModel.lockControllers();
            Object object = this.getDocumentStyles(xModel, "PageStyles");
            XNameAccess xNameAccess = this.getParagraphStyles(xModel);
            Object object2 = this.getDocumentStyles(xModel, "CharacterStyles");
            Object object3 = this.getDocumentStyles(xModel, "FrameStyles");
            Object object4 = this.getDocumentStyles(xModel, "NumberingStyles");
            XTemplate xTemplate = this.AttachedTemplate();
            TemplateImpl templateImpl = (TemplateImpl)xTemplate;
            ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "Hidden";
            propertyValue.Value = Boolean.TRUE;
            arrayList.add(propertyValue);
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.Name = "ReadOnly";
            propertyValue2.Value = Boolean.TRUE;
            arrayList.add(propertyValue2);
            XDocument xDocument = templateImpl.OpenAsDocument_WithProperties(arrayList);
            XModel xModel2 = ((DocumentImpl)xDocument).getXModel();
            if (object != null) {
                this.copyUsedStyles("PageStyles", object, xModel2);
            }
            if (xNameAccess != null) {
                this.copyUsedStyles("ParagraphStyles", xNameAccess, xModel2);
            }
            if (object2 != null) {
                this.copyUsedStyles("CharacterStyles", object2, xModel2);
            }
            if (object3 != null) {
                this.copyUsedStyles("FrameStyles", object3, xModel2);
            }
            if (object4 != null) {
                this.copyUsedStyles("NumberingStyles", object4, xModel2);
            }
            int n = 0;
            xDocument.Close(new Integer(n), null, null);
            xModel.unlockControllers();
        }
        catch (com.sun.star.uno.Exception exception) {
            xModel.unlockControllers();
            DebugHelper.exception(exception);
        }
    }

    public XCommandBars CommandBars() throws BasicErrorException {
        if (this.m_xCommandBarsCache == null) {
            this.m_xCommandBarsCache = new CommandBarsImpl(this);
        }
        return this.m_xCommandBarsCache;
    }

    public void setShowSpellingErrors(boolean bl) throws BasicErrorException {
        XController xController = this.getXModel().getCurrentController();
        if (xController != null) {
            PropertySetHelper propertySetHelper = new PropertySetHelper(xController);
            propertySetHelper.setPropertyValue("IsConstantSpellcheck", new Boolean(bl));
        }
        CommandBarsImpl.RefreshLayout(this.getXModel());
    }

    public boolean getShowSpellingErrors() throws BasicErrorException {
        boolean bl = false;
        XController xController = this.getXModel().getCurrentController();
        if (xController != null) {
            PropertySetHelper propertySetHelper = new PropertySetHelper(xController);
            bl = propertySetHelper.getPropertyValueAsBoolean("IsConstantSpellcheck", false);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

